/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet.hba;

import org.apache.activeio.xnet.hba.ExactIPAddressPermission;
import org.apache.activeio.xnet.hba.ExactIPv6AddressPermission;
import org.apache.activeio.xnet.hba.FactorizedIPAddressPermission;
import org.apache.activeio.xnet.hba.IPAddressPermission;
import org.apache.activeio.xnet.hba.NetmaskIPAddressPermission;
import org.apache.activeio.xnet.hba.NetmaskIPv6AddressPermission;
import org.apache.activeio.xnet.hba.StartWithIPAddressPermission;

public class IPAddressPermissionFactory {
    public static IPAddressPermission getIPAddressMask(String mask) {
        if (StartWithIPAddressPermission.canSupport(mask)) {
            return new StartWithIPAddressPermission(mask);
        }
        if (ExactIPAddressPermission.canSupport(mask)) {
            return new ExactIPAddressPermission(mask);
        }
        if (FactorizedIPAddressPermission.canSupport(mask)) {
            return new FactorizedIPAddressPermission(mask);
        }
        if (NetmaskIPAddressPermission.canSupport(mask)) {
            return new NetmaskIPAddressPermission(mask);
        }
        if (ExactIPv6AddressPermission.canSupport(mask)) {
            return new ExactIPv6AddressPermission(mask);
        }
        if (NetmaskIPv6AddressPermission.canSupport(mask)) {
            return new NetmaskIPv6AddressPermission(mask);
        }
        throw new IllegalArgumentException("Mask " + mask + " is not supported.");
    }
}

