/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.ControlError;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.IllegalMonitorState;
import org.armedbear.lisp.JavaStackFrame;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispStackFrame;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Primitives;
import org.armedbear.lisp.ProcessingTerminated;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.StackFrame;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.ThreadDestroyed;
import org.armedbear.lisp.Throw;
import org.armedbear.lisp.UnboundVariable;
import org.armedbear.lisp.WrongNumberOfArgumentsException;
import org.armedbear.lisp.protocol.Inspectable;

public final class LispThread
extends LispObject {
    static final ConcurrentHashMap<Thread, LispThread> map = new ConcurrentHashMap();
    LispObject threadValue = Lisp.NIL;
    private static ThreadLocal<LispThread> threads = new ThreadLocal<LispThread>(){

        @Override
        public LispThread initialValue() {
            Thread thisThread = Thread.currentThread();
            LispThread thread = map.get(thisThread);
            if (thread == null) {
                thread = new LispThread(thisThread);
                map.put(thisThread, thread);
            }
            return thread;
        }
    };
    final Thread javaThread;
    private boolean destroyed;
    final LispObject name;
    public LispObject[] _values;
    private boolean threadInterrupted;
    private LispObject pending = Lisp.NIL;
    private Symbol wrapper = Lisp.PACKAGE_THREADS.intern("THREAD-FUNCTION-WRAPPER");
    static final int UNASSIGNED_SPECIAL_INDEX = 0;
    static final AtomicInteger lastSpecial = new AtomicInteger(0);
    static final ConcurrentLinkedQueue<Integer> freeSpecialIndices = new ConcurrentLinkedQueue();
    static final int specialsInitialSize = Integer.valueOf(System.getProperty("abcl.specials.initialSize", "4096"));
    SpecialBinding[] specials = new SpecialBinding[specialsInitialSize + 1];
    static final ConcurrentHashMap<Integer, WeakReference<Symbol>> specialNames = new ConcurrentHashMap();
    static final int specialsDelta = Integer.valueOf(System.getProperty("abcl.specials.grow.delta", "1024"));
    private SpecialBindingsMark savedSpecials = null;
    private LispObject catchTags = Lisp.NIL;
    private static final StackMarker STACK_MARKER_0 = new StackMarker(0);
    private static final StackMarker STACK_MARKER_1 = new StackMarker(1);
    private static final StackMarker STACK_MARKER_2 = new StackMarker(2);
    private static final StackMarker STACK_MARKER_3 = new StackMarker(3);
    private static final StackMarker STACK_MARKER_4 = new StackMarker(4);
    private static final StackMarker STACK_MARKER_5 = new StackMarker(5);
    private static final StackMarker STACK_MARKER_6 = new StackMarker(6);
    private static final StackMarker STACK_MARKER_7 = new StackMarker(7);
    private static final StackMarker STACK_MARKER_8 = new StackMarker(8);
    private final int STACK_FRAME_EXTRA = 2;
    private StackSegment topStackSegment = new StackSegment(1024, null);
    private Object[] stack;
    private int stackPtr;
    private StackSegment spareStackSegment;
    private static final int INITIAL_SEGMENT_SIZE = 1024;
    private static final int SEGMENT_SIZE = 524284;
    @DocString(name="make-thread", args="function &key name")
    private static final Primitive MAKE_THREAD = new Primitive("make-thread", Lisp.PACKAGE_THREADS, true, "function &key name"){

        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length == 0) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 1, -1));
            }
            LispObject name = Lisp.NIL;
            if (length > 1) {
                if ((length - 1) % 2 != 0) {
                    Lisp.program_error("Odd number of keyword arguments.");
                }
                if (length > 3) {
                    Lisp.error(new WrongNumberOfArgumentsException((Operator)this, -1, 2));
                }
                if (args[1] == Keyword.NAME) {
                    name = args[2].STRING();
                } else {
                    Lisp.program_error("Unrecognized keyword argument " + args[1].princToString() + ".");
                }
            }
            return new LispThread(Lisp.checkFunction(args[0]), name);
        }
    };
    @DocString(name="threadp", args="object", doc="Boolean predicate testing if OBJECT is a thread.")
    private static final Primitive THREADP = new Primitive("threadp", Lisp.PACKAGE_THREADS, true){

        public LispObject execute(LispObject arg) {
            return arg instanceof LispThread ? Lisp.T : Lisp.NIL;
        }
    };
    @DocString(name="thread-alive-p", args="thread", doc="Returns T if THREAD is alive.")
    private static final Primitive THREAD_ALIVE_P = new Primitive("thread-alive-p", Lisp.PACKAGE_THREADS, true, "thread", "Boolean predicate whether THREAD is alive."){

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof LispThread)) {
                return Lisp.type_error(arg, Symbol.THREAD);
            }
            LispThread lispThread = (LispThread)arg;
            return lispThread.javaThread.isAlive() ? Lisp.T : Lisp.NIL;
        }
    };
    @DocString(name="thread-name", args="thread", doc="Return the name of THREAD, if it has one.")
    private static final Primitive THREAD_NAME = new Primitive("thread-name", Lisp.PACKAGE_THREADS, true){

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispThread) {
                return ((LispThread)arg).name;
            }
            return Lisp.type_error(arg, Symbol.THREAD);
        }
    };
    private static final Primitive THREAD_JOIN = new Primitive("thread-join", Lisp.PACKAGE_THREADS, true, "thread", "Waits for thread to finish."){

        public LispObject execute(LispObject arg) {
            if (arg instanceof LispThread) {
                LispThread joinedThread = (LispThread)arg;
                LispThread waitingThread = LispThread.currentThread();
                try {
                    joinedThread.javaThread.join();
                    return waitingThread.setValues(joinedThread.threadValue, Lisp.T);
                }
                catch (InterruptedException e) {
                    waitingThread.processThreadInterrupts();
                    return waitingThread.setValues(joinedThread.threadValue, Lisp.NIL);
                }
            }
            return Lisp.type_error(arg, Symbol.THREAD);
        }
    };
    static final DoubleFloat THOUSAND = new DoubleFloat(1000.0);
    @DocString(name="sleep", args="seconds", doc="Causes the invoking thread to sleep for an interveral expressed in SECONDS.\nSECONDS may be specified as a fraction of a second, with intervals\nless than or equal to a nanosecond resulting in a yield of execution\nto other waiting threads rather than an actual sleep.\nA zero value of SECONDS *may* result in the JVM sleeping indefinitely,\ndepending on the implementation.")
    private static final Primitive SLEEP = new Primitive("sleep", Lisp.PACKAGE_CL, true){

        public LispObject execute(LispObject arg) {
            long millis = LispThread.sleepMillisPart(arg);
            int nanos = LispThread.sleepNanosPart(arg);
            boolean zeroArgP = arg.ZEROP() != Lisp.NIL;
            try {
                if (millis == 0L && nanos == 0) {
                    if (zeroArgP) {
                        Thread.sleep(0L, 0);
                    } else {
                        Thread.sleep(0L, 1);
                    }
                } else {
                    Thread.sleep(millis, nanos);
                }
            }
            catch (InterruptedException e) {
                LispThread.currentThread().processThreadInterrupts();
            }
            return Lisp.NIL;
        }
    };
    @DocString(name="mapcar-threads", args="function", doc="Applies FUNCTION to all existing threads.")
    private static final Primitive MAPCAR_THREADS = new Primitive("mapcar-threads", Lisp.PACKAGE_THREADS, true){

        public LispObject execute(LispObject arg) {
            Function fun = Lisp.checkFunction(arg);
            LispThread thread = LispThread.currentThread();
            LispObject result = Lisp.NIL;
            Iterator<LispThread> it = map.values().iterator();
            while (it.hasNext()) {
                LispObject[] args = new LispObject[]{it.next()};
                result = new Cons(Lisp.funcall(fun, args, thread), result);
            }
            return result;
        }
    };
    @DocString(name="destroy-thread", args="thread", doc="Mark THREAD as destroyed")
    private static final Primitive DESTROY_THREAD = new Primitive("destroy-thread", Lisp.PACKAGE_THREADS, true){

        public LispObject execute(LispObject arg) {
            if (!(arg instanceof LispThread)) {
                return Lisp.type_error(arg, Symbol.THREAD);
            }
            LispThread thread = (LispThread)arg;
            thread.setDestroyed(true);
            return Lisp.T;
        }
    };
    @DocString(name="interrupt-thread", args="thread function &rest args", doc="Interrupts thread and forces it to apply function to args. When the\nfunction returns, the thread's original computation continues. If\nmultiple interrupts are queued for a thread, they are all run, but the\norder is not guaranteed.")
    private static final Primitive INTERRUPT_THREAD = new Primitive("interrupt-thread", Lisp.PACKAGE_THREADS, true, "thread function &rest args", "Interrupts THREAD and forces it to apply FUNCTION to ARGS.\nWhen the function returns, the thread's original computation continues. If  multiple interrupts are queued for a thread, they are all run, but the order is not guaranteed."){

        public LispObject execute(LispObject[] args) {
            if (args.length < 2) {
                return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 2, -1));
            }
            if (!(args[0] instanceof LispThread)) {
                return Lisp.type_error(args[0], Symbol.THREAD);
            }
            LispThread thread = (LispThread)args[0];
            LispObject fun = args[1];
            LispObject funArgs = Lisp.NIL;
            int i = args.length;
            while (i-- > 2) {
                funArgs = new Cons(args[i], funArgs);
            }
            thread.interrupt(fun, funArgs);
            return Lisp.T;
        }
    };
    public static final Primitive CURRENT_THREAD = new pf_current_thread();
    public static final Primitive BACKTRACE = new pf_backtrace();
    public static final Primitive FRAME_TO_STRING = new pf_frame_to_string();
    public static final Primitive FRAME_TO_LIST = new pf_frame_to_list();
    public static final SpecialOperator SYNCHRONIZED_ON = new so_synchronized_on();
    public static final Primitive OBJECT_WAIT = new pf_object_wait();
    public static final Primitive OBJECT_NOTIFY = new pf_object_notify();
    public static final Primitive OBJECT_NOTIFY_ALL = new pf_object_notify_all();

    public static final LispThread currentThread() {
        return threads.get();
    }

    LispThread(Thread javaThread) {
        this.stack = this.topStackSegment.stack;
        this.stackPtr = 0;
        this.javaThread = javaThread;
        this.name = new SimpleString(javaThread.getName());
    }

    LispThread(final Function fun, LispObject name) {
        this.stack = this.topStackSegment.stack;
        this.stackPtr = 0;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    LispThread.this.threadValue = Lisp.funcall(LispThread.this.wrapper, new LispObject[]{fun}, LispThread.this);
                }
                catch (ThreadDestroyed ignored) {
                }
                catch (ProcessingTerminated e) {
                    System.exit(e.getStatus());
                }
                catch (Throwable t) {
                    if (LispThread.this.isInterrupted()) {
                        LispThread.this.processThreadInterrupts();
                    }
                    String msg = MessageFormat.format("Ignoring uncaught exception {0}.", t.toString());
                    Debug.warn(msg);
                }
                finally {
                    map.remove(Thread.currentThread());
                }
            }
        };
        this.javaThread = new Thread(r);
        this.name = name;
        map.put(this.javaThread, this);
        if (name != Lisp.NIL) {
            this.javaThread.setName(name.getStringValue());
        }
        this.javaThread.setDaemon(true);
        this.javaThread.start();
    }

    public StackTraceElement[] getJavaStackTrace() {
        return this.javaThread.getStackTrace();
    }

    public LispObject typeOf() {
        return Symbol.THREAD;
    }

    public LispObject classOf() {
        return BuiltInClass.THREAD;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.THREAD) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.THREAD) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public final synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    final synchronized boolean isInterrupted() {
        return this.threadInterrupted;
    }

    final synchronized void setDestroyed(boolean b) {
        this.destroyed = b;
    }

    final synchronized void interrupt(LispObject function, LispObject args) {
        this.pending = new Cons(args, this.pending);
        this.pending = new Cons(function, this.pending);
        this.threadInterrupted = true;
        this.javaThread.interrupt();
    }

    final synchronized void processThreadInterrupts() {
        while (this.pending != Lisp.NIL) {
            LispObject function = this.pending.car();
            LispObject args = this.pending.cadr();
            this.pending = this.pending.cddr();
            Primitives.APPLY.execute(function, args);
        }
        this.threadInterrupted = false;
    }

    public final LispObject[] getValues() {
        return this._values;
    }

    public final LispObject[] getValues(LispObject result, int count) {
        if (this._values == null) {
            LispObject[] values = new LispObject[count];
            if (count > 0) {
                values[0] = result;
            }
            for (int i = 1; i < count; ++i) {
                values[i] = Lisp.NIL;
            }
            return values;
        }
        if (count <= this._values.length) {
            return this._values;
        }
        LispObject[] values = new LispObject[count];
        int i = this._values.length;
        while (i-- > 0) {
            values[i] = this._values[i];
        }
        for (i = this._values.length; i < count; ++i) {
            values[i] = Lisp.NIL;
        }
        return values;
    }

    public final LispObject[] accumulateValues(LispObject result, LispObject[] oldValues) {
        if (oldValues == null) {
            if (this._values != null) {
                return this._values;
            }
            LispObject[] values = new LispObject[]{result};
            return values;
        }
        if (this._values != null) {
            if (this._values.length == 0) {
                return oldValues;
            }
            int totalLength = oldValues.length + this._values.length;
            LispObject[] values = new LispObject[totalLength];
            System.arraycopy(oldValues, 0, values, 0, oldValues.length);
            System.arraycopy(this._values, 0, values, oldValues.length, this._values.length);
            return values;
        }
        int totalLength = oldValues.length + 1;
        LispObject[] values = new LispObject[totalLength];
        System.arraycopy(oldValues, 0, values, 0, oldValues.length);
        values[totalLength - 1] = result;
        return values;
    }

    public final LispObject setValues() {
        this._values = new LispObject[0];
        return Lisp.NIL;
    }

    public final LispObject setValues(LispObject value1) {
        this._values = null;
        return value1;
    }

    public final LispObject setValues(LispObject value1, LispObject value2) {
        this._values = new LispObject[2];
        this._values[0] = value1;
        this._values[1] = value2;
        return value1;
    }

    public final LispObject setValues(LispObject value1, LispObject value2, LispObject value3) {
        this._values = new LispObject[3];
        this._values[0] = value1;
        this._values[1] = value2;
        this._values[2] = value3;
        return value1;
    }

    public final LispObject setValues(LispObject value1, LispObject value2, LispObject value3, LispObject value4) {
        this._values = new LispObject[4];
        this._values[0] = value1;
        this._values[1] = value2;
        this._values[2] = value3;
        this._values[3] = value4;
        return value1;
    }

    public final LispObject setValues(LispObject[] values) {
        switch (values.length) {
            case 0: {
                this._values = values;
                return Lisp.NIL;
            }
            case 1: {
                this._values = null;
                return values[0];
            }
        }
        this._values = values;
        return values[0];
    }

    public final void clearValues() {
        this._values = null;
    }

    public final LispObject nothing() {
        this._values = new LispObject[0];
        return Lisp.NIL;
    }

    public final LispObject value(LispObject obj) {
        this._values = null;
        return obj;
    }

    public final SpecialBindingsMark markSpecialBindings() {
        return this.savedSpecials;
    }

    public final void resetSpecialBindings(SpecialBindingsMark mark) {
        SpecialBindingsMark c = this.savedSpecials;
        while (mark != c) {
            this.specials[c.idx] = c.binding;
            c = c.next;
        }
        this.savedSpecials = c;
    }

    final void clearSpecialBindings() {
        this.resetSpecialBindings(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignSpecialIndex(Symbol sym) {
        if (sym.specialIndex != 0) {
            return;
        }
        Symbol symbol = sym;
        synchronized (symbol) {
            if (sym.specialIndex == 0) {
                Integer next = freeSpecialIndices.poll();
                if (next == null && this.specials.length < lastSpecial.get() && null == System.getProperty("abcl.specials.grow.slowly")) {
                    System.gc();
                    next = freeSpecialIndices.poll();
                }
                sym.specialIndex = next == null ? lastSpecial.incrementAndGet() : next.intValue();
            }
        }
    }

    protected static void releaseSpecialIndex(Symbol sym) {
        int index = sym.specialIndex;
        if (index != 0) {
            for (LispThread thread : map.values()) {
                SpecialBindingsMark savedSpecial = thread.savedSpecials;
                while (savedSpecial != null) {
                    if (savedSpecial.idx == index) {
                        savedSpecial.idx = 0;
                        savedSpecial.binding = null;
                    }
                    savedSpecial = savedSpecial.next;
                }
                thread.specials[index] = null;
            }
            freeSpecialIndices.add(new Integer(index));
        }
    }

    private void growSpecials() {
        SpecialBinding[] newSpecials = new SpecialBinding[this.specials.length + specialsDelta];
        System.arraycopy(this.specials, 0, newSpecials, 0, this.specials.length);
        this.specials = newSpecials;
    }

    private SpecialBinding ensureSpecialBinding(int idx) {
        SpecialBinding binding;
        boolean assigned;
        do {
            try {
                binding = this.specials[idx];
                assigned = true;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                assigned = false;
                binding = null;
                this.growSpecials();
            }
        } while (!assigned);
        return binding;
    }

    public final SpecialBinding bindSpecial(Symbol name, LispObject value) {
        this.assignSpecialIndex(name);
        int idx = name.specialIndex;
        SpecialBinding binding = this.ensureSpecialBinding(idx);
        this.savedSpecials = new SpecialBindingsMark(idx, binding, this.savedSpecials);
        this.specials[idx] = new SpecialBinding(idx, value);
        return this.specials[idx];
    }

    public final SpecialBinding bindSpecialToCurrentValue(Symbol name) {
        this.assignSpecialIndex(name);
        int idx = name.specialIndex;
        SpecialBinding binding = this.ensureSpecialBinding(idx);
        this.savedSpecials = new SpecialBindingsMark(idx, binding, this.savedSpecials);
        this.specials[idx] = new SpecialBinding(idx, binding == null ? name.getSymbolValue() : binding.value);
        return this.specials[idx];
    }

    public final LispObject lookupSpecial(Symbol name) {
        SpecialBinding binding = this.ensureSpecialBinding(name.specialIndex);
        return binding == null ? null : binding.value;
    }

    public final SpecialBinding getSpecialBinding(Symbol name) {
        return this.ensureSpecialBinding(name.specialIndex);
    }

    public final LispObject setSpecialVariable(Symbol name, LispObject value) {
        SpecialBinding binding = this.ensureSpecialBinding(name.specialIndex);
        if (binding != null) {
            binding.value = value;
            return binding.value;
        }
        name.setSymbolValue(value);
        return value;
    }

    public final LispObject pushSpecial(Symbol name, LispObject thing) {
        SpecialBinding binding = this.ensureSpecialBinding(name.specialIndex);
        if (binding != null) {
            binding.value = new Cons(thing, binding.value);
            return binding.value;
        }
        LispObject value = name.getSymbolValue();
        if (value != null) {
            Cons newValue = new Cons(thing, value);
            name.setSymbolValue(newValue);
            return newValue;
        }
        return Lisp.error(new UnboundVariable(name));
    }

    public final LispObject safeSymbolValue(Symbol name) {
        SpecialBinding binding = this.ensureSpecialBinding(name.specialIndex);
        if (binding != null) {
            return binding.value;
        }
        LispObject value = name.getSymbolValue();
        return value != null ? value : Lisp.NIL;
    }

    public final void rebindSpecial(Symbol name, LispObject value) {
        SpecialBinding binding = this.getSpecialBinding(name);
        binding.value = value;
    }

    public void pushCatchTag(LispObject tag) {
        this.catchTags = new Cons(tag, this.catchTags);
    }

    public void popCatchTag() {
        if (this.catchTags != Lisp.NIL) {
            this.catchTags = this.catchTags.cdr();
        } else {
            Debug.assertTrue(false);
        }
    }

    public void throwToTag(LispObject tag, LispObject result) {
        for (LispObject rest = this.catchTags; rest != Lisp.NIL; rest = rest.cdr()) {
            if (rest.car() != tag) continue;
            throw new Throw(tag, result, this);
        }
        Lisp.error(new ControlError("Attempt to throw to the nonexistent tag " + tag.princToString() + "."));
    }

    private void ensureStackCapacity(int itemsToPush) {
        if (this.stackPtr + (itemsToPush - 1) >= this.stack.length) {
            this.grow(itemsToPush);
        }
    }

    private void grow(int numEntries) {
        this.topStackSegment.stackPtr = this.stackPtr;
        if (this.spareStackSegment != null) {
            if (this.stackPtr > 0 && this.spareStackSegment.stack.length >= numEntries) {
                this.topStackSegment = this.spareStackSegment;
                this.stack = this.topStackSegment.stack;
                this.spareStackSegment = null;
                this.stackPtr = 0;
                return;
            }
            this.spareStackSegment = null;
        }
        int newSize = this.stackPtr + numEntries;
        if (this.topStackSegment.stack.length < 524284 || this.stackPtr == 0) {
            int newLength = Math.max(newSize, Math.min(524284, this.stack.length * 2));
            StackSegment newSegment = new StackSegment(newLength, this.topStackSegment.next);
            System.arraycopy(this.stack, 0, newSegment.stack, 0, this.stackPtr);
            this.topStackSegment = newSegment;
            this.stack = this.topStackSegment.stack;
            return;
        }
        this.topStackSegment = new StackSegment(Math.max(524284, numEntries), this.topStackSegment);
        this.stack = this.topStackSegment.stack;
        this.stackPtr = 0;
    }

    private StackFrame getStackTop() {
        this.topStackSegment.stackPtr = this.stackPtr;
        if (this.stackPtr == 0) {
            assert (this.topStackSegment.next == null);
            return null;
        }
        StackFrame prev = null;
        StackSegment segment = this.topStackSegment;
        while (segment != null) {
            int numArgs;
            Object[] stk = segment.stack;
            for (int framePos = segment.stackPtr; framePos > 0; framePos -= numArgs + 2) {
                Object stackObj = stk[framePos - 1];
                if (stackObj instanceof StackFrame) {
                    if (prev != null) {
                        prev.setNext((StackFrame)stackObj);
                    }
                    return (StackFrame)this.stack[this.stackPtr - 1];
                }
                StackMarker marker = (StackMarker)stackObj;
                numArgs = marker.getNumArgs();
                LispStackFrame frame = new LispStackFrame(stk, framePos - numArgs - 2, numArgs);
                stk[framePos - 1] = frame;
                if (prev != null) {
                    prev.setNext(frame);
                }
                prev = frame;
            }
            segment = segment.next;
        }
        return (StackFrame)this.stack[this.stackPtr - 1];
    }

    public final void pushStackFrame(JavaStackFrame frame) {
        frame.setNext(this.getStackTop());
        this.ensureStackCapacity(1);
        this.stack[this.stackPtr] = frame;
        ++this.stackPtr;
    }

    private void popStackFrame(int numArgs) {
        Object stackObj = this.stack[this.stackPtr - 1];
        if (stackObj instanceof StackMarker) {
            assert (numArgs == ((StackMarker)stackObj).getNumArgs());
        } else {
            while (stackObj instanceof JavaStackFrame) {
                this.stack[--this.stackPtr] = null;
                stackObj = this.stack[this.stackPtr - 1];
            }
            if (stackObj instanceof StackMarker ? !$assertionsDisabled && numArgs != ((StackMarker)stackObj).getNumArgs() : !$assertionsDisabled && numArgs != ((LispStackFrame)stackObj).getNumArgs()) {
                throw new AssertionError();
            }
        }
        this.stackPtr -= numArgs + 2;
        for (int i = 0; i < numArgs + 2; ++i) {
            this.stack[this.stackPtr + i] = null;
        }
        if (this.stackPtr == 0) {
            this.popStackSegment();
        }
    }

    private void popStackSegment() {
        this.topStackSegment.stackPtr = 0;
        if (this.topStackSegment.next != null) {
            this.spareStackSegment = this.topStackSegment;
            this.topStackSegment = this.topStackSegment.next;
            this.stack = this.topStackSegment.stack;
        }
        this.stackPtr = this.topStackSegment.stackPtr;
    }

    public final Environment setEnv(Environment env) {
        StackFrame stackTop = this.getStackTop();
        return stackTop != null ? stackTop.setEnv(env) : null;
    }

    public void resetStack() {
        this.topStackSegment = new StackSegment(1024, null);
        this.stack = this.topStackSegment.stack;
        this.spareStackSegment = null;
        this.stackPtr = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function) {
        this.ensureStackCapacity(2);
        this.stack[this.stackPtr] = function;
        this.stack[this.stackPtr + 1] = STACK_MARKER_0;
        this.stackPtr += 2;
        try {
            LispObject lispObject = function.execute();
            return lispObject;
        }
        finally {
            this.popStackFrame(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject arg) {
        this.ensureStackCapacity(3);
        this.stack[this.stackPtr] = function;
        this.stack[this.stackPtr + 1] = arg;
        this.stack[this.stackPtr + 2] = STACK_MARKER_1;
        this.stackPtr += 3;
        try {
            LispObject lispObject = function.execute(arg);
            return lispObject;
        }
        finally {
            this.popStackFrame(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second) {
        this.ensureStackCapacity(4);
        this.stack[this.stackPtr] = function;
        this.stack[this.stackPtr + 1] = first;
        this.stack[this.stackPtr + 2] = second;
        this.stack[this.stackPtr + 3] = STACK_MARKER_2;
        this.stackPtr += 4;
        try {
            LispObject lispObject = function.execute(first, second);
            return lispObject;
        }
        finally {
            this.popStackFrame(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third) {
        this.ensureStackCapacity(5);
        this.stack[this.stackPtr] = function;
        this.stack[this.stackPtr + 1] = first;
        this.stack[this.stackPtr + 2] = second;
        this.stack[this.stackPtr + 3] = third;
        this.stack[this.stackPtr + 4] = STACK_MARKER_3;
        this.stackPtr += 5;
        try {
            LispObject lispObject = function.execute(first, second, third);
            return lispObject;
        }
        finally {
            this.popStackFrame(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth) {
        this.ensureStackCapacity(6);
        this.stack[this.stackPtr] = function;
        this.stack[this.stackPtr + 1] = first;
        this.stack[this.stackPtr + 2] = second;
        this.stack[this.stackPtr + 3] = third;
        this.stack[this.stackPtr + 4] = fourth;
        this.stack[this.stackPtr + 5] = STACK_MARKER_4;
        this.stackPtr += 6;
        try {
            LispObject lispObject = function.execute(first, second, third, fourth);
            return lispObject;
        }
        finally {
            this.popStackFrame(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        this.ensureStackCapacity(7);
        this.stack[this.stackPtr] = function;
        this.stack[this.stackPtr + 1] = first;
        this.stack[this.stackPtr + 2] = second;
        this.stack[this.stackPtr + 3] = third;
        this.stack[this.stackPtr + 4] = fourth;
        this.stack[this.stackPtr + 5] = fifth;
        this.stack[this.stackPtr + 6] = STACK_MARKER_5;
        this.stackPtr += 7;
        try {
            LispObject lispObject = function.execute(first, second, third, fourth, fifth);
            return lispObject;
        }
        finally {
            this.popStackFrame(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        this.ensureStackCapacity(8);
        this.stack[this.stackPtr] = function;
        this.stack[this.stackPtr + 1] = first;
        this.stack[this.stackPtr + 2] = second;
        this.stack[this.stackPtr + 3] = third;
        this.stack[this.stackPtr + 4] = fourth;
        this.stack[this.stackPtr + 5] = fifth;
        this.stack[this.stackPtr + 6] = sixth;
        this.stack[this.stackPtr + 7] = STACK_MARKER_6;
        this.stackPtr += 8;
        try {
            LispObject lispObject = function.execute(first, second, third, fourth, fifth, sixth);
            return lispObject;
        }
        finally {
            this.popStackFrame(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        this.ensureStackCapacity(9);
        this.stack[this.stackPtr] = function;
        this.stack[this.stackPtr + 1] = first;
        this.stack[this.stackPtr + 2] = second;
        this.stack[this.stackPtr + 3] = third;
        this.stack[this.stackPtr + 4] = fourth;
        this.stack[this.stackPtr + 5] = fifth;
        this.stack[this.stackPtr + 6] = sixth;
        this.stack[this.stackPtr + 7] = seventh;
        this.stack[this.stackPtr + 8] = STACK_MARKER_7;
        this.stackPtr += 9;
        try {
            LispObject lispObject = function.execute(first, second, third, fourth, fifth, sixth, seventh);
            return lispObject;
        }
        finally {
            this.popStackFrame(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        this.ensureStackCapacity(10);
        this.stack[this.stackPtr] = function;
        this.stack[this.stackPtr + 1] = first;
        this.stack[this.stackPtr + 2] = second;
        this.stack[this.stackPtr + 3] = third;
        this.stack[this.stackPtr + 4] = fourth;
        this.stack[this.stackPtr + 5] = fifth;
        this.stack[this.stackPtr + 6] = sixth;
        this.stack[this.stackPtr + 7] = seventh;
        this.stack[this.stackPtr + 8] = eighth;
        this.stack[this.stackPtr + 9] = STACK_MARKER_8;
        this.stackPtr += 10;
        try {
            LispObject lispObject = function.execute(first, second, third, fourth, fifth, sixth, seventh, eighth);
            return lispObject;
        }
        finally {
            this.popStackFrame(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject execute(LispObject function, LispObject[] args) {
        this.ensureStackCapacity(args.length + 2);
        this.stack[this.stackPtr] = function;
        System.arraycopy(args, 0, this.stack, this.stackPtr + 1, args.length);
        this.stack[this.stackPtr + args.length + 1] = new StackMarker(args.length);
        this.stackPtr += args.length + 2;
        try {
            LispObject lispObject = function.execute(args);
            return lispObject;
        }
        finally {
            this.popStackFrame(args.length);
        }
    }

    public void printBacktrace() {
        this.printBacktrace(0);
    }

    public void printBacktrace(int limit) {
        StackFrame stackTop = this.getStackTop();
        if (stackTop != null) {
            int count = 0;
            Stream out = Lisp.checkCharacterOutputStream(Symbol.TRACE_OUTPUT.symbolValue());
            out._writeLine("Evaluation stack:");
            out._finishOutput();
            StackFrame s = stackTop;
            while (s != null) {
                out._writeString("  ");
                out._writeString(String.valueOf(count));
                out._writeString(": ");
                LispThread.pprint(s.toLispList(), out.getCharPos(), out);
                out.terpri();
                out._finishOutput();
                if (limit > 0 && ++count == limit) break;
                s = s.next;
            }
        }
    }

    public LispObject backtrace(int limit) {
        StackFrame stackTop = this.getStackTop();
        LispObject result = Lisp.NIL;
        if (stackTop != null) {
            int count = 0;
            for (StackFrame s = stackTop; s != null; s = s.getNext()) {
                result = result.push(s);
                if (limit > 0 && ++count == limit) break;
            }
        }
        return result.nreverse();
    }

    public void incrementCallCounts() {
        this.topStackSegment.stackPtr = this.stackPtr;
        int depth = 0;
        StackSegment segment = this.topStackSegment;
        while (segment != null) {
            Object[] stk = segment.stack;
            int framePos = segment.stackPtr;
            while (framePos > 0) {
                LispObject operator;
                int numArgs;
                ++depth;
                Object stackObj = stk[framePos - 1];
                if (stackObj instanceof StackMarker) {
                    numArgs = ((StackMarker)stackObj).getNumArgs();
                } else if (stackObj instanceof LispStackFrame) {
                    numArgs = ((LispStackFrame)stackObj).getNumArgs();
                } else {
                    assert (stackObj instanceof JavaStackFrame);
                    --framePos;
                    continue;
                }
                if ((operator = (LispObject)this.stack[framePos -= numArgs + 2]) == null) continue;
                if (depth <= 8) {
                    operator.incrementHotCount();
                }
                operator.incrementCallCount();
            }
            segment = segment.next;
        }
    }

    private static void pprint(LispObject obj, int indentBy, Stream stream) {
        if (stream.getCharPos() == 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < indentBy; ++i) {
                sb.append(' ');
            }
            stream._writeString(sb.toString());
        }
        String raw = obj.printObject();
        if (stream.getCharPos() + raw.length() < 80) {
            stream._writeString(raw);
            return;
        }
        if (obj instanceof Cons) {
            LispObject first;
            boolean newlineBefore = false;
            LispObject[] array = obj.copyToArray();
            if (array.length > 0 && (first = array[0]) == Symbol.LET) {
                newlineBefore = true;
            }
            int charPos = stream.getCharPos();
            if (newlineBefore && charPos != indentBy) {
                stream.terpri();
                charPos = stream.getCharPos();
            }
            if (charPos < indentBy) {
                StringBuffer sb = new StringBuffer();
                for (int i = charPos; i < indentBy; ++i) {
                    sb.append(' ');
                }
                stream._writeString(sb.toString());
            }
            stream.print('(');
            for (int i = 0; i < array.length; ++i) {
                LispThread.pprint(array[i], indentBy + 2, stream);
                if (i >= array.length - 1) continue;
                stream.print(' ');
            }
        } else {
            stream.terpri();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < indentBy; ++i) {
                sb.append(' ');
            }
            stream._writeString(sb.toString());
            stream._writeString(raw);
            return;
        }
        stream.print(')');
    }

    public String printObject() {
        StringBuffer sb = new StringBuffer("THREAD");
        if (this.name != Lisp.NIL) {
            sb.append(" \"");
            sb.append(this.name.getStringValue());
            sb.append("\"");
        }
        return this.unreadableString(sb.toString());
    }

    static final long sleepMillisPart(LispObject seconds) {
        double d = Lisp.checkDoubleFloat(seconds.multiplyBy(THOUSAND)).getValue();
        if (d < 0.0) {
            Lisp.type_error(seconds, Lisp.list(Symbol.REAL, Fixnum.ZERO));
        }
        return d < 9.223372036854776E18 ? (long)d : Long.MAX_VALUE;
    }

    static final int sleepNanosPart(LispObject seconds) {
        double d = Lisp.checkDoubleFloat(seconds.multiplyBy(THOUSAND)).getValue();
        double n = d * 1000000.0;
        return (n -= (d = 1000000.0 * (double)((long)d))) < 2.147483647E9 ? (int)n : Integer.MAX_VALUE;
    }

    @DocString(name="object-notify-all", args="object", doc="Wakes up all threads that are waiting on this OBJECT's monitor.\nA thread waits on an object's monitor by calling one of the wait methods.")
    private static final class pf_object_notify_all
    extends Primitive {
        pf_object_notify_all() {
            super("object-notify-all", Lisp.PACKAGE_THREADS, true);
        }

        public LispObject execute(LispObject object) {
            try {
                object.lockableInstance().notifyAll();
            }
            catch (IllegalMonitorStateException e) {
                return Lisp.error(new IllegalMonitorState(e.getMessage()));
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="object-notify", args="object", doc="Wakes up a single thread that is waiting on OBJECT's monitor.\nIf any threads are waiting on this object, one of them is chosen to be awakened. The choice is arbitrary and occurs at the discretion of the implementation. A thread waits on an object's monitor by calling one of the wait methods.")
    private static final class pf_object_notify
    extends Primitive {
        pf_object_notify() {
            super("object-notify", Lisp.PACKAGE_THREADS, true, "object");
        }

        public LispObject execute(LispObject object) {
            try {
                object.lockableInstance().notify();
            }
            catch (IllegalMonitorStateException e) {
                return Lisp.error(new IllegalMonitorState(e.getMessage()));
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="object-wait", args="object &optional timeout", doc="Causes the current thread to block until object-notify or object-notify-all is called on OBJECT.\nOptionally unblock execution after TIMEOUT seconds.  A TIMEOUT of zero\nmeans to wait indefinitely.\nA non-zero TIMEOUT of less than a nanosecond is interpolated as a nanosecond wait.\nSee the documentation of java.lang.Object.wait() for further\ninformation.\n")
    private static final class pf_object_wait
    extends Primitive {
        pf_object_wait() {
            super("object-wait", Lisp.PACKAGE_THREADS, true);
        }

        public LispObject execute(LispObject object) {
            try {
                object.lockableInstance().wait();
            }
            catch (InterruptedException e) {
                LispThread.currentThread().processThreadInterrupts();
            }
            catch (IllegalMonitorStateException e) {
                return Lisp.error(new IllegalMonitorState(e.getMessage()));
            }
            return Lisp.NIL;
        }

        public LispObject execute(LispObject object, LispObject timeout) {
            long millis = LispThread.sleepMillisPart(timeout);
            int nanos = LispThread.sleepNanosPart(timeout);
            boolean zeroArgP = timeout.ZEROP() != Lisp.NIL;
            try {
                if (millis == 0L && nanos == 0) {
                    if (zeroArgP) {
                        object.lockableInstance().wait(0L, 0);
                    } else {
                        object.lockableInstance().wait(0L, 1);
                    }
                } else {
                    object.lockableInstance().wait(millis, nanos);
                }
            }
            catch (InterruptedException e) {
                LispThread.currentThread().processThreadInterrupts();
            }
            catch (IllegalMonitorStateException e) {
                return Lisp.error(new IllegalMonitorState(e.getMessage()));
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="synchronized-on", args="form &body body")
    private static final class so_synchronized_on
    extends SpecialOperator {
        so_synchronized_on() {
            super("synchronized-on", Lisp.PACKAGE_THREADS, true, "form &body body");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject args, Environment env) {
            if (args == Lisp.NIL) {
                return Lisp.error(new WrongNumberOfArgumentsException(this, 1));
            }
            LispThread thread = LispThread.currentThread();
            Object object = Lisp.eval(args.car(), env, thread).lockableInstance();
            synchronized (object) {
                return Lisp.progn(args.cdr(), env, thread);
            }
        }
    }

    @DocString(name="frame-to-list", args="frame")
    private static final class pf_frame_to_list
    extends Primitive {
        pf_frame_to_list() {
            super("frame-to-list", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject[] args) {
            if (args.length != 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this, 1));
            }
            return Lisp.checkStackFrame(args[0]).toLispList();
        }
    }

    @DocString(name="frame-to-string", args="frame", doc="Convert stack FRAME to a (potentially) readable string.")
    private static final class pf_frame_to_string
    extends Primitive {
        pf_frame_to_string() {
            super("frame-to-string", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject[] args) {
            if (args.length != 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this, 1));
            }
            return Lisp.checkStackFrame(args[0]).toLispString();
        }
    }

    @DocString(name="backtrace", doc="Returns a Java backtrace of the invoking thread.")
    private static final class pf_backtrace
    extends Primitive {
        pf_backtrace() {
            super("backtrace", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject[] args) {
            if (args.length > 1) {
                return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, -1, 1));
            }
            int limit = args.length > 0 ? Fixnum.getValue(args[0]) : 0;
            return LispThread.currentThread().backtrace(limit);
        }
    }

    @DocString(name="current-thread", doc="Returns a reference to invoking thread.")
    private static final class pf_current_thread
    extends Primitive {
        pf_current_thread() {
            super("current-thread", Lisp.PACKAGE_THREADS, true);
        }

        public LispObject execute() {
            return LispThread.currentThread();
        }
    }

    private static class StackSegment
    implements Inspectable {
        final Object[] stack;
        final StackSegment next;
        int stackPtr;

        StackSegment(int size, StackSegment next) {
            this.stack = new Object[size];
            this.next = next;
        }

        public LispObject getParts() {
            Cons result = new Cons(Lisp.NIL);
            return result.push(new Symbol("INITIAL-SEGMENT-SIZE")).push(LispInteger.getInstance(1024)).push(new Symbol("SEGMENT-SIZE")).push(LispInteger.getInstance(524284)).nreverse();
        }
    }

    private static class StackMarker {
        final int numArgs;

        StackMarker(int numArgs) {
            this.numArgs = numArgs;
        }

        int getNumArgs() {
            return this.numArgs;
        }
    }
}

