require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_PMAP_H_)) {
    eval 'sub _POWERPC_PMAP_H_ () {1;}' unless defined(&_POWERPC_PMAP_H_);
    require 'machine/pte.ph';
    unless(defined(&_LOCORE)) {
    }
    eval 'sub SR_TYPE () {0x80000000;}' unless defined(&SR_TYPE);
    eval 'sub SR_SUKEY () {0x40000000;}' unless defined(&SR_SUKEY);
    eval 'sub SR_PRKEY () {0x20000000;}' unless defined(&SR_PRKEY);
    eval 'sub SR_NOEXEC () {0x10000000;}' unless defined(&SR_NOEXEC);
    eval 'sub SR_VSID () {0xffffff;}' unless defined(&SR_VSID);
    unless(defined(&_LOCORE)) {
	eval 'sub VP_SR_SIZE () {16;}' unless defined(&VP_SR_SIZE);
	eval 'sub VP_SR_MASK () {( &VP_SR_SIZE-1);}' unless defined(&VP_SR_MASK);
	eval 'sub VP_SR_POS () {28;}' unless defined(&VP_SR_POS);
	eval 'sub VP_IDX1_SIZE () {256;}' unless defined(&VP_IDX1_SIZE);
	eval 'sub VP_IDX1_MASK () {( &VP_IDX1_SIZE-1);}' unless defined(&VP_IDX1_MASK);
	eval 'sub VP_IDX1_POS () {20;}' unless defined(&VP_IDX1_POS);
	eval 'sub VP_IDX2_SIZE () {256;}' unless defined(&VP_IDX2_SIZE);
	eval 'sub VP_IDX2_MASK () {( &VP_IDX2_SIZE-1);}' unless defined(&VP_IDX2_MASK);
	eval 'sub VP_IDX2_POS () {12;}' unless defined(&VP_IDX2_POS);
	eval 'sub PMAP_CACHE_DEFAULT () {0;}' unless defined(&PMAP_CACHE_DEFAULT);
	eval 'sub PMAP_CACHE_CI () {1;}' unless defined(&PMAP_CACHE_CI);
	eval 'sub PMAP_CACHE_WT () {2;}' unless defined(&PMAP_CACHE_WT);
	eval 'sub PMAP_CACHE_WB () {3;}' unless defined(&PMAP_CACHE_WB);
	if(defined(&_KERNEL)) {
	    eval 'sub PPC_SEGMENT_LENGTH () {0x10000000;}' unless defined(&PPC_SEGMENT_LENGTH);
	    eval 'sub PPC_SEGMENT_MASK () {0xf0000000;}' unless defined(&PPC_SEGMENT_MASK);
	    unless(defined(&NPMAPS)) {
		eval 'sub NPMAPS () {32768;}' unless defined(&NPMAPS);
	    }
	    eval 'sub pmap_kernel () {
	        eval q(( &kernel_pmap_));
	    }' unless defined(&pmap_kernel);
	    eval 'sub pmap_clear_modify {
	        my($page) = @_;
    		eval q(( &pteclrbits(($page),  &PG_PMAP_MOD,  &TRUE)));
	    }' unless defined(&pmap_clear_modify);
	    eval 'sub pmap_clear_reference {
	        my($page) = @_;
    		eval q(( &pteclrbits(($page),  &PG_PMAP_REF,  &TRUE)));
	    }' unless defined(&pmap_clear_reference);
	    eval 'sub pmap_is_modified {
	        my($page) = @_;
    		eval q(( &pteclrbits(($page),  &PG_PMAP_MOD,  &FALSE)));
	    }' unless defined(&pmap_is_modified);
	    eval 'sub pmap_is_referenced {
	        my($page) = @_;
    		eval q(( &pteclrbits(($page),  &PG_PMAP_REF,  &FALSE)));
	    }' unless defined(&pmap_is_referenced);
	    eval 'sub pmap_unwire {
	        my($pm, $va) = @_;
    		eval q();
	    }' unless defined(&pmap_unwire);
	    eval 'sub pmap_update {
	        my($pmap) = @_;
    		eval q();
	    }' unless defined(&pmap_update);
	    eval 'sub pmap_resident_count {
	        my($pmap) = @_;
    		eval q((($pmap)-> ($pm_stats->{resident_count})));
	    }' unless defined(&pmap_resident_count);
	    eval 'sub pmap_map_direct {
	        my($pg) = @_;
    		eval q((( &vaddr_t) &VM_PAGE_TO_PHYS($pg)));
	    }' unless defined(&pmap_map_direct);
	    eval 'sub pmap_unmap_direct {
	        my($va) = @_;
    		eval q( &PHYS_TO_VM_PAGE(( &paddr_t)$va));
	    }' unless defined(&pmap_unmap_direct);
	    eval 'sub __HAVE_PMAP_DIRECT () {1;}' unless defined(&__HAVE_PMAP_DIRECT);
	    eval 'sub pmap_copy {
	        my($dst_pmap, $src_pmap, $dst_addr, $len, $src_addr) = @_;
    		eval q(;);
	    }' unless defined(&pmap_copy);
	    eval 'sub pmap_unuse_final {
	        my($p) = @_;
    		eval q();
	    }' unless defined(&pmap_unuse_final);
	    eval 'sub pmap_remove_holes {
	        my($vm) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&pmap_remove_holes);
	    eval 'sub PMAP_STEAL_MEMORY () {1;}' unless defined(&PMAP_STEAL_MEMORY);
	    eval 'sub PG_PMAP_MOD () { &PG_PMAP0;}' unless defined(&PG_PMAP_MOD);
	    eval 'sub PG_PMAP_REF () { &PG_PMAP1;}' unless defined(&PG_PMAP_REF);
	    eval 'sub PG_PMAP_EXE () { &PG_PMAP2;}' unless defined(&PG_PMAP_EXE);
	    eval 'sub PMAP_PA_MASK () {~(( &paddr_t) &PAGE_MASK);}' unless defined(&PMAP_PA_MASK);
	    eval 'sub PMAP_NOCACHE () {0x1;}' unless defined(&PMAP_NOCACHE);
	    eval 'sub PMAP_WT () {0x2;}' unless defined(&PMAP_WT);
	}
	eval 'sub VM_MDPAGE_INIT {
	    my($pg) = @_;
    	    eval q( &do {  &LIST_INIT((($pg)-> ($mdpage->{pv_list}))); }  &while (0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
