require '_h2ph_pre.ph';

no warnings qw(redefine misc);

eval 'sub IRQ_NONE () {0;}' unless defined(&IRQ_NONE);
eval 'sub IRQ_HANDLED () {1;}' unless defined(&IRQ_HANDLED);
eval 'sub __force () {1;}' unless defined(&__force);
eval 'sub KERN_INFO () {1;}' unless defined(&KERN_INFO);
eval 'sub KERN_WARNING () {1;}' unless defined(&KERN_WARNING);
eval 'sub KERN_NOTICE () {1;}' unless defined(&KERN_NOTICE);
eval 'sub KERN_DEBUG () {1;}' unless defined(&KERN_DEBUG);
eval 'sub KERN_CRIT () {1;}' unless defined(&KERN_CRIT);
eval 'sub KERN_ERR () {1;}' unless defined(&KERN_ERR);
eval 'sub KBUILD_MODNAME () {"drm";}' unless defined(&KBUILD_MODNAME);
unless(defined(&pr_fmt)) {
    eval 'sub pr_fmt {
        my($fmt) = @_;
	    eval q($fmt);
    }' unless defined(&pr_fmt);
}
eval 'sub printk () {( &fmt,  &arg...)  &printf( &fmt,   &arg);}' unless defined(&printk);
eval 'sub pr_warn () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_warn);
eval 'sub pr_notice () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_notice);
eval 'sub pr_crit () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_crit);
eval 'sub pr_err () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_err);
if(defined(&DRMDEBUG)) {
    eval 'sub pr_info () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_info);
    eval 'sub pr_debug () {( &fmt,  &arg...)  &printf( &pr_fmt( &fmt),   &arg);}' unless defined(&pr_debug);
} else {
    eval 'sub pr_info () {( &fmt,  &arg...)  &do { }  &while(0);}' unless defined(&pr_info);
    eval 'sub pr_debug () {( &fmt,  &arg...)  &do { }  &while(0);}' unless defined(&pr_debug);
}
eval 'sub dev_warn () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *WARNING* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_warn);
eval 'sub dev_notice () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *NOTICE* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_notice);
eval 'sub dev_crit () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *ERROR* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_crit);
eval 'sub dev_err () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *ERROR* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_err);
if(defined(&DRMDEBUG)) {
    eval 'sub dev_info () {( &dev,  &fmt,  &arg...)  &printf("drm: "  &fmt,   &arg);}' unless defined(&dev_info);
    eval 'sub dev_debug () {( &dev,  &fmt,  &arg...)  &printf("drm:pid%d:%s *DEBUG* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&dev_debug);
} else {
    eval 'sub dev_info () {( &dev,  &fmt,  &arg...)  &do { }  &while(0);}' unless defined(&dev_info);
    eval 'sub dev_debug () {( &dev,  &fmt,  &arg...)  &do { }  &while(0);}' unless defined(&dev_debug);
}
unless(defined(&spin_lock)) {
    sub spin_lock {
	my($mtxp) = @_;
	eval q( &mtx_enter($mtxp));
    }
}
unless(defined(&spin_unlock)) {
    sub spin_unlock {
	my($mtxp) = @_;
	eval q( &mtx_leave($mtxp));
    }
}
unless(defined(&spin_lock_irq)) {
    sub spin_lock_irq {
	my($mtxp) = @_;
	eval q( &mtx_enter($mtxp));
    }
}
unless(defined(&spin_unlock_irq)) {
    sub spin_unlock_irq {
	my($mtxp) = @_;
	eval q( &mtx_leave($mtxp));
    }
}
unless(defined(&assert_spin_locked)) {
    sub assert_spin_locked {
	my($mtxp) = @_;
	eval q( &MUTEX_ASSERT_LOCKED($mtxp));
    }
}
unless(defined(&mutex_lock_interruptible)) {
    sub mutex_lock_interruptible {
	my($rwl) = @_;
	eval q(- &rw_enter($rwl,  &RW_WRITE |  &RW_INTR));
    }
}
unless(defined(&mutex_lock)) {
    sub mutex_lock {
	my($rwl) = @_;
	eval q( &rw_enter_write($rwl));
    }
}
unless(defined(&mutex_unlock)) {
    sub mutex_unlock {
	my($rwl) = @_;
	eval q( &rw_exit_write($rwl));
    }
}
unless(defined(&mutex_is_locked)) {
    sub mutex_is_locked {
	my($rwl) = @_;
	eval q(( &rw_status($rwl) ==  &RW_WRITE));
    }
}
unless(defined(&down_read)) {
    sub down_read {
	my($rwl) = @_;
	eval q( &rw_enter_read($rwl));
    }
}
unless(defined(&up_read)) {
    sub up_read {
	my($rwl) = @_;
	eval q( &rw_exit_read($rwl));
    }
}
unless(defined(&down_write)) {
    sub down_write {
	my($rwl) = @_;
	eval q( &rw_enter_write($rwl));
    }
}
unless(defined(&up_write)) {
    sub up_write {
	my($rwl) = @_;
	eval q( &rw_exit_write($rwl));
    }
}
unless(defined(&read_lock)) {
    sub read_lock {
	my($rwl) = @_;
	eval q( &rw_enter_read($rwl));
    }
}
unless(defined(&read_unlock)) {
    sub read_unlock {
	my($rwl) = @_;
	eval q( &rw_exit_read($rwl));
    }
}
unless(defined(&write_lock)) {
    sub write_lock {
	my($rwl) = @_;
	eval q( &rw_enter_write($rwl));
    }
}
unless(defined(&write_unlock)) {
    sub write_unlock {
	my($rwl) = @_;
	eval q( &rw_exit_write($rwl));
    }
}
if(defined(&__i386__) || defined(&__amd64__)) {
}
1;
