require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sys/timeout.ph';
if(!defined(&SMALL_KERNEL)) {
    eval 'sub NCR53C9X_DEBUG () {1;}' unless defined(&NCR53C9X_DEBUG);
}
eval 'sub NCR_NTARG () {16;}' unless defined(&NCR_NTARG);
eval 'sub NCR_NLUN () {8;}' unless defined(&NCR_NLUN);
eval 'sub NCR_ABORT_TIMEOUT () {2000;}' unless defined(&NCR_ABORT_TIMEOUT);
eval 'sub NCR_SENSE_TIMEOUT () {1000;}' unless defined(&NCR_SENSE_TIMEOUT);
unless(defined(&FREQTOCCF)) {
    sub FREQTOCCF {
	my($freq) = @_;
	eval q(((($freq + 4) / 5)));
    }
}
eval 'sub NCR_VARIANT_ESP100 () {0;}' unless defined(&NCR_VARIANT_ESP100);
eval 'sub NCR_VARIANT_ESP100A () {1;}' unless defined(&NCR_VARIANT_ESP100A);
eval 'sub NCR_VARIANT_ESP200 () {2;}' unless defined(&NCR_VARIANT_ESP200);
eval 'sub NCR_VARIANT_NCR53C94 () {3;}' unless defined(&NCR_VARIANT_NCR53C94);
eval 'sub NCR_VARIANT_NCR53C96 () {4;}' unless defined(&NCR_VARIANT_NCR53C96);
eval 'sub NCR_VARIANT_ESP406 () {5;}' unless defined(&NCR_VARIANT_ESP406);
eval 'sub NCR_VARIANT_FAS408 () {6;}' unless defined(&NCR_VARIANT_FAS408);
eval 'sub NCR_VARIANT_FAS216 () {7;}' unless defined(&NCR_VARIANT_FAS216);
eval 'sub NCR_VARIANT_AM53C974 () {8;}' unless defined(&NCR_VARIANT_AM53C974);
eval 'sub NCR_VARIANT_FAS366 () {9;}' unless defined(&NCR_VARIANT_FAS366);
eval 'sub NCR_VARIANT_MAX () {10;}' unless defined(&NCR_VARIANT_MAX);
eval 'sub ECB_ALLOC () {0x1;}' unless defined(&ECB_ALLOC);
eval 'sub ECB_READY () {0x2;}' unless defined(&ECB_READY);
eval 'sub ECB_SENSE () {0x4;}' unless defined(&ECB_SENSE);
eval 'sub ECB_ABORT () {0x40;}' unless defined(&ECB_ABORT);
eval 'sub ECB_RESET () {0x80;}' unless defined(&ECB_RESET);
eval 'sub ECB_TENTATIVE_DONE () {0x100;}' unless defined(&ECB_TENTATIVE_DONE);
if((defined(&NCR53C9X_DEBUG) ? &NCR53C9X_DEBUG : undef) > 1) {
}
if((defined(&NCR53C9X_DEBUG) ? &NCR53C9X_DEBUG : undef) > 1) {
    eval 'sub ECB_TRACE {
        my($ecb, $msg, $a, $b) = @_;
	    eval q( &do {  &const \'char\' * &f = \\"[\\" $msg \\"]\\"; \'int\'  &n =  &strlen(($ecb)-> &trace);  &if ( &n < ($sizeof{($ecb)-> &trace}-100))  &snprintf(($ecb)-> &trace +  &n, $sizeof{($ecb)-> &trace} -  &n,  &f, $a, $b); }  &while(0));
    }' unless defined(&ECB_TRACE);
} else {
    eval 'sub ECB_TRACE {
        my($ecb, $msg, $a, $b) = @_;
	    eval q();
    }' unless defined(&ECB_TRACE);
}
eval 'sub T_NEED_TO_RESET () {0x1;}' unless defined(&T_NEED_TO_RESET);
eval 'sub T_NEGOTIATE () {0x2;}' unless defined(&T_NEGOTIATE);
eval 'sub T_BUSY () {0x4;}' unless defined(&T_BUSY);
eval 'sub T_SYNCMODE () {0x8;}' unless defined(&T_SYNCMODE);
eval 'sub T_SYNCHOFF () {0x10;}' unless defined(&T_SYNCHOFF);
eval 'sub T_RSELECTOFF () {0x20;}' unless defined(&T_RSELECTOFF);
eval 'sub T_TAG () {0x40;}' unless defined(&T_TAG);
eval 'sub T_WIDE () {0x80;}' unless defined(&T_WIDE);
unless(defined(&TINFO_LUN)) {
    sub TINFO_LUN {
	my($t, $l) = @_;
	eval q((((($l) <  &NCR_NLUN)  && ((($t)-> $lun[($l)]) !=  &NULL)) ? (($t)-> $lun[($l)]) :  &ncr53c9x_lunsearch(($t), ( &int64_t)($l))));
    }
}
unless(defined(&LOGLINE)) {
    sub LOGLINE {
	my($p) = @_;
	eval q();
    }
}
eval 'sub NCR_SHOWECBS () {0x1;}' unless defined(&NCR_SHOWECBS);
eval 'sub NCR_SHOWINTS () {0x2;}' unless defined(&NCR_SHOWINTS);
eval 'sub NCR_SHOWCMDS () {0x4;}' unless defined(&NCR_SHOWCMDS);
eval 'sub NCR_SHOWMISC () {0x8;}' unless defined(&NCR_SHOWMISC);
eval 'sub NCR_SHOWTRAC () {0x10;}' unless defined(&NCR_SHOWTRAC);
eval 'sub NCR_SHOWSTART () {0x20;}' unless defined(&NCR_SHOWSTART);
eval 'sub NCR_SHOWPHASE () {0x40;}' unless defined(&NCR_SHOWPHASE);
eval 'sub NCR_SHOWDMA () {0x80;}' unless defined(&NCR_SHOWDMA);
eval 'sub NCR_SHOWCCMDS () {0x100;}' unless defined(&NCR_SHOWCCMDS);
eval 'sub NCR_SHOWMSGS () {0x200;}' unless defined(&NCR_SHOWMSGS);
if(defined(&NCR53C9X_DEBUG)) {
    eval 'sub NCR_ECBS {
        my($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWECBS)  &printf $str;}  &while (0));
    }' unless defined(&NCR_ECBS);
    eval 'sub NCR_MISC {
        my($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWMISC)  &printf $str;}  &while (0));
    }' unless defined(&NCR_MISC);
    eval 'sub NCR_INTS {
        my($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWINTS)  &printf $str;}  &while (0));
    }' unless defined(&NCR_INTS);
    eval 'sub NCR_TRACE {
        my($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWTRAC)  &printf $str;}  &while (0));
    }' unless defined(&NCR_TRACE);
    eval 'sub NCR_CMDS {
        my($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWCMDS)  &printf $str;}  &while (0));
    }' unless defined(&NCR_CMDS);
    eval 'sub NCR_START {
        my($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWSTART)  &printf $str;} &while (0));
    }' unless defined(&NCR_START);
    eval 'sub NCR_PHASE {
        my($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWPHASE)  &printf $str;} &while (0));
    }' unless defined(&NCR_PHASE);
    eval 'sub NCR_DMA {
        my($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWDMA)  &printf $str;} &while (0));
    }' unless defined(&NCR_DMA);
    eval 'sub NCR_MSGS {
        my($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWMSGS)  &printf $str;} &while (0));
    }' unless defined(&NCR_MSGS);
} else {
    eval 'sub NCR_ECBS {
        my($str) = @_;
	    eval q();
    }' unless defined(&NCR_ECBS);
    eval 'sub NCR_MISC {
        my($str) = @_;
	    eval q();
    }' unless defined(&NCR_MISC);
    eval 'sub NCR_INTS {
        my($str) = @_;
	    eval q();
    }' unless defined(&NCR_INTS);
    eval 'sub NCR_TRACE {
        my($str) = @_;
	    eval q();
    }' unless defined(&NCR_TRACE);
    eval 'sub NCR_CMDS {
        my($str) = @_;
	    eval q();
    }' unless defined(&NCR_CMDS);
    eval 'sub NCR_START {
        my($str) = @_;
	    eval q();
    }' unless defined(&NCR_START);
    eval 'sub NCR_PHASE {
        my($str) = @_;
	    eval q();
    }' unless defined(&NCR_PHASE);
    eval 'sub NCR_DMA {
        my($str) = @_;
	    eval q();
    }' unless defined(&NCR_DMA);
    eval 'sub NCR_MSGS {
        my($str) = @_;
	    eval q();
    }' unless defined(&NCR_MSGS);
}
eval 'sub NCR_MAX_MSG_LEN () {8;}' unless defined(&NCR_MAX_MSG_LEN);
eval 'sub NCR_IDLE () {1;}' unless defined(&NCR_IDLE);
eval 'sub NCR_SELECTING () {2;}' unless defined(&NCR_SELECTING);
eval 'sub NCR_RESELECTED () {3;}' unless defined(&NCR_RESELECTED);
eval 'sub NCR_IDENTIFIED () {4;}' unless defined(&NCR_IDENTIFIED);
eval 'sub NCR_CONNECTED () {5;}' unless defined(&NCR_CONNECTED);
eval 'sub NCR_DISCONNECT () {6;}' unless defined(&NCR_DISCONNECT);
eval 'sub NCR_CMDCOMPLETE () {7;}' unless defined(&NCR_CMDCOMPLETE);
eval 'sub NCR_CLEANING () {8;}' unless defined(&NCR_CLEANING);
eval 'sub NCR_SBR () {9;}' unless defined(&NCR_SBR);
eval 'sub NCR_DROP_MSGI () {0x1;}' unless defined(&NCR_DROP_MSGI);
eval 'sub NCR_ABORTING () {0x2;}' unless defined(&NCR_ABORTING);
eval 'sub NCR_DOINGDMA () {0x4;}' unless defined(&NCR_DOINGDMA);
eval 'sub NCR_SYNCHNEGO () {0x8;}' unless defined(&NCR_SYNCHNEGO);
eval 'sub NCR_ICCS () {0x10;}' unless defined(&NCR_ICCS);
eval 'sub NCR_WAITI () {0x20;}' unless defined(&NCR_WAITI);
eval 'sub NCR_ATN () {0x40;}' unless defined(&NCR_ATN);
eval 'sub NCR_EXPECT_ILLCMD () {0x80;}' unless defined(&NCR_EXPECT_ILLCMD);
eval 'sub NCR_F_HASCFG3 () {0x1;}' unless defined(&NCR_F_HASCFG3);
eval 'sub NCR_F_FASTSCSI () {0x2;}' unless defined(&NCR_F_FASTSCSI);
eval 'sub NCR_F_DMASELECT () {0x4;}' unless defined(&NCR_F_DMASELECT);
eval 'sub NCR_F_SELATN3 () {0x8;}' unless defined(&NCR_F_SELATN3);
eval 'sub SEND_DEV_RESET () {0x1;}' unless defined(&SEND_DEV_RESET);
eval 'sub SEND_PARITY_ERROR () {0x2;}' unless defined(&SEND_PARITY_ERROR);
eval 'sub SEND_INIT_DET_ERR () {0x4;}' unless defined(&SEND_INIT_DET_ERR);
eval 'sub SEND_REJECT () {0x8;}' unless defined(&SEND_REJECT);
eval 'sub SEND_IDENTIFY () {0x10;}' unless defined(&SEND_IDENTIFY);
eval 'sub SEND_ABORT () {0x20;}' unless defined(&SEND_ABORT);
eval 'sub SEND_WDTR () {0x40;}' unless defined(&SEND_WDTR);
eval 'sub SEND_SDTR () {0x80;}' unless defined(&SEND_SDTR);
eval 'sub SEND_TAG () {0x100;}' unless defined(&SEND_TAG);
eval 'sub ST_MASK () {0x3e;}' unless defined(&ST_MASK);
eval 'sub IOI () {0x1;}' unless defined(&IOI);
eval 'sub CDI () {0x2;}' unless defined(&CDI);
eval 'sub MSGI () {0x4;}' unless defined(&MSGI);
eval 'sub DATA_OUT_PHASE () {(0);}' unless defined(&DATA_OUT_PHASE);
eval 'sub DATA_IN_PHASE () {( &IOI);}' unless defined(&DATA_IN_PHASE);
eval 'sub COMMAND_PHASE () {( &CDI);}' unless defined(&COMMAND_PHASE);
eval 'sub STATUS_PHASE () {( &CDI| &IOI);}' unless defined(&STATUS_PHASE);
eval 'sub MESSAGE_OUT_PHASE () {( &MSGI| &CDI);}' unless defined(&MESSAGE_OUT_PHASE);
eval 'sub MESSAGE_IN_PHASE () {( &MSGI| &CDI| &IOI);}' unless defined(&MESSAGE_IN_PHASE);
eval 'sub PHASE_MASK () {( &MSGI| &CDI| &IOI);}' unless defined(&PHASE_MASK);
eval 'sub BUSFREE_PHASE () {0x100;}' unless defined(&BUSFREE_PHASE);
eval 'sub INVALID_PHASE () {0x101;}' unless defined(&INVALID_PHASE);
eval 'sub PSEUDO_PHASE () {0x100;}' unless defined(&PSEUDO_PHASE);
unless(defined(&NCR_READ_REG)) {
    sub NCR_READ_REG {
	my($sc, $reg) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_read_reg}))(($sc), ($reg)));
    }
}
unless(defined(&NCR_WRITE_REG)) {
    sub NCR_WRITE_REG {
	my($sc, $reg, $val) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_write_reg}))(($sc), ($reg), ($val)));
    }
}
if(defined(&NCR53C9X_DEBUG)) {
    eval 'sub NCRCMD {
        my($sc, $cmd) = @_;
	    eval q( &do {  &if ( &ncr53c9x_debug &  &NCR_SHOWCCMDS)  &printf(\\"<cmd:0x%x %d>\\", $cmd,  &__LINE__);  ($sc->{sc_lastcmd}) = $cmd;  &NCR_WRITE_REG($sc,  &NCR_CMD, $cmd); }  &while (0));
    }' unless defined(&NCRCMD);
} else {
    eval 'sub NCRCMD {
        my($sc, $cmd) = @_;
	    eval q( &NCR_WRITE_REG($sc,  &NCR_CMD, $cmd));
    }' unless defined(&NCRCMD);
}
unless(defined(&NCRDMA_ISINTR)) {
    sub NCRDMA_ISINTR {
	my($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_isintr}))(($sc)));
    }
}
unless(defined(&NCRDMA_RESET)) {
    sub NCRDMA_RESET {
	my($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_reset}))(($sc)));
    }
}
unless(defined(&NCRDMA_INTR)) {
    sub NCRDMA_INTR {
	my($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_intr}))(($sc)));
    }
}
unless(defined(&NCRDMA_SETUP)) {
    sub NCRDMA_SETUP {
	my($sc, $addr, $len, $datain, $dmasize) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_setup}))(($sc), ($addr), ($len), ($datain), ($dmasize)));
    }
}
unless(defined(&NCRDMA_GO)) {
    sub NCRDMA_GO {
	my($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_go}))(($sc)));
    }
}
unless(defined(&NCRDMA_ISACTIVE)) {
    sub NCRDMA_ISACTIVE {
	my($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_isactive}))(($sc)));
    }
}
unless(defined(&ncr53c9x_cpb2stp)) {
    sub ncr53c9x_cpb2stp {
	my($sc, $cpb) = @_;
	eval q(((250* ($cpb)) / ($sc)-> &sc_freq));
    }
}
1;
