require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_BIT_TWIDDLE)) {
    eval 'sub _BIT_TWIDDLE () {1;}' unless defined(&_BIT_TWIDDLE);
    eval 'sub LOWEST_SET_BIT {
        my($x) = @_;
	    eval q((((($x) - 1) & ($x)) ^ ($x)));
    }' unless defined(&LOWEST_SET_BIT);
    eval 'sub GTEQ_POWER {
        my($x, $p) = @_;
	    eval q(((($x) >> ($p)) != 0));
    }' unless defined(&GTEQ_POWER);
    eval 'sub MASK_TO_SHIFT2 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 1) ? 1: 0));
    }' unless defined(&MASK_TO_SHIFT2);
    eval 'sub MASK_TO_SHIFT4 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 2) ? 2+  &MASK_TO_SHIFT2(($m) >> 2) :  &MASK_TO_SHIFT2(($m))));
    }' unless defined(&MASK_TO_SHIFT4);
    eval 'sub MASK_TO_SHIFT8 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 4) ? 4+  &MASK_TO_SHIFT4(($m) >> 4) :  &MASK_TO_SHIFT4(($m))));
    }' unless defined(&MASK_TO_SHIFT8);
    eval 'sub MASK_TO_SHIFT16 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 8) ? 8+  &MASK_TO_SHIFT8(($m) >> 8) :  &MASK_TO_SHIFT8(($m))));
    }' unless defined(&MASK_TO_SHIFT16);
    eval 'sub MASK_TO_SHIFT {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 16) ? 16+  &MASK_TO_SHIFT16(($m) >> 16) :  &MASK_TO_SHIFT16(($m))));
    }' unless defined(&MASK_TO_SHIFT);
    eval 'sub MASK_AND_RSHIFT {
        my($x, $mask) = @_;
	    eval q(((($x) & ($mask)) >>  &MASK_TO_SHIFT($mask)));
    }' unless defined(&MASK_AND_RSHIFT);
    eval 'sub LSHIFT {
        my($x, $mask) = @_;
	    eval q((($x) <<  &MASK_TO_SHIFT($mask)));
    }' unless defined(&LSHIFT);
    eval 'sub MASK_AND_REPLACE {
        my($reg, $val, $mask) = @_;
	    eval q((($reg & ~$mask) |  &LSHIFT($val, $mask)));
    }' unless defined(&MASK_AND_REPLACE);
    eval 'sub PRESHIFT {
        my($m) = @_;
	    eval q( &MASK_AND_RSHIFT(($m), ($m)));
    }' unless defined(&PRESHIFT);
}
eval 'sub RTW_IDR0 () {0x;}' unless defined(&RTW_IDR0);
eval 'sub RTW_IDR1 () {0x4;}' unless defined(&RTW_IDR1);
eval 'sub RTW_MAR0 () {0x8;}' unless defined(&RTW_MAR0);
eval 'sub RTW_MAR1 () {0xc;}' unless defined(&RTW_MAR1);
eval 'sub RTW_TSFTRL () {0x18;}' unless defined(&RTW_TSFTRL);
eval 'sub RTW_TSFTRH () {0x1c;}' unless defined(&RTW_TSFTRH);
eval 'sub RTW_TLPDA () {0x20;}' unless defined(&RTW_TLPDA);
eval 'sub RTW_TNPDA () {0x24;}' unless defined(&RTW_TNPDA);
eval 'sub RTW_THPDA () {0x28;}' unless defined(&RTW_THPDA);
eval 'sub RTW_BRSR () {0x2c;}' unless defined(&RTW_BRSR);
eval 'sub RTW8180_BRSR_BPLCP () {(1<<8);}' unless defined(&RTW8180_BRSR_BPLCP);
eval 'sub RTW8180_BRSR_MBR_MASK () {0x3;}' unless defined(&RTW8180_BRSR_MBR_MASK);
eval 'sub RTW8180_BRSR_MBR_1MBPS () { &LSHIFT(0,  &RTW8180_BRSR_MBR_MASK);}' unless defined(&RTW8180_BRSR_MBR_1MBPS);
eval 'sub RTW8180_BRSR_MBR_2MBPS () { &LSHIFT(1,  &RTW8180_BRSR_MBR_MASK);}' unless defined(&RTW8180_BRSR_MBR_2MBPS);
eval 'sub RTW8180_BRSR_MBR_5MBPS () { &LSHIFT(2,  &RTW8180_BRSR_MBR_MASK);}' unless defined(&RTW8180_BRSR_MBR_5MBPS);
eval 'sub RTW8180_BRSR_MBR_11MBPS () { &LSHIFT(3,  &RTW8180_BRSR_MBR_MASK);}' unless defined(&RTW8180_BRSR_MBR_11MBPS);
eval 'sub RTW8185_BRSR_MBR_MASK () {0xfff;}' unless defined(&RTW8185_BRSR_MBR_MASK);
eval 'sub RTW8185_BRSR_MBR_1MBPS () {(1<<0);}' unless defined(&RTW8185_BRSR_MBR_1MBPS);
eval 'sub RTW8185_BRSR_MBR_2MBPS () {(1<<1);}' unless defined(&RTW8185_BRSR_MBR_2MBPS);
eval 'sub RTW8185_BRSR_MBR_5MBPS () {(1<<2);}' unless defined(&RTW8185_BRSR_MBR_5MBPS);
eval 'sub RTW8185_BRSR_MBR_11MBPS () {(1<<3);}' unless defined(&RTW8185_BRSR_MBR_11MBPS);
eval 'sub RTW8185_BRSR_MBR_6MBPS () {(1<<4);}' unless defined(&RTW8185_BRSR_MBR_6MBPS);
eval 'sub RTW8185_BRSR_MBR_9MBPS () {(1<<5);}' unless defined(&RTW8185_BRSR_MBR_9MBPS);
eval 'sub RTW8185_BRSR_MBR_12MBPS () {(1<<6);}' unless defined(&RTW8185_BRSR_MBR_12MBPS);
eval 'sub RTW8185_BRSR_MBR_18MBPS () {(1<<7);}' unless defined(&RTW8185_BRSR_MBR_18MBPS);
eval 'sub RTW8185_BRSR_MBR_24MBPS () {(1<<8);}' unless defined(&RTW8185_BRSR_MBR_24MBPS);
eval 'sub RTW8185_BRSR_MBR_36MBPS () {(1<<9);}' unless defined(&RTW8185_BRSR_MBR_36MBPS);
eval 'sub RTW8185_BRSR_MBR_48MBPS () {(1<<10);}' unless defined(&RTW8185_BRSR_MBR_48MBPS);
eval 'sub RTW8185_BRSR_MBR_54MBPS () {(1<<11);}' unless defined(&RTW8185_BRSR_MBR_54MBPS);
eval 'sub RTW_BSSID () {0x2e;}' unless defined(&RTW_BSSID);
eval 'sub RTW_BSSID16 () {0x2e;}' unless defined(&RTW_BSSID16);
eval 'sub RTW_BSSID32 () {(0x2e + 4);}' unless defined(&RTW_BSSID32);
eval 'sub RTW_BSSID0 () { &RTW_BSSID16;}' unless defined(&RTW_BSSID0);
eval 'sub RTW_BSSID1 () {( &RTW_BSSID0 + 1);}' unless defined(&RTW_BSSID1);
eval 'sub RTW_BSSID2 () {( &RTW_BSSID1 + 1);}' unless defined(&RTW_BSSID2);
eval 'sub RTW_BSSID3 () {( &RTW_BSSID2 + 1);}' unless defined(&RTW_BSSID3);
eval 'sub RTW_BSSID4 () {( &RTW_BSSID3 + 1);}' unless defined(&RTW_BSSID4);
eval 'sub RTW_BSSID5 () {( &RTW_BSSID4 + 1);}' unless defined(&RTW_BSSID5);
eval 'sub RTW8185_RR () {0x34;}' unless defined(&RTW8185_RR);
eval 'sub RTW8185_RR_MAX () { &BIT(7, 4);}' unless defined(&RTW8185_RR_MAX);
eval 'sub RTW8185_RR_MAX_1MPBS () { &LSHIFT(0,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_1MPBS);
eval 'sub RTW8185_RR_MAX_2MPBS () { &LSHIFT(1,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_2MPBS);
eval 'sub RTW8185_RR_MAX_5MPBS () { &LSHIFT(2,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_5MPBS);
eval 'sub RTW8185_RR_MAX_11MPBS () { &LSHIFT(3,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_11MPBS);
eval 'sub RTW8185_RR_MAX_6MPBS () { &LSHIFT(4,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_6MPBS);
eval 'sub RTW8185_RR_MAX_9MPBS () { &LSHIFT(5,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_9MPBS);
eval 'sub RTW8185_RR_MAX_12MPBS () { &LSHIFT(6,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_12MPBS);
eval 'sub RTW8185_RR_MAX_18MPBS () { &LSHIFT(7,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_18MPBS);
eval 'sub RTW8185_RR_MAX_24MPBS () { &LSHIFT(8,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_24MPBS);
eval 'sub RTW8185_RR_MAX_36MPBS () { &LSHIFT(9,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_36MPBS);
eval 'sub RTW8185_RR_MAX_48MPBS () { &LSHIFT(10,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_48MPBS);
eval 'sub RTW8185_RR_MAX_54MPBS () { &LSHIFT(11,  &RTW8185_RR_MAX_MASK);}' unless defined(&RTW8185_RR_MAX_54MPBS);
eval 'sub RTW8185_RR_MIN_MASK () { &BIT(3, 0);}' unless defined(&RTW8185_RR_MIN_MASK);
eval 'sub RTW8185_RR_MIN_1MPBS () { &LSHIFT(0,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_1MPBS);
eval 'sub RTW8185_RR_MIN_2MPBS () { &LSHIFT(1,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_2MPBS);
eval 'sub RTW8185_RR_MIN_5MPBS () { &LSHIFT(2,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_5MPBS);
eval 'sub RTW8185_RR_MIN_11MPBS () { &LSHIFT(3,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_11MPBS);
eval 'sub RTW8185_RR_MIN_6MPBS () { &LSHIFT(4,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_6MPBS);
eval 'sub RTW8185_RR_MIN_9MPBS () { &LSHIFT(5,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_9MPBS);
eval 'sub RTW8185_RR_MIN_12MPBS () { &LSHIFT(6,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_12MPBS);
eval 'sub RTW8185_RR_MIN_18MPBS () { &LSHIFT(7,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_18MPBS);
eval 'sub RTW8185_RR_MIN_24MPBS () { &LSHIFT(8,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_24MPBS);
eval 'sub RTW8185_RR_MIN_36MPBS () { &LSHIFT(9,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_36MPBS);
eval 'sub RTW8185_RR_MIN_48MPBS () { &LSHIFT(10,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_48MPBS);
eval 'sub RTW8185_RR_MIN_54MPBS () { &LSHIFT(11,  &RTW8185_RR_MIN_MASK);}' unless defined(&RTW8185_RR_MIN_54MPBS);
eval 'sub RTW8185_EIFS_TIMER () {0x35;}' unless defined(&RTW8185_EIFS_TIMER);
eval 'sub RTW_CR () {0x37;}' unless defined(&RTW_CR);
eval 'sub RTW_CR_RST () {(1<<4);}' unless defined(&RTW_CR_RST);
eval 'sub RTW_CR_RE () {(1<<3);}' unless defined(&RTW_CR_RE);
eval 'sub RTW_CR_TE () {(1<<2);}' unless defined(&RTW_CR_TE);
eval 'sub RTW_CR_MULRW () {(1<<0);}' unless defined(&RTW_CR_MULRW);
eval 'sub RTW_IMR () {0x3c;}' unless defined(&RTW_IMR);
eval 'sub RTW_ISR () {0x3e;}' unless defined(&RTW_ISR);
eval 'sub RTW_INTR_TXFOVW () {(1<<15);}' unless defined(&RTW_INTR_TXFOVW);
eval 'sub RTW_INTR_TIMEOUT () {(1<<14);}' unless defined(&RTW_INTR_TIMEOUT);
eval 'sub RTW_INTR_BCNINT () {(1<<13);}' unless defined(&RTW_INTR_BCNINT);
eval 'sub RTW_INTR_ATIMINT () {(1<<12);}' unless defined(&RTW_INTR_ATIMINT);
eval 'sub RTW_INTR_TBDER () {(1<<11);}' unless defined(&RTW_INTR_TBDER);
eval 'sub RTW_INTR_TBDOK () {(1<<10);}' unless defined(&RTW_INTR_TBDOK);
eval 'sub RTW_INTR_THPDER () {(1<<9);}' unless defined(&RTW_INTR_THPDER);
eval 'sub RTW_INTR_THPDOK () {(1<<8);}' unless defined(&RTW_INTR_THPDOK);
eval 'sub RTW_INTR_TNPDER () {(1<<7);}' unless defined(&RTW_INTR_TNPDER);
eval 'sub RTW_INTR_TNPDOK () {(1<<6);}' unless defined(&RTW_INTR_TNPDOK);
eval 'sub RTW_INTR_RXFOVW () {(1<<5);}' unless defined(&RTW_INTR_RXFOVW);
eval 'sub RTW_INTR_RDU () {(1<<4);}' unless defined(&RTW_INTR_RDU);
eval 'sub RTW_INTR_TLPDER () {(1<<3);}' unless defined(&RTW_INTR_TLPDER);
eval 'sub RTW_INTR_TLPDOK () {(1<<2);}' unless defined(&RTW_INTR_TLPDOK);
eval 'sub RTW_INTR_RER () {(1<<1);}' unless defined(&RTW_INTR_RER);
eval 'sub RTW_INTR_ROK () {(1<<0);}' unless defined(&RTW_INTR_ROK);
eval 'sub RTW_INTR_RX () {( &RTW_INTR_RER| &RTW_INTR_ROK);}' unless defined(&RTW_INTR_RX);
eval 'sub RTW_INTR_TX () {( &RTW_INTR_TLPDER| &RTW_INTR_TLPDOK| &RTW_INTR_THPDER|  &RTW_INTR_THPDOK| &RTW_INTR_TNPDER| &RTW_INTR_TNPDOK|  &RTW_INTR_TBDER| &RTW_INTR_TBDOK);}' unless defined(&RTW_INTR_TX);
eval 'sub RTW_INTR_BEACON () {( &RTW_INTR_BCNINT| &RTW_INTR_TBDER| &RTW_INTR_TBDOK);}' unless defined(&RTW_INTR_BEACON);
eval 'sub RTW_INTR_IOERROR () {( &RTW_INTR_TXFOVW| &RTW_INTR_RXFOVW| &RTW_INTR_RDU);}' unless defined(&RTW_INTR_IOERROR);
eval 'sub RTW_TCR () {0x40;}' unless defined(&RTW_TCR);
eval 'sub RTW_TCR_CWMIN () {(1<<31);}' unless defined(&RTW_TCR_CWMIN);
eval 'sub RTW_TCR_SWSEQ () {(1<<30);}' unless defined(&RTW_TCR_SWSEQ);
eval 'sub RTW8185_TCR_NOPROBERSPTO () {(1<<29);}' unless defined(&RTW8185_TCR_NOPROBERSPTO);
eval 'sub RTW_TCR_HWVERID_MASK () {0xe000000;}' unless defined(&RTW_TCR_HWVERID_MASK);
eval 'sub RTW_TCR_HWVERID_RTL8180D () {(1<<26);}' unless defined(&RTW_TCR_HWVERID_RTL8180D);
eval 'sub RTW_TCR_HWVERID_RTL8180F () {0x6000000;}' unless defined(&RTW_TCR_HWVERID_RTL8180F);
eval 'sub RTW_TCR_HWVERID_RTL8185 () {((1<<27) | (1<<25));}' unless defined(&RTW_TCR_HWVERID_RTL8185);
eval 'sub RTW8180_TCR_SAT () {(1<<24);}' unless defined(&RTW8180_TCR_SAT);
eval 'sub RTW8185_TCR_PLCPLENGTH () {(1<<24);}' unless defined(&RTW8185_TCR_PLCPLENGTH);
eval 'sub RTW_TCR_MXDMA_MASK () {0xe00000;}' unless defined(&RTW_TCR_MXDMA_MASK);
eval 'sub RTW_TCR_MXDMA_16 () { &LSHIFT(0,  &RTW_TCR_MXDMA_MASK);}' unless defined(&RTW_TCR_MXDMA_16);
eval 'sub RTW_TCR_MXDMA_32 () { &LSHIFT(1,  &RTW_TCR_MXDMA_MASK);}' unless defined(&RTW_TCR_MXDMA_32);
eval 'sub RTW_TCR_MXDMA_64 () { &LSHIFT(2,  &RTW_TCR_MXDMA_MASK);}' unless defined(&RTW_TCR_MXDMA_64);
eval 'sub RTW_TCR_MXDMA_128 () { &LSHIFT(3,  &RTW_TCR_MXDMA_MASK);}' unless defined(&RTW_TCR_MXDMA_128);
eval 'sub RTW_TCR_MXDMA_256 () { &LSHIFT(4,  &RTW_TCR_MXDMA_MASK);}' unless defined(&RTW_TCR_MXDMA_256);
eval 'sub RTW_TCR_MXDMA_512 () { &LSHIFT(5,  &RTW_TCR_MXDMA_MASK);}' unless defined(&RTW_TCR_MXDMA_512);
eval 'sub RTW_TCR_MXDMA_1024 () { &LSHIFT(6,  &RTW_TCR_MXDMA_MASK);}' unless defined(&RTW_TCR_MXDMA_1024);
eval 'sub RTW_TCR_MXDMA_2048 () { &LSHIFT(7,  &RTW_TCR_MXDMA_MASK);}' unless defined(&RTW_TCR_MXDMA_2048);
eval 'sub RTW_TCR_DISCW () {(1<<20);}' unless defined(&RTW_TCR_DISCW);
eval 'sub RTW_TCR_ICV () {(1<<19);}' unless defined(&RTW_TCR_ICV);
eval 'sub RTW_TCR_LBK_MASK () {0x60000;}' unless defined(&RTW_TCR_LBK_MASK);
eval 'sub RTW_TCR_LBK_NORMAL () { &LSHIFT(0,  &RTW_TCR_LBK_MASK);}' unless defined(&RTW_TCR_LBK_NORMAL);
eval 'sub RTW_TCR_LBK_MAC () { &LSHIFT(1,  &RTW_TCR_LBK_MASK);}' unless defined(&RTW_TCR_LBK_MAC);
eval 'sub RTW_TCR_LBK_BBP () { &LSHIFT(2,  &RTW_TCR_LBK_MASK);}' unless defined(&RTW_TCR_LBK_BBP);
eval 'sub RTW_TCR_LBK_CONT () { &LSHIFT(3,  &RTW_TCR_LBK_MASK);}' unless defined(&RTW_TCR_LBK_CONT);
eval 'sub RTW_TCR_CRC () {(1<<16);}' unless defined(&RTW_TCR_CRC);
eval 'sub RTW_TCR_SRL_MASK () {0xff00;}' unless defined(&RTW_TCR_SRL_MASK);
eval 'sub RTW_TCR_LRL_MASK () {0xff;}' unless defined(&RTW_TCR_LRL_MASK);
eval 'sub RTW_RCR () {0x44;}' unless defined(&RTW_RCR);
eval 'sub RTW_RCR_ONLYERLPKT () {(1<<31);}' unless defined(&RTW_RCR_ONLYERLPKT);
eval 'sub RTW_RCR_ENCS2 () {(1<<30);}' unless defined(&RTW_RCR_ENCS2);
eval 'sub RTW_RCR_ENCS1 () {(1<<29);}' unless defined(&RTW_RCR_ENCS1);
eval 'sub RTW_RCR_ENMARP () {(1<<28);}' unless defined(&RTW_RCR_ENMARP);
eval 'sub RTW_RCR_CBSSID () {(1<<23);}' unless defined(&RTW_RCR_CBSSID);
eval 'sub RTW_RCR_APWRMGT () {(1<<22);}' unless defined(&RTW_RCR_APWRMGT);
eval 'sub RTW_RCR_ADD3 () {(1<<21);}' unless defined(&RTW_RCR_ADD3);
eval 'sub RTW_RCR_AMF () {(1<<20);}' unless defined(&RTW_RCR_AMF);
eval 'sub RTW_RCR_ACF () {(1<<19);}' unless defined(&RTW_RCR_ACF);
eval 'sub RTW_RCR_ADF () {(1<<18);}' unless defined(&RTW_RCR_ADF);
eval 'sub RTW8180_RCR_RXFTH_MASK () {0xe000;}' unless defined(&RTW8180_RCR_RXFTH_MASK);
eval 'sub RTW8180_RCR_RXFTH_64 () { &LSHIFT(2,  &RTW8180_RCR_RXFTH_MASK);}' unless defined(&RTW8180_RCR_RXFTH_64);
eval 'sub RTW8180_RCR_RXFTH_128 () { &LSHIFT(3,  &RTW8180_RCR_RXFTH_MASK);}' unless defined(&RTW8180_RCR_RXFTH_128);
eval 'sub RTW8180_RCR_RXFTH_256 () { &LSHIFT(4,  &RTW8180_RCR_RXFTH_MASK);}' unless defined(&RTW8180_RCR_RXFTH_256);
eval 'sub RTW8180_RCR_RXFTH_512 () { &LSHIFT(5,  &RTW8180_RCR_RXFTH_MASK);}' unless defined(&RTW8180_RCR_RXFTH_512);
eval 'sub RTW8180_RCR_RXFTH_1024 () { &LSHIFT(6,  &RTW8180_RCR_RXFTH_MASK);}' unless defined(&RTW8180_RCR_RXFTH_1024);
eval 'sub RTW8180_RCR_RXFTH_WHOLE () { &LSHIFT(7,  &RTW8180_RCR_RXFTH_MASK);}' unless defined(&RTW8180_RCR_RXFTH_WHOLE);
eval 'sub RTW_RCR_AICV () {(1<<12);}' unless defined(&RTW_RCR_AICV);
eval 'sub RTW_RCR_MXDMA_MASK () {0x700;}' unless defined(&RTW_RCR_MXDMA_MASK);
eval 'sub RTW_RCR_MXDMA_16 () { &LSHIFT(0,  &RTW_RCR_MXDMA_MASK);}' unless defined(&RTW_RCR_MXDMA_16);
eval 'sub RTW_RCR_MXDMA_32 () { &LSHIFT(1,  &RTW_RCR_MXDMA_MASK);}' unless defined(&RTW_RCR_MXDMA_32);
eval 'sub RTW_RCR_MXDMA_64 () { &LSHIFT(2,  &RTW_RCR_MXDMA_MASK);}' unless defined(&RTW_RCR_MXDMA_64);
eval 'sub RTW_RCR_MXDMA_128 () { &LSHIFT(3,  &RTW_RCR_MXDMA_MASK);}' unless defined(&RTW_RCR_MXDMA_128);
eval 'sub RTW_RCR_MXDMA_256 () { &LSHIFT(4,  &RTW_RCR_MXDMA_MASK);}' unless defined(&RTW_RCR_MXDMA_256);
eval 'sub RTW_RCR_MXDMA_512 () { &LSHIFT(5,  &RTW_RCR_MXDMA_MASK);}' unless defined(&RTW_RCR_MXDMA_512);
eval 'sub RTW_RCR_MXDMA_1024 () { &LSHIFT(6,  &RTW_RCR_MXDMA_MASK);}' unless defined(&RTW_RCR_MXDMA_1024);
eval 'sub RTW_RCR_MXDMA_UNLIMITED () { &LSHIFT(7,  &RTW_RCR_MXDMA_MASK);}' unless defined(&RTW_RCR_MXDMA_UNLIMITED);
eval 'sub RTW_RCR_9356SEL () {(1<<6);}' unless defined(&RTW_RCR_9356SEL);
eval 'sub RTW_RCR_ACRC32 () {(1<<5);}' unless defined(&RTW_RCR_ACRC32);
eval 'sub RTW_RCR_AB () {(1<<3);}' unless defined(&RTW_RCR_AB);
eval 'sub RTW_RCR_AM () {(1<<2);}' unless defined(&RTW_RCR_AM);
eval 'sub RTW_RCR_APM () {(1<<1);}' unless defined(&RTW_RCR_APM);
eval 'sub RTW_RCR_AAP () {(1<<0);}' unless defined(&RTW_RCR_AAP);
eval 'sub RTW_RCR_MONITOR () {(  &RTW_RCR_AAP |  &RTW_RCR_ACF |  &RTW_RCR_ACRC32 |  &RTW_RCR_AICV | 0);}' unless defined(&RTW_RCR_MONITOR);
eval 'sub RTW_RCR_PKTFILTER_MASK () {(  &RTW_RCR_AAP |  &RTW_RCR_AB |  &RTW_RCR_ACF |  &RTW_RCR_ACRC32 |  &RTW_RCR_ADD3 |  &RTW_RCR_ADF |  &RTW_RCR_AICV |  &RTW_RCR_AM |  &RTW_RCR_AMF |  &RTW_RCR_APM |  &RTW_RCR_APWRMGT | 0);}' unless defined(&RTW_RCR_PKTFILTER_MASK);
eval 'sub RTW_RCR_PKTFILTER_DEFAULT () {(  &RTW_RCR_ADF |  &RTW_RCR_AMF |  &RTW_RCR_APM |  &RTW_RCR_APWRMGT | 0);}' unless defined(&RTW_RCR_PKTFILTER_DEFAULT);
eval 'sub RTW_TINT () {0x48;}' unless defined(&RTW_TINT);
eval 'sub RTW_TBDA () {0x4c;}' unless defined(&RTW_TBDA);
eval 'sub RTW_9346CR () {0x50;}' unless defined(&RTW_9346CR);
eval 'sub RTW_9346CR_EEM_MASK () {0xc0;}' unless defined(&RTW_9346CR_EEM_MASK);
eval 'sub RTW_9346CR_EEM_NORMAL () { &LSHIFT(0,  &RTW_9346CR_EEM_MASK);}' unless defined(&RTW_9346CR_EEM_NORMAL);
eval 'sub RTW_9346CR_EEM_AUTOLOAD () { &LSHIFT(1,  &RTW_9346CR_EEM_MASK);}' unless defined(&RTW_9346CR_EEM_AUTOLOAD);
eval 'sub RTW_9346CR_EEM_PROGRAM () { &LSHIFT(2,  &RTW_9346CR_EEM_MASK);}' unless defined(&RTW_9346CR_EEM_PROGRAM);
eval 'sub RTW_9346CR_EEM_CONFIG () { &LSHIFT(3,  &RTW_9346CR_EEM_MASK);}' unless defined(&RTW_9346CR_EEM_CONFIG);
eval 'sub RTW_9346CR_EECS () {(1<<3);}' unless defined(&RTW_9346CR_EECS);
eval 'sub RTW_9346CR_EESK () {(1<<2);}' unless defined(&RTW_9346CR_EESK);
eval 'sub RTW_9346CR_EEDI () {(1<<1);}' unless defined(&RTW_9346CR_EEDI);
eval 'sub RTW_9346CR_EEDO () {(1<<0);}' unless defined(&RTW_9346CR_EEDO);
eval 'sub RTW_CONFIG0 () {0x51;}' unless defined(&RTW_CONFIG0);
eval 'sub RTW8180_CONFIG0_WEP40 () {(1<<7);}' unless defined(&RTW8180_CONFIG0_WEP40);
eval 'sub RTW8180_CONFIG0_WEP104 () {(1<<6);}' unless defined(&RTW8180_CONFIG0_WEP104);
eval 'sub RTW8180_CONFIG0_LEDGPOEN () {(1<<4);}' unless defined(&RTW8180_CONFIG0_LEDGPOEN);
eval 'sub RTW_CONFIG0_AUXPWR () {(1<<3);}' unless defined(&RTW_CONFIG0_AUXPWR);
eval 'sub RTW8180_CONFIG0_GL_MASK () {0x3;}' unless defined(&RTW8180_CONFIG0_GL_MASK);
eval 'sub RTW8180_CONFIG0_GL_USA () { &LSHIFT(3,  &RTW8180_CONFIG0_GL_MASK);}' unless defined(&RTW8180_CONFIG0_GL_USA);
eval 'sub RTW8180_CONFIG0_GL_EUROPE () { &LSHIFT(2,  &RTW8180_CONFIG0_GL_MASK);}' unless defined(&RTW8180_CONFIG0_GL_EUROPE);
eval 'sub RTW8180_CONFIG0_GL_JAPAN () { &LSHIFT(1,  &RTW8180_CONFIG0_GL_MASK);}' unless defined(&RTW8180_CONFIG0_GL_JAPAN);
eval 'sub RTW8180_CONFIG0_GL_JAPAN2 () { &LSHIFT(0,  &RTW8180_CONFIG0_GL_MASK);}' unless defined(&RTW8180_CONFIG0_GL_JAPAN2);
eval 'sub RTW_CONFIG1 () {0x52;}' unless defined(&RTW_CONFIG1);
eval 'sub RTW_CONFIG1_LEDS_MASK () {0xc0;}' unless defined(&RTW_CONFIG1_LEDS_MASK);
eval 'sub RTW_CONFIG1_LEDS_ACT_INFRA () { &LSHIFT(0,  &RTW_CONFIG1_LEDS_MASK);}' unless defined(&RTW_CONFIG1_LEDS_ACT_INFRA);
eval 'sub RTW_CONFIG1_LEDS_ACT_LINK () { &LSHIFT(1,  &RTW_CONFIG1_LEDS_MASK);}' unless defined(&RTW_CONFIG1_LEDS_ACT_LINK);
eval 'sub RTW_CONFIG1_LEDS_TX_RX () { &LSHIFT(2,  &RTW_CONFIG1_LEDS_MASK);}' unless defined(&RTW_CONFIG1_LEDS_TX_RX);
eval 'sub RTW_CONFIG1_LEDS_LINKACT_INFRA () { &LSHIFT(3,  &RTW_CONFIG1_LEDS_MASK);}' unless defined(&RTW_CONFIG1_LEDS_LINKACT_INFRA);
eval 'sub RTW_CONFIG1_LWACT () {(1<<4);}' unless defined(&RTW_CONFIG1_LWACT);
eval 'sub RTW_CONFIG1_MEMMAP () {(1<<3);}' unless defined(&RTW_CONFIG1_MEMMAP);
eval 'sub RTW_CONFIG1_IOMAP () {(1<<2);}' unless defined(&RTW_CONFIG1_IOMAP);
eval 'sub RTW_CONFIG1_VPD () {(1<<1);}' unless defined(&RTW_CONFIG1_VPD);
eval 'sub RTW_CONFIG1_PMEN () {(1<<0);}' unless defined(&RTW_CONFIG1_PMEN);
eval 'sub RTW_CONFIG2 () {0x53;}' unless defined(&RTW_CONFIG2);
eval 'sub RTW_CONFIG2_LCK () {(1<<7);}' unless defined(&RTW_CONFIG2_LCK);
eval 'sub RTW8180_CONFIG2_ANT () {(1<<6);}' unless defined(&RTW8180_CONFIG2_ANT);
eval 'sub RTW_CONFIG2_DPS () {(1<<3);}' unless defined(&RTW_CONFIG2_DPS);
eval 'sub RTW_CONFIG2_PAPESIGN () {(1<<2);}' unless defined(&RTW_CONFIG2_PAPESIGN);
eval 'sub RTW_CONFIG2_PAPETIME_MASK () {0x3;}' unless defined(&RTW_CONFIG2_PAPETIME_MASK);
eval 'sub RTW_ANAPARM_0 () {0x54;}' unless defined(&RTW_ANAPARM_0);
eval 'sub RTW8185_ANAPARM_1 () {0x60;}' unless defined(&RTW8185_ANAPARM_1);
eval 'sub RTW_ANAPARM_RFPOW0_MASK () {0x70000000;}' unless defined(&RTW_ANAPARM_RFPOW0_MASK);
eval 'sub RTW_ANAPARM_RFPOW_MASK () {( &RTW_ANAPARM_RFPOW0_MASK| &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_MASK);
eval 'sub RTW_ANAPARM_TXDACOFF () {(1<<27);}' unless defined(&RTW_ANAPARM_TXDACOFF);
eval 'sub RTW_ANAPARM_RFPOW1_MASK () {0x7f00000;}' unless defined(&RTW_ANAPARM_RFPOW1_MASK);
eval 'sub RTW_ANAPARM_RFPOW_MAXIM_ON () { &LSHIFT(0x8,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_MAXIM_ON);
eval 'sub RTW_ANAPARM_RFPOW_MAXIM_SLEEP () { &LSHIFT(0x378,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_MAXIM_SLEEP);
eval 'sub RTW_ANAPARM_RFPOW_MAXIM_OFF () { &LSHIFT(0x379,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_MAXIM_OFF);
eval 'sub RTW_ANAPARM_RFPOW_RFMD_ON () { &LSHIFT(0x408,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_RFMD_ON);
eval 'sub RTW_ANAPARM_RFPOW_RFMD_SLEEP () { &LSHIFT(0x378,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_RFMD_SLEEP);
eval 'sub RTW_ANAPARM_RFPOW_RFMD_OFF () { &LSHIFT(0x379,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_RFMD_OFF);
eval 'sub RTW_ANAPARM_RFPOW_ANA_PHILIPS_ON () { &LSHIFT(0x328,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_ANA_PHILIPS_ON);
eval 'sub RTW_ANAPARM_RFPOW_DIG_PHILIPS_ON () { &LSHIFT(0x8,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_DIG_PHILIPS_ON);
eval 'sub RTW_ANAPARM_RFPOW_PHILIPS_SLEEP () { &LSHIFT(0x378,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_PHILIPS_SLEEP);
eval 'sub RTW_ANAPARM_RFPOW_PHILIPS_OFF () { &LSHIFT(0x379,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_PHILIPS_OFF);
eval 'sub RTW_ANAPARM_RFPOW_PHILIPS_ON () { &LSHIFT(0x328,  &RTW_ANAPARM_RFPOW1_MASK);}' unless defined(&RTW_ANAPARM_RFPOW_PHILIPS_ON);
eval 'sub RTW_ANAPARM_CARDSP_MASK () {0xfffff;}' unless defined(&RTW_ANAPARM_CARDSP_MASK);
eval 'sub RTW_MSR () {0x58;}' unless defined(&RTW_MSR);
eval 'sub RTW_MSR_NETYPE_MASK () {0xc;}' unless defined(&RTW_MSR_NETYPE_MASK);
eval 'sub RTW_MSR_NETYPE_AP_OK () { &LSHIFT(3,  &RTW_MSR_NETYPE_MASK);}' unless defined(&RTW_MSR_NETYPE_AP_OK);
eval 'sub RTW_MSR_NETYPE_INFRA_OK () { &LSHIFT(2,  &RTW_MSR_NETYPE_MASK);}' unless defined(&RTW_MSR_NETYPE_INFRA_OK);
eval 'sub RTW_MSR_NETYPE_ADHOC_OK () { &LSHIFT(1,  &RTW_MSR_NETYPE_MASK);}' unless defined(&RTW_MSR_NETYPE_ADHOC_OK);
eval 'sub RTW_MSR_NETYPE_NOLINK () { &LSHIFT(0,  &RTW_MSR_NETYPE_MASK);}' unless defined(&RTW_MSR_NETYPE_NOLINK);
eval 'sub RTW_CONFIG3 () {0x59;}' unless defined(&RTW_CONFIG3);
eval 'sub RTW_CONFIG3_GNTSEL () {(1<<7);}' unless defined(&RTW_CONFIG3_GNTSEL);
eval 'sub RTW_CONFIG3_PARMEN () {(1<<6);}' unless defined(&RTW_CONFIG3_PARMEN);
eval 'sub RTW_CONFIG3_MAGIC () {(1<<5);}' unless defined(&RTW_CONFIG3_MAGIC);
eval 'sub RTW_CONFIG3_CARDBEN () {(1<<3);}' unless defined(&RTW_CONFIG3_CARDBEN);
eval 'sub RTW_CONFIG3_CLKRUNEN () {(1<<2);}' unless defined(&RTW_CONFIG3_CLKRUNEN);
eval 'sub RTW_CONFIG3_FUNCREGEN () {(1<<1);}' unless defined(&RTW_CONFIG3_FUNCREGEN);
eval 'sub RTW_CONFIG3_FBTBEN () {(1<<0);}' unless defined(&RTW_CONFIG3_FBTBEN);
eval 'sub RTW_CONFIG4 () {0x5a;}' unless defined(&RTW_CONFIG4);
eval 'sub RTW_CONFIG4_VCOPDN () {(1<<7);}' unless defined(&RTW_CONFIG4_VCOPDN);
eval 'sub RTW_CONFIG4_PWROFF () {(1<<6);}' unless defined(&RTW_CONFIG4_PWROFF);
eval 'sub RTW_CONFIG4_PWRMGT () {(1<<5);}' unless defined(&RTW_CONFIG4_PWRMGT);
eval 'sub RTW_CONFIG4_LWPME () {(1<<4);}' unless defined(&RTW_CONFIG4_LWPME);
eval 'sub RTW_CONFIG4_LWPTN () {(1<<2);}' unless defined(&RTW_CONFIG4_LWPTN);
eval 'sub RTW_CONFIG4_RFTYPE_MASK () {0x3;}' unless defined(&RTW_CONFIG4_RFTYPE_MASK);
eval 'sub RTW_CONFIG4_RFTYPE_INTERSIL () { &LSHIFT(1,  &RTW_CONFIG4_RFTYPE_MASK);}' unless defined(&RTW_CONFIG4_RFTYPE_INTERSIL);
eval 'sub RTW_CONFIG4_RFTYPE_RFMD () { &LSHIFT(2,  &RTW_CONFIG4_RFTYPE_MASK);}' unless defined(&RTW_CONFIG4_RFTYPE_RFMD);
eval 'sub RTW_CONFIG4_RFTYPE_PHILIPS () { &LSHIFT(3,  &RTW_CONFIG4_RFTYPE_MASK);}' unless defined(&RTW_CONFIG4_RFTYPE_PHILIPS);
eval 'sub RTW_TESTR () {0x5b;}' unless defined(&RTW_TESTR);
eval 'sub RTW_PSR () {0x5e;}' unless defined(&RTW_PSR);
eval 'sub RTW_PSR_GPO () {(1<<7);}' unless defined(&RTW_PSR_GPO);
eval 'sub RTW_PSR_GPI () {(1<<6);}' unless defined(&RTW_PSR_GPI);
eval 'sub RTW_PSR_LEDGPO1 () {(1<<5);}' unless defined(&RTW_PSR_LEDGPO1);
eval 'sub RTW_PSR_LEDGPO0 () {(1<<4);}' unless defined(&RTW_PSR_LEDGPO0);
eval 'sub RTW_PSR_UWF () {(1<<1);}' unless defined(&RTW_PSR_UWF);
eval 'sub RTW_PSR_PSEN () {(1<<0);}' unless defined(&RTW_PSR_PSEN);
eval 'sub RTW8180_SCR () {0x5f;}' unless defined(&RTW8180_SCR);
eval 'sub RTW8180_SCR_KM_MASK () {0x30;}' unless defined(&RTW8180_SCR_KM_MASK);
eval 'sub RTW8180_SCR_KM_WEP104 () { &LSHIFT(1,  &RTW8180_SCR_KM_MASK);}' unless defined(&RTW8180_SCR_KM_WEP104);
eval 'sub RTW8180_SCR_KM_WEP40 () { &LSHIFT(0,  &RTW8180_SCR_KM_MASK);}' unless defined(&RTW8180_SCR_KM_WEP40);
eval 'sub RTW8180_SCR_TXSECON () {(1<<1);}' unless defined(&RTW8180_SCR_TXSECON);
eval 'sub RTW8180_SCR_RXSECON () {(1<<0);}' unless defined(&RTW8180_SCR_RXSECON);
eval 'sub RTW8185_RFPARM () {0x60;}' unless defined(&RTW8185_RFPARM);
eval 'sub RTW_BCNITV () {0x70;}' unless defined(&RTW_BCNITV);
eval 'sub RTW_BCNITV_BCNITV_MASK () {0x3ff;}' unless defined(&RTW_BCNITV_BCNITV_MASK);
eval 'sub RTW_ATIMWND () {0x72;}' unless defined(&RTW_ATIMWND);
eval 'sub RTW_ATIMWND_ATIMWND () {0x3ff;}' unless defined(&RTW_ATIMWND_ATIMWND);
eval 'sub RTW_BINTRITV () {0x74;}' unless defined(&RTW_BINTRITV);
eval 'sub RTW_BINTRITV_BINTRITV () {0x3ff;}' unless defined(&RTW_BINTRITV_BINTRITV);
eval 'sub RTW_ATIMTRITV () {0x76;}' unless defined(&RTW_ATIMTRITV);
eval 'sub RTW_ATIMTRITV_ATIMTRITV () {0x3ff;}' unless defined(&RTW_ATIMTRITV_ATIMTRITV);
eval 'sub RTW_PHYDELAY () {0x78;}' unless defined(&RTW_PHYDELAY);
eval 'sub RTW_PHYDELAY_REVC_MAGIC () {(1<<3);}' unless defined(&RTW_PHYDELAY_REVC_MAGIC);
eval 'sub RTW_PHYDELAY_PHYDELAY () {0x7;}' unless defined(&RTW_PHYDELAY_PHYDELAY);
eval 'sub RTW_CRCOUNT () {0x79;}' unless defined(&RTW_CRCOUNT);
eval 'sub RTW_CRCOUNT_MAGIC () {0x4c;}' unless defined(&RTW_CRCOUNT_MAGIC);
eval 'sub RTW_CRC16ERR () {0x7a;}' unless defined(&RTW_CRC16ERR);
eval 'sub RTW_BB () {0x7c;}' unless defined(&RTW_BB);
eval 'sub RTW_BB_RD_MASK () {0xff0000;}' unless defined(&RTW_BB_RD_MASK);
eval 'sub RTW_BB_WR_MASK () {0xff00;}' unless defined(&RTW_BB_WR_MASK);
eval 'sub RTW_BB_WREN () {(1<<7);}' unless defined(&RTW_BB_WREN);
eval 'sub RTW_BB_ADDR_MASK () {0x7f;}' unless defined(&RTW_BB_ADDR_MASK);
eval 'sub RTW_PHYADDR () {0x7c;}' unless defined(&RTW_PHYADDR);
eval 'sub RTW_PHYDATAW () {0x7d;}' unless defined(&RTW_PHYDATAW);
eval 'sub RTW_PHYDATAR () {0x7e;}' unless defined(&RTW_PHYDATAR);
eval 'sub RTW8180_PHYCFG () {0x80;}' unless defined(&RTW8180_PHYCFG);
eval 'sub RTW8180_PHYCFG_MAC_POLL () {(1<<31);}' unless defined(&RTW8180_PHYCFG_MAC_POLL);
eval 'sub RTW8180_PHYCFG_HST () {(1<<30);}' unless defined(&RTW8180_PHYCFG_HST);
eval 'sub RTW8180_PHYCFG_MAC_RFTYPE_MASK () {0x30000000;}' unless defined(&RTW8180_PHYCFG_MAC_RFTYPE_MASK);
eval 'sub RTW8180_PHYCFG_MAC_RFTYPE_INTERSIL () { &LSHIFT(0,  &RTW8180_PHYCFG_MAC_RFTYPE_MASK);}' unless defined(&RTW8180_PHYCFG_MAC_RFTYPE_INTERSIL);
eval 'sub RTW8180_PHYCFG_MAC_RFTYPE_RFMD () { &LSHIFT(1,  &RTW8180_PHYCFG_MAC_RFTYPE_MASK);}' unless defined(&RTW8180_PHYCFG_MAC_RFTYPE_RFMD);
eval 'sub RTW8180_PHYCFG_MAC_RFTYPE_GCT () { &RTW8180_PHYCFG_MAC_RFTYPE_RFMD;}' unless defined(&RTW8180_PHYCFG_MAC_RFTYPE_GCT);
eval 'sub RTW8180_PHYCFG_MAC_RFTYPE_PHILIPS () { &LSHIFT(3,  &RTW8180_PHYCFG_MAC_RFTYPE_MASK);}' unless defined(&RTW8180_PHYCFG_MAC_RFTYPE_PHILIPS);
eval 'sub RTW8180_PHYCFG_MAC_PHILIPS_ADDR_MASK () {0xf000000;}' unless defined(&RTW8180_PHYCFG_MAC_PHILIPS_ADDR_MASK);
eval 'sub RTW8180_PHYCFG_MAC_PHILIPS_DATA_MASK () {0xffffff;}' unless defined(&RTW8180_PHYCFG_MAC_PHILIPS_DATA_MASK);
eval 'sub RTW8180_PHYCFG_MAC_MAXIM_LODATA_MASK () {0xf000000;}' unless defined(&RTW8180_PHYCFG_MAC_MAXIM_LODATA_MASK);
eval 'sub RTW8180_PHYCFG_MAC_MAXIM_ADDR_MASK () {0xf00;}' unless defined(&RTW8180_PHYCFG_MAC_MAXIM_ADDR_MASK);
eval 'sub RTW8180_PHYCFG_MAC_MAXIM_HIDATA_MASK () {0xff;}' unless defined(&RTW8180_PHYCFG_MAC_MAXIM_HIDATA_MASK);
eval 'sub RTW8180_PHYCFG_HST_EN () {(1<<2);}' unless defined(&RTW8180_PHYCFG_HST_EN);
eval 'sub RTW8180_PHYCFG_HST_CLK () {(1<<1);}' unless defined(&RTW8180_PHYCFG_HST_CLK);
eval 'sub RTW8180_PHYCFG_HST_DATA () {(1<<0);}' unless defined(&RTW8180_PHYCFG_HST_DATA);
eval 'sub RTW8185_RFPINSOUTPUT () {0x80;}' unless defined(&RTW8185_RFPINSOUTPUT);
eval 'sub RTW8185_RFPINSOUTPUT_MASK () {0xfff3;}' unless defined(&RTW8185_RFPINSOUTPUT_MASK);
eval 'sub RTW8185_RFPINSENABLE () {0x82;}' unless defined(&RTW8185_RFPINSENABLE);
eval 'sub RTW8185_RFPINSENABLE_ENABLE () {0x7;}' unless defined(&RTW8185_RFPINSENABLE_ENABLE);
eval 'sub RTW8185_INSSELECT () {0x84;}' unless defined(&RTW8185_INSSELECT);
eval 'sub RTW8185_SW_GPIO () {0x400;}' unless defined(&RTW8185_SW_GPIO);
eval 'sub RTW_MAXIM_HIDATA_MASK () {0xff0;}' unless defined(&RTW_MAXIM_HIDATA_MASK);
eval 'sub RTW_MAXIM_LODATA_MASK () {0xf;}' unless defined(&RTW_MAXIM_LODATA_MASK);
eval 'sub RTW_WAKEUP0L () {0x84;}' unless defined(&RTW_WAKEUP0L);
eval 'sub RTW_WAKEUP0H () {0x88;}' unless defined(&RTW_WAKEUP0H);
eval 'sub RTW_WAKEUP1L () {0x8c;}' unless defined(&RTW_WAKEUP1L);
eval 'sub RTW_WAKEUP1H () {0x90;}' unless defined(&RTW_WAKEUP1H);
eval 'sub RTW_WAKEUP2LL () {0x94;}' unless defined(&RTW_WAKEUP2LL);
eval 'sub RTW_WAKEUP2LH () {0x98;}' unless defined(&RTW_WAKEUP2LH);
eval 'sub RTW_WAKEUP2HL () {0x9c;}' unless defined(&RTW_WAKEUP2HL);
eval 'sub RTW_WAKEUP2HH () {0xa0;}' unless defined(&RTW_WAKEUP2HH);
eval 'sub RTW_WAKEUP3LL () {0xa4;}' unless defined(&RTW_WAKEUP3LL);
eval 'sub RTW_WAKEUP3LH () {0xa8;}' unless defined(&RTW_WAKEUP3LH);
eval 'sub RTW_WAKEUP3HL () {0xac;}' unless defined(&RTW_WAKEUP3HL);
eval 'sub RTW_WAKEUP3HH () {0xb0;}' unless defined(&RTW_WAKEUP3HH);
eval 'sub RTW_WAKEUP4LL () {0xb4;}' unless defined(&RTW_WAKEUP4LL);
eval 'sub RTW_WAKEUP4LH () {0xb8;}' unless defined(&RTW_WAKEUP4LH);
eval 'sub RTW_WAKEUP4HL () {0xbc;}' unless defined(&RTW_WAKEUP4HL);
eval 'sub RTW_WAKEUP4HH () {0xc0;}' unless defined(&RTW_WAKEUP4HH);
eval 'sub RTW_CRC0 () {0xc4;}' unless defined(&RTW_CRC0);
eval 'sub RTW_CRC1 () {0xc6;}' unless defined(&RTW_CRC1);
eval 'sub RTW_CRC2 () {0xc8;}' unless defined(&RTW_CRC2);
eval 'sub RTW_CRC3 () {0xca;}' unless defined(&RTW_CRC3);
eval 'sub RTW_CRC4 () {0xcc;}' unless defined(&RTW_CRC4);
eval 'sub RTW8180_DK0 () {0x90;}' unless defined(&RTW8180_DK0);
eval 'sub RTW8180_DK1 () {0xa0;}' unless defined(&RTW8180_DK1);
eval 'sub RTW8180_DK2 () {0xb0;}' unless defined(&RTW8180_DK2);
eval 'sub RTW8180_DK3 () {0xc0;}' unless defined(&RTW8180_DK3);
eval 'sub RTW8185_RFPINSSELECT () {0x84;}' unless defined(&RTW8185_RFPINSSELECT);
eval 'sub RTW8185_RFPINSSELECT_ENABLE () {0x7;}' unless defined(&RTW8185_RFPINSSELECT_ENABLE);
eval 'sub RTW8185_RFPINSINPUT () {0x86;}' unless defined(&RTW8185_RFPINSINPUT);
eval 'sub RTW8185_RFPARA () {0x88;}' unless defined(&RTW8185_RFPARA);
eval 'sub RTW8185_RFTIMING () {0x8c;}' unless defined(&RTW8185_RFTIMING);
eval 'sub RTW8185_GPO () {0x90;}' unless defined(&RTW8185_GPO);
eval 'sub RTW8185_GPE () {0x91;}' unless defined(&RTW8185_GPE);
eval 'sub RTW8185_GPI () {0x92;}' unless defined(&RTW8185_GPI);
eval 'sub RTW8185_TXAGCCTL () {0x9c;}' unless defined(&RTW8185_TXAGCCTL);
eval 'sub RTW8185_CCKTXAGC () {0x9d;}' unless defined(&RTW8185_CCKTXAGC);
eval 'sub RTW8185_OFDMTXAGC () {0x9e;}' unless defined(&RTW8185_OFDMTXAGC);
eval 'sub RTW8185_ANTSEL () {0x9f;}' unless defined(&RTW8185_ANTSEL);
eval 'sub RTW8185_CAMRW () {0xa0;}' unless defined(&RTW8185_CAMRW);
eval 'sub RTW8185_CAMRW_POOLING () {(1<<31);}' unless defined(&RTW8185_CAMRW_POOLING);
eval 'sub RTW8185_CAMRW_WRITE () {(1<<16);}' unless defined(&RTW8185_CAMRW_WRITE);
eval 'sub RTW8185_CAMRW_ADDRESS () {0x7f;}' unless defined(&RTW8185_CAMRW_ADDRESS);
eval 'sub RTW8185_CAMOUTPUT () {0xa4;}' unless defined(&RTW8185_CAMOUTPUT);
eval 'sub RTW8185_CAMINPUT () {0xa8;}' unless defined(&RTW8185_CAMINPUT);
eval 'sub RTW8185_CAMDEBUG () {0xac;}' unless defined(&RTW8185_CAMDEBUG);
eval 'sub RTW8185_CAMDEBUG_SELTXRXINFO () {(1<<31);}' unless defined(&RTW8185_CAMDEBUG_SELTXRXINFO);
eval 'sub RTW8185_CAMDEBUG_KEYFOUND () {(1<<30);}' unless defined(&RTW8185_CAMDEBUG_KEYFOUND);
eval 'sub RTW8185_CAMDEBUG_WPACONFIG () {0x3f000000;}' unless defined(&RTW8185_CAMDEBUG_WPACONFIG);
eval 'sub RTW8185_CAMDEBUG_CAMKEY () {0xffffff;}' unless defined(&RTW8185_CAMDEBUG_CAMKEY);
eval 'sub RTW8185_WPACONFIG () {0xb0;}' unless defined(&RTW8185_WPACONFIG);
eval 'sub RTW8185_WPACONFIG_RXWPADUMMY () {(1<<8);}' unless defined(&RTW8185_WPACONFIG_RXWPADUMMY);
eval 'sub RTW8185_WPACONFIG_DISRX_AESMIC () {(1<<3);}' unless defined(&RTW8185_WPACONFIG_DISRX_AESMIC);
eval 'sub RTW8185_WPACONFIG_RXDECRYPT () {(1<<2);}' unless defined(&RTW8185_WPACONFIG_RXDECRYPT);
eval 'sub RTW8185_WPACONFIG_TXENCRYPT () {(1<<1);}' unless defined(&RTW8185_WPACONFIG_TXENCRYPT);
eval 'sub RTW8185_WPACONFIG_USEDEFAULTKEY () {(1<<0);}' unless defined(&RTW8185_WPACONFIG_USEDEFAULTKEY);
eval 'sub RTW8185_AESMASK () {0xb2;}' unless defined(&RTW8185_AESMASK);
eval 'sub RTW8185_SIFS () {0xb4;}' unless defined(&RTW8185_SIFS);
eval 'sub RTW8185_DIFS () {0xb5;}' unless defined(&RTW8185_DIFS);
eval 'sub RTW8185_SLOTTIME () {0xb6;}' unless defined(&RTW8185_SLOTTIME);
eval 'sub RTW8185_UTUNE () {0xb7;}' unless defined(&RTW8185_UTUNE);
eval 'sub RTW8185_CWCONFIG () {0xbc;}' unless defined(&RTW8185_CWCONFIG);
eval 'sub RTW8185_CWCONFIG_PPRETRYLIMIT () {(1<<1);}' unless defined(&RTW8185_CWCONFIG_PPRETRYLIMIT);
eval 'sub RTW8185_CWCONFIG_PPCW () {(1<<1);}' unless defined(&RTW8185_CWCONFIG_PPCW);
eval 'sub RTW8185_CWVALUES () {0xbd;}' unless defined(&RTW8185_CWVALUES);
eval 'sub RTW8185_CWVALUES_CWMAX () {0xf0;}' unless defined(&RTW8185_CWVALUES_CWMAX);
eval 'sub RTW8185_CWVALUES_CWMIN () {0xf;}' unless defined(&RTW8185_CWVALUES_CWMIN);
eval 'sub RTW8185_RATEFALLBACKCTL () {0xbe;}' unless defined(&RTW8185_RATEFALLBACKCTL);
eval 'sub RTW8185_RATEFALLBACKCTL_ENABLE () {(1<<7);}' unless defined(&RTW8185_RATEFALLBACKCTL_ENABLE);
eval 'sub RTW8185_RATEFALLBACKCTL_STEP () {0x3;}' unless defined(&RTW8185_RATEFALLBACKCTL_STEP);
eval 'sub RTW_CONFIG5 () {0xd8;}' unless defined(&RTW_CONFIG5);
eval 'sub RTW_CONFIG5_TXFIFOOK () {(1<<7);}' unless defined(&RTW_CONFIG5_TXFIFOOK);
eval 'sub RTW_CONFIG5_RXFIFOOK () {(1<<6);}' unless defined(&RTW_CONFIG5_RXFIFOOK);
eval 'sub RTW_CONFIG5_CALON () {(1<<5);}' unless defined(&RTW_CONFIG5_CALON);
eval 'sub RTW_CONFIG5_EACPI () {(1<<2);}' unless defined(&RTW_CONFIG5_EACPI);
eval 'sub RTW_CONFIG5_LANWAKE () {(1<<1);}' unless defined(&RTW_CONFIG5_LANWAKE);
eval 'sub RTW_CONFIG5_PMESTS () {(1<<0);}' unless defined(&RTW_CONFIG5_PMESTS);
eval 'sub RTW_TPPOLL () {0xd9;}' unless defined(&RTW_TPPOLL);
eval 'sub RTW_TPPOLL_BQ () {(1<<7);}' unless defined(&RTW_TPPOLL_BQ);
eval 'sub RTW_TPPOLL_HPQ () {(1<<6);}' unless defined(&RTW_TPPOLL_HPQ);
eval 'sub RTW_TPPOLL_NPQ () {(1<<5);}' unless defined(&RTW_TPPOLL_NPQ);
eval 'sub RTW_TPPOLL_LPQ () {(1<<4);}' unless defined(&RTW_TPPOLL_LPQ);
eval 'sub RTW_TPPOLL_SBQ () {(1<<3);}' unless defined(&RTW_TPPOLL_SBQ);
eval 'sub RTW_TPPOLL_SHPQ () {(1<<2);}' unless defined(&RTW_TPPOLL_SHPQ);
eval 'sub RTW_TPPOLL_SNPQ () {(1<<1);}' unless defined(&RTW_TPPOLL_SNPQ);
eval 'sub RTW_TPPOLL_SLPQ () {(1<<0);}' unless defined(&RTW_TPPOLL_SLPQ);
eval 'sub RTW_TPPOLL_ALL () {( &RTW_TPPOLL_BQ |  &RTW_TPPOLL_HPQ |  &RTW_TPPOLL_NPQ |  &RTW_TPPOLL_LPQ);}' unless defined(&RTW_TPPOLL_ALL);
eval 'sub RTW_TPPOLL_ACTIVE () { &RTW_TPPOLL_ALL;}' unless defined(&RTW_TPPOLL_ACTIVE);
eval 'sub RTW_TPPOLL_SALL () {( &RTW_TPPOLL_SBQ |  &RTW_TPPOLL_SHPQ |  &RTW_TPPOLL_SNPQ |  &RTW_TPPOLL_SLPQ);}' unless defined(&RTW_TPPOLL_SALL);
eval 'sub RTW_CWR () {0xdc;}' unless defined(&RTW_CWR);
eval 'sub RTW_CWR_CW () {0x3ff;}' unless defined(&RTW_CWR_CW);
eval 'sub RTW_RETRYCTR () {0xde;}' unless defined(&RTW_RETRYCTR);
eval 'sub RTW_RETRYCTR_RETRYCT () {0xff;}' unless defined(&RTW_RETRYCTR_RETRYCT);
eval 'sub RTW_RDSAR () {0xe4;}' unless defined(&RTW_RDSAR);
eval 'sub RTW_FER () {0xf0;}' unless defined(&RTW_FER);
eval 'sub RTW_FER_INTR () {(1<<15);}' unless defined(&RTW_FER_INTR);
eval 'sub RTW_FER_GWAKE () {(1<<4);}' unless defined(&RTW_FER_GWAKE);
eval 'sub RTW_FEMR () {0xf4;}' unless defined(&RTW_FEMR);
eval 'sub RTW_FEMR_INTR () {(1<<15);}' unless defined(&RTW_FEMR_INTR);
eval 'sub RTW_FEMR_WKUP () {(1<<14);}' unless defined(&RTW_FEMR_WKUP);
eval 'sub RTW_FEMR_GWAKE () {(1<<4);}' unless defined(&RTW_FEMR_GWAKE);
eval 'sub RTW_FPSR () {0xf8;}' unless defined(&RTW_FPSR);
eval 'sub RTW_FPSR_INTR () {(1<<15);}' unless defined(&RTW_FPSR_INTR);
eval 'sub RTW_FPSR_GWAKE () {(1<<4);}' unless defined(&RTW_FPSR_GWAKE);
eval 'sub RTW_FFER () {0xfc;}' unless defined(&RTW_FFER);
eval 'sub RTW_FFER_INTR () {(1<<15);}' unless defined(&RTW_FFER_INTR);
eval 'sub RTW_FFER_GWAKE () {(1<<4);}' unless defined(&RTW_FFER_GWAKE);
eval 'sub RTW_SR_ID () {0x;}' unless defined(&RTW_SR_ID);
eval 'sub RTW_SR_VID () {0x2;}' unless defined(&RTW_SR_VID);
eval 'sub RTW_SR_DID () {0x4;}' unless defined(&RTW_SR_DID);
eval 'sub RTW_SR_SVID () {0x6;}' unless defined(&RTW_SR_SVID);
eval 'sub RTW_SR_SMID () {0x8;}' unless defined(&RTW_SR_SMID);
eval 'sub RTW_SR_MNGNT () {0xa;}' unless defined(&RTW_SR_MNGNT);
eval 'sub RTW_SR_MXLAT () {0xb;}' unless defined(&RTW_SR_MXLAT);
eval 'sub RTW_SR_RFCHIPID () {0xc;}' unless defined(&RTW_SR_RFCHIPID);
eval 'sub RTW_SR_CONFIG3 () {0xd;}' unless defined(&RTW_SR_CONFIG3);
eval 'sub RTW_SR_MAC () {0xe;}' unless defined(&RTW_SR_MAC);
eval 'sub RTW_SR_CONFIG0 () {0x14;}' unless defined(&RTW_SR_CONFIG0);
eval 'sub RTW_SR_CONFIG1 () {0x15;}' unless defined(&RTW_SR_CONFIG1);
eval 'sub RTW_SR_PMC () {0x16;}' unless defined(&RTW_SR_PMC);
eval 'sub RTW_SR_CONFIG2 () {0x18;}' unless defined(&RTW_SR_CONFIG2);
eval 'sub RTW_SR_CONFIG4 () {0x19;}' unless defined(&RTW_SR_CONFIG4);
eval 'sub RTW_SR_ANAPARM () {0x1a;}' unless defined(&RTW_SR_ANAPARM);
eval 'sub RTW_SR_TESTR () {0x1e;}' unless defined(&RTW_SR_TESTR);
eval 'sub RTW_SR_CONFIG5 () {0x1f;}' unless defined(&RTW_SR_CONFIG5);
eval 'sub RTW_SR_TXPOWER1 () {0x20;}' unless defined(&RTW_SR_TXPOWER1);
eval 'sub RTW_SR_TXPOWER2 () {0x21;}' unless defined(&RTW_SR_TXPOWER2);
eval 'sub RTW_SR_TXPOWER3 () {0x22;}' unless defined(&RTW_SR_TXPOWER3);
eval 'sub RTW_SR_TXPOWER4 () {0x23;}' unless defined(&RTW_SR_TXPOWER4);
eval 'sub RTW_SR_TXPOWER5 () {0x24;}' unless defined(&RTW_SR_TXPOWER5);
eval 'sub RTW_SR_TXPOWER6 () {0x25;}' unless defined(&RTW_SR_TXPOWER6);
eval 'sub RTW_SR_TXPOWER7 () {0x26;}' unless defined(&RTW_SR_TXPOWER7);
eval 'sub RTW_SR_TXPOWER8 () {0x27;}' unless defined(&RTW_SR_TXPOWER8);
eval 'sub RTW_SR_TXPOWER9 () {0x28;}' unless defined(&RTW_SR_TXPOWER9);
eval 'sub RTW_SR_TXPOWER10 () {0x29;}' unless defined(&RTW_SR_TXPOWER10);
eval 'sub RTW_SR_TXPOWER11 () {0x2a;}' unless defined(&RTW_SR_TXPOWER11);
eval 'sub RTW_SR_TXPOWER12 () {0x2b;}' unless defined(&RTW_SR_TXPOWER12);
eval 'sub RTW_SR_TXPOWER13 () {0x2c;}' unless defined(&RTW_SR_TXPOWER13);
eval 'sub RTW_SR_TXPOWER14 () {0x2d;}' unless defined(&RTW_SR_TXPOWER14);
eval 'sub RTW_SR_CHANNELPLAN () {0x2e;}' unless defined(&RTW_SR_CHANNELPLAN);
eval 'sub RTW_SR_ENERGYDETTHR () {0x2f;}' unless defined(&RTW_SR_ENERGYDETTHR);
eval 'sub RTW_SR_ENERGYDETTHR_DEFAULT () {0xc;}' unless defined(&RTW_SR_ENERGYDETTHR_DEFAULT);
eval 'sub RTW_SR_CISPOINTER () {0x30;}' unless defined(&RTW_SR_CISPOINTER);
eval 'sub RTW_SR_RFPARM () {0x32;}' unless defined(&RTW_SR_RFPARM);
eval 'sub RTW_SR_RFPARM_DIGPHY () {(1<<0);}' unless defined(&RTW_SR_RFPARM_DIGPHY);
eval 'sub RTW_SR_RFPARM_DFLANTB () {(1<<1);}' unless defined(&RTW_SR_RFPARM_DFLANTB);
eval 'sub RTW_SR_RFPARM_CS_MASK () {0xc;}' unless defined(&RTW_SR_RFPARM_CS_MASK);
eval 'sub RTW_SR_VERSION () {0x3c;}' unless defined(&RTW_SR_VERSION);
eval 'sub RTW_SR_CRC () {0x3e;}' unless defined(&RTW_SR_CRC);
eval 'sub RTW_SR_VPD () {0x40;}' unless defined(&RTW_SR_VPD);
eval 'sub RTW_SR_CIS () {0x80;}' unless defined(&RTW_SR_CIS);
eval 'sub RTW_DESC_ALIGNMENT () {256;}' unless defined(&RTW_DESC_ALIGNMENT);
eval 'sub td_stat () { &td_ctl0;}' unless defined(&td_stat);
eval 'sub RTW_TXCTL0_OWN () {(1<<31);}' unless defined(&RTW_TXCTL0_OWN);
eval 'sub RTW_TXCTL0_RSVD0 () {(1<<30);}' unless defined(&RTW_TXCTL0_RSVD0);
eval 'sub RTW_TXCTL0_FS () {(1<<29);}' unless defined(&RTW_TXCTL0_FS);
eval 'sub RTW_TXCTL0_LS () {(1<<28);}' unless defined(&RTW_TXCTL0_LS);
eval 'sub RTW_TXCTL0_RATE_MASK () {0xf000000;}' unless defined(&RTW_TXCTL0_RATE_MASK);
eval 'sub RTW_TXCTL0_RATE_1MBPS () { &LSHIFT(0,  &RTW_TXCTL0_RATE_MASK);}' unless defined(&RTW_TXCTL0_RATE_1MBPS);
eval 'sub RTW_TXCTL0_RATE_2MBPS () { &LSHIFT(1,  &RTW_TXCTL0_RATE_MASK);}' unless defined(&RTW_TXCTL0_RATE_2MBPS);
eval 'sub RTW_TXCTL0_RATE_5MBPS () { &LSHIFT(2,  &RTW_TXCTL0_RATE_MASK);}' unless defined(&RTW_TXCTL0_RATE_5MBPS);
eval 'sub RTW_TXCTL0_RATE_11MBPS () { &LSHIFT(3,  &RTW_TXCTL0_RATE_MASK);}' unless defined(&RTW_TXCTL0_RATE_11MBPS);
eval 'sub RTW_TXCTL0_RTSEN () {(1<<23);}' unless defined(&RTW_TXCTL0_RTSEN);
eval 'sub RTW_TXCTL0_RTSRATE_MASK () {0x780000;}' unless defined(&RTW_TXCTL0_RTSRATE_MASK);
eval 'sub RTW_TXCTL0_RTSRATE_1MBPS () { &LSHIFT(0,  &RTW_TXCTL0_RTSRATE_MASK);}' unless defined(&RTW_TXCTL0_RTSRATE_1MBPS);
eval 'sub RTW_TXCTL0_RTSRATE_2MBPS () { &LSHIFT(1,  &RTW_TXCTL0_RTSRATE_MASK);}' unless defined(&RTW_TXCTL0_RTSRATE_2MBPS);
eval 'sub RTW_TXCTL0_RTSRATE_5MBPS () { &LSHIFT(2,  &RTW_TXCTL0_RTSRATE_MASK);}' unless defined(&RTW_TXCTL0_RTSRATE_5MBPS);
eval 'sub RTW_TXCTL0_RTSRATE_11MBPS () { &LSHIFT(3,  &RTW_TXCTL0_RTSRATE_MASK);}' unless defined(&RTW_TXCTL0_RTSRATE_11MBPS);
eval 'sub RTW_TXCTL0_BEACON () {(1<<18);}' unless defined(&RTW_TXCTL0_BEACON);
eval 'sub RTW_TXCTL0_MOREFRAG () {(1<<17);}' unless defined(&RTW_TXCTL0_MOREFRAG);
eval 'sub RTW_TXCTL0_SPLCP () {(1<<16);}' unless defined(&RTW_TXCTL0_SPLCP);
eval 'sub RTW_TXCTL0_KEYID_MASK () {0xc000;}' unless defined(&RTW_TXCTL0_KEYID_MASK);
eval 'sub RTW_TXCTL0_RSVD1_MASK () {0x3000;}' unless defined(&RTW_TXCTL0_RSVD1_MASK);
eval 'sub RTW_TXCTL0_TPKTSIZE_MASK () {0xfff;}' unless defined(&RTW_TXCTL0_TPKTSIZE_MASK);
eval 'sub RTW_TXSTAT_OWN () { &RTW_TXCTL0_OWN;}' unless defined(&RTW_TXSTAT_OWN);
eval 'sub RTW_TXSTAT_RSVD0 () { &RTW_TXCTL0_RSVD0;}' unless defined(&RTW_TXSTAT_RSVD0);
eval 'sub RTW_TXSTAT_FS () { &RTW_TXCTL0_FS;}' unless defined(&RTW_TXSTAT_FS);
eval 'sub RTW_TXSTAT_LS () { &RTW_TXCTL0_LS;}' unless defined(&RTW_TXSTAT_LS);
eval 'sub RTW_TXSTAT_RSVD1_MASK () {0xfff0000;}' unless defined(&RTW_TXSTAT_RSVD1_MASK);
eval 'sub RTW_TXSTAT_TOK () {(1<<15);}' unless defined(&RTW_TXSTAT_TOK);
eval 'sub RTW_TXSTAT_RTSRETRY_MASK () {0x7f00;}' unless defined(&RTW_TXSTAT_RTSRETRY_MASK);
eval 'sub RTW_TXSTAT_DRC_MASK () {0xff;}' unless defined(&RTW_TXSTAT_DRC_MASK);
eval 'sub RTW_TXCTL1_LENGEXT () {(1<<31);}' unless defined(&RTW_TXCTL1_LENGEXT);
eval 'sub RTW_TXCTL1_LENGTH_MASK () {0x7fff0000;}' unless defined(&RTW_TXCTL1_LENGTH_MASK);
eval 'sub RTW_TXCTL1_RTSDUR_MASK () {0xffff;}' unless defined(&RTW_TXCTL1_RTSDUR_MASK);
eval 'sub RTW_TXLEN_LENGTH_MASK () {0xfff;}' unless defined(&RTW_TXLEN_LENGTH_MASK);
eval 'sub rd_stat () { &rd_ctl;}' unless defined(&rd_stat);
eval 'sub rd_rssi () { &rd_rsvd0;}' unless defined(&rd_rssi);
eval 'sub rd_tsftl () { &rd_buf;}' unless defined(&rd_tsftl);
eval 'sub rd_tsfth () { &rd_rsvd1;}' unless defined(&rd_tsfth);
eval 'sub RTW_RXCTL_OWN () {(1<<31);}' unless defined(&RTW_RXCTL_OWN);
eval 'sub RTW_RXCTL_EOR () {(1<<30);}' unless defined(&RTW_RXCTL_EOR);
eval 'sub RTW_RXCTL_FS () {(1<<29);}' unless defined(&RTW_RXCTL_FS);
eval 'sub RTW_RXCTL_LS () {(1<<28);}' unless defined(&RTW_RXCTL_LS);
eval 'sub RTW_RXCTL_RSVD0_MASK () {0x3ffff000;}' unless defined(&RTW_RXCTL_RSVD0_MASK);
eval 'sub RTW_RXCTL_LENGTH_MASK () {0xfff;}' unless defined(&RTW_RXCTL_LENGTH_MASK);
eval 'sub RTW_RXSTAT_OWN () { &RTW_RXCTL_OWN;}' unless defined(&RTW_RXSTAT_OWN);
eval 'sub RTW_RXSTAT_EOR () { &RTW_RXCTL_EOR;}' unless defined(&RTW_RXSTAT_EOR);
eval 'sub RTW_RXSTAT_FS () { &RTW_RXCTL_FS;}' unless defined(&RTW_RXSTAT_FS);
eval 'sub RTW_RXSTAT_LS () { &RTW_RXCTL_LS;}' unless defined(&RTW_RXSTAT_LS);
eval 'sub RTW_RXSTAT_DMAFAIL () {(1<<27);}' unless defined(&RTW_RXSTAT_DMAFAIL);
eval 'sub RTW_RXSTAT_BOVF () {(1<<26);}' unless defined(&RTW_RXSTAT_BOVF);
eval 'sub RTW_RXSTAT_SPLCP () {(1<<25);}' unless defined(&RTW_RXSTAT_SPLCP);
eval 'sub RTW_RXSTAT_RSVD1 () {(1<<24);}' unless defined(&RTW_RXSTAT_RSVD1);
eval 'sub RTW_RXSTAT_RATE_MASK () {0xf00000;}' unless defined(&RTW_RXSTAT_RATE_MASK);
eval 'sub RTW_RXSTAT_RATE_1MBPS () { &LSHIFT(0,  &RTW_RXSTAT_RATE_MASK);}' unless defined(&RTW_RXSTAT_RATE_1MBPS);
eval 'sub RTW_RXSTAT_RATE_2MBPS () { &LSHIFT(1,  &RTW_RXSTAT_RATE_MASK);}' unless defined(&RTW_RXSTAT_RATE_2MBPS);
eval 'sub RTW_RXSTAT_RATE_5MBPS () { &LSHIFT(2,  &RTW_RXSTAT_RATE_MASK);}' unless defined(&RTW_RXSTAT_RATE_5MBPS);
eval 'sub RTW_RXSTAT_RATE_11MBPS () { &LSHIFT(3,  &RTW_RXSTAT_RATE_MASK);}' unless defined(&RTW_RXSTAT_RATE_11MBPS);
eval 'sub RTW_RXSTAT_MIC () {(1<<19);}' unless defined(&RTW_RXSTAT_MIC);
eval 'sub RTW_RXSTAT_MAR () {(1<<18);}' unless defined(&RTW_RXSTAT_MAR);
eval 'sub RTW_RXSTAT_PAR () {(1<<17);}' unless defined(&RTW_RXSTAT_PAR);
eval 'sub RTW_RXSTAT_BAR () {(1<<16);}' unless defined(&RTW_RXSTAT_BAR);
eval 'sub RTW_RXSTAT_RES () {(1<<15);}' unless defined(&RTW_RXSTAT_RES);
eval 'sub RTW_RXSTAT_PWRMGT () {(1<<14);}' unless defined(&RTW_RXSTAT_PWRMGT);
eval 'sub RTW_RXSTAT_CRC16 () {(1<<14);}' unless defined(&RTW_RXSTAT_CRC16);
eval 'sub RTW_RXSTAT_CRC32 () {(1<<13);}' unless defined(&RTW_RXSTAT_CRC32);
eval 'sub RTW_RXSTAT_ICV () {(1<<12);}' unless defined(&RTW_RXSTAT_ICV);
eval 'sub RTW_RXSTAT_LENGTH_MASK () {0xfff;}' unless defined(&RTW_RXSTAT_LENGTH_MASK);
eval 'sub RTW_RXSTAT_ONESEG () {( &RTW_RXSTAT_FS| &RTW_RXSTAT_LS);}' unless defined(&RTW_RXSTAT_ONESEG);
eval 'sub RTW_RXSTAT_IOERROR () {( &RTW_RXSTAT_DMAFAIL| &RTW_RXSTAT_BOVF);}' unless defined(&RTW_RXSTAT_IOERROR);
eval 'sub RTW_RXSTAT_DEBUG () {( &RTW_RXSTAT_SPLCP| &RTW_RXSTAT_MAR|  &RTW_RXSTAT_PAR| &RTW_RXSTAT_BAR|  &RTW_RXSTAT_PWRMGT| &RTW_RXSTAT_CRC32|  &RTW_RXSTAT_ICV);}' unless defined(&RTW_RXSTAT_DEBUG);
eval 'sub RTW_RXRSSI_VLAN () {0xfffe;}' unless defined(&RTW_RXRSSI_VLAN);
eval 'sub RTW_RXRSSI_RSSI () {0xff00;}' unless defined(&RTW_RXRSSI_RSSI);
eval 'sub RTW_RXRSSI_IMR_RSSI () {0xfe00;}' unless defined(&RTW_RXRSSI_IMR_RSSI);
eval 'sub RTW_RXRSSI_IMR_LNA () {(1<<8);}' unless defined(&RTW_RXRSSI_IMR_LNA);
eval 'sub RTW_RXRSSI_SQ () {0xff;}' unless defined(&RTW_RXRSSI_SQ);
unless(defined(&RTW_READ8)) {
    sub RTW_READ8 {
	my($regs, $ofs) = @_;
	eval q(((*($regs)-> &r_read8)($regs, $ofs)));
    }
}
unless(defined(&RTW_READ16)) {
    sub RTW_READ16 {
	my($regs, $ofs) = @_;
	eval q(((*($regs)-> &r_read16)($regs, $ofs)));
    }
}
unless(defined(&RTW_READ)) {
    sub RTW_READ {
	my($regs, $ofs) = @_;
	eval q(((*($regs)-> &r_read32)($regs, $ofs)));
    }
}
unless(defined(&RTW_WRITE8)) {
    sub RTW_WRITE8 {
	my($regs, $ofs, $val) = @_;
	eval q(((*($regs)-> &r_write8)($regs, $ofs, $val)));
    }
}
unless(defined(&RTW_WRITE16)) {
    sub RTW_WRITE16 {
	my($regs, $ofs, $val) = @_;
	eval q(((*($regs)-> &r_write16)($regs, $ofs, $val)));
    }
}
unless(defined(&RTW_WRITE)) {
    sub RTW_WRITE {
	my($regs, $ofs, $val) = @_;
	eval q(((*($regs)-> &r_write32)($regs, $ofs, $val)));
    }
}
unless(defined(&RTW_ISSET)) {
    sub RTW_ISSET {
	my($regs, $reg, $mask) = @_;
	eval q(( &RTW_READ(($regs), ($reg)) & ($mask)));
    }
}
unless(defined(&RTW_CLR)) {
    sub RTW_CLR {
	my($regs, $reg, $mask) = @_;
	eval q( &RTW_WRITE(($regs), ($reg),  &RTW_READ(($regs), ($reg)) & ~($mask)));
    }
}
unless(defined(&BUS_SPACE_BARRIER_SYNC)) {
    eval 'sub BUS_SPACE_BARRIER_SYNC () {( &BUS_SPACE_BARRIER_READ| &BUS_SPACE_BARRIER_WRITE);}' unless defined(&BUS_SPACE_BARRIER_SYNC);
}
unless(defined(&BUS_SPACE_BARRIER_READ_BEFORE_READ)) {
    eval 'sub BUS_SPACE_BARRIER_READ_BEFORE_READ () { &BUS_SPACE_BARRIER_READ;}' unless defined(&BUS_SPACE_BARRIER_READ_BEFORE_READ);
}
unless(defined(&BUS_SPACE_BARRIER_READ_BEFORE_WRITE)) {
    eval 'sub BUS_SPACE_BARRIER_READ_BEFORE_WRITE () { &BUS_SPACE_BARRIER_READ;}' unless defined(&BUS_SPACE_BARRIER_READ_BEFORE_WRITE);
}
unless(defined(&BUS_SPACE_BARRIER_WRITE_BEFORE_READ)) {
    eval 'sub BUS_SPACE_BARRIER_WRITE_BEFORE_READ () { &BUS_SPACE_BARRIER_WRITE;}' unless defined(&BUS_SPACE_BARRIER_WRITE_BEFORE_READ);
}
unless(defined(&BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE)) {
    eval 'sub BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE () { &BUS_SPACE_BARRIER_WRITE;}' unless defined(&BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE);
}
unless(defined(&RTW_BARRIER)) {
    sub RTW_BARRIER {
	my($regs, $reg0, $reg1, $flags) = @_;
	eval q(((*($regs)-> &r_barrier)($regs, $reg0, $reg1, $flags)));
    }
}
unless(defined(&RTW_SYNC)) {
    sub RTW_SYNC {
	my($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_SYNC));
    }
}
unless(defined(&RTW_WBW)) {
    sub RTW_WBW {
	my($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE));
    }
}
unless(defined(&RTW_WBR)) {
    sub RTW_WBR {
	my($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_WRITE_BEFORE_READ));
    }
}
unless(defined(&RTW_RBR)) {
    sub RTW_RBR {
	my($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_READ_BEFORE_READ));
    }
}
unless(defined(&RTW_RBW)) {
    sub RTW_RBW {
	my($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_READ_BEFORE_WRITE));
    }
}
unless(defined(&RTW_WBRW)) {
    sub RTW_WBRW {
	my($regs, $reg0, $reg1) = @_;
	eval q( &RTW_BARRIER($regs, $reg0, $reg1,  &BUS_SPACE_BARRIER_WRITE_BEFORE_READ |  &BUS_SPACE_BARRIER_WRITE_BEFORE_WRITE));
    }
}
eval 'sub RTW_BBP_SYS1 () {0x;}' unless defined(&RTW_BBP_SYS1);
eval 'sub RTW_BBP_TXAGC () {0x3;}' unless defined(&RTW_BBP_TXAGC);
eval 'sub RTW_BBP_LNADET () {0x4;}' unless defined(&RTW_BBP_LNADET);
eval 'sub RTW_BBP_IFAGCINI () {0x5;}' unless defined(&RTW_BBP_IFAGCINI);
eval 'sub RTW_BBP_IFAGCLIMIT () {0x6;}' unless defined(&RTW_BBP_IFAGCLIMIT);
eval 'sub RTW_BBP_IFAGCDET () {0x7;}' unless defined(&RTW_BBP_IFAGCDET);
eval 'sub RTW_BBP_ANTATTEN () {0x10;}' unless defined(&RTW_BBP_ANTATTEN);
eval 'sub RTW_BBP_ANTATTEN_PHILIPS_MAGIC () {0x91;}' unless defined(&RTW_BBP_ANTATTEN_PHILIPS_MAGIC);
eval 'sub RTW_BBP_ANTATTEN_INTERSIL_MAGIC () {0x92;}' unless defined(&RTW_BBP_ANTATTEN_INTERSIL_MAGIC);
eval 'sub RTW_BBP_ANTATTEN_RFMD_MAGIC () {0x93;}' unless defined(&RTW_BBP_ANTATTEN_RFMD_MAGIC);
eval 'sub RTW_BBP_ANTATTEN_GCT_MAGIC () {0xa3;}' unless defined(&RTW_BBP_ANTATTEN_GCT_MAGIC);
eval 'sub RTW_BBP_ANTATTEN_MAXIM_MAGIC () {0xb3;}' unless defined(&RTW_BBP_ANTATTEN_MAXIM_MAGIC);
eval 'sub RTW_BBP_ANTATTEN_DFLANTB () {0x40;}' unless defined(&RTW_BBP_ANTATTEN_DFLANTB);
eval 'sub RTW_BBP_ANTATTEN_CHAN14 () {0xc;}' unless defined(&RTW_BBP_ANTATTEN_CHAN14);
eval 'sub RTW_BBP_TRL () {0x11;}' unless defined(&RTW_BBP_TRL);
eval 'sub RTW_BBP_SYS2 () {0x12;}' unless defined(&RTW_BBP_SYS2);
eval 'sub RTW_BBP_SYS2_ANTDIV () {0x80;}' unless defined(&RTW_BBP_SYS2_ANTDIV);
eval 'sub RTW_BBP_SYS2_RATE_MASK () {0x30;}' unless defined(&RTW_BBP_SYS2_RATE_MASK);
eval 'sub RTW_BBP_SYS3 () {0x13;}' unless defined(&RTW_BBP_SYS3);
eval 'sub RTW_BBP_SYS3_CSTHRESH_MASK () {0xf;}' unless defined(&RTW_BBP_SYS3_CSTHRESH_MASK);
eval 'sub RTW_BBP_CHESTLIM () {0x19;}' unless defined(&RTW_BBP_CHESTLIM);
eval 'sub RTW_BBP_CHSQLIM () {0x1a;}' unless defined(&RTW_BBP_CHSQLIM);
1;
