require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'uvm/uvm_extern.ph';
eval 'sub OOSIOP_NTGT () {8;}' unless defined(&OOSIOP_NTGT);
eval 'sub OOSIOP_NCB () {32;}' unless defined(&OOSIOP_NCB);
eval 'sub OOSIOP_NSG () {( &MIN( &atop( &MAXPHYS) + 1, 32));}' unless defined(&OOSIOP_NSG);
eval 'sub OOSIOP_MAX_XFER () { &ptoa( &OOSIOP_NSG - 1);}' unless defined(&OOSIOP_MAX_XFER);
eval 'sub SCSI_OOSIOP_NOSTATUS () {0xff;}' unless defined(&SCSI_OOSIOP_NOSTATUS);
unless(defined(&OOSIOP_XFEROFF)) {
    sub OOSIOP_XFEROFF {
	my($x) = @_;
	eval q( &offsetof('struct oosiop_xfer', $x));
    }
}
eval 'sub OOSIOP_DINSCROFF () { &OOSIOP_XFEROFF( $datain_scr[0]);}' unless defined(&OOSIOP_DINSCROFF);
eval 'sub OOSIOP_DOUTSCROFF () { &OOSIOP_XFEROFF( $dataout_scr[0]);}' unless defined(&OOSIOP_DOUTSCROFF);
eval 'sub OOSIOP_MSGINOFF () { &OOSIOP_XFEROFF( $msgin[0]);}' unless defined(&OOSIOP_MSGINOFF);
eval 'sub OOSIOP_MSGOUTOFF () { &OOSIOP_XFEROFF( $msgout[0]);}' unless defined(&OOSIOP_MSGOUTOFF);
unless(defined(&OOSIOP_XFERSCR_SYNC)) {
    sub OOSIOP_XFERSCR_SYNC {
	my($sc, $cb, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($cb)-> &xferdma,  &OOSIOP_DINSCROFF,  &OOSIOP_MSGINOFF -  &OOSIOP_DINSCROFF, ($ops)));
    }
}
unless(defined(&OOSIOP_DINSCR_SYNC)) {
    sub OOSIOP_DINSCR_SYNC {
	my($sc, $cb, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($cb)-> &xferdma,  &OOSIOP_DINSCROFF,  &OOSIOP_DOUTSCROFF -  &OOSIOP_DINSCROFF, ($ops)));
    }
}
unless(defined(&OOSIOP_DOUTSCR_SYNC)) {
    sub OOSIOP_DOUTSCR_SYNC {
	my($sc, $cb, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($cb)-> &xferdma,  &OOSIOP_DOUTSCROFF,  &OOSIOP_MSGINOFF -  &OOSIOP_DOUTSCROFF, ($ops)));
    }
}
unless(defined(&OOSIOP_XFERMSG_SYNC)) {
    sub OOSIOP_XFERMSG_SYNC {
	my($sc, $cb, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($cb)-> &xferdma,  &OOSIOP_MSGINOFF, $sizeof{'struct oosiop_xfer'} -  &OOSIOP_MSGINOFF, ($ops)));
    }
}
unless(defined(&OOSIOP_SCRIPT_SYNC)) {
    sub OOSIOP_SCRIPT_SYNC {
	my($sc, $ops) = @_;
	eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &sc_scrdma, 0, $sizeof{ &oosiop_script}, ($ops)));
    }
}
eval 'sub CBF_SELTOUT () {0x1;}' unless defined(&CBF_SELTOUT);
eval 'sub CBF_TIMEOUT () {0x2;}' unless defined(&CBF_TIMEOUT);
eval 'sub CBF_AUTOSENSE () {0x4;}' unless defined(&CBF_AUTOSENSE);
eval 'sub TGTF_SYNCNEG () {0x1;}' unless defined(&TGTF_SYNCNEG);
eval 'sub TGTF_WAITSDTR () {0x2;}' unless defined(&TGTF_WAITSDTR);
eval 'sub OOSIOP_700 () {0;}' unless defined(&OOSIOP_700);
eval 'sub OOSIOP_700_66 () {1;}' unless defined(&OOSIOP_700_66);
unless(defined(&oosiop_read_1)) {
    sub oosiop_read_1 {
	my($sc, $addr) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_bst, ($sc)-> &sc_bsh, ($addr)));
    }
}
unless(defined(&oosiop_write_1)) {
    sub oosiop_write_1 {
	my($sc, $addr, $data) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_bst, ($sc)-> &sc_bsh, ($addr), ($data)));
    }
}
unless(defined(&oosiop_read_4)) {
    sub oosiop_read_4 {
	my($sc, $addr) = @_;
	eval q( &letoh32( &bus_space_read_4(($sc)-> &sc_bst, ($sc)-> &sc_bsh, ($addr))));
    }
}
unless(defined(&oosiop_write_4)) {
    sub oosiop_write_4 {
	my($sc, $addr, $data) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bst, ($sc)-> &sc_bsh, ($addr),  &htole32($data)));
    }
}
1;
