require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DEV_PCI_OHCIREG_H_)) {
    eval 'sub _DEV_PCI_OHCIREG_H_ () {1;}' unless defined(&_DEV_PCI_OHCIREG_H_);
    eval 'sub PCI_CBMEM () {0x10;}' unless defined(&PCI_CBMEM);
    eval 'sub PCI_INTERFACE_OHCI () {0x10;}' unless defined(&PCI_INTERFACE_OHCI);
    eval 'sub OHCI_REVISION () {0x;}' unless defined(&OHCI_REVISION);
    eval 'sub OHCI_REV_LO {
        my($rev) = @_;
	    eval q((($rev)&0xf));
    }' unless defined(&OHCI_REV_LO);
    eval 'sub OHCI_REV_HI {
        my($rev) = @_;
	    eval q(((($rev)>>4)&0xf));
    }' unless defined(&OHCI_REV_HI);
    eval 'sub OHCI_REV_LEGACY {
        my($rev) = @_;
	    eval q((($rev) & 0x100));
    }' unless defined(&OHCI_REV_LEGACY);
    eval 'sub OHCI_CONTROL () {0x4;}' unless defined(&OHCI_CONTROL);
    eval 'sub OHCI_CBSR_MASK () {0x3;}' unless defined(&OHCI_CBSR_MASK);
    eval 'sub OHCI_RATIO_1_1 () {0x;}' unless defined(&OHCI_RATIO_1_1);
    eval 'sub OHCI_RATIO_1_2 () {0x1;}' unless defined(&OHCI_RATIO_1_2);
    eval 'sub OHCI_RATIO_1_3 () {0x2;}' unless defined(&OHCI_RATIO_1_3);
    eval 'sub OHCI_RATIO_1_4 () {0x3;}' unless defined(&OHCI_RATIO_1_4);
    eval 'sub OHCI_PLE () {0x4;}' unless defined(&OHCI_PLE);
    eval 'sub OHCI_IE () {0x8;}' unless defined(&OHCI_IE);
    eval 'sub OHCI_CLE () {0x10;}' unless defined(&OHCI_CLE);
    eval 'sub OHCI_BLE () {0x20;}' unless defined(&OHCI_BLE);
    eval 'sub OHCI_HCFS_MASK () {0xc0;}' unless defined(&OHCI_HCFS_MASK);
    eval 'sub OHCI_HCFS_RESET () {0x;}' unless defined(&OHCI_HCFS_RESET);
    eval 'sub OHCI_HCFS_RESUME () {0x40;}' unless defined(&OHCI_HCFS_RESUME);
    eval 'sub OHCI_HCFS_OPERATIONAL () {0x80;}' unless defined(&OHCI_HCFS_OPERATIONAL);
    eval 'sub OHCI_HCFS_SUSPEND () {0xc0;}' unless defined(&OHCI_HCFS_SUSPEND);
    eval 'sub OHCI_IR () {0x100;}' unless defined(&OHCI_IR);
    eval 'sub OHCI_RWC () {0x200;}' unless defined(&OHCI_RWC);
    eval 'sub OHCI_RWE () {0x400;}' unless defined(&OHCI_RWE);
    eval 'sub OHCI_COMMAND_STATUS () {0x8;}' unless defined(&OHCI_COMMAND_STATUS);
    eval 'sub OHCI_HCR () {0x1;}' unless defined(&OHCI_HCR);
    eval 'sub OHCI_CLF () {0x2;}' unless defined(&OHCI_CLF);
    eval 'sub OHCI_BLF () {0x4;}' unless defined(&OHCI_BLF);
    eval 'sub OHCI_OCR () {0x8;}' unless defined(&OHCI_OCR);
    eval 'sub OHCI_SOC_MASK () {0x30000;}' unless defined(&OHCI_SOC_MASK);
    eval 'sub OHCI_INTERRUPT_STATUS () {0xc;}' unless defined(&OHCI_INTERRUPT_STATUS);
    eval 'sub OHCI_SO () {0x1;}' unless defined(&OHCI_SO);
    eval 'sub OHCI_WDH () {0x2;}' unless defined(&OHCI_WDH);
    eval 'sub OHCI_SF () {0x4;}' unless defined(&OHCI_SF);
    eval 'sub OHCI_RD () {0x8;}' unless defined(&OHCI_RD);
    eval 'sub OHCI_UE () {0x10;}' unless defined(&OHCI_UE);
    eval 'sub OHCI_FNO () {0x20;}' unless defined(&OHCI_FNO);
    eval 'sub OHCI_RHSC () {0x40;}' unless defined(&OHCI_RHSC);
    eval 'sub OHCI_OC () {0x40000000;}' unless defined(&OHCI_OC);
    eval 'sub OHCI_MIE () {0x80000000;}' unless defined(&OHCI_MIE);
    eval 'sub OHCI_INTERRUPT_ENABLE () {0x10;}' unless defined(&OHCI_INTERRUPT_ENABLE);
    eval 'sub OHCI_INTERRUPT_DISABLE () {0x14;}' unless defined(&OHCI_INTERRUPT_DISABLE);
    eval 'sub OHCI_HCCA () {0x18;}' unless defined(&OHCI_HCCA);
    eval 'sub OHCI_PERIOD_CURRENT_ED () {0x1c;}' unless defined(&OHCI_PERIOD_CURRENT_ED);
    eval 'sub OHCI_CONTROL_HEAD_ED () {0x20;}' unless defined(&OHCI_CONTROL_HEAD_ED);
    eval 'sub OHCI_CONTROL_CURRENT_ED () {0x24;}' unless defined(&OHCI_CONTROL_CURRENT_ED);
    eval 'sub OHCI_BULK_HEAD_ED () {0x28;}' unless defined(&OHCI_BULK_HEAD_ED);
    eval 'sub OHCI_BULK_CURRENT_ED () {0x2c;}' unless defined(&OHCI_BULK_CURRENT_ED);
    eval 'sub OHCI_DONE_HEAD () {0x30;}' unless defined(&OHCI_DONE_HEAD);
    eval 'sub OHCI_FM_INTERVAL () {0x34;}' unless defined(&OHCI_FM_INTERVAL);
    eval 'sub OHCI_GET_IVAL {
        my($s) = @_;
	    eval q((($s) & 0x3fff));
    }' unless defined(&OHCI_GET_IVAL);
    eval 'sub OHCI_GET_FSMPS {
        my($s) = @_;
	    eval q(((($s) >> 16) & 0x7fff));
    }' unless defined(&OHCI_GET_FSMPS);
    eval 'sub OHCI_FIT () {0x80000000;}' unless defined(&OHCI_FIT);
    eval 'sub OHCI_FM_REMAINING () {0x38;}' unless defined(&OHCI_FM_REMAINING);
    eval 'sub OHCI_FM_NUMBER () {0x3c;}' unless defined(&OHCI_FM_NUMBER);
    eval 'sub OHCI_PERIODIC_START () {0x40;}' unless defined(&OHCI_PERIODIC_START);
    eval 'sub OHCI_LS_THRESHOLD () {0x44;}' unless defined(&OHCI_LS_THRESHOLD);
    eval 'sub OHCI_RH_DESCRIPTOR_A () {0x48;}' unless defined(&OHCI_RH_DESCRIPTOR_A);
    eval 'sub OHCI_GET_NDP {
        my($s) = @_;
	    eval q((($s) & 0xff));
    }' unless defined(&OHCI_GET_NDP);
    eval 'sub OHCI_PSM () {0x100;}' unless defined(&OHCI_PSM);
    eval 'sub OHCI_NPS () {0x200;}' unless defined(&OHCI_NPS);
    eval 'sub OHCI_DT () {0x400;}' unless defined(&OHCI_DT);
    eval 'sub OHCI_OCPM () {0x800;}' unless defined(&OHCI_OCPM);
    eval 'sub OHCI_NOCP () {0x1000;}' unless defined(&OHCI_NOCP);
    eval 'sub OHCI_GET_POTPGT {
        my($s) = @_;
	    eval q((($s) >> 24));
    }' unless defined(&OHCI_GET_POTPGT);
    eval 'sub OHCI_RH_DESCRIPTOR_B () {0x4c;}' unless defined(&OHCI_RH_DESCRIPTOR_B);
    eval 'sub OHCI_RH_STATUS () {0x50;}' unless defined(&OHCI_RH_STATUS);
    eval 'sub OHCI_LPS () {0x1;}' unless defined(&OHCI_LPS);
    eval 'sub OHCI_OCI () {0x2;}' unless defined(&OHCI_OCI);
    eval 'sub OHCI_DRWE () {0x8000;}' unless defined(&OHCI_DRWE);
    eval 'sub OHCI_LPSC () {0x10000;}' unless defined(&OHCI_LPSC);
    eval 'sub OHCI_CCIC () {0x20000;}' unless defined(&OHCI_CCIC);
    eval 'sub OHCI_CRWE () {0x80000000;}' unless defined(&OHCI_CRWE);
    eval 'sub OHCI_RH_PORT_STATUS {
        my($n) = @_;
	    eval q((0x50 + ($n)*4));
    }' unless defined(&OHCI_RH_PORT_STATUS);
    eval 'sub OHCI_LES () {( &OHCI_PLE |  &OHCI_IE |  &OHCI_CLE |  &OHCI_BLE);}' unless defined(&OHCI_LES);
    eval 'sub OHCI_ALL_INTRS () {( &OHCI_SO |  &OHCI_WDH |  &OHCI_SF |  &OHCI_RD |  &OHCI_UE |  &OHCI_FNO |  &OHCI_RHSC |  &OHCI_OC);}' unless defined(&OHCI_ALL_INTRS);
    eval 'sub OHCI_NORMAL_INTRS () {( &OHCI_SO |  &OHCI_WDH |  &OHCI_RD |  &OHCI_UE |  &OHCI_RHSC);}' unless defined(&OHCI_NORMAL_INTRS);
    eval 'sub OHCI_FSMPS {
        my($i) = @_;
	    eval q(((($i-210)*6/7) << 16));
    }' unless defined(&OHCI_FSMPS);
    eval 'sub OHCI_PERIODIC {
        my($i) = @_;
	    eval q((($i)*9/10));
    }' unless defined(&OHCI_PERIODIC);
    eval 'sub OHCI_NO_INTRS () {32;}' unless defined(&OHCI_NO_INTRS);
    eval 'sub OHCI_DONE_INTRS () {1;}' unless defined(&OHCI_DONE_INTRS);
    eval 'sub OHCI_HCCA_SIZE () {256;}' unless defined(&OHCI_HCCA_SIZE);
    eval 'sub OHCI_HCCA_ALIGN () {256;}' unless defined(&OHCI_HCCA_ALIGN);
    eval 'sub OHCI_PAGE_SIZE () {0x1000;}' unless defined(&OHCI_PAGE_SIZE);
    eval 'sub OHCI_PAGE {
        my($x) = @_;
	    eval q((($x) &~ 0xfff));
    }' unless defined(&OHCI_PAGE);
    eval 'sub OHCI_PAGE_OFFSET {
        my($x) = @_;
	    eval q((($x) & 0xfff));
    }' unless defined(&OHCI_PAGE_OFFSET);
    eval 'sub OHCI_ED_GET_FA {
        my($s) = @_;
	    eval q((($s) & 0x7f));
    }' unless defined(&OHCI_ED_GET_FA);
    eval 'sub OHCI_ED_ADDRMASK () {0x7f;}' unless defined(&OHCI_ED_ADDRMASK);
    eval 'sub OHCI_ED_SET_FA {
        my($s) = @_;
	    eval q(($s));
    }' unless defined(&OHCI_ED_SET_FA);
    eval 'sub OHCI_ED_GET_EN {
        my($s) = @_;
	    eval q(((($s) >> 7) & 0xf));
    }' unless defined(&OHCI_ED_GET_EN);
    eval 'sub OHCI_ED_SET_EN {
        my($s) = @_;
	    eval q((($s) << 7));
    }' unless defined(&OHCI_ED_SET_EN);
    eval 'sub OHCI_ED_DIR_MASK () {0x1800;}' unless defined(&OHCI_ED_DIR_MASK);
    eval 'sub OHCI_ED_DIR_TD () {0x;}' unless defined(&OHCI_ED_DIR_TD);
    eval 'sub OHCI_ED_DIR_OUT () {0x800;}' unless defined(&OHCI_ED_DIR_OUT);
    eval 'sub OHCI_ED_DIR_IN () {0x1000;}' unless defined(&OHCI_ED_DIR_IN);
    eval 'sub OHCI_ED_SPEED () {0x2000;}' unless defined(&OHCI_ED_SPEED);
    eval 'sub OHCI_ED_SKIP () {0x4000;}' unless defined(&OHCI_ED_SKIP);
    eval 'sub OHCI_ED_FORMAT_GEN () {0x;}' unless defined(&OHCI_ED_FORMAT_GEN);
    eval 'sub OHCI_ED_FORMAT_ISO () {0x8000;}' unless defined(&OHCI_ED_FORMAT_ISO);
    eval 'sub OHCI_ED_GET_MAXP {
        my($s) = @_;
	    eval q(((($s) >> 16) & 0x7ff));
    }' unless defined(&OHCI_ED_GET_MAXP);
    eval 'sub OHCI_ED_SET_MAXP {
        my($s) = @_;
	    eval q((($s) << 16));
    }' unless defined(&OHCI_ED_SET_MAXP);
    eval 'sub OHCI_ED_MAXPMASK () {(0x7ff << 16);}' unless defined(&OHCI_ED_MAXPMASK);
    eval 'sub OHCI_HALTED () {0x1;}' unless defined(&OHCI_HALTED);
    eval 'sub OHCI_TOGGLECARRY () {0x2;}' unless defined(&OHCI_TOGGLECARRY);
    eval 'sub OHCI_HEADMASK () {0xfffffffc;}' unless defined(&OHCI_HEADMASK);
    eval 'sub OHCI_ED_ALIGN () {16;}' unless defined(&OHCI_ED_ALIGN);
    eval 'sub OHCI_TD_R () {0x40000;}' unless defined(&OHCI_TD_R);
    eval 'sub OHCI_TD_DP_MASK () {0x180000;}' unless defined(&OHCI_TD_DP_MASK);
    eval 'sub OHCI_TD_SETUP () {0x;}' unless defined(&OHCI_TD_SETUP);
    eval 'sub OHCI_TD_OUT () {0x80000;}' unless defined(&OHCI_TD_OUT);
    eval 'sub OHCI_TD_IN () {0x100000;}' unless defined(&OHCI_TD_IN);
    eval 'sub OHCI_TD_GET_DI {
        my($x) = @_;
	    eval q(((($x) >> 21) & 7));
    }' unless defined(&OHCI_TD_GET_DI);
    eval 'sub OHCI_TD_SET_DI {
        my($x) = @_;
	    eval q((($x) << 21));
    }' unless defined(&OHCI_TD_SET_DI);
    eval 'sub OHCI_TD_NOINTR () {0xe00000;}' unless defined(&OHCI_TD_NOINTR);
    eval 'sub OHCI_TD_INTR_MASK () {0xe00000;}' unless defined(&OHCI_TD_INTR_MASK);
    eval 'sub OHCI_TD_TOGGLE_CARRY () {0x;}' unless defined(&OHCI_TD_TOGGLE_CARRY);
    eval 'sub OHCI_TD_TOGGLE_0 () {0x2000000;}' unless defined(&OHCI_TD_TOGGLE_0);
    eval 'sub OHCI_TD_TOGGLE_1 () {0x3000000;}' unless defined(&OHCI_TD_TOGGLE_1);
    eval 'sub OHCI_TD_TOGGLE_MASK () {0x3000000;}' unless defined(&OHCI_TD_TOGGLE_MASK);
    eval 'sub OHCI_TD_GET_EC {
        my($x) = @_;
	    eval q(((($x) >> 26) & 3));
    }' unless defined(&OHCI_TD_GET_EC);
    eval 'sub OHCI_TD_GET_CC {
        my($x) = @_;
	    eval q((($x) >> 28));
    }' unless defined(&OHCI_TD_GET_CC);
    eval 'sub OHCI_TD_NOCC () {0xf0000000;}' unless defined(&OHCI_TD_NOCC);
    eval 'sub OHCI_TD_ALIGN () {16;}' unless defined(&OHCI_TD_ALIGN);
    eval 'sub OHCI_ITD_NOFFSET () {8;}' unless defined(&OHCI_ITD_NOFFSET);
    eval 'sub OHCI_ITD_GET_SF {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&OHCI_ITD_GET_SF);
    eval 'sub OHCI_ITD_SET_SF {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&OHCI_ITD_SET_SF);
    eval 'sub OHCI_ITD_GET_DI {
        my($x) = @_;
	    eval q(((($x) >> 21) & 7));
    }' unless defined(&OHCI_ITD_GET_DI);
    eval 'sub OHCI_ITD_SET_DI {
        my($x) = @_;
	    eval q((($x) << 21));
    }' unless defined(&OHCI_ITD_SET_DI);
    eval 'sub OHCI_ITD_NOINTR () {0xe00000;}' unless defined(&OHCI_ITD_NOINTR);
    eval 'sub OHCI_ITD_GET_FC {
        my($x) = @_;
	    eval q((((($x) >> 24) & 7)+1));
    }' unless defined(&OHCI_ITD_GET_FC);
    eval 'sub OHCI_ITD_SET_FC {
        my($x) = @_;
	    eval q(((($x)-1) << 24));
    }' unless defined(&OHCI_ITD_SET_FC);
    eval 'sub OHCI_ITD_GET_CC {
        my($x) = @_;
	    eval q((($x) >> 28));
    }' unless defined(&OHCI_ITD_GET_CC);
    eval 'sub OHCI_ITD_NOCC () {0xf0000000;}' unless defined(&OHCI_ITD_NOCC);
    eval 'sub itd_pswn () { &itd_offset;}' unless defined(&itd_pswn);
    eval 'sub OHCI_ITD_PAGE_SELECT () {0x1000;}' unless defined(&OHCI_ITD_PAGE_SELECT);
    eval 'sub OHCI_ITD_MK_OFFS {
        my($len) = @_;
	    eval q((0xe000 | (($len) & 0x1fff)));
    }' unless defined(&OHCI_ITD_MK_OFFS);
    eval 'sub OHCI_ITD_PSW_LENGTH {
        my($x) = @_;
	    eval q((($x) & 0xfff));
    }' unless defined(&OHCI_ITD_PSW_LENGTH);
    eval 'sub OHCI_ITD_PSW_GET_CC {
        my($x) = @_;
	    eval q((($x) >> 12));
    }' unless defined(&OHCI_ITD_PSW_GET_CC);
    eval 'sub OHCI_ITD_ALIGN () {32;}' unless defined(&OHCI_ITD_ALIGN);
    eval 'sub OHCI_CC_NO_ERROR () {0;}' unless defined(&OHCI_CC_NO_ERROR);
    eval 'sub OHCI_CC_CRC () {1;}' unless defined(&OHCI_CC_CRC);
    eval 'sub OHCI_CC_BIT_STUFFING () {2;}' unless defined(&OHCI_CC_BIT_STUFFING);
    eval 'sub OHCI_CC_DATA_TOGGLE_MISMATCH () {3;}' unless defined(&OHCI_CC_DATA_TOGGLE_MISMATCH);
    eval 'sub OHCI_CC_STALL () {4;}' unless defined(&OHCI_CC_STALL);
    eval 'sub OHCI_CC_DEVICE_NOT_RESPONDING () {5;}' unless defined(&OHCI_CC_DEVICE_NOT_RESPONDING);
    eval 'sub OHCI_CC_PID_CHECK_FAILURE () {6;}' unless defined(&OHCI_CC_PID_CHECK_FAILURE);
    eval 'sub OHCI_CC_UNEXPECTED_PID () {7;}' unless defined(&OHCI_CC_UNEXPECTED_PID);
    eval 'sub OHCI_CC_DATA_OVERRUN () {8;}' unless defined(&OHCI_CC_DATA_OVERRUN);
    eval 'sub OHCI_CC_DATA_UNDERRUN () {9;}' unless defined(&OHCI_CC_DATA_UNDERRUN);
    eval 'sub OHCI_CC_BUFFER_OVERRUN () {12;}' unless defined(&OHCI_CC_BUFFER_OVERRUN);
    eval 'sub OHCI_CC_BUFFER_UNDERRUN () {13;}' unless defined(&OHCI_CC_BUFFER_UNDERRUN);
    eval 'sub OHCI_CC_NOT_ACCESSED () {14;}' unless defined(&OHCI_CC_NOT_ACCESSED);
    eval 'sub OHCI_CC_NOT_ACCESSED_MASK () {14;}' unless defined(&OHCI_CC_NOT_ACCESSED_MASK);
    eval 'sub OHCI_ENABLE_POWER_DELAY () {5;}' unless defined(&OHCI_ENABLE_POWER_DELAY);
    eval 'sub OHCI_READ_DESC_DELAY () {5;}' unless defined(&OHCI_READ_DESC_DELAY);
}
1;
