require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&osiop_read_1)) {
    sub osiop_read_1 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_bst, ($sc)-> &sc_reg, $reg));
    }
}
unless(defined(&osiop_write_1)) {
    sub osiop_write_1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_bst, ($sc)-> &sc_reg, $reg, $val));
    }
}
unless(defined(&osiop_read_4)) {
    sub osiop_read_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_bst, ($sc)-> &sc_reg, $reg));
    }
}
unless(defined(&osiop_write_4)) {
    sub osiop_write_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_bst, ($sc)-> &sc_reg, $reg, $val));
    }
}
eval 'sub OSIOP_NSG () {(16+ 1);}' unless defined(&OSIOP_NSG);
if((defined(&MAXPHYS) ? &MAXPHYS : undef) > ((defined(&PAGE_SIZE) ? &PAGE_SIZE : undef) * ((defined(&OSIOP_NSG) ? &OSIOP_NSG : undef) - 1))) {
    eval 'sub OSIOP_MAX_XFER () {( &PAGE_SIZE * ( &OSIOP_NSG - 1));}' unless defined(&OSIOP_MAX_XFER);
} else {
    eval 'sub OSIOP_MAX_XFER () { &MAXPHYS;}' unless defined(&OSIOP_MAX_XFER);
}
eval 'sub OSIOP_NTGT () {8;}' unless defined(&OSIOP_NTGT);
eval 'sub OSIOP_NACB () {32;}' unless defined(&OSIOP_NACB);
eval 'sub SCSI_OSIOP_NOCHECK () {0xfe;}' unless defined(&SCSI_OSIOP_NOCHECK);
eval 'sub SCSI_OSIOP_NOSTATUS () {0xff;}' unless defined(&SCSI_OSIOP_NOSTATUS);
eval 'sub MSG_INVALID () {0xff;}' unless defined(&MSG_INVALID);
unless(defined(&OSIOP_DSOFF)) {
    sub OSIOP_DSOFF {
	my($x) = @_;
	eval q( &offsetof('struct osiop_ds', $x));
    }
}
eval 'sub OSIOP_DSIDOFF () { &OSIOP_DSOFF( $msgout[0]);}' unless defined(&OSIOP_DSIDOFF);
eval 'sub OSIOP_DSMSGOFF () { &OSIOP_DSOFF( $msgbuf[0]);}' unless defined(&OSIOP_DSMSGOFF);
eval 'sub OSIOP_DSMSGINOFF () { &OSIOP_DSOFF( $msgbuf[1]);}' unless defined(&OSIOP_DSMSGINOFF);
eval 'sub OSIOP_DSEXTMSGOFF () { &OSIOP_DSOFF( $msgbuf[2]);}' unless defined(&OSIOP_DSEXTMSGOFF);
eval 'sub OSIOP_DSSYNMSGOFF () { &OSIOP_DSOFF( $msgbuf[3]);}' unless defined(&OSIOP_DSSYNMSGOFF);
eval 'sub OSIOP_DSSTATOFF () { &OSIOP_DSOFF( $stat[0]);}' unless defined(&OSIOP_DSSTATOFF);
eval 'sub OSIOP_DSCMDOFF () { &OSIOP_DSOFF( &scsi_cmd);}' unless defined(&OSIOP_DSCMDOFF);
eval 'sub ACB_S_FREE () {0;}' unless defined(&ACB_S_FREE);
eval 'sub ACB_S_READY () {1;}' unless defined(&ACB_S_READY);
eval 'sub ACB_S_ACTIVE () {2;}' unless defined(&ACB_S_ACTIVE);
eval 'sub ACB_S_DONE () {3;}' unless defined(&ACB_S_DONE);
eval 'sub ACB_F_TIMEOUT () {0x1;}' unless defined(&ACB_F_TIMEOUT);
eval 'sub ACB_F_AUTOSENSE () {0x2;}' unless defined(&ACB_F_AUTOSENSE);
eval 'sub TI_NOSYNC () {0x1;}' unless defined(&TI_NOSYNC);
eval 'sub TI_NODISC () {0x2;}' unless defined(&TI_NODISC);
eval 'sub OSIOP_INTSOFF () {0x80;}' unless defined(&OSIOP_INTSOFF);
eval 'sub OSIOP_INTDEFER () {0x40;}' unless defined(&OSIOP_INTDEFER);
eval 'sub OSIOP_NODMA () {0x2;}' unless defined(&OSIOP_NODMA);
eval 'sub OSIOP_ALIVE () {0x1;}' unless defined(&OSIOP_ALIVE);
eval 'sub NEG_INIT () {0;}' unless defined(&NEG_INIT);
eval 'sub NEG_SYNC () { &NEG_INIT;}' unless defined(&NEG_SYNC);
eval 'sub NEG_WAITS () {1;}' unless defined(&NEG_WAITS);
eval 'sub NEG_DONE () {2;}' unless defined(&NEG_DONE);
1;
