var NAVTREE =
[
  [ "LibOFX", "index.html", [
    [ "tree.hh", "index.html", null ],
    [ "Data Structures", "annotated.html", [
      [ "cmdline_parser_params", "structcmdline__parser__params.html", null ],
      [ "ErrorMsg", "structErrorMsg.html", null ],
      [ "tree< T, tree_node_allocator >::fixed_depth_iterator", "classtree_1_1fixed__depth__iterator.html", null ],
      [ "gengetopt_args_info", "structgengetopt__args__info.html", null ],
      [ "tree< T, tree_node_allocator >::iterator_base", "classtree_1_1iterator__base.html", null ],
      [ "tree< T, tree_node_allocator >::iterator_base_less", "classtree_1_1iterator__base__less.html", null ],
      [ "LibofxContext", "classLibofxContext.html", null ],
      [ "LibofxFileFormatInfo", "structLibofxFileFormatInfo.html", null ],
      [ "OFCApplication", "classOFCApplication.html", null ],
      [ "OfxAccountContainer", "classOfxAccountContainer.html", null ],
      [ "OfxAccountData", "structOfxAccountData.html", null ],
      [ "OfxAccountInfoRequest", "classOfxAccountInfoRequest.html", null ],
      [ "OfxAggregate", "classOfxAggregate.html", null ],
      [ "OFXApplication", "classOFXApplication.html", null ],
      [ "OfxBalanceContainer", "classOfxBalanceContainer.html", null ],
      [ "OfxBankTransactionContainer", "classOfxBankTransactionContainer.html", null ],
      [ "OfxCurrency", "structOfxCurrency.html", null ],
      [ "OfxDummyContainer", "classOfxDummyContainer.html", null ],
      [ "OfxFiLogin", "structOfxFiLogin.html", null ],
      [ "OfxFiServiceInfo", "structOfxFiServiceInfo.html", null ],
      [ "OfxGenericContainer", "classOfxGenericContainer.html", null ],
      [ "OfxInvestmentTransactionContainer", "classOfxInvestmentTransactionContainer.html", null ],
      [ "OfxMainContainer", "classOfxMainContainer.html", null ],
      [ "OfxPayee", "structOfxPayee.html", null ],
      [ "OfxPayment", "structOfxPayment.html", null ],
      [ "OfxPaymentRequest", "classOfxPaymentRequest.html", null ],
      [ "OfxPushUpContainer", "classOfxPushUpContainer.html", null ],
      [ "OfxRequest", "classOfxRequest.html", null ],
      [ "OfxSecurityContainer", "classOfxSecurityContainer.html", null ],
      [ "OfxSecurityData", "structOfxSecurityData.html", null ],
      [ "OfxStatementContainer", "classOfxStatementContainer.html", null ],
      [ "OfxStatementData", "structOfxStatementData.html", null ],
      [ "OfxStatementRequest", "classOfxStatementRequest.html", null ],
      [ "OfxStatusContainer", "classOfxStatusContainer.html", null ],
      [ "OfxStatusData", "structOfxStatusData.html", null ],
      [ "OfxTransactionContainer", "classOfxTransactionContainer.html", null ],
      [ "OfxTransactionData", "structOfxTransactionData.html", null ],
      [ "option", "structoption.html", null ],
      [ "tree< T, tree_node_allocator >::post_order_iterator", "classtree_1_1post__order__iterator.html", null ],
      [ "tree< T, tree_node_allocator >::pre_order_iterator", "classtree_1_1pre__order__iterator.html", null ],
      [ "tree< T, tree_node_allocator >::sibling_iterator", "classtree_1_1sibling__iterator.html", null ],
      [ "tree< T, tree_node_allocator >", "classtree.html", null ],
      [ "tree_node_< T >", "classtree__node__.html", null ]
    ] ],
    [ "Data Structure Index", "classes.html", null ],
    [ "Class Hierarchy", "hierarchy.html", [
      [ "cmdline_parser_params", "structcmdline__parser__params.html", null ],
      [ "ErrorMsg", "structErrorMsg.html", null ],
      [ "gengetopt_args_info", "structgengetopt__args__info.html", null ],
      [ "tree< T, tree_node_allocator >::iterator_base", "classtree_1_1iterator__base.html", [
        [ "tree< T, tree_node_allocator >::fixed_depth_iterator", "classtree_1_1fixed__depth__iterator.html", null ],
        [ "tree< T, tree_node_allocator >::post_order_iterator", "classtree_1_1post__order__iterator.html", null ],
        [ "tree< T, tree_node_allocator >::pre_order_iterator", "classtree_1_1pre__order__iterator.html", null ],
        [ "tree< T, tree_node_allocator >::sibling_iterator", "classtree_1_1sibling__iterator.html", null ]
      ] ],
      [ "tree< T, tree_node_allocator >::iterator_base_less", "classtree_1_1iterator__base__less.html", null ],
      [ "LibofxContext", "classLibofxContext.html", null ],
      [ "LibofxFileFormatInfo", "structLibofxFileFormatInfo.html", null ],
      [ "OFCApplication", "classOFCApplication.html", null ],
      [ "OfxAccountData", "structOfxAccountData.html", null ],
      [ "OfxAggregate", "classOfxAggregate.html", [
        [ "OfxRequest", "classOfxRequest.html", [
          [ "OfxAccountInfoRequest", "classOfxAccountInfoRequest.html", null ],
          [ "OfxPaymentRequest", "classOfxPaymentRequest.html", null ],
          [ "OfxStatementRequest", "classOfxStatementRequest.html", null ]
        ] ]
      ] ],
      [ "OFXApplication", "classOFXApplication.html", null ],
      [ "OfxCurrency", "structOfxCurrency.html", null ],
      [ "OfxFiLogin", "structOfxFiLogin.html", null ],
      [ "OfxFiServiceInfo", "structOfxFiServiceInfo.html", null ],
      [ "OfxGenericContainer", "classOfxGenericContainer.html", [
        [ "OfxAccountContainer", "classOfxAccountContainer.html", null ],
        [ "OfxBalanceContainer", "classOfxBalanceContainer.html", null ],
        [ "OfxDummyContainer", "classOfxDummyContainer.html", null ],
        [ "OfxMainContainer", "classOfxMainContainer.html", null ],
        [ "OfxPushUpContainer", "classOfxPushUpContainer.html", null ],
        [ "OfxSecurityContainer", "classOfxSecurityContainer.html", null ],
        [ "OfxStatementContainer", "classOfxStatementContainer.html", null ],
        [ "OfxStatusContainer", "classOfxStatusContainer.html", null ],
        [ "OfxTransactionContainer", "classOfxTransactionContainer.html", [
          [ "OfxBankTransactionContainer", "classOfxBankTransactionContainer.html", null ],
          [ "OfxInvestmentTransactionContainer", "classOfxInvestmentTransactionContainer.html", null ]
        ] ]
      ] ],
      [ "OfxPayee", "structOfxPayee.html", null ],
      [ "OfxPayment", "structOfxPayment.html", null ],
      [ "OfxSecurityData", "structOfxSecurityData.html", null ],
      [ "OfxStatementData", "structOfxStatementData.html", null ],
      [ "OfxStatusData", "structOfxStatusData.html", null ],
      [ "OfxTransactionData", "structOfxTransactionData.html", null ],
      [ "option", "structoption.html", null ],
      [ "tree< T, tree_node_allocator >", "classtree.html", null ],
      [ "tree_node_< T >", "classtree__node__.html", null ]
    ] ],
    [ "Data Fields", "functions.html", null ],
    [ "Namespace List", "namespaces.html", [
      [ "kp", "namespacekp.html", null ]
    ] ],
    [ "File List", "files.html", [
      [ "ofxconnect/cmdline.c", null, null ],
      [ "ofxdump/cmdline.c", null, null ],
      [ "ofxconnect/cmdline.h", null, null ],
      [ "ofxdump/cmdline.h", null, null ],
      [ "config.h", null, null ],
      [ "context.cpp", null, null ],
      [ "context.hh", null, null ],
      [ "file_preproc.cpp", "file__preproc_8cpp.html", null ],
      [ "file_preproc.hh", "file__preproc_8hh.html", null ],
      [ "getopt.c", null, null ],
      [ "getopt1.c", null, null ],
      [ "gnugetopt.h", null, null ],
      [ "inc/libofx.h", "inc_2libofx_8h.html", null ],
      [ "libofx-0.9.7/inc/libofx.h", "libofx-0_89_87_2inc_2libofx_8h.html", null ],
      [ "messages.cpp", "messages_8cpp.html", null ],
      [ "messages.hh", "messages_8hh.html", null ],
      [ "ofc_sgml.cpp", "ofc__sgml_8cpp.html", null ],
      [ "ofc_sgml.hh", "ofc__sgml_8hh.html", null ],
      [ "ofx_aggregate.hh", "ofx__aggregate_8hh.html", null ],
      [ "ofx_container_account.cpp", "ofx__container__account_8cpp.html", null ],
      [ "ofx_container_generic.cpp", "ofx__container__generic_8cpp.html", null ],
      [ "ofx_container_main.cpp", "ofx__container__main_8cpp.html", null ],
      [ "ofx_container_security.cpp", "ofx__container__security_8cpp.html", null ],
      [ "ofx_container_statement.cpp", "ofx__container__statement_8cpp.html", null ],
      [ "ofx_container_transaction.cpp", "ofx__container__transaction_8cpp.html", null ],
      [ "ofx_containers.hh", "ofx__containers_8hh.html", null ],
      [ "ofx_containers_misc.cpp", "ofx__containers__misc_8cpp.html", null ],
      [ "ofx_error_msg.hh", "ofx__error__msg_8hh.html", null ],
      [ "ofx_preproc.cpp", "ofx__preproc_8cpp.html", null ],
      [ "ofx_preproc.hh", "ofx__preproc_8hh.html", null ],
      [ "ofx_request.cpp", "ofx__request_8cpp.html", null ],
      [ "ofx_request.hh", "ofx__request_8hh.html", null ],
      [ "ofx_request_accountinfo.cpp", "ofx__request__accountinfo_8cpp.html", null ],
      [ "ofx_request_accountinfo.hh", "ofx__request__accountinfo_8hh.html", null ],
      [ "ofx_request_statement.cpp", "ofx__request__statement_8cpp.html", null ],
      [ "ofx_request_statement.hh", "ofx__request__statement_8hh.html", null ],
      [ "ofx_sgml.cpp", "ofx__sgml_8cpp.html", null ],
      [ "ofx_sgml.hh", "ofx__sgml_8hh.html", null ],
      [ "ofx_utilities.cpp", "ofx__utilities_8cpp.html", null ],
      [ "ofx_utilities.hh", "ofx__utilities_8hh.html", null ],
      [ "tree.hh", null, null ],
      [ "win32.cpp", null, null ],
      [ "win32.hh", null, null ]
    ] ],
    [ "Globals", "globals.html", null ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

