require File.join(File.dirname(File.expand_path(__FILE__)), "spec_helper")

describe "Sequel::Plugins::ErrorSplitter" do
  before do
    @c = Class.new(Sequel::Model)
    @c.plugin :error_splitter
    @m = @c.new
    def @m.validate
      errors.add([:a, :b], 'is bad')
    end
  end

  it "should split errors for multiple columns and assign them to each column" do
    @m.valid?.should == false
    @m.errors.should == {:a=>['is bad'], :b=>['is bad']}
  end
end

