# SCHEMA

The schema for the SQL version of Chef server is found in:

pgsql_schema.sql

The schema in these files is used by the Chef installer to setup the database. It is also presented for easy reference.

# LOADING THE SCHEMA

The Chef installer will take the necessary steps to load the schema, but the schema can be loaded manually by feeding the approriate file to the appropriate database command line tool through psql.

To load the schema manually, a database and user will need to be setup for Chef's use.

While loading the schema into Postgres the following error might be encountered:

ERROR:  must be owner of extension plpgsql

This error can be safely ignored.

# SCHEMA FILE GENERATION

The pgsql_schema.sql file was generated by running this command against a functioning Postgres database with the Chef Schema loaded:

pg_dump --userername=opscode_chef --schema-only --no-owner --no-acl -f pgsql_schema.sql opscode_chef

Note that depending on settings the database and or username are subject to be different.

# LICENSE

Copyright 2011-2012 Opscode, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the specific language governing permissions and limitations under the License.
