SET(SD_DATADIR_ABS "/usr/local/share/speed-dreams-2")
              SET(SD_LOCALDIR "~/.speed-dreams-2")
            SET(SD_LIBDIR_ABS "/usr/local/lib/speed-dreams-2")
            SET(SD_BINDIR_ABS "/usr/local/bin")
            SET(SD_INCLUDEDIR_ABS "/usr/local/include/speed-dreams-2")
               SET(IN_SOURCETREE FALSE)

############################################################################
#
#   file        : macros.cmake
#   copyright   : (C) 2008 by Mart Kelder
#   web         : www.speed-dreams.org 
#   version     : $Id: macros.cmake 4539 2012-02-26 13:00:58Z pouillot $
#
############################################################################

############################################################################
#                                                                          #
#   This program is free software you can redistribute it and/or modify   #
#   it under the terms of the GNU General Public License as published by   #
#   the Free Software Foundation either version 2 of the License, or      #
#   (at your option) any later version.                                    #
#                                                                          #
############################################################################

# @file     Main CMake configuration file
# @author   Mart Kelder
# @version  $Id: macros.cmake 4539 2012-02-26 13:00:58Z pouillot $

#MESSAGE(STATUS "Processing ${CMAKE_CURRENT_SOURCE_DIR} ...")

# By default, we assume an "in-source" build.
IF(NOT DEFINED IN_SOURCETREE)
  SET(IN_SOURCETREE TRUE)
ENDIF(NOT DEFINED IN_SOURCETREE)

# Setup the install prefix.
IF(CMAKE_INSTALL_PREFIX_INITIALIZED_TO_DEFAULT)
  IF(WIN32)
    SET(CMAKE_INSTALL_PREFIX "C:/Program files/speed-dreams-2" CACHE PATH "Prefix prepended to install directories" FORCE)
  ELSE(WIN32)
    SET(CMAKE_INSTALL_PREFIX "/usr/local" CACHE PATH "Prefix prepended to install directories" FORCE)
  ENDIF(WIN32)
ENDIF(CMAKE_INSTALL_PREFIX_INITIALIZED_TO_DEFAULT)

# Determine the source folder if ???
IF(NOT SOURCE_DIR AND IN_SOURCETREE)
  FIND_PATH(SOURCE_CMAKE_PATH cmake/macros.cmake PATHS . .. ../.. ../../.. ../../../.. ../../../../.. ../../../../../.. ../../../../../../.. ../../../../../../../.. ${CMAKE_SOURCE_DIR} NO_DEFAULT_PATH)
  FIND_PATH(SOURCE_CMAKE_PATH cmake/macros.cmake PATHS . .. ../.. ../../.. ../../../.. ../../../../.. ../../../../../.. ../../../../../../.. ../../../../../../../.. ${CMAKE_SOURCE_DIR})
  GET_FILENAME_COMPONENT(SOURCE_DIR ${SOURCE_CMAKE_PATH} ABSOLUTE CACHE)
  MARK_AS_ADVANCED(SOURCE_DIR)
  SET(SOURCE_CMAKE_PATH "")
  MARK_AS_ADVANCED(SOURCE_CMAKE_PATH)
ENDIF(NOT SOURCE_DIR AND IN_SOURCETREE)

# The path of the folder of the current CMakeLists.txt
GET_FILENAME_COMPONENT(CURRENT_LIST_FILE_PATH ${CMAKE_CURRENT_LIST_FILE} PATH)

# Macros arg list parsing tools.
IF(NOT _ALREADY_DONE)
  INCLUDE(${CURRENT_LIST_FILE_PATH}/split_argn.cmake)
ENDIF(NOT _ALREADY_DONE)

# Include dir for config.h
IF(IN_SOURCETREE)
  FIND_PATH(CONFIGH_INCLUDE_DIR config.h PATHS ${SOURCE_DIR} ${CMAKE_BINARY_DIR} NO_DEFAULT_PATH)
  FIND_PATH(CONFIGH_INCLUDE_DIR config.h PATHS ${SOURCE_DIR} ${CMAKE_BINARY_DIR})
  MARK_AS_ADVANCED(CONFIGH_INCLUDE_DIR)
  IF(CONFIGH_INCLUDE_DIR)
    SET(HAVE_CONFIG_H TRUE)
  ELSE(CONFIGH_INCLUDE_DIR)
    SET(HAVE_CONFIG_H FALSE)
  ENDIF(CONFIGH_INCLUDE_DIR)
ELSE(IN_SOURCETREE)
  SET(HAVE_CONFIG_H FALSE)
ENDIF(IN_SOURCETREE)

# Determine the default value of the user settings folder.
IF(WIN32)
  SET(SD_LOCALDIR "~/speed-dreams-2.settings" CACHE DOC "Where the user settings files should go")
ELSE(WIN32) #UNIX
  SET(SD_LOCALDIR "~/.speed-dreams-2" CACHE DOC "Where the user settings files should go")
ENDIF(WIN32)
MARK_AS_ADVANCED(SD_LOCALDIR)

# Determine the default value of the tools executable file prefix.
SET(SD_TOOLS_EXECPREFIX "sd2-" CACHE DOC "Prefix for the tools executable names")
MARK_AS_ADVANCED(SD_TOOLS_EXECPREFIX)

# Determine the default value of the data, bin and lib (and man) folders.
IF(IN_SOURCETREE)
  SET(_DEFLIBDIR "lib")
  IF(WIN32)
    SET(SD_BINDIR bin CACHE PATH "Place where the executables should go")
    SET(SD_DATADIR data CACHE PATH "Place where all the static data files should go")
    SET(SD_LIBDIR ${_DEFLIBDIR} CACHE PATH "Place where the libraries should go")
    SET(SD_INCLUDEDIR include CACHE PATH "Place where the include files should go")
  ELSE(WIN32) #UNIX
    SET(SD_BINDIR bin CACHE PATH "Place where the executables should go")
    SET(SD_DATADIR share/speed-dreams-2 CACHE PATH "Place where all the static data files should go")
    SET(SD_LIBDIR ${_DEFLIBDIR}/speed-dreams-2 CACHE PATH "Place where the libraries should go")
    SET(SD_INCLUDEDIR include/speed-dreams-2 CACHE PATH "Place where the include files should go")
    SET(SD_MANDIR man CACHE PATH "Place where the manual pages should go")
  ENDIF(WIN32)
  MARK_AS_ADVANCED(SD_BINDIR)
  MARK_AS_ADVANCED(SD_DATADIR)
  MARK_AS_ADVANCED(SD_LIBDIR)
  MARK_AS_ADVANCED(SD_INCLUDEDIR)
  IF(UNIX)
    MARK_AS_ADVANCED(SD_MANDIR)
  ENDIF(UNIX)
ELSE(IN_SOURCETREE)
  SET(SD_DATADIR ${SD_DATADIR_ABS})
  SET(SD_LIBDIR ${SD_LIBDIR_ABS})
  SET(SD_BINDIR ${SD_BINDIR_ABS})
  SET(SD_INCLUDEDIR ${SD_INCLUDEDIR_ABS})
  IF(UNIX)
    SET(SD_MANDIR ${SD_MANDIR_ABS})
  ENDIF(UNIX)
ENDIF(IN_SOURCETREE)

# Determine the aboslute paths of the data, bin and lib (and man) folders.
IF(IS_ABSOLUTE ${SD_DATADIR})
  GET_FILENAME_COMPONENT(SD_DATADIR_ABS ${SD_DATADIR} ABSOLUTE)
ELSE(IS_ABSOLUTE ${SD_DATADIR})
  GET_FILENAME_COMPONENT(SD_DATADIR_ABS ${CMAKE_INSTALL_PREFIX}/${SD_DATADIR} ABSOLUTE)
ENDIF(IS_ABSOLUTE ${SD_DATADIR})

IF(IS_ABSOLUTE ${SD_LIBDIR})
  GET_FILENAME_COMPONENT(SD_LIBDIR_ABS ${SD_LIBDIR} ABSOLUTE)
ELSE(IS_ABSOLUTE ${SD_LIBDIR})
  GET_FILENAME_COMPONENT(SD_LIBDIR_ABS ${CMAKE_INSTALL_PREFIX}/${SD_LIBDIR} ABSOLUTE)
ENDIF(IS_ABSOLUTE ${SD_LIBDIR})

IF(IS_ABSOLUTE ${SD_BINDIR})
  GET_FILENAME_COMPONENT(SD_BINDIR_ABS ${SD_BINDIR} ABSOLUTE)
ELSE(IS_ABSOLUTE ${SD_BINDIR})
  GET_FILENAME_COMPONENT(SD_BINDIR_ABS ${CMAKE_INSTALL_PREFIX}/${SD_BINDIR} ABSOLUTE)
ENDIF(IS_ABSOLUTE ${SD_BINDIR})

IF(IS_ABSOLUTE ${SD_INCLUDEDIR})
  GET_FILENAME_COMPONENT(SD_INCLUDEDIR_ABS ${SD_INCLUDEDIR} ABSOLUTE)
ELSE(IS_ABSOLUTE ${SD_INCLUDEDIR})
  GET_FILENAME_COMPONENT(SD_INCLUDEDIR_ABS ${CMAKE_INSTALL_PREFIX}/${SD_INCLUDEDIR} ABSOLUTE)
ENDIF(IS_ABSOLUTE ${SD_INCLUDEDIR})

IF(UNIX)
  IF(IS_ABSOLUTE ${SD_MANDIR})
    GET_FILENAME_COMPONENT(SD_MANDIR_ABS ${SD_MANDIR} ABSOLUTE)
  ELSE(IS_ABSOLUTE ${SD_MANDIR})
    GET_FILENAME_COMPONENT(SD_MANDIR_ABS ${CMAKE_INSTALL_PREFIX}/${SD_MANDIR} ABSOLUTE)
  ENDIF(IS_ABSOLUTE ${SD_MANDIR})
ENDIF(UNIX)

STRING(REGEX REPLACE "^(.*[^/])/*$" "\\1" SD_LOCALDIR_TMP ${SD_LOCALDIR})
SET(SD_LOCALDIR ${SD_LOCALDIR_TMP})

SET(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} ${CURRENT_LIST_FILE_PATH})
SET(CMAKE_INSTALL_RPATH "${SD_LIBDIR_ABS}/lib")

# Robot .def file generation for Windows
#  ROBOTNAME  : Name of the robot
#  DEF_FILE  : Target .def file  path-name
#  Other args  : Robot DLL Interface description, as a list of names of exported symbols,
#                 but with keywords shortcuts :
#                 - if empty, assumed keyword "LEGACY_MIN"
#                 - if "LEGACY_MIN", means the smallest legacy scheme interface  (TORCS style)
#                                    with only "${NAME}" exported
#                 - if "LEGACY", means the  complete legacy scheme interface,
#                                with "${NAME}" and "${NAME}Shut" exported
#                 - if "WELCOME", means the complete new scheme interface (Speed Dreams style),
#                                 with "moduleWelcome", "moduleInitialize" and "moduleTerminate"
#                                 exported
#                 - may be a list of above keywords for multi-scheme interface
#                 - may also be the raw list of symbols to export
MACRO(GENERATE_ROBOT_DEF_FILE ROBOTNAME DEF_FILE)

  # Build the real list of exported symbols from the given one (that may include shortcuts)
  #MESSAGE(STATUS "Generating ${DEF_FILE} for ${ROBOTNAME} robot")
  SET(SYMBOLS) # Initialize the list
  FOREACH(KEYSYM ${ARGN})
    IF(KEYSYM STREQUAL "LEGACY_MIN")
      LIST(APPEND SYMBOLS ${ROBOTNAME})
    ELSEIF(KEYSYM STREQUAL "LEGACY")
      LIST(APPEND SYMBOLS ${ROBOTNAME})
      LIST(APPEND SYMBOLS "${ROBOTNAME}Shut")
    ELSEIF(KEYSYM STREQUAL "WELCOME")
      LIST(APPEND SYMBOLS moduleWelcome moduleInitialize moduleTerminate)
    ELSE(KEYSYM STREQUAL "LEGACY_MIN")
      LIST(APPEND SYMBOLS ${KEYSYM})
    ENDIF(KEYSYM STREQUAL "LEGACY_MIN")
  ENDFOREACH(KEYSYM ${ARGN})

  # Clean duplicates
  LIST(REMOVE_DUPLICATES SYMBOLS)

  #MESSAGE(STATUS "Symbols: ${SYMBOLS}")

  # Build an acceptable string for the .def file from this symbol list
  SET(ROBOTSYMBOLS "")
  FOREACH(SYMBOL ${SYMBOLS})
    SET(ROBOTSYMBOLS "${ROBOTSYMBOLS}\n\t${SYMBOL}")
  ENDFOREACH(SYMBOL ${SYMBOLS})

  # Generate the .def file
  IF(IN_SOURCETREE)
    CONFIGURE_FILE(${SOURCE_DIR}/cmake/robot_def.cmake ${DEF_FILE})
  ELSE(IN_SOURCETREE)
    CONFIGURE_FILE(${SD_DATADIR_ABS}/cmake/robot_def.cmake ${DEF_FILE})
  ENDIF(IN_SOURCETREE)

ENDMACRO(GENERATE_ROBOT_DEF_FILE ROBOTNAME DEF_FILE)

# Robot project definition (module build and install, without associated data)
# Args:
#  NAME       : Name of the robot
#  INTERFACE  : Robot Windows DLL Interface description (tells about exported symbols)
#                 See GENERATE_ROBOT_DEF_FILE macro.
#                 If not specified, defaults to "LEGACY_MIN"  not used if MODULE used
#  SOURCES    : List of files to use as build sources if any  not needed if MODULE used
#  CLONENAMES : The names of the clones to generate
#  VERSION    : The VERSION of the libraries to produce (robot and its clones) (def: $VERSION).
#  SOVERSION  : The SOVERSION of the libraries to produce (in the ldconfig meaning) (def: 0.0.0).
#               WARNING: Not taken into account for the moment : might not work with GCC 4.5 or +.
#
# Example:
#    ROBOT_MODULE(NAME simplix VERSION 3.0.5 SOVERSION 0.0.0
#                 INTERFACE LEGACY WELCOME simplix_trb1 simplix_ls1 simplix_36GP
#                 SOURCES simplix.cpp ...
#                 CLONENAMES simplix_trb1 simplix_ls1 simplix_36GP)
MACRO(ROBOT_MODULE)

  SET(RBM_SYNTAX "NAME,1,1,RBM_HAS_NAME,RBM_NAME")
  SET(RBM_SYNTAX ${RBM_SYNTAX} "VERSION,0,1,RBM_HAS_VERSION,RBM_VERSION")
  SET(RBM_SYNTAX ${RBM_SYNTAX} "SOVERSION,0,1,RBM_HAS_SOVERSION,RBM_SOVERSION")
  SET(RBM_SYNTAX ${RBM_SYNTAX} "INTERFACE,0,-1,RBM_HAS_INTERFACE,RBM_INTERFACE")
  SET(RBM_SYNTAX ${RBM_SYNTAX} "SOURCES,0,-1,RBM_HAS_SOURCES,RBM_SOURCES")
  SET(RBM_SYNTAX ${RBM_SYNTAX} "CLONENAMES,0,-1,RBM_HAS_CLONENAMES,RBM_CLONENAMES")

  SPLIT_ARGN(${RBM_SYNTAX} ARGUMENTS ${ARGN})

  IF(NOT RBM_HAS_NAME OR NOT RBM_NAME)
    MESSAGE(FATAL_ERROR "Cannot build a robot module with no specified name")
  ENDIF()
  IF(NOT RBM_HAS_SOURCES OR NOT RBM_SOURCES)
    MESSAGE(FATAL_ERROR "Cannot build a robot module without sources / module to copy")
  ENDIF()
  IF(NOT RBM_HAS_VERSION OR NOT RBM_VERSION)
    SET(RBM_VERSION ${VERSION})
    MESSAGE(STATUS "No version specified for robot module ${RBM_NAME}  using ${RBM_VERSION}")
  ENDIF()
  IF(NOT RBM_HAS_SOVERSION OR NOT RBM_SOVERSION)
    IF(UNIX)
      SET(RBM_SOVERSION 0.0.0)
      MESSAGE(STATUS "No so-version specified for robot module ${RBM_NAME}  using ${RBM_SOVERSION}")
    ENDIF()
  ENDIF()

  PROJECT("robot_${RBM_NAME}")

  ADD_INTERFACE_INCLUDEDIR()
  ADD_SDLIB_INCLUDEDIR(learning math portability robottools tgf)
  ADD_PLIB_INCLUDEDIR()

  # Generate / add .def file for Windows
  IF(WIN32)
    IF(NOT RBM_HAS_INTERFACE OR NOT RBM_INTERFACE)
      SET(RBM_INTERFACE "LEGACY_MIN")
    ENDIF()
    SET(ROBOT_DEF_FILE ${CMAKE_CURRENT_BINARY_DIR}/${RBM_NAME}_gen.def)
    GENERATE_ROBOT_DEF_FILE(${RBM_NAME} ${ROBOT_DEF_FILE} ${RBM_INTERFACE})
    SET(RBM_SOURCES ${RBM_SOURCES} ${ROBOT_DEF_FILE})
  ENDIF(WIN32)

  # Disable developer warning
  IF (COMMAND cmake_policy)
    CMAKE_POLICY(SET CMP0003 NEW)
  ENDIF(COMMAND cmake_policy)

  # Ignore some run-time libs to avoid MSVC link-time warnings and sometimes even crashes.
  IF(MSVC)
      SET(CMAKE_SHARED_LINKER_FLAGS_DEBUG "${CMAKE_SHARED_LINKER_FLAGS_DEBUG} /NODEFAULTLIB:msvcrt.lib")
  ENDIF(MSVC)

  # The robot module is actually a shared library.
  ADD_LIBRARY(${RBM_NAME} SHARED ${RBM_SOURCES})

  # Customize shared library versions and file prefix.
  IF(UNIX) # Use ldconfig version naming scheme + no "lib" prefix under Linux
    SET_TARGET_PROPERTIES(${RBM_NAME} PROPERTIES PREFIX "") 
    # Might not work with GCC 4.5 or + (non-robot modules crash at 1st reload = after 1 dlclose) 
    #SET_TARGET_PROPERTIES(${RBM_NAME} PROPERTIES VERSION ${RBM_VERSION})
    #SET_TARGET_PROPERTIES(${RBM_NAME} PROPERTIES SOVERSION ${RBM_SOVERSION})
  ELSE()
    SET_TARGET_PROPERTIES(${RBM_NAME} PROPERTIES VERSION ${RBM_VERSION})
  ENDIF()

  # Link/Run-time dependencies
  ADD_PLIB_LIBRARY(${RBM_NAME} sg)
  ADD_SDLIB_LIBRARY(${RBM_NAME} robottools)

  # Install target robot module shared library
  SD_INSTALL_FILES(LIB drivers/${RBM_NAME} TARGETS ${RBM_NAME})

  # Install clone robot modules shared libraries (use ldconfig version naming scheme under Linux)
  IF(RBM_HAS_CLONENAMES AND RBM_CLONENAMES)
    GET_TARGET_PROPERTY(MODLOC ${RBM_NAME} LOCATION)
    FOREACH(CLONENAME ${RBM_CLONENAMES})
      SET(CLONE_MODLOC ${CLONENAME}${CMAKE_SHARED_LIBRARY_SUFFIX})
      IF(FALSE)
      #IF(UNIX)
	# Might not work with GCC 4.5 or + (see above) 
        ADD_CUSTOM_COMMAND(TARGET ${RBM_NAME} POST_BUILD
                           COMMAND ${CMAKE_COMMAND} -E copy ${MODLOC} ${CLONE_MODLOC}.${RBM_VERSION})
        ADD_CUSTOM_COMMAND(TARGET ${RBM_NAME} POST_BUILD
                           COMMAND ${CMAKE_COMMAND} -E create_symlink ${CLONE_MODLOC}.${RBM_VERSION} ${CLONE_MODLOC}.${RBM_SOVERSION}
                           COMMAND ${CMAKE_COMMAND} -E create_symlink ${CLONE_MODLOC}.${RBM_SOVERSION} ${CLONE_MODLOC})
        SD_INSTALL_FILES(LIB drivers/${CLONENAME} PREFIX ${CMAKE_CURRENT_BINARY_DIR}
                         FILES ${CLONE_MODLOC} ${CLONE_MODLOC}.${RBM_SOVERSION} ${CLONE_MODLOC}.${RBM_VERSION} )
      ELSE()
        ADD_CUSTOM_COMMAND(TARGET ${RBM_NAME} POST_BUILD
                           COMMAND ${CMAKE_COMMAND} -E copy ${MODLOC} ${CLONE_MODLOC})
        SD_INSTALL_FILES(LIB drivers/${CLONENAME} PREFIX ${CMAKE_CURRENT_BINARY_DIR}
                         FILES ${CLONE_MODLOC})
      ENDIF()
    ENDFOREACH(CLONENAME ${RBM_CLONENAMES})
  ENDIF()

ENDMACRO(ROBOT_MODULE)

# Robot data installation
# Args:
#  NAME     : Name of the robot (may be a clone)
#  PREFIX   : Prefix to use to get source path for files/subdirs specified in FILES/SUBDIRS
#  FILES    : Files to install in the robot's data dir (see PREFIX)
#  SUBDIRS  : Sub-dirs to recusively install in the robot's data dir (see PREFIX)
#  PATTERNS : Files to install from SUBDIRS in the robot's data dir, 
#             as glob patterns (defaults to *.*)
#  USER     : If this keyword is present, also mark _any_ above specified XML file
#             as a user settings file (installed at run-time is the user settings folders).
#  
MACRO(ROBOT_DATA)

  SET(RBD_SYNTAX "NAME,1,1,RBD_HAS_NAME,RBD_NAME")
  SET(RBD_SYNTAX ${RBD_SYNTAX} "PREFIX,0,1,RBD_HAS_PREFIX,RBD_PREFIX")
  SET(RBD_SYNTAX ${RBD_SYNTAX} "FILES,0,-1,RBD_HAS_FILES,RBD_FILES")
  SET(RBD_SYNTAX ${RBD_SYNTAX} "SUBDIRS,0,-1,RBD_HAS_SUBDIRS,RBD_SUBDIRS")
  SET(RBD_SYNTAX ${RBD_SYNTAX} "PATTERNS,0,-1,RBD_HAS_PATTERNS,RBD_PATTERNS")
  SET(RBD_SYNTAX ${RBD_SYNTAX} "USER,0,0,RBD_IS_USER,_")

  SPLIT_ARGN(${RBD_SYNTAX} ARGUMENTS ${ARGN})

  #MESSAGE(STATUS "ROBOT_DATA(${RBD_NAME}): PREFIX=${RBD_PREFIX} FILES=${RBD_FILES} PATTERNS=${RBD_PATTERNS} SUBDIRS=${RBD_SUBDIRS} USER=${RBD_IS_USER}")

  # Check arguments syntax / values
  IF(NOT RBD_HAS_NAME OR NOT RBD_NAME)
    MESSAGE(FATAL_ERROR "Cannot install data for a robot module with no specified name")
  ENDIF()

  # Install specified files.
  IF(RBD_HAS_FILES AND RBD_FILES)

    IF(RBD_IS_USER)
      SD_INSTALL_FILES(DATA drivers/${RBD_NAME} USER drivers/${RBD_NAME} 
                PREFIX ${RBD_PREFIX} FILES ${RBD_FILES})
    ELSE()
      SD_INSTALL_FILES(DATA drivers/${RBD_NAME} 
                  PREFIX ${RBD_PREFIX} FILES ${RBD_FILES})
    ENDIF()

  ENDIF()

  # Install subdirs if specified.
  IF(RBD_HAS_SUBDIRS AND RBD_SUBDIRS)

    # Install specified files.
    IF(RBD_IS_USER)
      SD_INSTALL_DIRECTORIES(DATA drivers/${RBD_NAME} USER drivers/${RBD_NAME} 
                                    PREFIX ${RBD_PREFIX} DIRECTORIES ${RBD_SUBDIRS} 
                                 PATTERNS ${RBD_PATTERNS})
    ELSE()
      SD_INSTALL_DIRECTORIES(DATA drivers/${RBD_NAME} 
                                   PREFIX ${RBD_PREFIX} DIRECTORIES ${RBD_SUBDIRS} 
                                    PATTERNS ${RBD_PATTERNS})
    ENDIF()

  ENDIF(RBD_HAS_SUBDIRS AND RBD_SUBDIRS)

ENDMACRO(ROBOT_DATA)

# Robot project definition (module build and install, with associated data)
# Args:
#  NAME    : Name of the robot
#  INTERFACE  : Robot Windows DLL Interface description (tells about exported symbols)
#                 See GENERATE_ROBOT_DEF_FILE macro.
#                 If not specified, defaults to "LEGACY_MIN"  not used if MODULE used
#  SOURCES  : List of files to use as build sources if any  not needed if MODULE used
#  PREFIX  : Dir. prefix for source files/subdirs to install in the robot's data dir
#  FILES  : Extra (non default) files to install in the robot's data dir
#  SUBDIRS  : Data subdirectories to install in the robot's data dir
MACRO(ROBOT)

  SET(RB_SYNTAX "NAME,1,1,RB_HAS_NAME,RB_NAME")
  SET(RB_SYNTAX ${RB_SYNTAX} "INTERFACE,0,-1,RB_HAS_INTERFACE,RB_INTERFACE")
  SET(RB_SYNTAX ${RB_SYNTAX} "SOURCES,0,-1,RB_HAS_SOURCES,RB_SOURCES")
  SET(RB_SYNTAX ${RB_SYNTAX} "PREFIX,0,-1,RB_HAS_PREFIX,RB_PREFIX")
  SET(RB_SYNTAX ${RB_SYNTAX} "FILES,0,-1,RB_HAS_FILES,RB_FILES")
  SET(RB_SYNTAX ${RB_SYNTAX} "SUBDIRS,0,-1,RB_HAS_SUBDIRS,RB_SUBDIRS")

  #SET(__DEBUG__ TRUE)
  SPLIT_ARGN(${RB_SYNTAX} ARGUMENTS ${ARGN})
  #SET(__DEBUG__ FALSE)

  #MESSAGE(STATUS "ROBOT(${RB_NAME}): INTERFACE=${RB_INTERFACE} (${RB_HAS_INTERFACE}) SOURCES=${RB_SOURCES} (${RB_HAS_SOURCES}) PREFIX=${RB_PREFIX} (${RB_HAS_PREFIX}) FILES=${RB_FILES} (${RB_HAS_FILES}) SUBDIRS=${RB_SUBDIRS} (${RB_HAS_SUBDIRS})")

  IF(NOT RB_HAS_NAME OR NOT RB_NAME)
    MESSAGE(FATAL_ERROR "Cannot build a robot with no specified name")
  ENDIF()

  IF(NOT RB_HAS_SOURCES OR NOT RB_SOURCES)
    MESSAGE(FATAL_ERROR "Cannot build a robot without sources")
  ENDIF()

  ROBOT_MODULE(NAME ${RB_NAME} INTERFACE ${RB_INTERFACE} SOURCES ${RB_SOURCES})

  ROBOT_DATA(NAME ${RB_NAME} PREFIX ${RB_PREFIX} FILES ${RB_FILES} SUBDIRS ${RB_SUBDIRS})

ENDMACRO(ROBOT)

MACRO(ADD_INTERFACE_INCLUDEDIR)

  IF(IN_SOURCETREE)
    SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/interfaces)
  ELSE(IN_SOURCETREE)
    SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
  ENDIF(IN_SOURCETREE)
  
  FIND_PATH(INTERFACE_INCLUDE_DIR raceman.h 
        PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
  FIND_PATH(INTERFACE_INCLUDE_DIR raceman.h 
        PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
  MARK_AS_ADVANCED(INTERFACE_INCLUDE_DIR)
  IF(INTERFACE_INCLUDE_DIR)
    INCLUDE_DIRECTORIES(${INTERFACE_INCLUDE_DIR})
  ELSE(INTERFACE_INCLUDE_DIR)
    MESSAGE(FATAL_ERROR "Cannot find interface header files")
  ENDIF(INTERFACE_INCLUDE_DIR)

ENDMACRO(ADD_INTERFACE_INCLUDEDIR)

MACRO(ADD_SDLIB_INCLUDEDIR)

  SET(SDLIB_OPTIONAL FALSE)
  FOREACH(SDLIB_LIB ${ARGN})
    IF(${SDLIB_LIB} STREQUAL "OPTIONAL")
      SET(SDLIB_OPTIONAL TRUE)
    ENDIF(${SDLIB_LIB} STREQUAL "OPTIONAL")
  ENDFOREACH(SDLIB_LIB ${ARGN})

  FOREACH(SDLIB_LIB ${ARGN})
    SET(SDLIB_FOUND_LIB TRUE)
    SET(SDLIB_EXTRA_INCLUDEDIR "")
    IF(SDLIB_LIB STREQUAL "portability")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/libs/portability)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_PORTABILITY_INCLUDE_DIR portability.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_PORTABILITY_INCLUDE_DIR portability.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
      MARK_AS_ADVANCED(SDLIB_PORTABILITY_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_PORTABILITY_INCLUDE_DIR)
    ELSEIF(SDLIB_LIB STREQUAL "tgf")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/libs/tgf)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_TGF_INCLUDE_DIR tgf.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_TGF_INCLUDE_DIR tgf.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
      MARK_AS_ADVANCED(SDLIB_TGF_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_TGF_INCLUDE_DIR)
    ELSEIF(SDLIB_LIB STREQUAL "tgfclient")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/libs/tgfclient)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_TGFCLIENT_INCLUDE_DIR tgfclient.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_TGFCLIENT_INCLUDE_DIR tgfclient.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
      MARK_AS_ADVANCED(SDLIB_TGFCLIENT_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_TGFCLIENT_INCLUDE_DIR)
    ELSEIF(SDLIB_LIB STREQUAL "tgfdata")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/libs/tgfdata)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_TGFDATA_INCLUDE_DIR tgfdata.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_TGFDATA_INCLUDE_DIR tgfdata.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
      MARK_AS_ADVANCED(SDLIB_TGFDATA_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_TGFDATA_INCLUDE_DIR)
    ELSEIF(SDLIB_LIB STREQUAL "math")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/libs/math)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_MATH_INCLUDE_DIR linalg_t.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include PATH_SUFFIXES "" math tmath NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_MATH_INCLUDE_DIR linalg_t.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include PATH_SUFFIXES "" math tmath)
      MARK_AS_ADVANCED(SDLIB_MATH_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_MATH_INCLUDE_DIR)
    ELSEIF(SDLIB_LIB STREQUAL "txml")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/libs/txml)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_TXML_INCLUDE_DIR xml.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_TXML_INCLUDE_DIR xml.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
      MARK_AS_ADVANCED(SDLIB_TXML_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_TXML_INCLUDE_DIR)
    ELSEIF(SDLIB_LIB STREQUAL "robottools")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/libs/robottools)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_ROBOTTOOLS_INCLUDE_DIR robottools.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_ROBOTTOOLS_INCLUDE_DIR robottools.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
      MARK_AS_ADVANCED(SDLIB_ROBOTTOOLS_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_ROBOTTOOLS_INCLUDE_DIR)
    ELSEIF(SDLIB_LIB STREQUAL "learning")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/libs/learning)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_LEARNING_INCLUDE_DIR learn_debug.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include PATH_SUFFIXES "" learning NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_LEARNING_INCLUDE_DIR learn_debug.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include PATH_SUFFIXES "" learning)
      MARK_AS_ADVANCED(SDLIB_LEARNING_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_LEARNING_INCLUDE_DIR)
    ELSEIF(SDLIB_LIB STREQUAL "networking")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/modules/networking)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_NETWORKING_INCLUDE_DIR network.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_NETWORKING_INCLUDE_DIR network.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
      MARK_AS_ADVANCED(SDLIB_NETWORKING_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_NETWORKING_INCLUDE_DIR)
    ELSEIF(SDLIB_LIB STREQUAL "raceengine")
      IF(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SOURCE_DIR}/src/libs/raceengine)
      ELSE(IN_SOURCETREE)
        SET(INCLUDE_CANDIDATE ${SD_INCLUDEDIR_ABS})
      ENDIF(IN_SOURCETREE)
      FIND_PATH(SDLIB_RACEENGINE_INCLUDE_DIR raceengine.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
      FIND_PATH(SDLIB_RACEENGINE_INCLUDE_DIR raceengine.h PATHS ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
      MARK_AS_ADVANCED(SDLIB_RACEENGINE_INCLUDE_DIR)
      SET(SDLIB_EXTRA_INCLUDEDIR SDLIB_RACEENGINE_INCLUDE_DIR)
    ELSE(SDLIB_LIB STREQUAL "portability")
      SET(SDLIB_FOUND_LIB FALSE)
      IF(NOT SDLIB_LIB STREQUAL "OPTIONAL")
        MESSAGE(WARNING ": ${SDLIB_LIB} is not a Speed Dreams library")
      ENDIF(NOT SDLIB_LIB STREQUAL "OPTIONAL")
    ENDIF(SDLIB_LIB STREQUAL "portability")
    IF(SDLIB_FOUND_LIB)
      IF(${SDLIB_EXTRA_INCLUDEDIR})
        SET(SDLIB_INCLUDE_DIRS ${SDLIB_INCLUDE_DIRS} ${${SDLIB_EXTRA_INCLUDEDIR}})
      ELSE(${SDLIB_EXTRA_INCLUDEDIR})
        IF(NOT SDLIB_OPTIONAL AND NOT SDLIB_LIB STREQUAL "OPTIONAL")
          MESSAGE(FATAL_ERROR "Cannot find ${SDLIB_LIB} library header files")
        ENDIF(NOT SDLIB_OPTIONAL AND NOT SDLIB_LIB STREQUAL "OPTIONAL")
      ENDIF(${SDLIB_EXTRA_INCLUDEDIR})
    ENDIF(SDLIB_FOUND_LIB)
  ENDFOREACH(SDLIB_LIB ${SDLIB_LIBS})

  INCLUDE_DIRECTORIES(${SDLIB_INCLUDE_DIRS})

ENDMACRO(ADD_SDLIB_INCLUDEDIR)

MACRO(ADD_SDLIB_LIBRARY TARGET)

  SET(SDLIB_OPTIONAL FALSE)
  SET(SDLIB_STATIC FALSE)
  SET(SDLIB_TARGET_SUFFIX "")
  FOREACH(SDLIB_LIB ${ARGN})
    IF(${SDLIB_LIB} STREQUAL "OPTIONAL")
      SET(SDLIB_OPTIONAL TRUE)
    ENDIF(${SDLIB_LIB} STREQUAL "OPTIONAL")
    IF(${SDLIB_LIB} STREQUAL "STATIC")
      SET(SDLIB_STATIC TRUE)
      SET(SDLIB_TARGET_SUFFIX "_static")
    ENDIF(${SDLIB_LIB} STREQUAL "STATIC")
  ENDFOREACH(SDLIB_LIB ${ARGN})

  FOREACH(SDLIB_LIB ${ARGN})
    SET(SDLIB_IGNORE TRUE)
    IF(NOT UNIX)
      SET(SDLIB_IGNORE FALSE)
    ELSEIF(NOT SDLIB_LIB STREQUAL "ssggraph" AND NOT SDLIB_LIB STREQUAL "track")
      SET(SDLIB_IGNORE FALSE)
    ENDIF(NOT UNIX)
    IF(SDLIB_LIB STREQUAL "OPTIONAL" OR SDLIB_LIB STREQUAL "STATIC")
      SET(SDLIB_IGNORE TRUE) #Ignore: not a real target
    ENDIF(SDLIB_LIB STREQUAL "OPTIONAL" OR SDLIB_LIB STREQUAL "STATIC")

    IF(NOT SDLIB_IGNORE)
      SET(SDLIB_FOUND_LIB TRUE)
      SET(SDLIB_EXTRA_LIBRARY "")
      #Use IF(TARGET ${SDLIB_LIB}) from CMake 2.6
      GET_TARGET_PROPERTY(SDLIB_TARGET_LOCATION ${SDLIB_LIB}${SDLIB_TARGET_SUFFIX} LOCATION)
      IF(NOT SDLIB_TARGET_LOCATION STREQUAL "NOTFOUND")
        SET(SDLIB_LIBRARIES ${SDLIB_LIBRARIES} ${SDLIB_LIB}${SDLIB_TARGET_SUFFIX})
      ELSE(NOT SDLIB_TARGET_LOCATION STREQUAL "NOTFOUND")
        MESSAGE(WARNING "Warning: didn't found target ${SDLIB_LIB}")
        IF(SDLIB_LIB STREQUAL "tgf")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/libs/tgf)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_TGF_LIBRARY tgf${SDLIB_TARGET_SUFFIX} PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib
                       PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_TGF_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "tgfclient")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/libs/tgfclient)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_TGFCLIENT_LIBRARY tgfclient PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_TGFCLIENT_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "tgfdata")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/libs/tgfdata)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_TGFDATA_LIBRARY tgfdata PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_TGFDATA_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "txml")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/libs/txml)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_TXML_LIBRARY txml${SDLIB_TARGET_SUFFIX} PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib
                       PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_TXML_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "robottools")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/libs/robottools)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_ROBOTTOOLS_LIBRARY robottools PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_ROBOTTOOLS_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "learning")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/libs/learning)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_LEARNING_LIBRARY learning PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_LEARNING_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "networking")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/modules/networking)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_NETWORKING_LIBRARY networking PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_NETWORKING_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "raceengine")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/libs/raceengine)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_RACEENGINE_LIBRARY raceengine PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_RACEENGINE_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "legacymenu")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/modules/userinterface/legacymenu)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_LEGACYMENU_LIBRARY legacymenu ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_LEGACYMENU_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "ssggraph")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/modules/graphic/ssggraph)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_SSGGRAPH_LIBRARY ssggraph PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_SSGGRAPH_LIBRARY)
        ELSEIF(SDLIB_LIB STREQUAL "track")
          IF(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SOURCE_DIR}/src/modules/track)
          ELSE(IN_SOURCETREE)
            SET(LIBRARY_CANDIDATE ${SD_LIBDIR_ABS})
          ENDIF(IN_SOURCETREE)
          FIND_LIBRARY(SDLIB_TRACK_LIBRARY track PATHS ${LIBRARY_CANDIDATE} /usr/lib /usr/local/lib PATH_SUFFIXES "" lib)
          SET(SDLIB_EXTRA_LIBRARY SDLIB_TRACK_LIBRARY)
        ELSE(SDLIB_LIB STREQUAL "tgf")
          SET(SDLIB_FOUND_LIB FALSE)
          IF(NOT SDLIB_LIB STREQUAL "OPTIONAL" AND NOT SDLIB_LIB STREQUAL "STATIC")
            MESSAGE(WARNING ": ${SDLIB_LIB} is not a Speed Dreams library")
          ENDIF(NOT SDLIB_LIB STREQUAL "OPTIONAL" AND NOT SDLIB_LIB STREQUAL "STATIC")
        ENDIF(SDLIB_LIB STREQUAL "tgf")
        IF(SDLIB_FOUND_LIB)
          IF(${SDLIB_EXTRA_LIBRARY})
            SET(SDLIB_LIBRARIES ${SDLIB_LIBRARIES} ${${SDLIB_EXTRA_LIBRARY}})
          ELSE(${SDLIB_EXTRA_LIBRARY})
            IF(NOT SDLIB_OPTIONAL AND NOT SDLIB_LIB STREQUAL "OPTIONAL" AND NOT SDLIB_LIB STREQUAL "STATIC")
              MESSAGE(FATAL_ERROR "Cannot find ${SDLIB_LIB} library shared object")
            ENDIF(NOT SDLIB_OPTIONAL AND NOT SDLIB_LIB STREQUAL "OPTIONAL" AND NOT SDLIB_LIB STREQUAL "STATIC")
          ENDIF(${SDLIB_EXTRA_LIBRARY})
        ENDIF(SDLIB_FOUND_LIB)
      ENDIF(NOT SDLIB_TARGET_LOCATION STREQUAL "NOTFOUND")
    ENDIF(NOT SDLIB_IGNORE)
  ENDFOREACH(SDLIB_LIB ${SDLIB_LIBS})

  TARGET_LINK_LIBRARIES(${TARGET} ${SDLIB_LIBRARIES})

ENDMACRO(ADD_SDLIB_LIBRARY TARGET)

MACRO(ADD_PLIB_INCLUDEDIR)

  FIND_PACKAGE(PLIB)

  IF(PLIB_FOUND)
    INCLUDE_DIRECTORIES(${PLIB_INCLUDE_DIR})
  ELSE(PLIB_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find plib header files")
  ENDIF(PLIB_FOUND)

ENDMACRO(ADD_PLIB_INCLUDEDIR)

MACRO(ADD_PLIB_LIBRARY TARGET)

  FIND_PACKAGE(PLIB)
  IF(NOT PLIB_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find plib")
  ENDIF(NOT PLIB_FOUND)

  IF(NOT APPLE)
    FOREACH(PLIB_LIB ${ARGN})
      IF(PLIB_LIB STREQUAL "ul")
        SET(PLIB_LIBRARIES ${PLIB_LIBRARIES} ${PLIB_UL_LIBRARY})
      ELSEIF(PLIB_LIB STREQUAL "js")
        SET(PLIB_LIBRARIES ${PLIB_LIBRARIES} ${PLIB_JS_LIBRARY})
      ELSEIF(PLIB_LIB STREQUAL "sg")
        SET(PLIB_LIBRARIES ${PLIB_LIBRARIES} ${PLIB_SG_LIBRARY})
      ELSEIF(PLIB_LIB STREQUAL "sl")
        SET(PLIB_LIBRARIES ${PLIB_LIBRARIES} ${PLIB_SL_LIBRARY})
      ELSEIF(PLIB_LIB STREQUAL "sm")
        SET(PLIB_LIBRARIES ${PLIB_LIBRARIES} ${PLIB_SM_LIBRARY})
      ELSEIF(PLIB_LIB STREQUAL "ssg")
        SET(PLIB_LIBRARIES ${PLIB_LIBRARIES} ${PLIB_SSG_LIBRARY})
      ELSEIF(PLIB_LIB STREQUAL "ssgaux")
        SET(PLIB_LIBRARIES ${PLIB_LIBRARIES} ${PLIB_SSGAUX_LIBRARY})
      ELSE(PLIB_LIB STREQUAL "ul")
        MESSAGE(WARNING "${PLIB_LIB} is not part of plib")
      ENDIF(PLIB_LIB STREQUAL "ul")
    ENDFOREACH(PLIB_LIB ${ARGN})
  ENDIF(NOT APPLE)

  # Special case: Apple only uses one library
  IF(APPLE)
    SET(PLIB_LIBRARIES ${PLIB_LIBRARIES} ${PLIB_APPLE_LIBRARY})  
  ENDIF(APPLE)

  TARGET_LINK_LIBRARIES(${TARGET} ${PLIB_LIBRARIES})

ENDMACRO(ADD_PLIB_LIBRARY TARGET)

MACRO(ADD_SDL_INCLUDEDIR)

  FIND_PACKAGE(SDL)

  IF(SDL_FOUND)
    INCLUDE_DIRECTORIES(${SDL_INCLUDE_DIR})
  ELSE(SDL_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find SDL header files")
  ENDIF(SDL_FOUND)

ENDMACRO(ADD_SDL_INCLUDEDIR)

MACRO(ADD_SDL_LIBRARY TARGET)

  FIND_PACKAGE(SDL)

  IF(SDL_FOUND)
    TARGET_LINK_LIBRARIES(${TARGET} ${SDL_LIBRARY})
    IF(SDLMAIN_LIBRARY)
      TARGET_LINK_LIBRARIES(${TARGET} ${SDLMAIN_LIBRARY})
    ENDIF(SDLMAIN_LIBRARY)
  ELSE(SDL_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find SDL library")
  ENDIF(SDL_FOUND)

ENDMACRO(ADD_SDL_LIBRARY TARGET)

MACRO(ADD_OPENGL_INCLUDEDIR)

  FIND_PACKAGE(OpenGL)

  IF(OPENGL_FOUND)
    INCLUDE_DIRECTORIES(${OPENGL_INCLUDE_DIR})
  ELSE(OPENGL_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find OpenGL header files")
  ENDIF(OPENGL_FOUND)

ENDMACRO(ADD_OPENGL_INCLUDEDIR)

MACRO(ADD_OPENGL_LIBRARY TARGET)

  FIND_PACKAGE(OpenGL)

  IF(OPENGL_FOUND)
    TARGET_LINK_LIBRARIES(${TARGET} ${OPENGL_LIBRARIES})
  ELSE(OPENGL_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find OpenGL libraries")
  ENDIF(OPENGL_FOUND)

ENDMACRO(ADD_OPENGL_LIBRARY TARGET)

MACRO(ADD_OPENAL_INCLUDEDIR)

  FIND_PACKAGE(OpenAL)

  IF(OPENAL_FOUND)
    INCLUDE_DIRECTORIES(${OPENAL_INCLUDE_DIR})
  ELSE(OPENAL_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find OpenAL header files")
  ENDIF(OPENAL_FOUND)

ENDMACRO(ADD_OPENAL_INCLUDEDIR)

MACRO(ADD_OPENAL_LIBRARY TARGET)

  FIND_PACKAGE(OpenAL)

  IF(OPENAL_FOUND)
    TARGET_LINK_LIBRARIES(${TARGET} ${OPENAL_LIBRARIES})
  ELSE(OPENAL_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find OpenAL libraries")
  ENDIF(OPENAL_FOUND)

ENDMACRO(ADD_OPENAL_LIBRARY TARGET)

MACRO(ADD_ENET_INCLUDEDIR)

  FIND_PACKAGE(ENET)

  IF(ENET_FOUND)
    INCLUDE_DIRECTORIES(${ENET_INCLUDE_DIR})
  ELSE(ENET_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find ENET header files")
  ENDIF(ENET_FOUND)

ENDMACRO(ADD_ENET_INCLUDEDIR)

MACRO(ADD_ENET_LIBRARY TARGET)

  FIND_PACKAGE(ENET)

  IF(ENET_FOUND)
    TARGET_LINK_LIBRARIES(${TARGET} ${ENET_LIBRARY})
  ELSE(ENET_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find ENET libraries")
  ENDIF(ENET_FOUND)

ENDMACRO(ADD_ENET_LIBRARY TARGET)

MACRO(ADD_PNG_INCLUDEDIR)

  FIND_PACKAGE(PNG)

  IF(PNG_FOUND)
    INCLUDE_DIRECTORIES(${PNG_INCLUDE_DIR})
  ELSE(PNG_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find PNG header files")
  ENDIF(PNG_FOUND)

ENDMACRO(ADD_PNG_INCLUDEDIR)

MACRO(ADD_PNG_LIBRARY TARGET)

  FIND_PACKAGE(PNG)

  IF(PNG_FOUND)
    TARGET_LINK_LIBRARIES(${TARGET} ${PNG_LIBRARIES})
  ELSE(PNG_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find PNG libraries")
  ENDIF(PNG_FOUND)

ENDMACRO(ADD_PNG_LIBRARY TARGET)

MACRO(ADD_JPEG_INCLUDEDIR)

  FIND_PACKAGE(JPEG)

  IF(JPEG_FOUND)
    INCLUDE_DIRECTORIES(${JPEG_INCLUDE_DIR})
  ELSE(JPEG_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find JPEG header files")
  ENDIF(JPEG_FOUND)

ENDMACRO(ADD_JPEG_INCLUDEDIR)

MACRO(ADD_JPEG_LIBRARY TARGET)

  FIND_PACKAGE(JPEG)

  IF(JPEG_FOUND)
    TARGET_LINK_LIBRARIES(${TARGET} ${JPEG_LIBRARIES})
  ELSE(JPEG_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find JPEG libraries")
  ENDIF(JPEG_FOUND)

ENDMACRO(ADD_JPEG_LIBRARY TARGET)

MACRO(ADD_X11_INCLUDEDIR)

  FIND_PACKAGE(X11)

  IF(X11_FOUND)
    INCLUDE_DIRECTORIES(${X11_INCLUDE_DIR})
    MESSAGE(STATUS "INCLUDED ${X11_INCLUDE_DIR}")
  ELSE(X11_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find X11 header files")
  ENDIF(X11_FOUND)

ENDMACRO(ADD_X11_INCLUDEDIR)

MACRO(ADD_X11_LIBRARY TARGET)

  FIND_PACKAGE(X11)

  IF(X11_FOUND)
    TARGET_LINK_LIBRARIES(${TARGET} ${X11_LIBRARIES})
  ELSE(X11_FOUND)
    MESSAGE(FATAL_ERROR "Cannot find X11 libraries")
  ENDIF(X11_FOUND)

ENDMACRO(ADD_X11_LIBRARY TARGET)

MACRO(ADD_XRANDR_INCLUDEDIR)

  FIND_PACKAGE(X11)

  FIND_PATH(X11_Xrandr_INCLUDE_PATH X11/extensions/Xrandr.h ${X11_INC_SEARCH_PATH})
  MARK_AS_ADVANCED(X11_Xrandr_INCLUDE_PATH)

  IF(X11_Xrandr_INCLUDE_PATH)
    INCLUDE_DIRECTORIES(${X11_Xrandr_INCLUDE_PATH} ${X11_INCLUDE_DIR})
    SET(HAVE_XRANDR TRUE)
  ELSE(X11_Xrandr_INCLUDE_PATH)
    SET(HAVE_XRANDR FALSE)
  ENDIF(X11_Xrandr_INCLUDE_PATH)

ENDMACRO(ADD_XRANDR_INCLUDEDIR)

MACRO(ADD_XRANDR_LIBRARY TARGET)

  FIND_PACKAGE(X11)

  FIND_LIBRARY(X11_Xrandr_LIB Xrandr ${X11_LIB_SEARCH_PATH})

  IF(X11_Xrandr_LIB)
    TARGET_LINK_LIBRARIES(${TARGET} ${X11_Xrandr_LIB})
    SET(HAVE_XRANDR TRUE)
  ELSE(X11_Xrandr_LIB)
    SET(HAVE_XRANDR FALSE)
  ENDIF(X11_Xrandr_LIB)

ENDMACRO(ADD_XRANDR_LIBRARY TARGET)

#Some unix compilers need libdl
MACRO(ADD_DL_LIBRARY TARGET)

  IF(UNIX)
    FIND_LIBRARY(LIBDL_LIB dl "")

    IF(LIBDL_LIB)
      TARGET_LINK_LIBRARIES(${TARGET} ${LIBDL_LIB})
    ENDIF(LIBDL_LIB)
    #MESSAGE(STATUS LIBDL = ${LIBDL_LIB})
  ENDIF(UNIX)

ENDMACRO(ADD_DL_LIBRARY TARGET)

MACRO(ADD_SD_COMPILE_OPTIONS)

  # This has to be done more than once, because HAVE_CONFIG_H may change.
  IF(HAVE_CONFIG_H)

    ADD_DEFINITIONS(-DHAVE_CONFIG_H)

    IF(IN_SOURCETREE)
      SET(INCLUDE_CANDIDATE ${SOURCE_DIR})
    ELSE(IN_SOURCETREE)
      SET(INCLUDE_CANDIDATE "")
    ENDIF(IN_SOURCETREE)
    FIND_PATH(CONFIGH_INCLUDE_DIR config.h ${INCLUDE_CANDIDATE} /usr/include /usr/local/include NO_DEFAULT_PATH)
    FIND_PATH(CONFIGH_INCLUDE_DIR config.h ${INCLUDE_CANDIDATE} /usr/include /usr/local/include)
    MARK_AS_ADVANCED(CONFIGH_INCLUDE_DIR)
    IF(CONFIGH_INCLUDE_DIR)
      INCLUDE_DIRECTORIES(${CONFIGH_INCLUDE_DIR})
    ELSE(CONFIGH_INCLUDE_DIR)
      MESSAGE(FATAL_ERROR "Cannot find config.h header file")
    ENDIF(CONFIGH_INCLUDE_DIR)

  ENDIF(HAVE_CONFIG_H)

  # Pre-processor definitions (do it only once).
  IF(NOT _ALREADY_DONE)

    # CMake options.
    SET(OPTION_OFFICIAL_ONLY false CACHE BOOL "Build / install only officially released contents")

    SET(OPTION_DEBUG true CACHE BOOL "Enable debug symbols even in Release build")

    SET(OPTION_TRACE true CACHE BOOL "Enable traces into the console or log file")

    SET(OPTION_TRACE_LEVEL "5" CACHE STRING "Trace level integer threshold, only if OPTION_TRACE (traces with higher level are not logged  0=Fatal, 1=Error, 2=Warning, 3=Info, 4=Trace, 5=Debug, ...)")

    SET(OPTION_PROFILER false CACHE BOOL "Enable profiler")
  
    SET(OPTION_SCHEDULE_SPY false CACHE BOOL "Enable fine grained scheduling spy")
  
    IF(UNIX)
      SET(OPTION_XRANDR true CACHE BOOL "XrandR")  
      SET(OPTION_GLEXTPROTOTYPES true CACHE BOOL "Enable prototypes in glext.h")
      SET(OPTION_UNLOAD_SSGGRAPH true CACHE BOOL "If false, never unload ssggraph module (useful on some Linuxes to avoid XOrg crashes)")  
    ENDIF(UNIX)

    SET(OPTION_AUTOVERSION true CACHE BOOL "Enable automatic computation of the version from SVN source tree")
	
    # Compiler definitions.
    ADD_DEFINITIONS(-D_SVID_SOURCE -D_BSD_SOURCE -DSHM)

    IF(MSVC)
      # Suppress meaningless MSVC warnings
      ADD_DEFINITIONS(-D_CRT_SECURE_NO_WARNINGS -D_CRT_SECURE_NO_DEPRECATE -D_CRT_NO_DEPRECATE -D_SCL_SECURE_NO_WARNINGS)
    ENDIF(MSVC)

    IF(OPTION_DEBUG)
      ADD_DEFINITIONS(-DDEBUG)
    ENDIF(OPTION_DEBUG)
    IF(OPTION_TRACE)
      ADD_DEFINITIONS(-DTRACE_OUT)
    ENDIF(OPTION_TRACE)
    IF(OPTION_TRACE_LEVEL)
      ADD_DEFINITIONS(-DTRACE_LEVEL=${OPTION_TRACE_LEVEL})
    ENDIF(OPTION_TRACE_LEVEL)
    IF(OPTION_XRANDR)
      ADD_DEFINITIONS(-DUSE_RANDR_EXT)
    ENDIF(OPTION_XRANDR)
    IF(OPTION_PROFILER)
      ADD_DEFINITIONS(-DPROFILER)
    ENDIF(OPTION_PROFILER)
    IF(OPTION_SCHEDULE_SPY)
      ADD_DEFINITIONS(-DSCHEDULE_SPY)
    ENDIF(OPTION_SCHEDULE_SPY)
  
    IF(OPTION_GLEXTPROTOTYPES)
      ADD_DEFINITIONS(-DGL_GLEXT_PROTOTYPES)
    ENDIF(OPTION_GLEXTPROTOTYPES)

    IF(OPTION_UNLOAD_SSGGRAPH)
      ADD_DEFINITIONS(-DUNLOAD_SSGGRAPH)
    ENDIF(OPTION_UNLOAD_SSGGRAPH)

    # Define for code that needs Torcs backward compatibility
    ADD_DEFINITIONS(-DSPEED_DREAMS)
  
  ENDIF(NOT _ALREADY_DONE)

  # Compile options
  IF(NOT _ALREADY_DONE)

    # GCC warnings (at least for the 4.x series, there are none by default).
    IF(CMAKE_COMPILER_IS_GNUCXX)
      SET(_SD_WARN_OPTS "-Wall -Wextra -Wno-unused-parameter -Wno-missing-field-initializers")
      SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${_SD_WARN_OPTS}")
      SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${_SD_WARN_OPTS}")
    ENDIF(CMAKE_COMPILER_IS_GNUCXX)

  ENDIF(NOT _ALREADY_DONE)

ENDMACRO(ADD_SD_COMPILE_OPTIONS)

MACRO(SD_INSTALL_CAR CARNAME)

  SET(SDIC_FILES ${CARNAME}.xml ${ARGN})

  FILE(GLOB AC3D_FILES *.acc)
  FILE(GLOB PNG_FILES *.png)
  FILE(GLOB JPG_FILES *.jpg)
  FILE(GLOB RGB_FILES *.rgb)
  FILE(GLOB WAV_FILES *.wav)

  SET(SDIC_FILES ${SDIC_FILES} ${AC3D_FILES} ${RGB_FILES} ${PNG_FILES} ${JPG_FILES} ${WAV_FILES})

  SD_INSTALL_FILES(DATA cars/${CARNAME} FILES ${SDIC_FILES})

ENDMACRO(SD_INSTALL_CAR CARNAME)

MACRO(SD_INSTALL_TRACK TRACKNAME CATEGORY)

  SET(SDIT_FILES ${TRACKNAME}.xml ${ARGN})

  # Among AC3D files, keep any .acc one, but exclude *-src.ac
  # and *.ac when a .acc with same name exists.
  FILE(GLOB ACC_FILES *.acc)
  FILE(GLOB SRCAC_FILES *-src.ac)
  FILE(GLOB AC_FILES *.ac)
  FOREACH(AC_FILE ${AC_FILES})
    LIST(FIND SRCAC_FILES "${AC_FILE}" IS_SRC)
    LIST(FIND ACC_FILES "${AC_FILE}c" HAS_ACC)
    IF(IS_SRC EQUAL -1 AND HAS_ACC EQUAL -1)
      LIST(APPEND AC3D_FILES ${AC_FILE})
    ENDIF()
  ENDFOREACH()
  SET(AC3D_FILES ${AC3D_FILES} ${ACC_FILES})

  FILE(GLOB PNG_FILES *.png)
  FILE(GLOB JPG_FILES *.jpg)
  FILE(GLOB RGB_FILES *.rgb)

  SET(SDIT_FILES ${SDIT_FILES} ${AC3D_FILES} ${RGB_FILES} ${PNG_FILES} ${JPG_FILES})

  SD_INSTALL_FILES(DATA tracks/${CATEGORY}/${TRACKNAME} FILES ${SDIT_FILES})

ENDMACRO(SD_INSTALL_TRACK TRACKNAME CATEGORY)

# Data/Lib/Bin/Include files installation (with user settings registration for data files)
# Args:
#  DATA     : Data subdirectory where to install specified data files
#  LIB      : Lib subdirectory where to install specified files/targets
#  BIN      : If present, instructs to install specified files/targets in the bin dir
#  INCLUDE  : Include subdirectory where to install specified files
#  USER     : User settings subdirectory where to install/update specified data files at run-time
#  PREFIX   : Prefix to use to get source path for files specified in FILES
#  FILES    : Files to install (see PREFIX)
#  TARGETS  : Targets to install
# Examples:
#  SD_INSTALL_FILES(DATA drivers/bt FILES bt.xml logo.rgb)
#     Installs bt.xml and logo.rgb in ${prefix}/${SD_DATADIR}/drivers/bt
#  SD_INSTALL_FILES(DATA config/raceman USER config/raceman FILES quickrace.xml endrace.xml)
#     Installs quickrace.xml and endrace.xml in ${prefix}/${SD_DATADIR}/drivers/bt
#     and copies the file to the users settings folder ${SD_LOCALDIR}/config/raceman at startup.
#  SD_INSTALL_FILES(LIB drivers/bt TARGETS bt.so)
#     Installs bt.so in ${prefix}/${SD_LIBDIR}/drivers/bt
#  SD_INSTALL_FILES(BIN TARGETS speed-dreams)
#     Installs the speed-dreams target in ${prefix}/${SD_BINDIR}
#  SD_INSTALL_FILES(MAN man6 PREFIX ${SOURCE_DIR}/doc/man FILES sd2-menuview.6)
#     Installs ${SOURCE_DIR}/doc/man/sd2-menuview.6 in ${prefix}/${SD_MANDIR}/man6
MACRO(SD_INSTALL_FILES)

  SET(SD_INSTALL_FILES_SYNTAX "DATA,1,1,IS_DATA,DATA_PATH")
  SET(SD_INSTALL_FILES_SYNTAX ${SD_INSTALL_FILES_SYNTAX} "LIB,1,1,IS_LIB,LIB_PATH")
  SET(SD_INSTALL_FILES_SYNTAX ${SD_INSTALL_FILES_SYNTAX} "BIN,0,0,IS_BIN,_")
  SET(SD_INSTALL_FILES_SYNTAX ${SD_INSTALL_FILES_SYNTAX} "INCLUDE,0,1,IS_INCLUDE,INCLUDE_PATH")
  SET(SD_INSTALL_FILES_SYNTAX ${SD_INSTALL_FILES_SYNTAX} "MAN,1,1,IS_MAN,MAN_PATH")
  SET(SD_INSTALL_FILES_SYNTAX ${SD_INSTALL_FILES_SYNTAX} "USER,1,1,IS_USER,USER_PATH")
  SET(SD_INSTALL_FILES_SYNTAX ${SD_INSTALL_FILES_SYNTAX} "PREFIX,0,1,HAS_PREFIX,PREFIX")
  SET(SD_INSTALL_FILES_SYNTAX ${SD_INSTALL_FILES_SYNTAX} "FILES,0,-1,HAS_FILES,FILES")
  SET(SD_INSTALL_FILES_SYNTAX ${SD_INSTALL_FILES_SYNTAX} "TARGETS,0,-1,HAS_TARGETS,TARGETS")

  SPLIT_ARGN(${SD_INSTALL_FILES_SYNTAX} ARGUMENTS ${ARGN})

  #MESSAGE(STATUS "  SD_INSTALL_FILES: LIB=${IS_LIB}:${LIB_PATH} BIN=${IS_BIN} INCLUDE=${IS_INCLUDE}:${INCLUDE_PATH} DATA=${IS_DATA}:${DATA_PATH} MAN=${IS_MAN}:${MAN_PATH} USER=${IS_USER}:${USER_PATH} TARGETS=${HAS_TARGETS}:${TARGETS} FILES=${HAS_FILES}:${FILES}")

  # Fix/Check argument syntax / values
  IF(NOT DATA_PATH)
    SET(IS_DATA FALSE)
  ENDIF()
  IF(NOT USER_PATH)
    SET(IS_USER FALSE)
  ENDIF()
  IF(NOT LIB_PATH)
    SET(IS_LIB FALSE)
  ENDIF()
  IF(NOT MAN_PATH)
    SET(IS_MAN FALSE)
  ENDIF()
  IF(NOT PREFIX)
    SET(HAS_PREFIX FALSE)
  ENDIF()
  IF(NOT FILES)
    SET(HAS_FILES FALSE)
  ENDIF()
  IF(NOT TARGETS)
    SET(HAS_TARGETS FALSE)
  ENDIF()

  IF(IS_DATA OR IS_LIB OR IS_BIN OR IS_INCLUDE OR IS_MAN)
    IF(HAS_PREFIX)
      IF(NOT HAS_FILES)
        MESSAGE(FATAL_ERROR "SD_INSTALL_FILES: Expected FILES when PREFIX keyword is present")
      ENDIF()
    ENDIF()
  ELSE()
    MESSAGE(FATAL_ERROR "SD_INSTALL_FILES: Expected 1 and only 1 LIB, DATA, BIN, INCLUDE or MAN keyword")
  ENDIF()

  IF(IS_USER)
    IF(NOT IS_DATA)
      MESSAGE(FATAL_ERROR "SD_INSTALL_FILES: Expected DATA when USER keyword is present")
    ENDIF()
  ENDIF()

  # Compute destination sub-dir
  IF(IS_LIB)
    SET(DEST1 ${SD_LIBDIR})
    SET(DEST2 ${LIB_PATH})
  ELSEIF(IS_DATA)
    SET(DEST1 ${SD_DATADIR})
    SET(DEST2 ${DATA_PATH})
  ELSEIF(IS_BIN)
    SET(DEST1 ${SD_BINDIR})
    SET(DEST2 "")
  ELSEIF(IS_INCLUDE)
    SET(DEST1 ${SD_INCLUDEDIR})
    SET(DEST2 ${INCLUDE_PATH})
  ELSEIF(IS_MAN)
    SET(DEST1 ${SD_MANDIR})
    SET(DEST2 ${MAN_PATH})
  ENDIF()

  IF(DEST2 STREQUAL "" OR DEST2 STREQUAL "/")
    SET(DEST2 "")
    SET(DEST_ALL "${DEST1}")
  ELSE()
    SET(DEST_ALL "${DEST1}/${DEST2}")
  ENDIF()

  # Prepend prefix to files if specified.
  SET(REAL_FILES) # Reset the list (remember, it's a CMakeLists.txt global variable :-()
  IF(HAS_FILES)
    IF(HAS_PREFIX)
      FOREACH(FILE ${FILES})
        LIST(APPEND REAL_FILES ${PREFIX}/${FILE})
      ENDFOREACH()
    ELSE()
       SET(REAL_FILES ${FILES})
    ENDIF()
  ENDIF()

  # Install files
  IF(REAL_FILES)
    INSTALL(FILES ${REAL_FILES} DESTINATION ${DEST_ALL})
  ENDIF()

  # Install targets
  IF(HAS_TARGETS)
    INSTALL(TARGETS ${TARGETS} DESTINATION ${DEST_ALL})
  ENDIF()

  # Register files for run-time install/update at game startup (through filesetup.cpp services)
  IF(IS_USER)

    # Handle properly the "root" folder case.
    IF(DATA_PATH STREQUAL "/")
      SET(DATA_PATH "")
    ELSE()
      SET(DATA_PATH "${DATA_PATH}/")
    ENDIF()

    # Execute xmlversion at install-time to do this registration job.
    IF(WIN32)

      # Under Windows, in order to run xmlversion.exe in the build tree,
      # we have to copy dependencies next to it.
      GET_TARGET_PROPERTY(TXML_LIB txml LOCATION)
      GET_TARGET_PROPERTY(TGF_LIB tgf LOCATION)
      FIND_PACKAGE(SDL)
      GET_FILENAME_COMPONENT(SDL_LIBPATH ${SDL_LIBRARY} PATH)
      GET_FILENAME_COMPONENT(SDL_LIBNAME ${SDL_LIBRARY} NAME_WE)
      SET(SDL_LIB ${SDL_LIBPATH}/../bin/${CMAKE_SHARED_LIBRARY_PREFIX}${SDL_LIBNAME}${CMAKE_SHARED_LIBRARY_SUFFIX})

      INSTALL(CODE 
          "FILE(READ ${CMAKE_BINARY_DIR}/xmlversion_loc.txt XMLVERSION_EXE)
           STRING(REPLACE \"$(OutDir)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" XMLVERSION_EXE \${XMLVERSION_EXE})
           STRING(REPLACE \"$(ConfigurationName)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" XMLVERSION_EXE \${XMLVERSION_EXE})
           STRING(REPLACE \"$(Configuration)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" XMLVERSION_EXE \${XMLVERSION_EXE})
           GET_FILENAME_COMPONENT(XMLVERSION_DIR \${XMLVERSION_EXE} PATH)
           SET(TXML_LIB ${TXML_LIB})
           STRING(REPLACE \"$(OutDir)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TXML_LIB \${TXML_LIB})
           STRING(REPLACE \"$(ConfigurationName)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TXML_LIB \${TXML_LIB})
           STRING(REPLACE \"$(Configuration)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TXML_LIB \${TXML_LIB})
           SET(TGF_LIB ${TGF_LIB})
           STRING(REPLACE \"$(OutDir)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TGF_LIB \${TGF_LIB})
           STRING(REPLACE \"$(ConfigurationName)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TGF_LIB \${TGF_LIB})
           STRING(REPLACE \"$(Configuration)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TGF_LIB \${TGF_LIB})
           FILE(INSTALL DESTINATION \${XMLVERSION_DIR} TYPE FILE FILES \${TXML_LIB} \${TGF_LIB} \"${SDL_LIB}\")
           SET(SD_DATADIR_ABS \"${SD_DATADIR}\")
           IF(NOT IS_ABSOLUTE \${SD_DATADIR_ABS})
             GET_FILENAME_COMPONENT(SD_DATADIR_ABS \"\${CMAKE_INSTALL_PREFIX}/\${SD_DATADIR_ABS}\" ABSOLUTE)
           ENDIF()
           FOREACH(FILE ${FILES})
             GET_FILENAME_COMPONENT(FILENAME \${FILE} NAME)
              EXECUTE_PROCESS(COMMAND \"\${XMLVERSION_EXE}\" \"\${SD_DATADIR_ABS}/version.xml\" \"${DATA_PATH}\${FILENAME}\" \"${USER_PATH}/\${FILENAME}\" \"\${SD_DATADIR_ABS}\" RESULT_VARIABLE XMLVERSTATUS)
              IF(XMLVERSTATUS)
               MESSAGE(FATAL_ERROR \"Error: xmlversion failed\")
              ENDIF()
           ENDFOREACH()")

    ELSE(WIN32)

      INSTALL(CODE 
          "FILE(READ ${CMAKE_BINARY_DIR}/xmlversion_loc.txt XMLVERSION_EXE)
           SET(SD_DATADIR_ABS \"${SD_DATADIR}\")
           IF(NOT IS_ABSOLUTE \${SD_DATADIR_ABS})
             GET_FILENAME_COMPONENT(SD_DATADIR_ABS \"\${CMAKE_INSTALL_PREFIX}/\${SD_DATADIR_ABS}\" ABSOLUTE)
           ENDIF()
           # Why this path correction here ? This needs a comment !
           SET(CUR_DESTDIR \"\$ENV{DESTDIR}\")
           IF(CUR_DESTDIR MATCHES \"[^/]\")
            STRING(REGEX REPLACE \"^(.*[^/])/*$\" \"\\\\1\" CUR_DESTDIR_CORR \"\${CUR_DESTDIR}\")
           ELSE(CUR_DESTDIR MATCHES \"[^/]\")
            SET(CUR_DESTDIR_CORR \"\")
           ENDIF(CUR_DESTDIR MATCHES \"[^/]\")
           FOREACH(FILE ${FILES})
             GET_FILENAME_COMPONENT(FILENAME \${FILE} NAME)
              EXECUTE_PROCESS(COMMAND \"\${XMLVERSION_EXE}\" \"\${CUR_DESTDIR_CORR}\${SD_DATADIR_ABS}/version.xml\" \"${DATA_PATH}\${FILENAME}\" \"${USER_PATH}/\${FILENAME}\" \"\${CUR_DESTDIR_CORR}\${SD_DATADIR_ABS}\" RESULT_VARIABLE XMLVERSTATUS)
              IF(XMLVERSTATUS)
               MESSAGE(FATAL_ERROR \"Error: xmlversion failed\")
              ENDIF(XMLVERSTATUS)
           ENDFOREACH()")

    ENDIF(WIN32)

  ENDIF(IS_USER)

ENDMACRO(SD_INSTALL_FILES)

# Directory installation with pattern matching on files and user settings registration
# Args:
#  DATA        : Data subdirectory where to install specified sub-dirs
#  USER        : User settings subdirectory where to install/update specified sub-dirs at run-time
#  PREFIX      : Prefix to use to get source path for dirs specified in DIRECTORIES
#  DIRECTORIES : Sub-dirs to recursively install (see PREFIX)
#  PATTERNS    : Glob patterns to use for seelecting files to install (defaults to *.*)
# Example:
#  SD_INSTALL_DIRECTORIES(DATA drivers/human USER drivers/human 
#                         PREFIX pfx DIRECTORIES cars tracks PATTERNS *.xml)
#  will recursively install any .xml file from drivers/human/pfx/cars and drivers/human/pfx/tracks
#  into drivers/human/cars and  drivers/human/pfx/tracks data dirs  
#  these files / sub-dirs will also be scheduled for run-time update/install in user settings dir.
MACRO(SD_INSTALL_DIRECTORIES)

  SET(SDID_SYNTAX "DATA,1,1,IS_DATA,DATA_PATH")
  SET(SDID_SYNTAX ${SDID_SYNTAX} "USER,1,1,IS_USER,USER_PATH")
  SET(SDID_SYNTAX ${SDID_SYNTAX} "PREFIX,0,1,HAS_PREFIX,PREFIX")
  SET(SDID_SYNTAX ${SDID_SYNTAX} "DIRECTORIES,0,-1,HAS_DIRECTORIES,DIRECTORIES")
  SET(SDID_SYNTAX ${SDID_SYNTAX} "PATTERNS,0,-1,HAS_PATTERNS,PATTERNS")

  SPLIT_ARGN(${SDID_SYNTAX} ARGUMENTS ${ARGN})

  #MESSAGE(STATUS "  SD_INSTALL_DIRECTORIES: DATA=${IS_DATA}:${DATA_PATH} USER=${IS_USER}:${USER_PATH} DIRS=${HAS_DIRECTORIES}:${DIRECTORIES} PATTERNS=${HAS_PATTERNS}:${PATTERNS}")

  # Fix/Check argument syntax / values
  IF(NOT DATA_PATH)
    SET(IS_DATA FALSE)
  ENDIF()
  IF(NOT USER_PATH)
    SET(IS_USER FALSE)
  ENDIF()
  IF(NOT PREFIX)
    SET(HAS_PREFIX FALSE)
  ENDIF()
  IF(NOT DIRECTORIES)
    SET(HAS_DIRECTORIES FALSE)
  ENDIF()
  IF(NOT PATTERNS)
    SET(HAS_PATTERNS TRUE)
    SET(PATTERNS "*.*")
  ENDIF()

  IF(IS_DATA AND HAS_DIRECTORIES)
    IF(HAS_PREFIX)
      SET(PREFIX "${PREFIX}/")
      SET(POSTFIX "/${PREFIX}")
    ELSE()
      SET(PREFIX "")
      SET(POSTFIX "")
    ENDIF()
  ELSE()
    MESSAGE(ERROR "SD_INSTALL_DIRECTORIES: Expected mandatory DATA and DIRECTORIES keywords")
  ENDIF()

  # Compute destination sub-dir
  IF(DATA_PATH STREQUAL "/")
    SET(DEST_ALL "${SD_DATADIR}")
  ELSE()
    SET(DEST_ALL "${SD_DATADIR}/${DATA_PATH}")
  ENDIF()

  # Install selected files into the data dir.
  FOREACH(DIRECTORY ${DIRECTORIES})
    SET(GLOB_EXPRS)
    FOREACH(PATTERN ${PATTERNS})
      LIST(APPEND GLOB_EXPRS "${PREFIX}${DIRECTORY}/${PATTERN}")
    ENDFOREACH()
    FILE(GLOB_RECURSE FILES RELATIVE ${CMAKE_CURRENT_SOURCE_DIR}${POSTFIX} ${GLOB_EXPRS})
    FOREACH(FILE ${FILES})
      IF(NOT "${FILE}" MATCHES "\\.svn")
        GET_FILENAME_COMPONENT(SUBDIR ${FILE} PATH)
        INSTALL(FILES ${PREFIX}${FILE} DESTINATION ${DEST_ALL}/${SUBDIR})
      ENDIF()
    ENDFOREACH()
    #MESSAGE(STATUS "${DIRECTORY}/${PATTERNS} : ${FILES}")
  ENDFOREACH()

  # Register selected files in subdirs for run-time install/update
  # at game startup (through filesetup.cpp services)
  IF(IS_USER)

    # Handle properly the "root" folder case.
    IF(DATA_PATH STREQUAL "/")
      SET(DEST_ALL "")
    ELSE()
      SET(DEST_ALL "${DATA_PATH}/")
    ENDIF()

    # Execute xmlversion at install-time to do this registration job.
    IF(WIN32)

      # Under Windows, in order to run xmlversion.exe in the build tree,
      # we have to copy dependencies next to it.
      GET_TARGET_PROPERTY(TXML_LIB txml LOCATION)
      GET_TARGET_PROPERTY(TGF_LIB tgf LOCATION)
      FIND_PACKAGE(SDL)
      GET_FILENAME_COMPONENT(SDL_LIBPATH ${SDL_LIBRARY} PATH)
      GET_FILENAME_COMPONENT(SDL_LIBNAME ${SDL_LIBRARY} NAME_WE)
      SET(SDL_LIB ${SDL_LIBPATH}/../bin/${CMAKE_SHARED_LIBRARY_PREFIX}${SDL_LIBNAME}${CMAKE_SHARED_LIBRARY_SUFFIX})

      INSTALL(CODE 
          "FILE(READ ${CMAKE_BINARY_DIR}/xmlversion_loc.txt XMLVERSION_EXE)
           STRING(REPLACE \"$(OutDir)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" XMLVERSION_EXE \${XMLVERSION_EXE})
           STRING(REPLACE \"$(ConfigurationName)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" XMLVERSION_EXE \${XMLVERSION_EXE})
           STRING(REPLACE \"$(Configuration)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" XMLVERSION_EXE \${XMLVERSION_EXE})
           GET_FILENAME_COMPONENT(XMLVERSION_DIR \${XMLVERSION_EXE} PATH)
           SET(TXML_LIB ${TXML_LIB})
           STRING(REPLACE \"$(OutDir)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TXML_LIB \${TXML_LIB})
           STRING(REPLACE \"$(ConfigurationName)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TXML_LIB \${TXML_LIB})
           STRING(REPLACE \"$(Configuration)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TXML_LIB \${TXML_LIB})
           SET(TGF_LIB ${TGF_LIB})
           STRING(REPLACE \"$(OutDir)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TGF_LIB \${TGF_LIB})
           STRING(REPLACE \"$(ConfigurationName)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TGF_LIB \${TGF_LIB})
           STRING(REPLACE \"$(Configuration)\" \"\${CMAKE_INSTALL_CONFIG_NAME}\" TGF_LIB \${TGF_LIB})
           FILE(INSTALL DESTINATION \${XMLVERSION_DIR} TYPE FILE FILES \${TXML_LIB} \${TGF_LIB} \"${SDL_LIB}\")
           SET(SD_DATADIR_ABS \"${SD_DATADIR}\")
           IF(NOT IS_ABSOLUTE \${SD_DATADIR_ABS})
             GET_FILENAME_COMPONENT(SD_DATADIR_ABS \"\${CMAKE_INSTALL_PREFIX}/\${SD_DATADIR_ABS}\" ABSOLUTE)
           ENDIF()

           FOREACH(DIRECTORY ${DIRECTORIES})
             SET(GLOB_EXPRS)
             FOREACH(PATTERN ${PATTERNS})
               LIST(APPEND GLOB_EXPRS \"${PREFIX}\${DIRECTORY}/\${PATTERN}\")
             ENDFOREACH()
             FILE(GLOB_RECURSE FILES RELATIVE ${CMAKE_CURRENT_SOURCE_DIR}${POSTFIX} ${CMAKE_CURRENT_SOURCE_DIR}${POSTFIX}/\${GLOB_EXPRS})
             FOREACH(FILE \${FILES})
               IF(NOT \"\${FILE}\" MATCHES \"\\\\.svn\")
                  EXECUTE_PROCESS(COMMAND \"\${XMLVERSION_EXE}\" \"\${SD_DATADIR_ABS}/version.xml\" \"${DEST_ALL}\${FILE}\" \"${USER_PATH}/\${FILE}\" \"\${SD_DATADIR_ABS}\" RESULT_VARIABLE XMLVERSTATUS)
                  IF(XMLVERSTATUS)
                   MESSAGE(FATAL_ERROR \"Error: xmlversion failed\")
                  ENDIF(XMLVERSTATUS)
               ENDIF()
             ENDFOREACH()
           ENDFOREACH()")

    ELSE(WIN32)

      INSTALL(CODE 
          "FILE(READ ${CMAKE_BINARY_DIR}/xmlversion_loc.txt XMLVERSION_EXE)
           SET(SD_DATADIR_ABS \"${SD_DATADIR}\")
           IF(NOT IS_ABSOLUTE \${SD_DATADIR_ABS})
             GET_FILENAME_COMPONENT(SD_DATADIR_ABS \"\${CMAKE_INSTALL_PREFIX}/\${SD_DATADIR_ABS}\" ABSOLUTE)
           ENDIF()
           # Why this path correction here ? This needs a comment !
           SET(CUR_DESTDIR \"\$ENV{DESTDIR}\")
           IF(CUR_DESTDIR MATCHES \"[^/]\")
            STRING(REGEX REPLACE \"^(.*[^/])/*$\" \"\\\\1\" CUR_DESTDIR_CORR \"\${CUR_DESTDIR}\")
           ELSE(CUR_DESTDIR MATCHES \"[^/]\")
            SET(CUR_DESTDIR_CORR \"\")
           ENDIF(CUR_DESTDIR MATCHES \"[^/]\")

           FOREACH(DIRECTORY ${DIRECTORIES})
             SET(GLOB_EXPRS)
             FOREACH(PATTERN ${PATTERNS})
               LIST(APPEND GLOB_EXPRS \"${PREFIX}\${DIRECTORY}/\${PATTERN}\")
             ENDFOREACH()
             FILE(GLOB_RECURSE FILES RELATIVE ${CMAKE_CURRENT_SOURCE_DIR}${POSTFIX} ${CMAKE_CURRENT_SOURCE_DIR}${POSTFIX}/\${GLOB_EXPRS})
             FOREACH(FILE \${FILES})
               IF(NOT \"\${FILE}\" MATCHES \"\\\\.svn\")
                  EXECUTE_PROCESS(COMMAND \"\${XMLVERSION_EXE}\" \"\${CUR_DESTDIR_CORR}\${SD_DATADIR_ABS}/version.xml\" \"${DEST_ALL}\${FILE}\" \"${USER_PATH}/\${FILE}\" \"\${CUR_DESTDIR_CORR}\${SD_DATADIR_ABS}\" RESULT_VARIABLE XMLVERSTATUS)
                  IF(XMLVERSTATUS)
                   MESSAGE(FATAL_ERROR \"Error: xmlversion failed\")
                  ENDIF(XMLVERSTATUS)
               ENDIF()
             ENDFOREACH()
           ENDFOREACH()")

    ENDIF(WIN32)

  ENDIF(IS_USER)

ENDMACRO(SD_INSTALL_DIRECTORIES)

# Macro to install CMake config files for SD if in-source build.
IF(IN_SOURCETREE)
  MACRO(INSTALL_SD_CMAKE)
    INSTALL(CODE 
        "SET(CUR_DESTDIR \"\$ENV{DESTDIR}\")
         IF(CUR_DESTDIR MATCHES \"[^/]\")
           STRING(REGEX REPLACE \"^(.*[^/])/*$\" \"\\\\1\" CUR_DESTDIR_CORR \"\${CUR_DESTDIR}\")
         ELSE(CUR_DESTDIR MATCHES \"[^/]\")
           SET(CUR_DESTDIR_CORR \"\")
           ENDIF(CUR_DESTDIR MATCHES \"[^/]\")
         FILE(MAKE_DIRECTORY \"\${CUR_DESTDIR_CORR}${SD_DATADIR_ABS}/cmake\")
         FILE(WRITE \"\${CUR_DESTDIR_CORR}${SD_DATADIR_ABS}/cmake/speed-dreams.cmake\"
            \"SET(SD_DATADIR_ABS \\\"${SD_DATADIR_ABS}\\\")
              SET(SD_LOCALDIR \\\"${SD_LOCALDIR}\\\")
            SET(SD_LIBDIR_ABS \\\"${SD_LIBDIR_ABS}\\\")
            SET(SD_BINDIR_ABS \\\"${SD_BINDIR_ABS}\\\")
            SET(SD_INCLUDEDIR_ABS \\\"${SD_INCLUDEDIR_ABS}\\\")
               SET(IN_SOURCETREE FALSE)\\n\\n\")
         FILE(READ \"${SOURCE_DIR}/cmake/macros.cmake\" SD_MACRO_CONTENT)
         FILE(APPEND \"\${CUR_DESTDIR_CORR}${SD_DATADIR_ABS}/cmake/speed-dreams.cmake\" \${SD_MACRO_CONTENT})")
  ENDMACRO(INSTALL_SD_CMAKE)
ENDIF(IN_SOURCETREE)

# Generate clobber.sh/bat shell script (remove _any_ build system generated file)
MACRO(SD_GENERATE_CLOBBER_SCRIPT)

  IF(IN_SOURCETREE)
  
    IF(WIN32)
  
      SET(TGT_SCRIPT "${SOURCE_DIR}/clobber.bat")
      FILE(WRITE  "${TGT_SCRIPT}" "@echo off\n")
      FILE(APPEND "${TGT_SCRIPT}" "rem CMake-generated script for in-source build tree total cleanup\n")
      FILE(APPEND "${TGT_SCRIPT}" "rem (remove any build-system-generated file (+ .bak, *~, ... etc), \n")
      FILE(APPEND "${TGT_SCRIPT}" "rem  in case you want to get back to something like\n")
      FILE(APPEND "${TGT_SCRIPT}" "rem  right after a 'svn checkout' command).\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "rem Check if we are on top of a CMake-enabled SD source tree\n")
      FILE(APPEND "${TGT_SCRIPT}" "if not exist CMakeLists.txt goto ERROR\n")
      FILE(APPEND "${TGT_SCRIPT}" "if not exist credits.xml goto ERROR\n")
      FILE(APPEND "${TGT_SCRIPT}" "if not exist cmake goto ERROR\n")
      FILE(APPEND "${TGT_SCRIPT}" "if not exist data goto ERROR\n")
      FILE(APPEND "${TGT_SCRIPT}" "if not exist src goto ERROR\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "echo Cleaning up in-source build tree ...\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "rem CMake/compiler generated files and dirs\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "del CMakeCache.txt\n")
      FILE(APPEND "${TGT_SCRIPT}" "del config.h\n")
      FILE(APPEND "${TGT_SCRIPT}" "del CPackConfig.cmake\n")
      FILE(APPEND "${TGT_SCRIPT}" "del CPackSourceConfig.cmake\n")
      FILE(APPEND "${TGT_SCRIPT}" "del uninstall.cmake\n")
      FILE(APPEND "${TGT_SCRIPT}" "del doxygen_config\n")
      FILE(APPEND "${TGT_SCRIPT}" "del install_manifest.txt\n")
      FILE(APPEND "${TGT_SCRIPT}" "del speed-dreams-2.ncb\n")
      FILE(APPEND "${TGT_SCRIPT}" "del /ah speed-dreams-2.suo\n")
      FILE(APPEND "${TGT_SCRIPT}" "del speed-dreams-2.sln\n")
      FILE(APPEND "${TGT_SCRIPT}" "del version.h\n")
      FILE(APPEND "${TGT_SCRIPT}" "del xmlversion_loc.txt\n")
      FILE(APPEND "${TGT_SCRIPT}" "del /s /q *.vcproj*\n")
      FILE(APPEND "${TGT_SCRIPT}" "del /s /q cmake_install.cmake\n")
      FILE(APPEND "${TGT_SCRIPT}" "for /f \"tokens=*\" %%G in ('dir /b /ad /s CMakeFiles*') do rmdir /s /q %%G\n")
      FILE(APPEND "${TGT_SCRIPT}" "for /f \"tokens=*\" %%G in ('dir /b /ad /s *.dir') do rmdir /s /q %%G\n")
      FILE(APPEND "${TGT_SCRIPT}" "for /f \"tokens=*\" %%G in ('dir /b /ad /s Debug*') do rmdir /s /q %%G\n")
      FILE(APPEND "${TGT_SCRIPT}" "for /f \"tokens=*\" %%G in ('dir /b /ad /s Release*') do rmdir /s /q %%G\n")
      FILE(APPEND "${TGT_SCRIPT}" "rmdir /s /q _CPack_Packages\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "rem Other useless files\n")
      FILE(APPEND "${TGT_SCRIPT}" "del /s /q *.*~\n")
      FILE(APPEND "${TGT_SCRIPT}" "del /s /q *.~*\n")
      FILE(APPEND "${TGT_SCRIPT}" "del /s /q *.bak\n")
      FILE(APPEND "${TGT_SCRIPT}" "del /s /q *.flc\n")
      FILE(APPEND "${TGT_SCRIPT}" "del /s /q *.orig\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "echo Done.\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "goto END\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" ":ERROR\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "echo Bad current dir for that  please run from the root folder of a CMake-enabled SD source tree.\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" ":END\n")
  
    ELSE(WIN32)
  
      SET(TGT_SCRIPT "${SOURCE_DIR}/clobber.sh")
      FILE(WRITE  "${TGT_SCRIPT}" "#!/bin/sh\n")
      FILE(APPEND "${TGT_SCRIPT}" "# CMake-generated script for in-source build tree total cleanup\n")
      FILE(APPEND "${TGT_SCRIPT}" "# (remove any build-system-generated file (+ .bak, *~, ... etc), \n")
      FILE(APPEND "${TGT_SCRIPT}" "#  in case you want to get back to something like\n")
      FILE(APPEND "${TGT_SCRIPT}" "#  right after a 'svn checkout' command).\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "# Check if we are on top of a CMake-enabled SD source tree\n")
      FILE(APPEND "${TGT_SCRIPT}" "if [ -f CMakeLists.txt -a -f credits.xml -a -d cmake -a -d data -a -d src ]  then\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "  echo \"Cleaning up in-source build tree ...\"\n")
      FILE(APPEND "${TGT_SCRIPT}" "  \n")
      FILE(APPEND "${TGT_SCRIPT}" "  # CMake/compiler generated files and dirs\n")
      FILE(APPEND "${TGT_SCRIPT}" "  rm -f CMakeCache.txt config.h doxygen_config\n")
      FILE(APPEND "${TGT_SCRIPT}" "  rm -f CPackConfig.cmake CPackSourceConfig.cmake\n")
      FILE(APPEND "${TGT_SCRIPT}" "  rm -f uninstall.cmake\n")
      FILE(APPEND "${TGT_SCRIPT}" "  rm -f xmlversion_loc.txt install_manifest.txt version.h.txt\n")
      FILE(APPEND "${TGT_SCRIPT}" "  rm -fr _CPack_Packages\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -depth -type d -name \"CMakeFiles\" -exec rm -fr {} \\\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -type f -name \"cmake_install.cmake\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -type f -name \"Makefile\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -type f -name \"*.so\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find src/tools -type f -name \"sd2-*\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find src/main -type f -name \"speed-dreams-2\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "\n")
      FILE(APPEND "${TGT_SCRIPT}" "  # Other useless files\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -type f -name \"*.rej\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -type f -name \"*.orig\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -type f -name \"*.flc\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -type f -name \"*.bak\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -type f -name \"*~\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  find . -type f -name \"*.~*\" -delete\n")
      FILE(APPEND "${TGT_SCRIPT}" "  \n")
      FILE(APPEND "${TGT_SCRIPT}" "  echo \"Done.\"\n")
      FILE(APPEND "${TGT_SCRIPT}" "  \n")
      FILE(APPEND "${TGT_SCRIPT}" "else\n")
      FILE(APPEND "${TGT_SCRIPT}" "  echo \"Bad current dir for that  please run from the root folder of a CMake-enabled SD source tree.\"\n")
      FILE(APPEND "${TGT_SCRIPT}" "fi\n")
      EXECUTE_PROCESS(COMMAND chmod ugo+x ${TGT_SCRIPT})
    ENDIF(WIN32)
  
  ENDIF(IN_SOURCETREE)

ENDMACRO(SD_GENERATE_CLOBBER_SCRIPT)

# Add non-default compile options.
ADD_SD_COMPILE_OPTIONS()

# A useful variable for things that only need to be done once
# (macros.cmake is actually included by every CMakeLists.txt,
#  in order one can run 'cmake .' everywhere in the source tree,
#  but the bad side effect if that it is thus often included
#  _multiple_ times by every CMakeLists.txt).
IF(NOT _ALREADY_DONE)
  SET(_ALREADY_DONE TRUE)
ENDIF(NOT _ALREADY_DONE)
