// File: TimeCount.v
// Generated by MyHDL 0.7dev
// Date: Thu Sep 30 16:27:59 2010


`timescale 1ns/10ps

module TimeCount (
    tens,
    ones,
    tenths,
    startstop,
    reset,
    clock
);
// 3 digit time counter in seconds and tenths of a second.
// 
// tens: most significant digit of the seconds
// ones: least significant digit of the seconds
// tenths: tenths of a second
// startstop: input that starts or stops the counter on posedge
// reset: reset input
// clock: 10Hz clock input

output [3:0] tens;
reg [3:0] tens;
output [3:0] ones;
reg [3:0] ones;
output [3:0] tenths;
reg [3:0] tenths;
input startstop;
input reset;
input clock;






always @(posedge clock, posedge reset) begin: TIMECOUNT_LOGIC
    reg seen;
    reg counting;
    if (reset) begin
        tens <= 0;
        ones <= 0;
        tenths <= 0;
        seen = 1'b0;
        counting = 1'b0;
    end
    else begin
        if ((startstop && (!seen))) begin
            seen = 1'b1;
            counting = (!counting);
        end
        else if ((!startstop)) begin
            seen = 1'b0;
        end
        if (counting) begin
            if ((tenths == 9)) begin
                tenths <= 0;
                if ((ones == 9)) begin
                    ones <= 0;
                    if ((tens == 5)) begin
                        tens <= 0;
                    end
                    else begin
                        tens <= (tens + 1);
                    end
                end
                else begin
                    ones <= (ones + 1);
                end
            end
            else begin
                tenths <= (tenths + 1);
            end
        end
    end
end

endmodule
