/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.poi.poifs.dev.POIFSViewable;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.filesystem.DocumentOutputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.DocumentBlock;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.poifs.storage.RawDataBlock;
import org.apache.poi.poifs.storage.SmallDocumentBlock;
import org.apache.poi.util.HexDump;

public class POIFSDocument
implements BATManaged,
BlockWritable,
POIFSViewable {
    private DocumentProperty _property;
    private int _size;
    private SmallBlockStore _small_store;
    private BigBlockStore _big_store;

    public POIFSDocument(String string, RawDataBlock[] rawDataBlockArray, int n) throws IOException {
        this._size = n;
        this._big_store = new BigBlockStore(this, rawDataBlockArray);
        this._property = new DocumentProperty(string, this._size);
        this._small_store = new SmallBlockStore(this, new BlockWritable[0]);
        this._property.setDocument(this);
    }

    public POIFSDocument(String string, SmallDocumentBlock[] smallDocumentBlockArray, int n) {
        this._size = n;
        try {
            this._big_store = new BigBlockStore(this, new RawDataBlock[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._property = new DocumentProperty(string, this._size);
        this._small_store = new SmallBlockStore(this, smallDocumentBlockArray);
        this._property.setDocument(this);
    }

    public POIFSDocument(String string, ListManagedBlock[] listManagedBlockArray, int n) throws IOException {
        this._size = n;
        this._property = new DocumentProperty(string, this._size);
        this._property.setDocument(this);
        if (Property.isSmall(this._size)) {
            this._big_store = new BigBlockStore(this, new RawDataBlock[0]);
            this._small_store = new SmallBlockStore(this, listManagedBlockArray);
        } else {
            this._big_store = new BigBlockStore(this, listManagedBlockArray);
            this._small_store = new SmallBlockStore(this, new BlockWritable[0]);
        }
    }

    public POIFSDocument(String string, InputStream inputStream) throws IOException {
        Object[] objectArray;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        this._size = 0;
        do {
            int n;
            if ((n = (objectArray = new DocumentBlock(inputStream)).size()) <= 0) continue;
            arrayList.add(objectArray);
            this._size += n;
        } while (!objectArray.partiallyRead());
        objectArray = arrayList.toArray(new DocumentBlock[0]);
        this._big_store = new BigBlockStore(this, objectArray);
        this._property = new DocumentProperty(string, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(this, SmallDocumentBlock.convert((BlockWritable[])objectArray, this._size));
            this._big_store = new BigBlockStore(this, new DocumentBlock[0]);
        } else {
            this._small_store = new SmallBlockStore(this, new BlockWritable[0]);
        }
    }

    public POIFSDocument(String string, int n, POIFSDocumentPath pOIFSDocumentPath, POIFSWriterListener pOIFSWriterListener) throws IOException {
        this._size = n;
        this._property = new DocumentProperty(string, this._size);
        this._property.setDocument(this);
        if (this._property.shouldUseSmallBlocks()) {
            this._small_store = new SmallBlockStore(this, pOIFSDocumentPath, string, n, pOIFSWriterListener);
            this._big_store = new BigBlockStore(this, new Object[0]);
        } else {
            this._small_store = new SmallBlockStore(this, new BlockWritable[0]);
            this._big_store = new BigBlockStore(this, pOIFSDocumentPath, string, n, pOIFSWriterListener);
        }
    }

    public BlockWritable[] getSmallBlocks() {
        return this._small_store.getBlocks();
    }

    public int getSize() {
        return this._size;
    }

    void read(byte[] byArray, int n) {
        if (this._property.shouldUseSmallBlocks()) {
            SmallDocumentBlock.read(this._small_store.getBlocks(), byArray, n);
        } else {
            DocumentBlock.read(this._big_store.getBlocks(), byArray, n);
        }
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }

    public void writeBlocks(OutputStream outputStream) throws IOException {
        this._big_store.writeBlocks(outputStream);
    }

    public int countBlocks() {
        return this._big_store.countBlocks();
    }

    public void setStartBlock(int n) {
        this._property.setStartBlock(n);
    }

    public Object[] getViewableArray() {
        String string;
        Object[] objectArray = new Object[1];
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BlockWritable[] blockWritableArray = null;
            if (this._big_store.isValid()) {
                blockWritableArray = this._big_store.getBlocks();
            } else if (this._small_store.isValid()) {
                blockWritableArray = this._small_store.getBlocks();
            }
            if (blockWritableArray != null) {
                for (int i = 0; i < blockWritableArray.length; ++i) {
                    blockWritableArray[i].writeBlocks(byteArrayOutputStream);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray.length > this._property.getSize()) {
                    byte[] byArray2 = new byte[this._property.getSize()];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                    byArray = byArray2;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                HexDump.dump(byArray, 0L, byteArrayOutputStream, 0);
                string = byteArrayOutputStream.toString();
            } else {
                string = "<NO DATA>";
            }
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        objectArray[0] = string;
        return objectArray;
    }

    public Iterator getViewableIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean preferArray() {
        return true;
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Document: \"").append(this._property.getName()).append("\"");
        stringBuffer.append(" size = ").append(this.getSize());
        return stringBuffer.toString();
    }

    private class BigBlockStore {
        private DocumentBlock[] bigBlocks;
        private POIFSDocumentPath path;
        private String name;
        private int size;
        private POIFSWriterListener writer;

        BigBlockStore(POIFSDocument pOIFSDocument, Object[] objectArray) throws IOException {
            this.bigBlocks = new DocumentBlock[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.bigBlocks[i] = objectArray[i] instanceof DocumentBlock ? (DocumentBlock)objectArray[i] : new DocumentBlock((RawDataBlock)objectArray[i]);
            }
            this.path = null;
            this.name = null;
            this.size = -1;
            this.writer = null;
        }

        BigBlockStore(POIFSDocument pOIFSDocument, POIFSDocumentPath pOIFSDocumentPath, String string, int n, POIFSWriterListener pOIFSWriterListener) {
            this.bigBlocks = new DocumentBlock[0];
            this.path = pOIFSDocumentPath;
            this.name = string;
            this.size = n;
            this.writer = pOIFSWriterListener;
        }

        boolean isValid() {
            return this.bigBlocks.length > 0 || this.writer != null;
        }

        DocumentBlock[] getBlocks() {
            if (this.isValid() && this.writer != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size);
                DocumentOutputStream documentOutputStream = new DocumentOutputStream(byteArrayOutputStream, this.size);
                this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(documentOutputStream, this.path, this.name, this.size));
                this.bigBlocks = DocumentBlock.convert(byteArrayOutputStream.toByteArray(), this.size);
            }
            return this.bigBlocks;
        }

        void writeBlocks(OutputStream outputStream) throws IOException {
            if (this.isValid()) {
                if (this.writer != null) {
                    DocumentOutputStream documentOutputStream = new DocumentOutputStream(outputStream, this.size);
                    this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(documentOutputStream, this.path, this.name, this.size));
                    documentOutputStream.writeFiller(this.countBlocks() * 512, DocumentBlock.getFillByte());
                } else {
                    for (int i = 0; i < this.bigBlocks.length; ++i) {
                        this.bigBlocks[i].writeBlocks(outputStream);
                    }
                }
            }
        }

        int countBlocks() {
            int n = 0;
            if (this.isValid()) {
                n = this.writer != null ? (this.size + 512 - 1) / 512 : this.bigBlocks.length;
            }
            return n;
        }
    }

    private class SmallBlockStore {
        private SmallDocumentBlock[] smallBlocks;
        private POIFSDocumentPath path;
        private String name;
        private int size;
        private POIFSWriterListener writer;

        SmallBlockStore(POIFSDocument pOIFSDocument, Object[] objectArray) {
            this.smallBlocks = new SmallDocumentBlock[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.smallBlocks[i] = (SmallDocumentBlock)objectArray[i];
            }
            this.path = null;
            this.name = null;
            this.size = -1;
            this.writer = null;
        }

        SmallBlockStore(POIFSDocument pOIFSDocument, POIFSDocumentPath pOIFSDocumentPath, String string, int n, POIFSWriterListener pOIFSWriterListener) {
            this.smallBlocks = new SmallDocumentBlock[0];
            this.path = pOIFSDocumentPath;
            this.name = string;
            this.size = n;
            this.writer = pOIFSWriterListener;
        }

        boolean isValid() {
            return this.smallBlocks.length > 0 || this.writer != null;
        }

        BlockWritable[] getBlocks() {
            if (this.isValid() && this.writer != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size);
                DocumentOutputStream documentOutputStream = new DocumentOutputStream(byteArrayOutputStream, this.size);
                this.writer.processPOIFSWriterEvent(new POIFSWriterEvent(documentOutputStream, this.path, this.name, this.size));
                this.smallBlocks = SmallDocumentBlock.convert(byteArrayOutputStream.toByteArray(), this.size);
            }
            return this.smallBlocks;
        }
    }
}

