/*
 * Decompiled with CFR 0.152.
 */
package org.openamf;

import java.io.Serializable;

public class AMFBody
implements Serializable {
    protected String target;
    protected String serviceName;
    protected String serviceMethodName;
    protected String response;
    protected Object value;
    protected byte type;
    public static final byte DATA_TYPE_UNKNOWN = -1;
    public static final byte DATA_TYPE_NUMBER = 0;
    public static final byte DATA_TYPE_BOOLEAN = 1;
    public static final byte DATA_TYPE_STRING = 2;
    public static final byte DATA_TYPE_OBJECT = 3;
    public static final byte DATA_TYPE_MOVIE_CLIP = 4;
    public static final byte DATA_TYPE_NULL = 5;
    public static final byte DATA_TYPE_UNDEFINED = 6;
    public static final byte DATA_TYPE_REFERENCE_OBJECT = 7;
    public static final byte DATA_TYPE_MIXED_ARRAY = 8;
    public static final byte DATA_TYPE_OBJECT_END = 9;
    public static final byte DATA_TYPE_ARRAY = 10;
    public static final byte DATA_TYPE_DATE = 11;
    public static final byte DATA_TYPE_LONG_STRING = 12;
    public static final byte DATA_TYPE_AS_OBJECT = 13;
    public static final byte DATA_TYPE_RECORDSET = 14;
    public static final byte DATA_TYPE_XML = 15;
    public static final byte DATA_TYPE_CUSTOM_CLASS = 16;

    public AMFBody(String target, String response, Object value) {
        this(target, response, value, -1);
    }

    public AMFBody(String target, String response, Object value, byte type) {
        this.response = response;
        this.value = value;
        this.type = type;
        this.setTarget(target);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        int dotIndex = target.lastIndexOf(46);
        if (dotIndex > 0) {
            this.serviceName = target.substring(0, dotIndex);
            this.serviceMethodName = target.substring(dotIndex + 1);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceMethodName() {
        return this.serviceMethodName;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public static String getObjectTypeDescription(byte type) {
        switch (type) {
            case -1: {
                return "UNKNOWN";
            }
            case 0: {
                return "NUMBER";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 2: {
                return "STRING";
            }
            case 3: {
                return "OBJECT";
            }
            case 4: {
                return "MOVIECLIP";
            }
            case 5: {
                return "NULL";
            }
            case 6: {
                return "UNDEFINED";
            }
            case 7: {
                return "REFERENCE";
            }
            case 8: {
                return "MIXED_ARRAY";
            }
            case 9: {
                return "OBJECT_END";
            }
            case 10: {
                return "ARRAY";
            }
            case 11: {
                return "DATE";
            }
            case 12: {
                return "LONG_STRING";
            }
            case 13: {
                return "AS_OBJECT";
            }
            case 14: {
                return "RECORDSET";
            }
            case 15: {
                return "XML";
            }
            case 16: {
                return "CUSTOM_CLASS";
            }
        }
        return "UNKNOWN: 0x" + Integer.toBinaryString(type);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[AMFBody: {serviceName=");
        sb.append(this.getServiceName());
        sb.append(", serviceMethodName=");
        sb.append(this.getServiceMethodName());
        sb.append(", response=");
        sb.append(this.getResponse());
        sb.append(", type=");
        sb.append(AMFBody.getObjectTypeDescription(this.type));
        sb.append(", value=");
        sb.append(this.getValue());
        sb.append("}]");
        return sb.toString();
    }
}

