/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslException;
import java.io.UnsupportedEncodingException;

public class External
implements SaslClient {
    private byte[] username;
    private boolean completed = false;

    public External(String string) throws SaslException {
        if (string != null) {
            try {
                this.username = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("Cannot convert " + string + " into UTF-8", unsupportedEncodingException);
            }
        } else {
            this.username = new byte[0];
        }
    }

    public void dispose() throws SaslException {
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new SaslException("Already completed");
        }
        this.completed = true;
        return this.username;
    }

    public String getMechanismName() {
        return "EXTERNAL";
    }

    public String getNegotiatedProperty(String string) throws SaslException {
        if (this.completed) {
            return null;
        }
        throw new SaslException("Not completed");
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new SaslException("Not completed");
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("EXTERNAL has no supported QOP");
        }
        throw new SaslException("Not completed");
    }
}

