/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.views.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.lang.ref.SoftReference;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import org.icepdf.core.events.PaintPageEvent;
import org.icepdf.core.events.PaintPageListener;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.MemoryManager;
import org.icepdf.core.views.DocumentView;
import org.icepdf.core.views.DocumentViewController;
import org.icepdf.core.views.DocumentViewModel;
import org.icepdf.core.views.swing.AbstractPageViewComponent;

public class PageViewComponentImpl
extends AbstractPageViewComponent
implements PaintPageListener,
MouseInputListener,
FocusListener,
ComponentListener {
    private static final Logger logger;
    private static boolean isInteractiveAnnotationsEnabled;
    private static Color pageColor;
    private static Color annotationHighlightColor;
    private static float annotationHighlightAlpha;
    private PageTree pageTree;
    private JScrollPane parentScrollPane;
    private int pageIndex;
    private Rectangle pageSize = new Rectangle();
    private Rectangle defaultPageSize = new Rectangle();
    private boolean isPageSizeCalculated = false;
    private float currentZoom;
    private float currentRotation;
    private int mediaBox = 2;
    protected DocumentView parentDocumentView;
    protected DocumentViewModel documentViewModel;
    protected DocumentViewController documentViewController;
    private SoftReference<Image> bufferedPageImageReference;
    private Rectangle bufferedPageImageBounds = new Rectangle();
    private Timer isDirtyTimer;
    private PageInitilizer pageInitilizer;
    private PagePainter pagePainter;
    private final Object paintCopyAreaLock = new Object();
    private boolean disposing = false;
    private Rectangle clipBounds;
    private Rectangle oldClipBounds;
    private boolean inited;
    private static double verticalScaleFactor;
    private static double horizontalScaleFactor;
    private Annotation currentAnnotation;
    private boolean isMousePressed = false;

    public PageViewComponentImpl(DocumentViewModel documentViewModel, PageTree pageTree, int n, JScrollPane jScrollPane) {
        this(documentViewModel, pageTree, n, jScrollPane, 0, 0);
    }

    public PageViewComponentImpl(DocumentViewModel documentViewModel, PageTree pageTree, int n, JScrollPane jScrollPane, int n2, int n3) {
        this.documentViewModel = documentViewModel;
        this.parentScrollPane = jScrollPane;
        this.currentRotation = documentViewModel.getViewRotation();
        this.currentZoom = documentViewModel.getViewRotation();
        this.pageTree = pageTree;
        this.pageIndex = n;
        this.clipBounds = new Rectangle();
        this.oldClipBounds = new Rectangle();
        this.bufferedPageImageReference = new SoftReference<Object>(null);
        if (n2 == 0 && n3 == 0) {
            this.calculatePageSize(this.pageSize);
            this.isPageSizeCalculated = true;
        } else {
            this.pageSize.setSize(n2, n3);
            this.defaultPageSize.setSize(n2, n3);
        }
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.addPageRepaintListener();
        DirtyTimerAction dirtyTimerAction = new DirtyTimerAction();
        this.isDirtyTimer = new Timer(250, dirtyTimerAction);
        this.isDirtyTimer.setInitialDelay(0);
        this.pageInitilizer = new PageInitilizer();
        this.pagePainter = new PagePainter();
    }

    public void invalidatePage() {
        if (this.inited) {
            Page page = this.pageTree.getPage(this.pageIndex, this);
            page.getLibrary().disposeFontResources();
            page.reduceMemory();
            this.pageTree.releasePage(page, (Object)this);
            this.currentZoom = -1.0f;
        }
    }

    public void dispose() {
        Image image;
        this.disposing = true;
        if (this.isDirtyTimer != null) {
            this.isDirtyTimer.stop();
        }
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeComponentListener(this);
        this.removePageRepaintListener();
        if (this.bufferedPageImageReference != null && (image = this.bufferedPageImageReference.get()) != null) {
            image.flush();
        }
        this.inited = false;
    }

    public void setDocumentViewCallback(DocumentView documentView) {
        this.parentDocumentView = documentView;
        this.documentViewController = this.parentDocumentView.getParentViewController();
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setMediaType(int n) {
        this.mediaBox = n;
    }

    public Dimension getPreferredSize() {
        return this.pageSize.getSize();
    }

    public void invalidate() {
        this.calculateRoughPageSize(this.pageSize);
        if (this.pagePainter != null) {
            this.pagePainter.setIsBufferDirty(true);
        }
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        if (!this.inited) {
            this.init();
        }
        if (!this.isPageSizeCalculated) {
            this.calculatePageSize(this.pageSize);
            this.invalidate();
        } else if (this.isPageStateDirty()) {
            this.calculatePageSize(this.pageSize);
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create(0, 0, this.pageSize.width, this.pageSize.height);
        graphics2D.setColor(pageColor);
        graphics2D.fillRect(0, 0, this.pageSize.width, this.pageSize.height);
        if (this.isPageIntersectViewport() && !this.isDirtyTimer.isRunning()) {
            this.isDirtyTimer.start();
        }
        if (this.parentScrollPane == null) {
            this.oldClipBounds.setBounds(this.clipBounds);
            this.clipBounds.setBounds(graphics2D.getClipBounds());
            if (this.oldClipBounds.width == 0 && this.oldClipBounds.height == 0) {
                this.oldClipBounds.setBounds(this.clipBounds);
            }
        }
        if (this.bufferedPageImageReference != null) {
            Vector vector;
            Object object;
            Image image = this.bufferedPageImageReference.get();
            if (image != null && !this.isPageStateDirty()) {
                object = this.paintCopyAreaLock;
                synchronized (object) {
                    graphics2D.drawImage(image, this.bufferedPageImageBounds.x, this.bufferedPageImageBounds.y, this);
                }
            } else {
                this.currentZoom = -1.0f;
            }
            if ((object = this.pageTree.getPage(this.pageIndex, this)) != null && ((Page)object).isInitiated() && (vector = ((Page)object).getAnnotations()) != null) {
                Graphics2D graphics2D2 = (Graphics2D)graphics;
                AffineTransform affineTransform = ((Page)object).getPageTransform(this.mediaBox, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
                graphics2D2.transform(affineTransform);
                for (Object e : vector) {
                    Object e2 = e;
                    if (!(e2 instanceof Annotation)) continue;
                    Annotation annotation = (Annotation)e2;
                    annotation.render(graphics2D2, 1, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom(), false);
                }
                if (this.currentAnnotation != null && this.currentAnnotation.allowScreenRolloverMode() && this.isMousePressed && this.currentAnnotation instanceof LinkAnnotation) {
                    LinkAnnotation linkAnnotation = (LinkAnnotation)this.currentAnnotation;
                    int n = linkAnnotation.getHighlightMode();
                    if (n == 1) {
                        Rectangle2D.Float float_ = this.currentAnnotation.getUserSpaceRectangle();
                        graphics2D2.setColor(annotationHighlightColor);
                        graphics2D2.setComposite(AlphaComposite.getInstance(3, annotationHighlightAlpha));
                        graphics2D2.fillRect((int)((RectangularShape)float_).getX(), (int)((RectangularShape)float_).getY(), (int)((RectangularShape)float_).getWidth(), (int)((RectangularShape)float_).getHeight());
                    } else if (n == 2) {
                        Rectangle2D.Float float_ = this.currentAnnotation.getUserSpaceRectangle();
                        graphics2D2.setColor(annotationHighlightColor);
                        graphics2D2.setComposite(AlphaComposite.getInstance(3, annotationHighlightAlpha));
                        graphics2D2.drawRect((int)((RectangularShape)float_).getX(), (int)((RectangularShape)float_).getY(), (int)((RectangularShape)float_).getWidth(), (int)((RectangularShape)float_).getHeight());
                    } else if (n == 3) {
                        Rectangle2D.Float float_ = this.currentAnnotation.getUserSpaceRectangle();
                        graphics2D2.setColor(annotationHighlightColor);
                        graphics2D2.setComposite(AlphaComposite.getInstance(3, annotationHighlightAlpha));
                        graphics2D2.drawRect((int)((RectangularShape)float_).getX(), (int)((RectangularShape)float_).getY(), (int)((RectangularShape)float_).getWidth(), (int)((RectangularShape)float_).getHeight());
                    }
                }
            }
            this.pageTree.releasePage((Page)object, (Object)this);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.documentViewModel.getViewToolMode() == 2) {
            Point point = mouseEvent.getPoint();
            Point point2 = this.documentViewModel.getPageBounds(this.pageIndex).getLocation();
            point.setLocation(point.x + point2.x, point.y + point2.y);
            this.documentViewController.setZoomIn(point);
        } else if (this.documentViewModel.getViewToolMode() == 3) {
            Point point = mouseEvent.getPoint();
            this.documentViewController.setZoomOut(point);
        }
        if (this.currentAnnotation != null && this.documentViewController.getAnnotationCallback() != null) {
            this.documentViewController.getAnnotationCallback().proccessAnnotationAction(this.currentAnnotation);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point point2 = this.getLocation();
        point.setLocation(point.x + point2.x, point.y + point2.y);
        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        if (this.currentAnnotation == null && this.parentDocumentView != null) {
            this.parentDocumentView.mousePressed(mouseEvent2);
        }
        this.isMousePressed = true;
        if (this.currentAnnotation != null) {
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.currentAnnotation == null && this.parentDocumentView != null) {
            this.parentDocumentView.mouseReleased(mouseEvent);
        }
        this.isMousePressed = false;
        if (this.currentAnnotation != null) {
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.parentDocumentView != null) {
            this.parentDocumentView.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Vector vector;
        Page page;
        if (this.parentDocumentView != null) {
            this.parentDocumentView.mouseMoved(mouseEvent);
        }
        if ((page = this.pageTree.getPage(this.pageIndex, this)) != null && page.isInitiated() && isInteractiveAnnotationsEnabled && (vector = page.getAnnotations()) != null) {
            AffineTransform affineTransform = page.getPageTransform(this.mediaBox, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            Point point = mouseEvent.getPoint();
            try {
                affineTransform.inverseTransform(point, point);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
            for (Object e : vector) {
                Object e2 = e;
                if (!(e2 instanceof Annotation)) continue;
                Annotation annotation = (Annotation)e2;
                if (annotation.getUserSpaceRectangle().contains(point.getX(), point.getY())) {
                    this.currentAnnotation = annotation;
                    this.documentViewController.setViewCursor(9);
                    this.repaint();
                    break;
                }
                this.currentAnnotation = null;
            }
            if (this.currentAnnotation == null) {
                int n = this.documentViewModel.getViewToolMode();
                if (n == 1) {
                    this.documentViewController.setViewCursor(1);
                } else if (n == 2) {
                    this.documentViewController.setViewCursor(3);
                } else if (n == 3) {
                    this.documentViewController.setViewCursor(4);
                }
                this.repaint();
            }
        }
        this.pageTree.releasePage(page, (Object)this);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private void calculateRoughPageSize(Rectangle rectangle) {
        float f = this.defaultPageSize.width;
        float f2 = this.defaultPageSize.height;
        float f3 = this.documentViewModel.getViewRotation();
        if (f3 != 0.0f && f3 != 180.0f) {
            if (f3 == 90.0f || f3 == 270.0f) {
                float f4 = f;
                f = f2;
                f2 = f4;
            } else {
                AffineTransform affineTransform = new AffineTransform();
                double d = Math.toRadians(f3);
                affineTransform.rotate(d);
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                Point2D.Double double_2 = new Point2D.Double();
                Point2D.Double double_3 = new Point2D.Double();
                double_2.setLocation(0.0, f2);
                affineTransform.transform(double_2, double_3);
                double_.add(double_3);
                double_2.setLocation(f, f2);
                affineTransform.transform(double_2, double_3);
                double_.add(double_3);
                double_2.setLocation(0.0, 0.0);
                affineTransform.transform(double_2, double_3);
                double_.add(double_3);
                double_2.setLocation(f, 0.0);
                affineTransform.transform(double_2, double_3);
                double_.add(double_3);
                f = (float)double_.getWidth();
                f2 = (float)double_.getHeight();
            }
        }
        rectangle.setSize((int)(f * this.documentViewModel.getViewZoom()), (int)(f2 * this.documentViewModel.getViewZoom()));
    }

    private void calculatePageSize(Rectangle rectangle) {
        if (this.pageTree != null) {
            Page page = this.pageTree.getPage(this.pageIndex, this);
            if (page != null) {
                rectangle.setSize(page.getSize(this.mediaBox, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom()).toDimension());
                this.defaultPageSize.setSize(page.getSize(this.mediaBox, 0.0f, 1.0f).toDimension());
            }
            this.pageTree.releasePage(page, (Object)this);
        }
    }

    private boolean isBufferDirty() {
        if (this.disposing) {
            return false;
        }
        if (this.pageSize.height <= this.clipBounds.height && this.pageSize.width <= this.clipBounds.width) {
            return false;
        }
        Rectangle rectangle = new Rectangle(this.clipBounds);
        if (this.parentScrollPane != null) {
            rectangle.setBounds(this.parentScrollPane.getViewport().getViewRect());
        }
        Rectangle rectangle2 = this.documentViewModel.getPageBounds(this.pageIndex);
        Rectangle rectangle3 = new Rectangle(this.bufferedPageImageBounds);
        rectangle3.x += rectangle2.x;
        rectangle3.y += rectangle2.y;
        return !rectangle3.contains(rectangle2.intersection(rectangle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBufferedPageImage(PagePainter pagePainter) {
        double d;
        if (this.disposing) {
            return;
        }
        boolean bl = this.isPageStateDirty();
        this.currentRotation = this.documentViewModel.getViewRotation();
        this.currentZoom = this.documentViewModel.getViewZoom();
        Image image = this.bufferedPageImageReference.get();
        if (bl && image != null) {
            image.flush();
        }
        Rectangle rectangle = new Rectangle(this.bufferedPageImageBounds);
        Rectangle rectangle2 = this.documentViewModel.getPageBounds(this.pageIndex);
        if (this.parentScrollPane != null) {
            this.oldClipBounds.setBounds(this.clipBounds);
            this.clipBounds.setBounds(this.parentScrollPane.getViewport().getViewRect());
            if (this.oldClipBounds.width == 0 && this.oldClipBounds.height == 0) {
                this.oldClipBounds.setBounds(this.clipBounds);
            }
        }
        this.bufferedPageImageBounds.setBounds(rectangle2.intersection(this.clipBounds));
        if (this.pageSize.width <= this.clipBounds.width) {
            this.bufferedPageImageBounds.x = 0;
            this.bufferedPageImageBounds.width = this.pageSize.width;
        } else {
            if (horizontalScaleFactor > 1.0) {
                d = (double)this.clipBounds.width * horizontalScaleFactor / 2.0;
                this.bufferedPageImageBounds.x = (int)((double)this.clipBounds.x - d);
                this.bufferedPageImageBounds.width = (int)((double)this.clipBounds.width + d * 2.0);
            } else {
                this.bufferedPageImageBounds.width = this.clipBounds.width;
            }
            this.bufferedPageImageBounds.x -= rectangle2.x;
        }
        if (this.pageSize.height <= this.clipBounds.height) {
            this.bufferedPageImageBounds.y = 0;
            this.bufferedPageImageBounds.height = this.clipBounds.height;
        } else {
            if (verticalScaleFactor > 1.0) {
                d = (double)this.clipBounds.height * verticalScaleFactor / 2.0;
                this.bufferedPageImageBounds.y = (int)((double)this.clipBounds.y - d);
                this.bufferedPageImageBounds.height = (int)((double)this.clipBounds.height + d * 2.0);
            } else {
                this.bufferedPageImageBounds.height = this.clipBounds.height;
            }
            this.bufferedPageImageBounds.y -= rectangle2.y;
        }
        image = this.bufferedPageImageReference.get();
        if (bl || image == null) {
            if (image != null) {
                image.flush();
            }
            int n = this.bufferedPageImageBounds.width * this.bufferedPageImageBounds.height * 3;
            if (MemoryManager.getInstance().checkMemory(n)) {
                GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
                if (graphicsConfiguration != null && this.isShowing()) {
                    image = graphicsConfiguration.createCompatibleImage(this.bufferedPageImageBounds.width, this.bufferedPageImageBounds.height);
                    Graphics graphics = image.getGraphics();
                    graphics.setColor(pageColor);
                    graphics.fillRect(0, 0, this.pageSize.width, this.pageSize.height);
                }
                this.bufferedPageImageReference = new SoftReference<Image>(image);
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.info("Error creating buffer, not enough memory: page " + this.pageIndex);
                }
                this.currentZoom = -1.0f;
            }
            pagePainter.setIsBufferDirty(false);
        }
        if (this.bufferedPageImageBounds.x < 0) {
            this.bufferedPageImageBounds.x = 0;
        }
        if (this.bufferedPageImageBounds.x + this.bufferedPageImageBounds.width > this.pageSize.width) {
            this.bufferedPageImageBounds.width = this.pageSize.width - this.bufferedPageImageBounds.x;
        }
        if (this.bufferedPageImageBounds.y < 0) {
            this.bufferedPageImageBounds.y = 0;
        }
        if (this.bufferedPageImageBounds.y + this.bufferedPageImageBounds.height > this.pageSize.height) {
            this.bufferedPageImageBounds.height = this.pageSize.height - this.bufferedPageImageBounds.y;
        }
        if (image != null) {
            Object object;
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            graphics2D.setClip(new Rectangle(0, 0, this.bufferedPageImageBounds.width, this.bufferedPageImageBounds.height));
            int n = 0 - this.bufferedPageImageBounds.x;
            int n2 = 0 - this.bufferedPageImageBounds.y;
            Object object2 = this.paintCopyAreaLock;
            synchronized (object2) {
                object = new Rectangle(this.clipBounds);
                ((Rectangle)object).x -= rectangle2.x;
                ((Rectangle)object).y -= rectangle2.y;
                if (!pagePainter.isLastPaintDirty() && pagePainter.isBufferDirty() && this.bufferedPageImageBounds.intersects(rectangle)) {
                    Rectangle rectangle3 = this.bufferedPageImageBounds.intersection(rectangle);
                    rectangle3 = rectangle3.intersection((Rectangle)object);
                    int n3 = 0 - rectangle.x;
                    int n4 = 0 - rectangle.y;
                    int n5 = rectangle.x - this.bufferedPageImageBounds.x;
                    int n6 = rectangle.y - this.bufferedPageImageBounds.y;
                    graphics2D.copyArea(rectangle3.x + n3, rectangle3.y + n4, rectangle3.width, rectangle3.height, n5, n6);
                    Area area = new Area(rectangle3);
                    Area area2 = new Area(this.bufferedPageImageBounds);
                    area2.subtract(area);
                    graphics2D.translate(n, n2);
                    graphics2D.setClip(area2);
                    graphics2D.translate(-n, -n2);
                } else {
                    graphics2D.translate(n, n2);
                    graphics2D.setClip(this.bufferedPageImageBounds);
                    graphics2D.translate(-n, -n2);
                }
                graphics2D.translate(n, n2);
                graphics2D.setColor(pageColor);
                graphics2D.fillRect(this.bufferedPageImageBounds.x, this.bufferedPageImageBounds.y, this.bufferedPageImageBounds.width, this.bufferedPageImageBounds.height);
            }
            if (this.pageTree != null) {
                object2 = this.pageTree.getPage(this.pageIndex, this);
                ((Page)object2).paint(graphics2D, 1, this.mediaBox, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom(), pagePainter, false);
                this.pageTree.releasePage((Page)object2, (Object)this);
                if (pagePainter.isStopPaintingRequested()) {
                    pagePainter.setIsLastPaintDirty(true);
                } else {
                    pagePainter.setIsLastPaintDirty(false);
                    pagePainter.setIsBufferDirty(false);
                }
                object = new Runnable(){

                    public void run() {
                        if (!PageViewComponentImpl.this.disposing) {
                            PageViewComponentImpl.this.repaint();
                        }
                    }
                };
                SwingUtilities.invokeLater((Runnable)object);
            }
            graphics2D.dispose();
        }
    }

    private void addPageRepaintListener() {
        Page page = this.pageTree.getPage(this.pageIndex, this);
        if (page != null) {
            page.addPaintPageListener(this);
        }
        this.pageTree.releasePage(page, (Object)this);
    }

    private void removePageRepaintListener() {
        if (this.inited) {
            Page page = this.pageTree.getPage(this.pageIndex, this);
            if (page != null) {
                page.removePaintPageListener(this);
            }
            this.pageTree.releasePage(page, (Object)this);
        }
    }

    private boolean isPageStateDirty() {
        return this.currentZoom != this.documentViewModel.getViewZoom() || this.currentRotation != this.documentViewModel.getViewRotation() || this.oldClipBounds.width != this.clipBounds.width || this.oldClipBounds.height != this.clipBounds.height;
    }

    private boolean isPageIntersectViewport() {
        Rectangle rectangle = this.documentViewModel.getPageBounds(this.pageIndex);
        return rectangle != null && rectangle.intersects(this.parentScrollPane.getViewport().getViewRect());
    }

    public void paintPage(PaintPageEvent paintPageEvent) {
        Object object = paintPageEvent.getSource();
        Page page = this.pageTree.getPage(this.pageIndex, this);
        if (page.equals(object)) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (!PageViewComponentImpl.this.disposing) {
                        PageViewComponentImpl.this.repaint();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        this.pageTree.releasePage(page, (Object)this);
    }

    static {
        String string;
        block9: {
            int n;
            logger = Logger.getLogger(PageViewComponentImpl.class.toString());
            isInteractiveAnnotationsEnabled = Defs.sysPropertyBoolean("org.icepdf.core.annotations.interactive.enabled", true);
            try {
                string = Defs.sysProperty("org.icepdf.core.views.page.paper.color", "#FFFFFF");
                n = ColorUtil.convertNamedColor(string);
                pageColor = new Color(n > 0 ? n : Integer.parseInt("FFFFFF", 16));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("Error reading page paper color.");
            }
            try {
                string = Defs.sysProperty("org.icepdf.core.views.page.annotation.highlight.color", "#000000");
                n = ColorUtil.convertColor(string);
                annotationHighlightColor = new Color(n > 0 ? n : Integer.parseInt("000000", 16));
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.WARNING)) break block9;
                logger.warning("Error reading page annotation highlight colour");
            }
        }
        try {
            string = Defs.sysProperty("org.icepdf.core.views.page.annotation.highlight.alpha", "0.4");
            annotationHighlightAlpha = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Error reading page annotation highlight alpha");
            }
            annotationHighlightAlpha = 0.4f;
        }
        try {
            verticalScaleFactor = Double.parseDouble(Defs.sysProperty("org.icepdf.core.views.buffersize.vertical", "1.0"));
            horizontalScaleFactor = Double.parseDouble(Defs.sysProperty("org.icepdf.core.views.buffersize.horizontal", "1.0"));
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("Error reading buffered scale factor");
        }
    }

    private class DirtyTimerAction
    implements ActionListener {
        private DirtyTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PageViewComponentImpl.this.disposing || !PageViewComponentImpl.this.isPageIntersectViewport()) {
                PageViewComponentImpl.this.isDirtyTimer.stop();
                if (PageViewComponentImpl.this.pagePainter.isRunning()) {
                    PageViewComponentImpl.this.pagePainter.stopPaintingPage();
                    PageViewComponentImpl.this.currentZoom = -1.0f;
                }
                return;
            }
            if (!PageViewComponentImpl.this.disposing) {
                Page page;
                block12: {
                    block11: {
                        if (PageViewComponentImpl.this.parentScrollPane != null && PageViewComponentImpl.this.parentScrollPane.getVerticalScrollBar().getValueIsAdjusting()) {
                            return;
                        }
                        page = PageViewComponentImpl.this.pageTree.getPage(PageViewComponentImpl.this.pageIndex, this);
                        if (!(page == null || page.isInitiated() || PageViewComponentImpl.this.pageInitilizer.isRunning() || PageViewComponentImpl.this.pageInitilizer.hasBeenQueued())) {
                            try {
                                PageViewComponentImpl.this.pageInitilizer.setHasBeenQueued(true);
                                PageViewComponentImpl.this.documentViewModel.executePageInitialization(PageViewComponentImpl.this.pageInitilizer);
                            }
                            catch (InterruptedException interruptedException) {
                                PageViewComponentImpl.this.pageInitilizer.setHasBeenQueued(false);
                                if (!logger.isLoggable(Level.FINE)) break block11;
                                logger.fine("Page Initialization Interrupted: " + PageViewComponentImpl.this.pageIndex);
                            }
                        }
                    }
                    boolean bl = PageViewComponentImpl.this.isBufferDirty();
                    if (page != null && !PageViewComponentImpl.this.pageInitilizer.isRunning() && page.isInitiated() && !PageViewComponentImpl.this.pagePainter.isRunning() && !PageViewComponentImpl.this.pagePainter.hasBeenQueued() && (PageViewComponentImpl.this.isPageStateDirty() || bl)) {
                        try {
                            PageViewComponentImpl.this.pagePainter.setHasBeenQueued(true);
                            PageViewComponentImpl.this.pagePainter.setIsBufferDirty(bl);
                            PageViewComponentImpl.this.documentViewModel.executePagePainter(PageViewComponentImpl.this.pagePainter);
                        }
                        catch (InterruptedException interruptedException) {
                            PageViewComponentImpl.this.pagePainter.setHasBeenQueued(false);
                            if (!logger.isLoggable(Level.FINE)) break block12;
                            logger.fine("Page Painter Interrupted: " + PageViewComponentImpl.this.pageIndex);
                        }
                    }
                }
                if (page != null && !PageViewComponentImpl.this.pageInitilizer.isRunning() && page.isInitiated() && !PageViewComponentImpl.this.pagePainter.hasBeenQueued() && PageViewComponentImpl.this.pagePainter.isRunning() && PageViewComponentImpl.this.isPageStateDirty()) {
                    PageViewComponentImpl.this.pagePainter.stopPaintingPage();
                }
                PageViewComponentImpl.this.pageTree.releasePage(page, (Object)this);
            }
        }
    }

    private class PageInitilizer
    implements Runnable {
        private boolean isRunning;
        private final Object isRunningLock = new Object();
        private boolean hasBeenQueued;

        private PageInitilizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.isRunning = true;
            }
            try {
                object = PageViewComponentImpl.this.pageTree.getPage(PageViewComponentImpl.this.pageIndex, this);
                ((Page)object).init();
                if (PageViewComponentImpl.this.documentViewController.getAnnotationCallback() != null) {
                    PageViewComponentImpl.this.documentViewController.getAnnotationCallback().pageAnnotationsInitialized((Page)object);
                }
                PageViewComponentImpl.this.pageTree.releasePage((Page)object, (Object)this);
            }
            catch (Throwable throwable) {
                logger.log(Level.FINE, "Error initiating page: " + PageViewComponentImpl.this.pageIndex, throwable);
                PageViewComponentImpl.this.pageInitilizer.setHasBeenQueued(true);
                return;
            }
            object = this.isRunningLock;
            synchronized (object) {
                PageViewComponentImpl.this.pageInitilizer.setHasBeenQueued(false);
                this.isRunning = false;
            }
        }

        public boolean hasBeenQueued() {
            return this.hasBeenQueued;
        }

        public void setHasBeenQueued(boolean bl) {
            this.hasBeenQueued = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.isRunning;
            }
        }
    }

    public class PagePainter
    implements Runnable {
        private boolean isRunning;
        private boolean isLastPaintDirty;
        private boolean isBufferyDirty;
        private boolean isStopRequested;
        private final Object isRunningLock = new Object();
        private boolean hasBeenQueued;

        public synchronized boolean isLastPaintDirty() {
            return this.isLastPaintDirty;
        }

        public void setIsLastPaintDirty(boolean bl) {
            this.isLastPaintDirty = bl;
        }

        public void setIsBufferDirty(boolean bl) {
            this.isBufferyDirty = bl;
        }

        public boolean isBufferDirty() {
            return this.isBufferyDirty;
        }

        public boolean isStopPaintingRequested() {
            return this.isStopRequested;
        }

        public synchronized void stopPaintingPage() {
            this.isStopRequested = true;
            this.isLastPaintDirty = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.isRunning = true;
                this.hasBeenQueued = false;
            }
            try {
                PageViewComponentImpl.this.createBufferedPageImage(this);
            }
            catch (Throwable throwable) {
                logger.log(Level.FINE, "Error creating buffer, page: " + PageViewComponentImpl.this.pageIndex, throwable);
                PageViewComponentImpl.this.currentZoom = -1.0f;
            }
            object = this.isRunningLock;
            synchronized (object) {
                this.isStopRequested = false;
                this.isRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasBeenQueued() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.hasBeenQueued;
            }
        }

        public void setHasBeenQueued(boolean bl) {
            this.hasBeenQueued = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.isRunning;
            }
        }
    }
}

