/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.StringTokenizer;
import org.icepdf.core.pobjects.security.SecurityManager;

public class PDate {
    private static final int OFFSET_YYYY = 4;
    private static final int OFFSET_MM = 2;
    private static final int OFFSET_DD = 2;
    private static final int OFFSET_HH = 2;
    private static final int OFFSET_mm = 2;
    private static final int OFFSET_SS = 2;
    private static final int OFFSET_0 = 1;
    private static final String DATE_PREFIX = "D:";
    private static String[] monthNames = new String[]{"", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private String year = "";
    private String month = "";
    private String day = "";
    private String hour = "";
    private String minute = "";
    private String second = "";
    private String timeZoneOffset = "";
    private String timeZoneHour = "";
    private String timeZoneMinute = "";
    private boolean notStandardFormat = false;

    public PDate(SecurityManager securityManager, String string) {
        if (string != null) {
            this.parseDate(string);
        }
    }

    public String getYear() {
        return this.year;
    }

    public String getMonth() {
        return this.month;
    }

    public String getDay() {
        return this.day;
    }

    public String getHour() {
        return this.hour;
    }

    public String getMinute() {
        return this.minute;
    }

    public String getSecond() {
        return this.second;
    }

    public String getTimeZoneHour() {
        return this.timeZoneHour;
    }

    public String getTimeZoneMinute() {
        return this.timeZoneMinute;
    }

    public boolean getTimeZoneOffset() {
        return !"-".equals(this.timeZoneOffset);
    }

    public String toString() {
        if (!this.notStandardFormat) {
            StringBuffer stringBuffer = new StringBuffer(40);
            if (this.getMonth(this.month).length() > 0) {
                stringBuffer.append(this.getMonth(this.month));
            }
            if (this.day.length() > 0) {
                stringBuffer.append(" ").append(this.day);
            }
            if (this.year.length() > 0) {
                stringBuffer.append(", ").append(this.year);
            }
            if (this.hour.length() > 0) {
                stringBuffer.append(" ").append(this.hour);
            }
            if (this.minute.length() > 0) {
                stringBuffer.append(":").append(this.minute);
            }
            if (this.second.length() > 0) {
                stringBuffer.append(":").append(this.second);
            }
            if (this.timeZoneOffset.length() > 0) {
                if (this.timeZoneOffset.equalsIgnoreCase("Z")) {
                    stringBuffer.append(" (UTC)");
                } else {
                    stringBuffer.append(" (UTC ").append(this.timeZoneOffset);
                    if (this.timeZoneHour.length() > 0) {
                        stringBuffer.append("").append(this.timeZoneHour);
                    }
                    if (this.timeZoneMinute.length() > 0) {
                        stringBuffer.append(":").append(this.timeZoneMinute);
                    }
                    stringBuffer.append(")");
                }
            }
            return stringBuffer.toString();
        }
        return this.day;
    }

    private void parseDate(String string) {
        if (string.indexOf(DATE_PREFIX) >= 0) {
            string = string.substring(2);
            this.parseAdobeDate(string);
        } else if (string.indexOf("/") >= 0) {
            this.parseGhostScriptDate(string);
        } else {
            this.year = string;
            this.month = string;
            this.day = string;
            this.hour = string;
            this.minute = string;
            this.second = string;
            this.timeZoneOffset = string;
            this.timeZoneHour = string;
            this.timeZoneMinute = string;
            this.notStandardFormat = true;
        }
    }

    private void parseGhostScriptDate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "/");
        StringTokenizer stringTokenizer3 = new StringTokenizer(stringTokenizer.nextToken(), ":");
        this.month = stringTokenizer2.nextToken();
        this.day = stringTokenizer2.nextToken();
        this.year = stringTokenizer2.nextToken();
        this.hour = stringTokenizer3.nextToken();
        this.minute = stringTokenizer3.nextToken();
        this.second = stringTokenizer3.nextToken();
    }

    private void parseAdobeDate(String string) {
        int n = 0;
        int n2 = 0;
        if (n + 4 <= string.length()) {
            n2 = n + 4;
            this.year = string.substring(n, n2);
            n += n2;
        }
        if (n + 2 <= string.length()) {
            n2 = n + 2;
            this.month = string.substring(n, n2);
            n += 2;
        }
        if (n + 2 <= string.length()) {
            n2 = n + 2;
            this.day = string.substring(n, n2);
            n += 2;
        }
        if (n + 2 <= string.length()) {
            n2 = n + 2;
            this.hour = string.substring(n, n2);
            n += 2;
        }
        if (n + 2 <= string.length()) {
            n2 = n + 2;
            this.minute = string.substring(n, n2);
            n += 2;
        }
        if (n + 2 <= string.length()) {
            n2 = n + 2;
            this.second = string.substring(n, n2);
            n += 2;
        }
        if (n + 1 <= string.length()) {
            n2 = n + 1;
            this.timeZoneOffset = string.substring(n, n2);
            ++n;
        }
        if (n + 2 <= string.length()) {
            n2 = n + 2;
            this.timeZoneHour = string.substring(n, n2);
            n += 2;
        }
        if (n + 4 <= string.length()) {
            this.timeZoneMinute = string.substring(n + 1, n + 3);
        }
    }

    private String getMonth(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return monthNames[n];
    }
}

