/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.video.mpeg4.mp42;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sourceforge.jffmpeg.JMFCodec;
import net.sourceforge.jffmpeg.codecs.utils.FFMpegException;
import net.sourceforge.jffmpeg.codecs.utils.VLCTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.Mpeg4;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.mbtables.InterIntraVlc;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.mbtables.IntraMacroBlock;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.mbtables.NonIntraMacroBlock;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.motiontables.MVTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.motiontables.MVTable0;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.motiontables.MVTable1;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.rltables.InterRLTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.rltables.IntraRLTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.rltables.RLTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.rltables.RLTable0;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.rltables.RLTable1;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.rltables.RLTable2;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.rltables.RLTable4;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.tables.ScaleTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.tables.ScanTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.yuvtables.DiscreteCosineChrominanceVlc0;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.yuvtables.DiscreteCosineChrominanceVlc1;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.yuvtables.DiscreteCosineLuminanceVlc0;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.yuvtables.DiscreteCosineLuminanceVlc1;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.mp42.v2tables.V2CodedBlockPredictionY;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.mp42.v2tables.V2DiscreteCosineChrominance;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.mp42.v2tables.V2DiscreteCosineLuminance;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.mp42.v2tables.V2IntraBlockPrediction;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.mp42.v2tables.V2MacroBlockTypeVlc;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.mp42.v2tables.V2MoveTable;

public class MP42Codec
extends Mpeg4
implements Codec,
JMFCodec {
    private static final int MBAC_BITRATE = 51200;
    private static final VLCTable intraMacroBlock = new IntraMacroBlock();
    private static final VLCTable nonIntraMacroBlock = new NonIntraMacroBlock();
    private static final VLCTable interIntraVlc = new InterIntraVlc();
    private static final VLCTable[] dc_lum_vlc = new VLCTable[]{new DiscreteCosineLuminanceVlc0(), new DiscreteCosineLuminanceVlc1()};
    private static final VLCTable[] dc_chroma_vlc = new VLCTable[]{new DiscreteCosineChrominanceVlc0(), new DiscreteCosineChrominanceVlc1()};
    private static final MVTable[] moveTable = new MVTable[]{new MVTable0(), new MVTable1()};
    private static final RLTable[] rlTables = new RLTable[]{new RLTable0(), new RLTable2(), new IntraRLTable(), new RLTable1(), new RLTable4(), new InterRLTable()};
    private static final VLCTable v2_intra_cbpc_vlc = new V2IntraBlockPrediction();
    private static final VLCTable v2_mb_type_vlc = new V2MacroBlockTypeVlc();
    private static final VLCTable cbpy_vlc = new V2CodedBlockPredictionY();
    private static final VLCTable v2_mv_vlc = new V2MoveTable();
    private static final VLCTable v2_dc_lum_vlc = new V2DiscreteCosineLuminance();
    private static final VLCTable v2_dc_chrom_vlc = new V2DiscreteCosineChrominance();
    private VideoFormat inputFormat;
    private static final int[] motionOffset = new int[]{2, 1, 1, -1};

    private void memset(int[] nArray, int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            nArray[n++] = n3;
        }
    }

    protected void decodeFrame(byte[] byArray, int n) throws FFMpegException {
        int n2;
        if (n < 16) {
            return;
        }
        this.in.setData(byArray, n);
        this.pictType = this.in.getBits(2) + 1;
        this.qscale = this.in.getBits(5);
        if (this.pictType == 1) {
            n2 = this.in.getBits(5);
            this.sliceHeight = this.mbHeight / (n2 - 22);
            this.rlChromaTableIndex = 2;
            this.rlTableIndex = 2;
            this.dcTableIndex = 0;
            this.interIntraPred = false;
            this.no_rounding = true;
        } else {
            this.use_skip_mb_code = this.in.getTrueFalse();
            this.rlChromaTableIndex = 2;
            this.rlTableIndex = 2;
            this.dcTableIndex = 0;
            this.mv_table_index = 0;
            this.no_rounding = this.flipFlopRounding ? !this.no_rounding : false;
        }
        for (n2 = 0; n2 < this.mbHeight; ++n2) {
            this.blockIndex[0] = this.blockWrap[0] * (n2 * 2 + 1) - 1;
            this.blockIndex[1] = this.blockIndex[0] + 1;
            this.blockIndex[2] = this.blockIndex[0] + this.blockWrap[0];
            this.blockIndex[3] = this.blockIndex[2] + 1;
            this.blockIndex[4] = this.blockWrap[0] * (this.mbHeight * 2 + 2) + this.blockWrap[4] * (n2 + 1);
            this.blockIndex[5] = this.blockIndex[4] + this.blockWrap[4] * (this.mbHeight + 2);
            for (int i = 0; i < this.mbWidth; ++i) {
                int n3;
                this.blockIndex[0] = this.blockIndex[0] + 2;
                this.blockIndex[1] = this.blockIndex[1] + 2;
                this.blockIndex[2] = this.blockIndex[2] + 2;
                this.blockIndex[3] = this.blockIndex[3] + 2;
                this.blockIndex[4] = this.blockIndex[4] + 1;
                this.blockIndex[5] = this.blockIndex[5] + 1;
                int n4 = 0;
                if (this.pictType == 1) {
                    this.mb_intra = true;
                    n4 = this.in.getVLC(v2_intra_cbpc_vlc);
                } else {
                    if (this.use_skip_mb_code && this.in.getTrueFalse()) {
                        this.mb_intra = false;
                        this.pel_motionX = 0;
                        this.pel_motionY = 0;
                        this.mb_skipped = true;
                        this.MPV_decode_mb(i, n2);
                        continue;
                    }
                    this.mb_skipped = false;
                    n3 = this.in.getVLC(v2_mb_type_vlc);
                    this.mb_intra = (n3 & 4) != 0;
                    n4 = n3 & 3;
                }
                if (this.mb_intra) {
                    this.ac_pred = this.in.getTrueFalse();
                    n4 |= this.in.getVLC(cbpy_vlc) << 2;
                } else {
                    this.ac_pred = false;
                    if (((n4 |= this.in.getVLC(cbpy_vlc) << 2) & 3) != 3) {
                        n4 ^= 0x3C;
                    }
                    int[] nArray = this.h263_pred_motion(i, n2, 0);
                    this.pel_motionX = this.msmpeg4v2_decodeMotion(nArray[0], 1);
                    this.pel_motionY = this.msmpeg4v2_decodeMotion(nArray[1], 1);
                }
                for (n3 = 0; n3 < 6; ++n3) {
                    this.decodeBlock(n3, (n4 >> 5 - n3 & 1) != 0);
                }
                this.MPV_decode_mb(i, n2);
            }
        }
        if (this.pictType == 1) {
            this.flipFlopRounding = false;
            if (this.in.availableBits() >= 16) {
                n2 = this.in.getBits(5);
                this.bitRate = this.in.getBits(11) * 1024;
                this.flipFlopRounding = false;
                this.perMbRlTable = this.bitRate > 51200 && this.in.getTrueFalse();
            }
        }
        this.displayOutput.endFrame();
    }

    private int msmpeg4v2_decodeMotion(int n, int n2) throws FFMpegException {
        int n3 = this.in.getVLC(v2_mv_vlc);
        if (n3 == 0) {
            return n;
        }
        boolean bl = this.in.getTrueFalse();
        int n4 = n2 - 1;
        int n5 = n3;
        if (n4 != 0) {
            n5 = n5 - 1 << n4;
            n5 |= this.in.getBits(n4);
            ++n5;
        }
        if (bl) {
            n5 = -n5;
        }
        if ((n5 += n) <= -64) {
            n5 += 64;
        } else if (n5 >= 64) {
            n5 -= 64;
        }
        return n5;
    }

    protected void decodeBlock(int n, boolean bl) throws FFMpegException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        int n10 = 0;
        int[] nArray = null;
        if (this.mb_intra) {
            n6 = n < 4 ? this.in.getVLC(v2_dc_lum_vlc) : this.in.getVLC(v2_dc_chrom_vlc);
            n6 -= 256;
            n5 = n < 4 ? this.y_dc_scale : this.c_dc_scale;
            n4 = this.blockWrap[n];
            int n11 = this.blockIndex[n];
            int n12 = (this.dc_val[n11 - 1] + (n5 >> 1)) / n5;
            int n13 = (this.dc_val[n11 - 1 - n4] + (n5 >> 1)) / n5;
            int n14 = (this.dc_val[n11 - n4] + (n5 >> 1)) / n5;
            if (MP42Codec.abs(n12 - n13) <= MP42Codec.abs(n13 - n14)) {
                n3 = n14;
                this.dc_pred_dir = true;
            } else {
                n3 = n12;
                this.dc_pred_dir = false;
            }
            this.dc_val[n11] = (n6 += n3) * n5;
            n2 = n < 4 ? this.rlTableIndex : 3 + this.rlChromaTableIndex;
            this.block[n][0] = n6;
            this.skipBlock[n] = false;
            if (bl) {
                nArray = this.ac_pred ? (!this.dc_pred_dir ? ScanTable.getIntraVScanTable() : ScanTable.getIntraHScanTable()) : ScanTable.getIntraScanTable();
            }
        } else {
            n8 = this.qscale << 1;
            n9 = this.qscale - 1 | 1;
            n7 = -1;
            n2 = 3 + this.rlTableIndex;
            if (!bl) {
                return;
            }
            nArray = ScanTable.getInterScanTable();
            n10 = 0;
        }
        if (bl) {
            n6 = 0;
            while (n6 == 0) {
                n3 = this.in.getVLC(rlTables[n2]);
                n5 = rlTables[n2].getLevel(n3);
                n4 = rlTables[n2].getRun(n3);
                if (n5 == 0) {
                    if (!this.in.getTrueFalse()) {
                        if (!this.in.getTrueFalse()) {
                            n6 = this.in.getTrueFalse() ? 1 : 0;
                            n4 = this.in.getBits(6);
                            n5 = this.in.getBits(8);
                            n5 = n5 < 128 ? n5 * n8 + n9 : (-256 + n5) * n8 - n9;
                            n7 += n4 + 1 + (n6 != 0 ? 192 : 0);
                        } else {
                            n3 = this.in.getVLC(rlTables[n2]);
                            n5 = rlTables[n2].getLevel(n3) * n8 + n9;
                            n4 = rlTables[n2].getRun(n3);
                            n7 += n4 + rlTables[n2].getMaxRun()[n4 >> 7][n5 / n8] + n10;
                            if (this.in.getTrueFalse()) {
                                n5 = ~n5 + 1;
                            }
                        }
                    } else {
                        n3 = this.in.getVLC(rlTables[n2]);
                        n5 = rlTables[n2].getLevel(n3) * n8 + n9;
                        n4 = rlTables[n2].getRun(n3);
                        n7 += n4;
                        n5 += rlTables[n2].getMaxLevel()[n4 >> 7][n4 - 1 & 0x3F] * n8;
                        if (this.in.getTrueFalse()) {
                            n5 = ~n5 + 1;
                        }
                    }
                } else {
                    n7 += n4;
                    n5 = n5 * n8 + n9;
                    if (this.in.getTrueFalse()) {
                        n5 = ~n5 + 1;
                    }
                }
                if (n7 > 62) {
                    n6 = 1;
                    this.block[n][nArray[n7 -= 192]] = n5;
                    continue;
                }
                this.block[n][nArray[n7]] = n5;
            }
        }
        if (this.mb_intra) {
            n6 = this.blockIndex[n] * 16;
            if (this.ac_pred) {
                if (!this.dc_pred_dir) {
                    for (n3 = 1; n3 < 8; ++n3) {
                        int[] nArray2 = this.block[n];
                        int n15 = n3 * 8;
                        nArray2[n15] = nArray2[n15] + this.ac_val[n6 + n3 - 16];
                    }
                } else {
                    for (n3 = 1; n3 < 8; ++n3) {
                        int[] nArray3 = this.block[n];
                        int n16 = n3;
                        nArray3[n16] = nArray3[n16] + this.ac_val[n6 + n3 - 16 * this.blockWrap[n] + 8];
                    }
                }
            }
            for (n3 = 1; n3 < 8; ++n3) {
                this.ac_val[n6 + n3] = this.block[n][n3 * 8];
                this.ac_val[n6 + 8 + n3] = this.block[n][n3];
            }
            this.skipBlock[n] = n7 < 0;
        }
    }

    private static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    protected final int[] h263_pred_motion(int n, int n2, int n3) {
        int n4 = this.blockWrap[0];
        int n5 = this.blockIndex[n3];
        int n6 = 0;
        int n7 = 0;
        int[] nArray = this.motion_val[n5 - 1];
        if (n2 == 0 && n3 < 3) {
            if (n3 == 0) {
                if (n + 1 == this.resync_mb_x) {
                    int[] nArray2 = this.motion_val[n5 + motionOffset[n3] - n4];
                    if (n == 0) {
                        n6 = nArray2[0];
                        n7 = nArray2[1];
                    } else {
                        n6 = this.mid_pred(nArray[0], 0, nArray2[0]);
                        n7 = this.mid_pred(nArray[1], 0, nArray2[1]);
                    }
                } else if (n != this.resync_mb_x) {
                    n6 = nArray[0];
                    n7 = nArray[1];
                }
            } else if (n3 == 1) {
                if (n + 1 == this.resync_mb_x) {
                    int[] nArray3 = this.motion_val[n5 + motionOffset[n3] - n4];
                    n6 = this.mid_pred(nArray[0], 0, nArray3[0]);
                    n7 = this.mid_pred(nArray[1], 0, nArray3[1]);
                } else {
                    n6 = nArray[0];
                    n7 = nArray[1];
                }
            } else {
                int[] nArray4 = this.motion_val[n5 - n4];
                int[] nArray5 = this.motion_val[n5 + motionOffset[n3] - n4];
                if (n == this.resync_mb_x) {
                    nArray[0] = 0;
                    nArray[1] = 0;
                }
                n6 = this.mid_pred(nArray[0], nArray4[0], nArray5[0]);
                n7 = this.mid_pred(nArray[1], nArray4[1], nArray5[1]);
            }
        } else {
            int[] nArray6 = this.motion_val[n5 - n4];
            int[] nArray7 = this.motion_val[n5 + motionOffset[n3] - n4];
            n6 = this.mid_pred(nArray[0], nArray6[0], nArray7[0]);
            n7 = this.mid_pred(nArray[1], nArray6[1], nArray7[1]);
        }
        this.motion_val[n5][0] = n6;
        this.motion_val[n5][1] = n7;
        return this.motion_val[n5];
    }

    private final int mid_pred(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n;
        if (n2 < n5) {
            n5 = n2;
        } else {
            n4 = n2;
        }
        if (n3 < n5) {
            n5 = n3;
        } else if (n3 > n4) {
            n4 = n3;
        }
        return n + n2 + n3 - n5 - n4;
    }

    protected void initialise(int n, int n2) {
        super.initialise(n, n2);
        for (int i = 0; i < this.mbHeight; ++i) {
            int n3 = 2 * this.mbWidth + 2;
            this.memset(this.dc_val, 1 + i * n3, this.mbWidth * 2, 1024);
        }
        this.yDcScaleTable = ScaleTable.getMpeg4Luminance();
        this.cDcScaleTable = ScaleTable.getMpeg4Chrominance();
    }

    public MP42Codec() {
    }

    public MP42Codec(int n, int n2) {
        this.initialise(n, n2);
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new VideoFormat("DIV3")};
    }

    public Format[] getSupportedOutputFormats(Format format) {
        return new Format[]{new RGBFormat()};
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = (VideoFormat)format;
        this.initialise((int)this.inputFormat.getSize().getWidth(), (int)this.inputFormat.getSize().getHeight());
        return format;
    }

    public Format setOutputFormat(Format format) {
        return new RGBFormat(new Dimension(this.mbWidth * 16, this.mbHeight * 16), -1, new int[0].getClass(), this.inputFormat.getFrameRate(), 32, 0xFF0000, 65280, 255);
    }

    public int process(Buffer buffer, Buffer buffer2) {
        try {
            byte[] byArray = (byte[])buffer.getData();
            byte[] byArray2 = new byte[buffer.getLength() + 20];
            System.arraycopy(byArray, 0, byArray2, 0, buffer.getLength());
            this.decodeFrame(byArray2, buffer.getLength());
            this.displayOutput.showScreen(buffer2);
            buffer2.setTimeStamp(buffer.getTimeStamp());
            buffer2.setFlags(buffer.getFlags());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
        return 0;
    }

    public void open() {
    }

    public void close() {
    }

    public void reset() {
    }

    public String getName() {
        return "DIV3 video decoder";
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    public boolean isCodecAvailable() {
        return true;
    }

    public void setVideoSize(Dimension dimension) {
        this.setInputFormat((Format)new VideoFormat("DIV3", dimension, -1, new byte[0].getClass(), 0.0f));
    }

    public void setEncoding(String string) {
    }

    public void setIsRtp(boolean bl) {
    }

    public void setIsTruncated(boolean bl) {
    }
}

