/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.xml.comp.CXMLContext;
import oracle.xml.comp.CXMLStream;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.util.QxNameHash;
import org.w3c.dom.DOMException;

public class XMLDeclPI
extends XMLPI
implements Externalizable {
    boolean textDecl;
    String encoding;
    String standalone;
    String version;
    static String defaultEncoding = "UTF-8";
    static String defaultVersion = "1.0";
    static String defaultStandalone = "no";

    public XMLDeclPI() {
        super("xml");
    }

    public XMLDeclPI(String string, String string2, String string3, boolean bl) {
        super("xml");
        this.textDecl = bl;
        this.version = string;
        this.encoding = string2;
        this.standalone = string3;
    }

    XMLDeclPI(XMLDocument xMLDocument) {
        super(xMLDocument);
        this.xdkSetQxName(QxNameHash.create("", "xml", "", "xml"));
    }

    public String getData() throws DOMException {
        String string = this.xdkGetNodeValue();
        if (string != null) {
            return string;
        }
        if (!this.textDecl) {
            string = "version = '" + this.version + "'";
            if (this.encoding != null) {
                string = string + " " + "encoding" + " = '" + this.encoding + "'";
            }
            if (this.standalone != null) {
                string = string + " " + "standalone" + " = '" + this.standalone + "'";
            }
        } else {
            if (this.version != null) {
                string = "version = '" + this.version + "' ";
            }
            string = string + "encoding" + " = '" + this.encoding + "'";
        }
        this.xdkSetNodeValue(string);
        return string;
    }

    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    public boolean checkTypeNSName(int n, String string, String string2) {
        return false;
    }

    public final String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return defaultVersion;
    }

    public final void setVersion(String string) {
        this.xdkSetNodeValue(null);
        this.version = string;
    }

    public final String getEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        return System.getProperty("oracle.xml.parser.default.character.set", defaultEncoding);
    }

    public final void setEncoding(String string) {
        this.xdkSetNodeValue(null);
        this.encoding = string;
    }

    public final String getStandalone() {
        if (this.standalone != null) {
            return this.standalone;
        }
        return defaultStandalone;
    }

    public final boolean setStandalone(String string) {
        this.xdkSetNodeValue(null);
        this.standalone = string;
        return string != null && string.equalsIgnoreCase("yes");
    }

    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        XMLDeclPI xMLDeclPI = (XMLDeclPI)xMLDocument.createNodeFromType((short)15);
        xMLDeclPI.version = this.version;
        xMLDeclPI.standalone = this.standalone;
        xMLDeclPI.encoding = this.encoding;
        xMLDeclPI.textDecl = this.textDecl;
        return xMLDeclPI;
    }

    public static void printXMLDecl(XMLOutputStream xMLOutputStream, String string, String string2, String string3) throws IOException {
        xMLOutputStream.writeIndent();
        xMLOutputStream.writeChars("<?");
        String string4 = "version = '" + string + "'";
        if (string2 != null) {
            string4 = string4 + " " + "encoding" + " = '" + string2 + "'";
        }
        if (string3 != null) {
            string4 = string4 + " " + "standalone" + " = '" + string3 + "'";
        }
        xMLOutputStream.writeChars("xml " + string4);
        xMLOutputStream.writeChars("?>");
        xMLOutputStream.writeNewLine();
        xMLOutputStream.flush();
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(128)) {
            xMLOutputStream.writeIndent();
            xMLOutputStream.writeChars("<?");
            xMLOutputStream.writeChars(this.getNodeName() + " " + this.getData());
            xMLOutputStream.writeChars("?>");
            xMLOutputStream.writeNewLine();
            xMLOutputStream.flush();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CXMLContext cXMLContext = new CXMLContext();
        CXMLStream cXMLStream = new CXMLStream(cXMLContext);
        cXMLStream.setObjectOutput(objectOutput);
        this.writeExternal(cXMLStream, cXMLContext);
        cXMLStream.flush();
    }

    void writeExternal(CXMLStream cXMLStream, CXMLContext cXMLContext) throws IOException {
        byte by = cXMLContext.getVersion();
        cXMLStream.writeByte(16);
        cXMLStream.writeUTF(this.getVersion());
        cXMLStream.writeUTF(this.getEncoding());
        if (by == 2) {
            if (this.standalone != null && this.standalone.equalsIgnoreCase("yes")) {
                cXMLStream.writeByte(1);
            } else {
                cXMLStream.writeByte(16);
            }
        } else {
            cXMLStream.writeUTF(this.getStandalone());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        CXMLContext cXMLContext = new CXMLContext();
        CXMLStream cXMLStream = new CXMLStream(cXMLContext);
        cXMLStream.setObjectInput(objectInput);
        this.readExternal(cXMLStream, cXMLContext);
    }

    public void readExternal(CXMLStream cXMLStream, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = cXMLStream.readByte();
        byte by2 = cXMLContext.getVersion();
        if (by != 16) {
            throw new IOException("Error in reading serialized stream  corresponding to PI node");
        }
        this.setVersion(cXMLStream.readUTF());
        this.setEncoding(cXMLStream.readUTF());
        if (by2 == 2) {
            if (cXMLStream.readByte() == 1) {
                this.setStandalone("yes");
            } else {
                this.setStandalone("no");
            }
        } else {
            this.setStandalone(cXMLStream.readUTF());
        }
    }
}

