/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.pdfbox.filter.Filter;
import org.pdfbox.filter.FilterManager;
import org.pdfbox.util.ImageParameters;

public class PDInlinedImage {
    private ImageParameters params;
    private byte[] imageData;

    public ImageParameters getImageParameters() {
        return this.params;
    }

    public void setImageParameters(ImageParameters imageParams) {
        this.params = imageParams;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] value) {
        this.imageData = value;
    }

    public BufferedImage createImage() throws IOException {
        DataBuffer byteBuffer;
        ColorModel colorModel = this.params.getColorSpace().createColorModel(this.params.getBitsPerComponent());
        List filters = this.params.getFilters();
        byte[] finalData = null;
        if (filters == null) {
            finalData = this.getImageData();
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(this.getImageData());
            ByteArrayOutputStream out = new ByteArrayOutputStream(this.getImageData().length);
            FilterManager filterManager = new FilterManager();
            for (int i = 0; filters != null && i < filters.size(); ++i) {
                out.reset();
                Filter filter = filterManager.getFilter((String)filters.get(i));
                filter.decode(in, out, this.params.getDictionary());
                in = new ByteArrayInputStream(out.toByteArray());
            }
            finalData = out.toByteArray();
        }
        WritableRaster raster = colorModel.createCompatibleWritableRaster(this.params.getWidth(), this.params.getHeight());
        DataBuffer rasterBuffer = raster.getDataBuffer();
        if (rasterBuffer instanceof DataBufferByte) {
            byteBuffer = (DataBufferByte)rasterBuffer;
            byte[] data = ((DataBufferByte)byteBuffer).getData();
            System.arraycopy(finalData, 0, data, 0, data.length);
        } else if (rasterBuffer instanceof DataBufferInt) {
            byteBuffer = (DataBufferInt)rasterBuffer;
            int[] data = ((DataBufferInt)byteBuffer).getData();
            for (int i = 0; i < finalData.length; ++i) {
                data[i] = (finalData[i] + 256) % 256;
            }
        }
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        image.setData(raster);
        return image;
    }
}

