/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import com.rc.retroweaver.runtime.Autobox;
import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.actions.AbstractBlockCommentAction;
import org.python.pydev.editor.actions.PyAddBlockComment;
import org.python.pydev.editor.actions.PyAddSingleBlockComment;

public class PyRemoveBlockComment
extends PyAddBlockComment {
    public void run(IAction action) {
        try {
            PySelection ps = new PySelection(this.getTextEditor());
            this.getTextEditor().selectAndReveal(this.perform(ps), 0);
        }
        catch (Exception e) {
            PyRemoveBlockComment.beep(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int perform(PySelection ps) {
        FastStringBuffer strbuf = new FastStringBuffer();
        try {
            int startLineIndex = this.getStartIndex(ps);
            int endLineIndex = this.getEndIndex(ps);
            if (startLineIndex == -1 || endLineIndex == -1) {
                if (startLineIndex == -1 && endLineIndex == -1) {
                    return -1;
                }
                if (startLineIndex == -1) {
                    startLineIndex = endLineIndex;
                } else {
                    endLineIndex = startLineIndex;
                }
            }
            int i = startLineIndex;
            while (i <= endLineIndex) {
                boolean addDelim = true;
                String spacesBefore = "";
                String line = ps.getLine(i);
                int j = 0;
                while (j < line.length()) {
                    char c = line.charAt(j);
                    if (c != ' ' && c == '#') {
                        if (j > 0) {
                            spacesBefore = line.substring(0, j);
                        }
                        line = line.substring(j);
                        break;
                    }
                    ++j;
                }
                if (line.startsWith("#")) {
                    line = line.substring(1);
                }
                AbstractBlockCommentAction[] acts = new AbstractBlockCommentAction[]{new PyAddSingleBlockComment(), new PyAddBlockComment()};
                HashSet<Character> chars = new HashSet<Character>();
                int j2 = 0;
                while (j2 < acts.length) {
                    AbstractBlockCommentAction action = acts[j2];
                    chars.add((Character)action.getColsAndChar().o2);
                    ++j2;
                }
                if (line.length() > 0) {
                    boolean removedChar = false;
                    char lastChar = '\u0000';
                    int j3 = 0;
                    while (j3 < line.length()) {
                        lastChar = line.charAt(j3);
                        if (!chars.contains(Autobox.valueOf((char)lastChar))) break;
                        removedChar = true;
                        line = line.substring(1);
                        --j3;
                        ++j3;
                    }
                    if (line.length() == 0 && removedChar) {
                        addDelim = false;
                    }
                    if (removedChar && lastChar == ' ') {
                        line = line.substring(1);
                    }
                }
                if (addDelim) {
                    strbuf.append(spacesBefore);
                    strbuf.append(line);
                    String lineDelimiter = ps.getDoc().getLineDelimiter(i);
                    if (lineDelimiter != null) {
                        strbuf.append(lineDelimiter);
                    }
                }
                ++i;
            }
            int startLineOffset = ps.getLineOffset(startLineIndex);
            int endLineOffset = ps.getEndLineOffset(endLineIndex);
            String endLineDelimiter = ps.getDoc().getLineDelimiter(endLineIndex);
            if (endLineDelimiter != null) {
                endLineOffset += endLineDelimiter.length();
            }
            String str = strbuf.toString();
            ps.getDoc().replace(startLineOffset, endLineOffset - startLineOffset, str);
            return startLineOffset + str.length();
        }
        catch (Exception e) {
            PyRemoveBlockComment.beep(e);
            return -1;
        }
    }

    private int getEndIndex(PySelection ps) {
        String line;
        int endLineIndex = -1;
        int i = ps.getEndLineIndex();
        while (PySelection.isCommentLine((String)(line = ps.getLine(i)))) {
            endLineIndex = i++;
        }
        return endLineIndex;
    }

    private int getStartIndex(PySelection ps) {
        String line;
        int startLineIndex = -1;
        int i = ps.getStartLineIndex();
        while (PySelection.isCommentLine((String)(line = ps.getLine(i)))) {
            startLineIndex = i--;
        }
        return startLineIndex;
    }
}

