/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;

public abstract class PyAction
extends Action
implements IEditorActionDelegate {
    protected volatile IEditorPart targetEditor;

    public static Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            PydevPlugin.log("Error. Not currently with thread access (so, there is no activeWorkbenchWindow available)");
            return null;
        }
        return activeWorkbenchWindow.getShell();
    }

    public void setEditor(IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setEditor(targetEditor);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    public static String getDelimiter(IDocument doc) {
        return PySelection.getDelimiter((IDocument)doc);
    }

    protected ITextEditor getTextEditor() {
        if (this.targetEditor instanceof ITextEditor) {
            return (ITextEditor)this.targetEditor;
        }
        throw new RuntimeException("Expecting text editor. Found:" + this.targetEditor.getClass().getName());
    }

    protected PyEdit getPyEdit() {
        if (this.targetEditor instanceof PyEdit) {
            return (PyEdit)this.targetEditor;
        }
        throw new RuntimeException("Expecting PyEdit editor. Found:" + this.targetEditor.getClass().getName());
    }

    protected void setCaretPosition(int pos) throws BadLocationException {
        this.getTextEditor().selectAndReveal(pos, 0);
    }

    protected void isInFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            IRegion region = doc.getLineInformationOfOffset(cursorOffset);
            int offset = region.getOffset();
            String src = doc.get(offset, region.getLength());
            if ("".equals(src)) {
                return;
            }
            int i = 0;
            while (i < src.length()) {
                if (!Character.isWhitespace(src.charAt(i))) break;
                ++i;
            }
            this.setCaretPosition(offset + i - 1);
        }
        catch (BadLocationException e) {
            PyAction.beep((Exception)((Object)e));
            return;
        }
    }

    protected int getLastCharPosition(IDocument doc, int cursorOffset) throws BadLocationException {
        IRegion region = doc.getLineInformationOfOffset(cursorOffset);
        int offset = region.getOffset();
        String src = doc.get(offset, region.getLength());
        int i = src.length();
        boolean breaked = false;
        while (i > 0) {
            if (Character.isWhitespace(src.charAt(--i)) || src.charAt(i) == '\t') continue;
            breaked = true;
            break;
        }
        if (!breaked) {
            --i;
        }
        return offset + i;
    }

    protected void gotoFirstChar(IDocument doc, int cursorOffset) {
        try {
            IRegion region = doc.getLineInformationOfOffset(cursorOffset);
            int offset = region.getOffset();
            this.setCaretPosition(offset);
        }
        catch (BadLocationException e) {
            PyAction.beep((Exception)((Object)e));
        }
    }

    protected void gotoFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            this.setCaretPosition(PySelection.getFirstCharPosition((IDocument)doc, (int)cursorOffset));
        }
        catch (BadLocationException e) {
            PyAction.beep((Exception)((Object)e));
        }
    }

    protected boolean isAtFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            return PySelection.getFirstCharPosition((IDocument)doc, (int)cursorOffset) == cursorOffset;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected static void beep(Exception e) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().beep();
        }
        catch (IllegalStateException illegalStateException) {}
        e.printStackTrace();
    }

    public static String getLineWithoutComments(String sel) {
        return sel.replaceAll("#.*", "");
    }

    public static String getLineWithoutComments(PySelection ps) {
        return PyAction.getLineWithoutComments(ps.getCursorLineContents());
    }

    public static int countChars(char c, String line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static int countChars(char c, StringBuffer line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static int countChars(char c, FastStringBuffer line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static String getBeforeParentesisTok(PySelection ps) {
        String string = PyAction.getLineWithoutComments(ps);
        String callName = "";
        int i = string.indexOf("(");
        if (i != -1) {
            callName = "";
            int j = i - 1;
            while (j >= 0 && PyAction.stillInTok(string, j)) {
                callName = String.valueOf(string.charAt(j)) + callName;
                --j;
            }
        }
        return callName;
    }

    public static String lowerChar(String s, int pos) {
        char[] ds = s.toCharArray();
        ds[pos] = Character.toLowerCase(ds[pos]);
        return new String(ds);
    }

    public static boolean stillInTok(String string, int j) {
        char c = string.charAt(j);
        return c != '\n' && c != '\r' && c != ' ' && c != '.' && c != '(' && c != ')' && c != ',' && c != ']' && c != '[' && c != '#';
    }

    public static String getStaticIndentationString(PyEdit edit) {
        try {
            int tabWidth = DefaultIndentPrefs.getStaticTabWidth();
            boolean useSpaces = PydevPrefs.getPreferences().getBoolean("SUBSTITUTE_TABS");
            boolean forceTabs = false;
            if (edit != null) {
                forceTabs = edit.getIndentPrefs().getForceTabs();
            }
            String identString = useSpaces && !forceTabs ? PyAction.createStaticSpaceString(tabWidth) : "\t";
            return identString;
        }
        catch (Exception e) {
            PydevPlugin.log(e, false);
            return "    ";
        }
    }

    private static String createStaticSpaceString(int tabWidth) {
        FastStringBuffer b = new FastStringBuffer(tabWidth);
        while (tabWidth-- > 0) {
            b.append(" ");
        }
        return b.toString();
    }

    protected void revealSelEndLine(PySelection ps) {
        int docLen = ps.getDoc().getLength() - 1;
        IRegion endLine = ps.getEndLine();
        if (endLine != null) {
            int curOffset = endLine.getOffset();
            this.getTextEditor().selectAndReveal(curOffset < docLen ? curOffset : docLen, 0);
        }
    }
}

