/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.text.NumberFormat;
import java.util.Locale;
import org.python.core.ExtraMath;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.codecs;

final class StringFormatter {
    int index = 0;
    String format;
    StringBuffer buffer;
    boolean negative;
    int precision;
    int argIndex;
    PyObject args;

    final char pop() {
        try {
            return this.format.charAt(this.index++);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw Py.ValueError("incomplete format");
        }
    }

    final char peek() {
        return this.format.charAt(this.index);
    }

    final void push() {
        --this.index;
    }

    final PyObject getarg() {
        PyObject ret = null;
        switch (this.argIndex) {
            case -3: {
                return this.args;
            }
            case -2: {
                break;
            }
            case -1: {
                this.argIndex = -2;
                return this.args;
            }
            default: {
                ret = this.args.__finditem__(this.argIndex++);
                break;
            }
        }
        if (ret == null) {
            throw Py.TypeError("not enough arguments for format string");
        }
        return ret;
    }

    final int getNumber() {
        char c = this.pop();
        if (c == '*') {
            PyObject o = this.getarg();
            if (o instanceof PyInteger) {
                return ((PyInteger)o).getValue();
            }
            throw Py.TypeError("* wants int");
        }
        if (Character.isDigit(c)) {
            int numStart = this.index - 1;
            while (Character.isDigit(c = this.pop())) {
            }
            --this.index;
            Integer i = Integer.valueOf(this.format.substring(numStart, this.index));
            return i;
        }
        --this.index;
        return 0;
    }

    public final String formatLong(PyString arg, char type, boolean altFlag) {
        String s = arg.toString();
        int end = s.length();
        int ptr = 0;
        int numnondigits = 0;
        if (type == 'x' || type == 'X') {
            numnondigits = 2;
        }
        if (s.endsWith("L")) {
            --end;
        }
        boolean bl = this.negative = s.charAt(0) == '-';
        if (this.negative) {
            ++ptr;
        }
        int numdigits = end - numnondigits - ptr;
        if (!altFlag) {
            switch (type) {
                case 'o': {
                    if (numdigits <= 1) break;
                    ++ptr;
                    --numdigits;
                    break;
                }
                case 'X': 
                case 'x': {
                    ptr += 2;
                    numnondigits -= 2;
                    break;
                }
            }
        }
        if (this.precision > numdigits) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < numnondigits) {
                buf.append(s.charAt(ptr++));
                ++i;
            }
            i = 0;
            while (i < this.precision - numdigits) {
                buf.append('0');
                ++i;
            }
            i = 0;
            while (i < numdigits) {
                buf.append(s.charAt(ptr++));
                ++i;
            }
            s = buf.toString();
        } else if (end < s.length() || ptr > 0) {
            s = s.substring(ptr, end);
        }
        switch (type) {
            case 'x': {
                s = s.toLowerCase();
                break;
            }
        }
        return s;
    }

    public final String formatInteger(PyObject arg, int radix, boolean unsigned) {
        return this.formatInteger(arg.__int__().getValue(), radix, unsigned);
    }

    public final String formatInteger(long v, int radix, boolean unsigned) {
        if (unsigned) {
            if (v < 0L) {
                v = 0x100000000L + v;
            }
        } else if (v < 0L) {
            this.negative = true;
            v = -v;
        }
        String s = Long.toString(v, radix);
        while (s.length() < this.precision) {
            s = "0" + s;
        }
        return s;
    }

    public final String formatFloatDecimal(PyObject arg, boolean truncate) {
        return this.formatFloatDecimal(arg.__float__().getValue(), truncate);
    }

    public final String formatFloatDecimal(double v, boolean truncate) {
        NumberFormat format = NumberFormat.getInstance(Locale.US);
        int prec = this.precision;
        if (prec == -1) {
            prec = 6;
        }
        if (v < 0.0) {
            v = -v;
            this.negative = true;
        }
        format.setMaximumFractionDigits(prec);
        format.setMinimumFractionDigits(truncate ? 0 : prec);
        format.setGroupingUsed(false);
        String ret = format.format(v);
        return ret;
    }

    public final String formatFloatExponential(PyObject arg, char e, boolean truncate) {
        StringBuffer buf = new StringBuffer();
        double v = arg.__float__().getValue();
        boolean isNegative = false;
        if (v < 0.0) {
            v = -v;
            isNegative = true;
        }
        double power = 0.0;
        if (v > 0.0) {
            power = Math.floor(Math.log(v) / Math.log(10.0));
        }
        int savePrecision = this.precision;
        this.precision = truncate ? -1 : 3;
        String exp = this.formatInteger((long)power, 10, false);
        if (this.negative) {
            this.negative = false;
            exp = "-" + exp;
        } else if (!truncate) {
            exp = "+" + exp;
        }
        this.precision = savePrecision;
        double base = v / Math.pow(10.0, power);
        buf.append(this.formatFloatDecimal(base, truncate));
        buf.append(e);
        buf.append(exp);
        this.negative = isNegative;
        return buf.toString();
    }

    public final String format(PyObject args) {
        PyObject dict = null;
        this.args = args;
        if (args instanceof PyTuple) {
            this.argIndex = 0;
        } else {
            this.argIndex = -1;
            if (args instanceof PyDictionary || args instanceof PyStringMap || !(args instanceof PySequence) && args.__findattr__("__getitem__") != null) {
                dict = args;
                this.argIndex = -3;
            }
        }
        while (this.index < this.format.length()) {
            boolean ljustFlag = false;
            boolean signFlag = false;
            boolean blankFlag = false;
            boolean altFlag = false;
            boolean zeroFlag = false;
            int width = -1;
            this.precision = -1;
            char c = this.pop();
            if (c != '%') {
                this.buffer.append(c);
                continue;
            }
            c = this.pop();
            if (c == '(') {
                if (dict == null) {
                    throw Py.TypeError("format requires a mapping");
                }
                int parens = 1;
                int keyStart = this.index;
                while (parens > 0) {
                    c = this.pop();
                    if (c == ')') {
                        --parens;
                        continue;
                    }
                    if (c != '(') continue;
                    ++parens;
                }
                String tmp = this.format.substring(keyStart, this.index - 1);
                this.args = dict.__getitem__(new PyString(tmp));
            } else {
                this.push();
            }
            block21: while (true) {
                c = this.pop();
                switch (c) {
                    case '-': {
                        ljustFlag = true;
                        continue block21;
                    }
                    case '+': {
                        signFlag = true;
                        continue block21;
                    }
                    case ' ': {
                        blankFlag = true;
                        continue block21;
                    }
                    case '#': {
                        altFlag = true;
                        continue block21;
                    }
                    case '0': {
                        zeroFlag = true;
                        continue block21;
                    }
                }
                break;
            }
            this.push();
            width = this.getNumber();
            if (width < 0) {
                width = -width;
                ljustFlag = true;
            }
            if ((c = this.pop()) == '.') {
                this.precision = this.getNumber();
                if (this.precision < -1) {
                    this.precision = 0;
                }
                if (this.precision > 250) {
                    throw Py.OverflowError("formatted float is too long (precision too long?)");
                }
                c = this.pop();
            }
            if (c == 'h' || c == 'l' || c == 'L') {
                c = this.pop();
            }
            if (c == '%') {
                this.buffer.append(c);
                continue;
            }
            PyObject arg = this.getarg();
            char fill = ' ';
            String string = null;
            this.negative = false;
            fill = zeroFlag ? (char)'0' : ' ';
            switch (c) {
                case 'r': 
                case 's': {
                    fill = ' ';
                    string = c == 's' ? arg.__str__().toString() : arg.__repr__().toString();
                    if (this.precision < 0 || string.length() <= this.precision) break;
                    string = string.substring(0, this.precision);
                    break;
                }
                case 'd': 
                case 'i': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg.__str__(), c, altFlag);
                        break;
                    }
                    string = this.formatInteger(arg, 10, false);
                    break;
                }
                case 'u': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg.__str__(), c, altFlag);
                        break;
                    }
                    string = this.formatInteger(arg, 10, true);
                    break;
                }
                case 'o': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg.__oct__(), c, altFlag);
                        break;
                    }
                    string = this.formatInteger(arg, 8, true);
                    if (!altFlag || string.charAt(0) == '0') break;
                    string = "0" + string;
                    break;
                }
                case 'x': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg.__hex__(), c, altFlag);
                        break;
                    }
                    string = this.formatInteger(arg, 16, true);
                    string = string.toLowerCase();
                    if (!altFlag) break;
                    string = "0x" + string;
                    break;
                }
                case 'X': {
                    if (arg instanceof PyLong) {
                        string = this.formatLong(arg.__hex__(), c, altFlag);
                        break;
                    }
                    string = this.formatInteger(arg, 16, true);
                    string = string.toUpperCase();
                    if (!altFlag) break;
                    string = "0X" + string;
                    break;
                }
                case 'E': 
                case 'e': {
                    string = this.formatFloatExponential(arg, c, false);
                    break;
                }
                case 'f': {
                    string = this.formatFloatDecimal(arg, false);
                    break;
                }
                case 'G': 
                case 'g': {
                    double v;
                    int digits;
                    int prec = this.precision;
                    if (prec == -1) {
                        prec = 6;
                    }
                    if ((digits = (int)Math.ceil(ExtraMath.log10(v = arg.__float__().getValue()))) > 0) {
                        if (digits <= prec) {
                            this.precision = prec - digits;
                            string = this.formatFloatDecimal(arg, true);
                        } else {
                            string = this.formatFloatExponential(arg, (char)(c - 2), true);
                        }
                    } else {
                        string = this.formatFloatDecimal(arg, true);
                    }
                    if (!altFlag || string.indexOf(46) != -1) break;
                    int zpad = prec - string.length();
                    string = string + ".";
                    if (zpad <= 0) break;
                    char[] zeros = new char[zpad];
                    int ci = 0;
                    while (ci < zpad) {
                        zeros[ci++] = 48;
                    }
                    string = string + new String(zeros);
                    break;
                }
                case 'c': {
                    fill = ' ';
                    if (arg instanceof PyString) {
                        string = ((PyString)arg).toString();
                        if (string.length() == 1) break;
                        throw Py.TypeError("%c requires int or char");
                    }
                    char tmp = (char)arg.__int__().getValue();
                    string = new Character(tmp).toString();
                    break;
                }
                default: {
                    throw Py.ValueError("unsupported format character '" + codecs.encode(Py.newString(c), null, "replace") + "' (0x" + Integer.toHexString(c) + ") at index " + (this.index - 1));
                }
            }
            int length = string.length();
            int skip = 0;
            String signString = null;
            if (this.negative) {
                signString = "-";
            } else if (signFlag) {
                signString = "+";
            } else if (blankFlag) {
                signString = " ";
            }
            if (width < length) {
                width = length;
            }
            if (signString != null) {
                if (fill != ' ') {
                    this.buffer.append(signString);
                }
                if (width > length) {
                    --width;
                }
            }
            if (altFlag && (c == 'x' || c == 'X')) {
                if (fill != ' ') {
                    this.buffer.append('0');
                    this.buffer.append(c);
                    skip += 2;
                }
                if ((width -= 2) < 0) {
                    width = 0;
                }
                length -= 2;
            }
            if (width > length && !ljustFlag) {
                do {
                    this.buffer.append(fill);
                } while (--width > length);
            }
            if (fill == ' ') {
                if (signString != null) {
                    this.buffer.append(signString);
                }
                if (altFlag && (c == 'x' || c == 'X')) {
                    this.buffer.append('0');
                    this.buffer.append(c);
                    skip += 2;
                }
            }
            if (skip > 0) {
                this.buffer.append(string.substring(skip));
            } else {
                this.buffer.append(string);
            }
            while (--width >= length) {
                this.buffer.append(' ');
            }
        }
        if (this.argIndex == -1 || this.argIndex >= 0 && args.__finditem__(this.argIndex) != null) {
            throw Py.TypeError("not all arguments converted");
        }
        return this.buffer.toString();
    }

    public StringFormatter(String format) {
        this.format = format;
        this.buffer = new StringBuffer(format.length() + 100);
    }
}

