/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.form;

import com.sun.star.awt.XListBox;
import com.sun.star.awt.XRadioButton;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.TimeStampControl;
import com.sun.star.wizards.form.FormDocument;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.ui.UIConsts;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;

public class StyleApplier {
    private WizardDialog CurUnoDialog;
    private XPropertySet xPageStylePropertySet;
    private XMultiServiceFactory xMSF;
    private short curtabindex;
    private XRadioButton optNoBorder;
    private XRadioButton opt3DLook;
    private XRadioButton optFlat;
    private XListBox lstStyles;
    private FormDocument curFormDocument;
    private short iOldLayoutPos;
    private static final String SCHANGELAYOUT = "changeLayout";
    private static final String SCHANGEBORDERTYPE = "changeBorderLayouts";
    private String[] StyleNames;
    private String[] StyleNodeNames;
    private String[] FileNames;
    private static final int SOBACKGROUNDCOLOR = 0;
    private static final int SODBTEXTCOLOR = 1;
    private static final int SOLABELTEXTCOLOR = 2;
    private static final int SOBORDERCOLOR = 5;
    private Short IBorderValue = new Short(1);

    public StyleApplier(WizardDialog wizardDialog, FormDocument formDocument) throws NoValidPathException {
        this.curFormDocument = formDocument;
        this.xMSF = this.curFormDocument.xMSF;
        TextStyleHandler textStyleHandler = new TextStyleHandler(this.xMSF, this.curFormDocument.xTextDocument);
        this.xPageStylePropertySet = textStyleHandler.getStyleByName("PageStyles", "Standard");
        this.CurUnoDialog = wizardDialog;
        this.curtabindex = (short)700;
        Integer n = new Integer(7);
        String string = this.CurUnoDialog.m_oResource.getResText(2286);
        String string2 = this.CurUnoDialog.m_oResource.getResText(2229);
        String string3 = this.CurUnoDialog.m_oResource.getResText(2230);
        String string4 = this.CurUnoDialog.m_oResource.getResText(2231);
        String string5 = this.CurUnoDialog.m_oResource.getResText(2228);
        this.setStyles();
        short[] sArray = new short[]{0};
        Object[] objectArray = new Object[7];
        objectArray[0] = UIConsts.INTEGERS[8];
        objectArray[1] = string;
        objectArray[2] = 92;
        objectArray[3] = 25;
        objectArray[4] = n;
        short s = this.curtabindex;
        this.curtabindex = (short)(s + 1);
        objectArray[5] = new Short(s);
        objectArray[6] = 90;
        this.CurUnoDialog.insertLabel("lblStyles", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray);
        Object[] objectArray2 = new Object[9];
        objectArray2[0] = 143;
        objectArray2[1] = "HID:WIZARDS_HID_DLGFORM_LSTSTYLES";
        objectArray2[2] = 92;
        objectArray2[3] = 35;
        objectArray2[4] = sArray;
        objectArray2[5] = n;
        objectArray2[6] = this.StyleNames;
        short s2 = this.curtabindex;
        this.curtabindex = (short)(s2 + 1);
        objectArray2[7] = new Short(s2);
        objectArray2[8] = 90;
        this.lstStyles = this.CurUnoDialog.insertListBox("lstStyles", null, SCHANGELAYOUT, this, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.SELECTED_ITEMS, PropertyNames.PROPERTY_STEP, PropertyNames.STRING_ITEM_LIST, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray2);
        Object[] objectArray3 = new Object[9];
        objectArray3[0] = UIConsts.INTEGERS[10];
        objectArray3[1] = "HID:WIZARDS_HID_DLGFORM_CMDNOBORDER";
        objectArray3[2] = string2;
        objectArray3[3] = 196;
        objectArray3[4] = 39;
        objectArray3[5] = n;
        short s3 = this.curtabindex;
        this.curtabindex = (short)(s3 + 1);
        objectArray3[6] = new Short(s3);
        objectArray3[7] = "0";
        objectArray3[8] = 93;
        this.optNoBorder = this.CurUnoDialog.insertRadioButton("otpNoBorder", SCHANGEBORDERTYPE, this, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tag", PropertyNames.PROPERTY_WIDTH}, objectArray3);
        Object[] objectArray4 = new Object[10];
        objectArray4[0] = UIConsts.INTEGERS[10];
        objectArray4[1] = "HID:WIZARDS_HID_DLGFORM_CMD3DBORDER";
        objectArray4[2] = string3;
        objectArray4[3] = 196;
        objectArray4[4] = 53;
        objectArray4[5] = new Short(1);
        objectArray4[6] = n;
        short s4 = this.curtabindex;
        this.curtabindex = (short)(s4 + 1);
        objectArray4[7] = new Short(s4);
        objectArray4[8] = "1";
        objectArray4[9] = 93;
        this.opt3DLook = this.CurUnoDialog.insertRadioButton("otp3DLook", SCHANGEBORDERTYPE, this, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STATE, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tag", PropertyNames.PROPERTY_WIDTH}, objectArray4);
        Object[] objectArray5 = new Object[9];
        objectArray5[0] = UIConsts.INTEGERS[10];
        objectArray5[1] = "HID:WIZARDS_HID_DLGFORM_CMDSIMPLEBORDER";
        objectArray5[2] = string4;
        objectArray5[3] = 196;
        objectArray5[4] = 67;
        objectArray5[5] = n;
        short s5 = this.curtabindex;
        this.curtabindex = (short)(s5 + 1);
        objectArray5[6] = new Short(s5);
        objectArray5[7] = "2";
        objectArray5[8] = 93;
        this.optFlat = this.CurUnoDialog.insertRadioButton("otpFlat", SCHANGEBORDERTYPE, this, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tag", PropertyNames.PROPERTY_WIDTH}, objectArray5);
        Object[] objectArray6 = new Object[7];
        objectArray6[0] = UIConsts.INTEGERS[8];
        objectArray6[1] = string5;
        objectArray6[2] = 192;
        objectArray6[3] = 25;
        objectArray6[4] = n;
        short s6 = this.curtabindex;
        this.curtabindex = (short)(s6 + 1);
        objectArray6[5] = new Short(s6);
        objectArray6[6] = 98;
        this.CurUnoDialog.insertFixedLine("lnFieldBorder", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray6);
    }

    private void setStyles() {
        try {
            Object object = Configuration.getConfigurationRoot(this.xMSF, "org.openoffice.Office.FormWizard/FormWizard/Styles", false);
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
            this.StyleNodeNames = xNameAccess.getElementNames();
            this.StyleNames = new String[this.StyleNodeNames.length];
            this.FileNames = new String[this.StyleNodeNames.length];
            for (int i = 0; i < this.StyleNodeNames.length; ++i) {
                Object object2 = xNameAccess.getByName(this.StyleNodeNames[i]);
                this.StyleNames[i] = (String)Helper.getUnoPropertyValue(object2, PropertyNames.PROPERTY_NAME);
                this.FileNames[i] = (String)Helper.getUnoPropertyValue(object2, "CssHref");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private short getStyleIndex() {
        try {
            short[] sArray = (short[])AnyConverter.toArray((Object)Helper.getUnoPropertyValue(UnoDialog.getModel(this.lstStyles), PropertyNames.SELECTED_ITEMS));
            if (sArray != null) {
                return sArray[0];
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.err);
        }
        return -1;
    }

    public void applyStyle(boolean bl, boolean bl2) {
        short s = this.getStyleIndex();
        if ((s != this.iOldLayoutPos || bl2) && s > -1) {
            this.iOldLayoutPos = s;
            String string = this.FileNames[s];
            int[] nArray = this.getStyleColors(string);
            this.applyDBControlProperties(nArray);
        }
    }

    public void changeLayout() {
        short s = this.lstStyles.getSelectedItemPos();
        if (s != this.iOldLayoutPos) {
            this.iOldLayoutPos = s;
            String string = this.FileNames[s];
            int[] nArray = this.getStyleColors(string);
            this.applyDBControlProperties(nArray);
        }
        this.curFormDocument.unlockallControllers();
    }

    public Short getBorderType() {
        return this.IBorderValue;
    }

    public void changeBorderLayouts() {
        try {
            this.curFormDocument.xTextDocument.lockControllers();
            this.IBorderValue = this.optNoBorder.getState() ? new Short(0) : (this.opt3DLook.getState() ? new Short(1) : new Short(2));
            for (int i = 0; i < this.curFormDocument.oControlForms.size(); ++i) {
                DatabaseControl[] databaseControlArray;
                FormDocument.ControlForm controlForm = this.curFormDocument.oControlForms.get(i);
                if (controlForm.getArrangemode() == 3) {
                    databaseControlArray = controlForm.getGridControl();
                    databaseControlArray.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)this.IBorderValue);
                    continue;
                }
                databaseControlArray = controlForm.getDatabaseControls();
                for (int j = 0; j < databaseControlArray.length; ++j) {
                    if (databaseControlArray[j].xServiceInfo.supportsService("com.sun.star.drawing.ShapeCollection")) {
                        TimeStampControl timeStampControl = (TimeStampControl)databaseControlArray[j];
                        for (int k = 0; k < 2; ++k) {
                            XPropertySet xPropertySet = timeStampControl.getControlofGroupShapeByIndex(k);
                            if (!xPropertySet.getPropertySetInfo().hasPropertyByName(PropertyNames.PROPERTY_BORDER)) continue;
                            xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)this.IBorderValue);
                        }
                        continue;
                    }
                    if (!databaseControlArray[j].xPropertySet.getPropertySetInfo().hasPropertyByName(PropertyNames.PROPERTY_BORDER)) continue;
                    databaseControlArray[j].xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)this.IBorderValue);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        this.curFormDocument.unlockallControllers();
    }

    public void disposing(EventObject eventObject) {
    }

    private int getStyleColor(String[] stringArray, String string, String string2) {
        int n = JavaTools.FieldInList(stringArray, string);
        if (n > -1) {
            String string3 = PropertyNames.EMPTY_STRING;
            while (string3.indexOf("}") < 0 && n < stringArray.length - 1) {
                String string4;
                if ((string4 = stringArray[n++]).indexOf(string2) <= 0 || string4.indexOf(":") <= 0) continue;
                String[] stringArray2 = JavaTools.ArrayoutofString(string4, ":");
                String string5 = stringArray2[1];
                if ((string5 = string5.trim()).indexOf("#") <= -1) continue;
                string5 = JavaTools.replaceSubString(string5, PropertyNames.EMPTY_STRING, PropertyNames.SEMI_COLON);
                string5 = JavaTools.replaceSubString(string5, PropertyNames.EMPTY_STRING, PropertyNames.SPACE);
                return Integer.decode(string5);
            }
        }
        return -1;
    }

    private String getStylePath() {
        String string = "";
        try {
            string = FileAccess.getOfficePath(this.xMSF, "Config", "", "");
            string = FileAccess.combinePaths(this.xMSF, string, "/wizard/form/styles");
        }
        catch (NoValidPathException noValidPathException) {
            // empty catch block
        }
        return string;
    }

    private int[] getStyleColors(String string) {
        String string2 = this.getStylePath() + "/" + string;
        int[] nArray = new int[6];
        String[] stringArray = FileAccess.getDataFromTextFile(this.xMSF, string2);
        nArray[0] = this.getStyleColor(stringArray, ".toctitle {", "background-color:");
        nArray[1] = this.getStyleColor(stringArray, ".doctitle {", "color:");
        nArray[2] = this.getStyleColor(stringArray, ".toctitle {", "color:");
        nArray[5] = this.getStyleColor(stringArray, ".tcolor {", "border-color:");
        return nArray;
    }

    private void setDBControlColors(XPropertySet xPropertySet, int[] nArray) {
        try {
            if (xPropertySet.getPropertySetInfo().hasPropertyByName("TextColor") && nArray[1] > -1) {
                xPropertySet.setPropertyValue("TextColor", (Object)Integer.decode("#00000"));
            }
            if (xPropertySet.getPropertySetInfo().hasPropertyByName("BackgroundColor")) {
                xPropertySet.setPropertyValue("BackgroundColor", (Object)Integer.decode("#DDDDDD"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void applyDBControlProperties(int[] nArray) {
        try {
            for (int i = 0; i < this.curFormDocument.oControlForms.size(); ++i) {
                FormDocument.ControlForm controlForm = this.curFormDocument.oControlForms.get(i);
                if (controlForm.getArrangemode() == 3) {
                    if (nArray[2] > -1) {
                        controlForm.oGridControl.xPropertySet.setPropertyValue("TextColor", (Object)new Integer(nArray[1]));
                    }
                    controlForm.oGridControl.xPropertySet.setPropertyValue("BackgroundColor", (Object)Integer.decode("#DDDDDD"));
                    continue;
                }
                DatabaseControl[] databaseControlArray = controlForm.getDatabaseControls();
                for (int j = 0; j < databaseControlArray.length; ++j) {
                    DatabaseControl databaseControl;
                    if (nArray[1] <= -1 || (databaseControl = databaseControlArray[j]) == null) continue;
                    if (databaseControl.xServiceInfo.supportsService("com.sun.star.drawing.ShapeCollection")) {
                        TimeStampControl timeStampControl = (TimeStampControl)databaseControl;
                        for (int k = 0; k < 2; ++k) {
                            XPropertySet xPropertySet = timeStampControl.getControlofGroupShapeByIndex(k);
                            this.setDBControlColors(xPropertySet, nArray);
                        }
                        continue;
                    }
                    this.setDBControlColors(databaseControl.xPropertySet, nArray);
                }
                Control[] controlArray = controlForm.getLabelControls();
                for (int j = 0; j < controlArray.length; ++j) {
                    if (nArray[2] <= -1) continue;
                    controlArray[j].xPropertySet.setPropertyValue("TextColor", (Object)new Integer(nArray[2]));
                }
            }
            this.xPageStylePropertySet.setPropertyValue("BackColor", (Object)new Integer(nArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

