/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.io.IOException;
import java.util.Iterator;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.CellStyle;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.ColumnStyle;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.RowStyle;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetDecoder;
import org.openoffice.xmerge.converter.xml.sxc.SxcDocument;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SxcDocumentDeserializer
implements OfficeConstants,
DocumentDeserializer {
    private SpreadsheetDecoder decoder = null;
    private org.w3c.dom.Document settings = null;
    private org.w3c.dom.Document doc = null;
    private ConvertData cd = null;
    private StyleCatalog styleCat = null;
    private int textStyles = 1;
    private int colStyles = 1;
    private int rowStyles = 1;

    public SxcDocumentDeserializer(ConvertData convertData) {
        this.cd = convertData;
    }

    public abstract SpreadsheetDecoder createDecoder(String var1, String[] var2, String var3) throws IOException;

    protected abstract String getWorkbookName(ConvertData var1) throws IOException;

    protected abstract String[] getWorksheetNames(ConvertData var1) throws IOException;

    @Override
    public Document deserialize() throws ConvertException, IOException {
        String[] stringArray = this.getWorksheetNames(this.cd);
        String string = this.getWorkbookName(this.cd);
        SxcDocument sxcDocument = new SxcDocument(string);
        sxcDocument.initContentDOM();
        sxcDocument.initSettingsDOM();
        this.styleCat = new StyleCatalog(5);
        this.doc = sxcDocument.getContentDOM();
        this.settings = sxcDocument.getSettingsDOM();
        this.initFontTable();
        this.decoder = this.createDecoder(string, stringArray, "password");
        Debug.log(4, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        Debug.log(4, "<DEBUGLOG>");
        this.decoder.addDeviceContent(this.cd);
        this.decode();
        Debug.log(4, "</DEBUGLOG>");
        return sxcDocument;
    }

    private void initFontTable() {
        String[] stringArray = new String[]{"Tahoma", "Tahoma", "swiss", "variable", "Courier New", "&apos;Courier New&apos;", "modern", "fixed"};
        NodeList nodeList = this.doc.getElementsByTagName("office:font-decls");
        Node node = nodeList.item(0);
        int n = 0;
        while (n < stringArray.length) {
            Element element = this.doc.createElement("style:font-decl");
            element.setAttribute("style:name", stringArray[n++]);
            element.setAttribute("fo:font-family", stringArray[n++]);
            element.setAttribute("fo:font-family-generic", stringArray[n++]);
            element.setAttribute("style:font-pitch", stringArray[n++]);
            node.appendChild(element);
        }
    }

    protected void decode() throws IOException {
        int n = this.decoder.getNumberOfSheets();
        if (n == 0) {
            System.err.println("Error decoding invalid Input stream");
            return;
        }
        NodeList nodeList = this.doc.getElementsByTagName("office:body");
        Node node = nodeList.item(0);
        for (int i = 0; i < n; ++i) {
            this.decoder.setWorksheet(i);
            int n2 = nodeList.getLength();
            if (n2 <= 0) continue;
            this.processTable(node);
        }
        Iterator<NameDefinition> iterator = this.decoder.getNameDefinitions();
        if (iterator.hasNext()) {
            this.processNameDefinition(node, iterator);
        }
        NodeList nodeList2 = this.settings.getElementsByTagName("office:settings");
        Node node2 = nodeList2.item(0);
        this.processSettings(node2);
    }

    protected void processSettings(Node node) {
        Element element = this.settings.createElement("config:config-item-set");
        element.setAttribute("config:name", "view-settings");
        Element element2 = this.settings.createElement("config:config-item-map-indexed");
        element2.setAttribute("config:name", "Views");
        Element element3 = this.settings.createElement("config:config-item-map-entry");
        BookSettings bookSettings = this.decoder.getSettings();
        bookSettings.writeNode(this.settings, element3);
        element2.appendChild(element3);
        element.appendChild(element2);
        node.appendChild(element);
    }

    protected void processNameDefinition(Node node, Iterator<NameDefinition> iterator) throws IOException {
        Debug.log(4, "<NAMED-EXPRESSIONS>");
        Element element = this.doc.createElement("table:named-expressions");
        while (iterator.hasNext()) {
            NameDefinition nameDefinition = iterator.next();
            nameDefinition.writeNode(this.doc, element);
        }
        node.appendChild(element);
        Debug.log(4, "</NAMED-EXPRESSIONS>");
    }

    protected void processTable(Node node) throws IOException {
        Debug.log(4, "<TABLE>");
        Element element = this.doc.createElement("table:table");
        String string = this.decoder.getSheetName();
        element.setAttribute("table:name", string);
        element.setAttribute("table:style-name", "Default");
        node.appendChild(element);
        Debug.log(4, "<SheetName>" + string + "</SheetName>");
        this.processColumns(element);
        this.processCells(element);
        Debug.log(4, "</TABLE>");
    }

    protected void processColumns(Node node) throws IOException {
        Iterator<ColumnRowInfo> iterator = this.decoder.getColumnRowInfos();
        while (iterator.hasNext()) {
            Object object;
            String string;
            ColumnRowInfo columnRowInfo = iterator.next();
            if (!columnRowInfo.isColumn()) continue;
            ColumnStyle columnStyle = new ColumnStyle("Default", "table-column", "Default", columnRowInfo.getSize(), null);
            Style[] styleArray = this.styleCat.getMatching(columnStyle);
            if (styleArray.length == 0) {
                columnStyle.setName("co" + this.colStyles++);
                string = columnStyle.getName();
                Debug.log(4, "No existing style found, adding " + string);
                this.styleCat.add(columnStyle);
            } else {
                object = (ColumnStyle)styleArray[0];
                string = ((Style)object).getName();
                Debug.log(4, "Existing style found : " + string);
            }
            object = this.doc.createElement("table:table-column");
            object.setAttribute("table:style-name", string);
            if (columnRowInfo.getRepeated() != 1) {
                String string2 = String.valueOf(columnRowInfo.getRepeated());
                object.setAttribute("table:number-columns-repeated", string2);
            }
            node.appendChild((Node)object);
        }
    }

    protected void processCells(Node node) throws IOException {
        int n;
        int n2;
        Element element = null;
        Element element2 = null;
        int n3 = 0;
        int n4 = 1;
        int n5 = this.decoder.getNumberOfColumns();
        Node node2 = null;
        while (this.decoder.goToNextCell()) {
            Object object;
            Style[] styleArray;
            Object object2;
            Object object3;
            Style[] styleArray2;
            Cloneable cloneable;
            Object object4;
            Object object5;
            n2 = this.decoder.getRowNumber();
            if (n2 != n3) {
                if (n4 <= n5 && element != null) {
                    n = n5 - n4 + 1;
                    this.addEmptyCells(n, element);
                }
                if (n3 != 0) {
                    Debug.log(4, "</tr>");
                }
                if ((n = n2 - n3) > 1) {
                    this.addEmptyRows(n - 1, node, n5);
                }
                n4 = 1;
                element = this.doc.createElement("table:table-row");
                object5 = this.decoder.getColumnRowInfos();
                while (object5.hasNext()) {
                    object4 = (ColumnRowInfo)object5.next();
                    if (!((ColumnRowInfo)object4).isRow() || ((ColumnRowInfo)object4).getRepeated() != n2 - 1) continue;
                    cloneable = new RowStyle("Default", "table-row", "Default", ((ColumnRowInfo)object4).getSize(), null);
                    styleArray2 = this.styleCat.getMatching((Style)((Object)cloneable));
                    if (styleArray2.length == 0) {
                        ((Style)((Object)cloneable)).setName("ro" + this.rowStyles++);
                        object3 = ((Style)((Object)cloneable)).getName();
                        Debug.log(4, "No existing style found, adding " + (String)object3);
                        this.styleCat.add((Style)((Object)cloneable));
                    } else {
                        object2 = (RowStyle)styleArray2[0];
                        object3 = ((Style)object2).getName();
                        Debug.log(4, "Existing style found : " + (String)object3);
                    }
                    element.setAttribute("table:style-name", (String)object3);
                }
                node.appendChild(element);
                n3 = n2;
                Debug.log(4, "<tr>");
            }
            if ((n = this.decoder.getColNumber()) != n4) {
                int n6 = n - n4;
                this.addEmptyCells(n6, element);
                n4 = n;
            }
            Debug.log(4, "<td>");
            object5 = this.decoder.getCellContents();
            object4 = this.decoder.getCellDataType();
            cloneable = this.decoder.getCellFormat();
            element2 = this.doc.createElement("table:table-cell");
            styleArray2 = this.doc.getElementsByTagName("office:body").item(0);
            node2 = this.doc.getElementsByTagName("office:automatic-styles").item(0);
            if (node2 == null) {
                node2 = this.doc.createElement("office:automatic-styles");
                this.doc.insertBefore(node2, (Node)styleArray2);
            }
            if ((styleArray = this.styleCat.getMatching((Style)(object3 = new CellStyle("Default", "table-cell", "Default", (Format)cloneable, null)))).length == 0) {
                ((Style)object3).setName("ce" + this.textStyles++);
                object2 = ((Style)object3).getName();
                Debug.log(4, "No existing style found, adding " + (String)object2);
                this.styleCat.add((Style)object3);
            } else {
                object = (CellStyle)styleArray[0];
                object2 = ((Style)object).getName();
                Debug.log(4, "Existing style found : " + (String)object2);
            }
            element2.setAttribute("table:style-name", (String)object2);
            this.processCellData(element2, (String)object4, (String)object5);
            element.appendChild(element2);
            object = this.doc.createElement("text:p");
            element2.appendChild((Node)object);
            object.appendChild(this.doc.createTextNode((String)object5));
            Debug.log(4, (String)object5);
            Debug.log(4, "</td>");
            ++n4;
        }
        if (n4 <= n5 && element != null) {
            n2 = n5 - n4 + 1;
            this.addEmptyCells(n2, element);
        }
        if (node2 != null) {
            Debug.log(4, "Well the autostyle node was found!!!");
            NodeList nodeList = this.styleCat.writeNode(this.doc, "dummy").getChildNodes();
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                node2.appendChild(nodeList.item(0));
            }
        }
        if (n3 != 0) {
            Debug.log(4, "</tr>");
        }
    }

    protected void addEmptyRows(int n, Node node, int n2) {
        Element element = this.doc.createElement("table:table-row");
        element.setAttribute("table:style-name", "Default");
        element.setAttribute("table:number-rows-repeated", Integer.toString(n));
        node.appendChild(element);
        this.addEmptyCells(n2, element);
        for (int i = 0; i < n; ++i) {
            Debug.log(4, "<tr />");
        }
    }

    protected void addEmptyCells(int n, Node node) {
        Element element = this.doc.createElement("table:table-cell");
        element.setAttribute("table:style-name", "Default");
        if (n > 1) {
            element.setAttribute("table:number-columns-repeated", Integer.toString(n));
        }
        node.appendChild(element);
        for (int i = 0; i < n; ++i) {
            Debug.log(4, "<td />");
        }
    }

    protected void processCellData(Element element, String string, String string2) {
        element.setAttribute("table:value-type", string);
        if (string2.startsWith("=")) {
            element.setAttribute("table:formula", string2);
            element.setAttribute("table:value", this.decoder.getCellValue());
        } else if (!string.equals("string")) {
            if (string.equals("time")) {
                element.setAttribute("table:time-value", string2);
            } else if (string.equals("date")) {
                element.setAttribute("table:date-value", string2);
            } else if (string.equals("boolean")) {
                element.setAttribute("table:boolean-value", string2.toLowerCase());
            } else if (string.equals("currency")) {
                element.setAttribute("table:currency", "USD");
                element.setAttribute("table:value", string2);
            } else if (string.equals("percentage")) {
                element.setAttribute("table:value", string2);
            } else {
                element.setAttribute("table:value", string2);
            }
        }
    }
}

