/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.wizards.common.PropertyNames;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataAware {
    protected Object dataObject;
    protected Value value;

    protected DataAware(Object object, Value value) {
        this.dataObject = object;
        this.value = value;
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object object, boolean bl) {
        if (object != null && !this.value.isAssignable(object.getClass())) {
            throw new ClassCastException("can not cast new DataObject to original Class");
        }
        this.dataObject = object;
        if (bl) {
            this.updateUI();
        }
    }

    protected void setToData(Object object) {
        this.value.set(object, this.getDataObject());
    }

    protected Object getFromData() {
        return this.value.get(this.getDataObject());
    }

    protected abstract void setToUI(Object var1);

    protected abstract Object getFromUI();

    public void updateUI() {
        Object object;
        Object object2 = this.getFromData();
        if (!this.equals(object2, object = this.getFromUI())) {
            try {
                this.setToUI(object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.enableControls(object2);
    }

    protected void enableControls(Object object) {
    }

    public void updateData() {
        Object object;
        Object object2 = this.getFromData();
        if (!this.equals(object2, object = this.getFromUI())) {
            this.setToData(object);
        }
        this.enableControls(object);
    }

    protected boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass().isArray()) {
            if (object2.getClass().isArray()) {
                return Arrays.equals((short[])object, (short[])object2);
            }
            return false;
        }
        return object.equals(object2);
    }

    public static void updateUI(Collection<DataAware> collection) {
        Iterator<DataAware> iterator = collection.iterator();
        while (iterator.hasNext()) {
            iterator.next().updateUI();
        }
    }

    public static void updateData(Collection<DataAware> collection) {
        Iterator<DataAware> iterator = collection.iterator();
        while (iterator.hasNext()) {
            iterator.next().updateData();
        }
    }

    public static void setDataObject(Collection<DataAware> collection, Object object, boolean bl) {
        Iterator<DataAware> iterator = collection.iterator();
        while (iterator.hasNext()) {
            iterator.next().setDataObject(object, bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyValue
    implements Value {
        private Method getMethod;
        private Method setMethod;

        public PropertyValue(String string, Object object) {
            this.getMethod = this.createGetMethod(string, object);
            this.setMethod = this.createSetMethod(string, object, this.getMethod.getReturnType());
        }

        protected Method createGetMethod(String string, Object object) {
            Method method = null;
            try {
                method = object.getClass().getMethod("get" + string, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("get" + string + "() method does not exist on " + object.getClass().getName());
            }
            return method;
        }

        @Override
        public Object get(Object object) {
            block7: {
                try {
                    return this.getMethod.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (NullPointerException nullPointerException) {
                    if (this.getMethod.getReturnType().equals(String.class)) {
                        return PropertyNames.EMPTY_STRING;
                    }
                    if (this.getMethod.getReturnType().equals(Short.class)) {
                        return new Short(0);
                    }
                    if (this.getMethod.getReturnType().equals(Integer.class)) {
                        return 0;
                    }
                    if (!this.getMethod.getReturnType().equals(short[].class)) break block7;
                    return new short[0];
                }
            }
            return null;
        }

        protected Method createSetMethod(String string, Object object, Class<?> clazz) {
            Method method = null;
            try {
                method = object.getClass().getMethod("set" + string, clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("set" + string + "(" + this.getMethod.getReturnType().getName() + ") method does not exist on " + object.getClass().getName());
            }
            return method;
        }

        @Override
        public void set(Object object, Object object2) {
            try {
                this.setMethod.invoke(object2, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }

        @Override
        public boolean isAssignable(Class<?> clazz) {
            return this.getMethod.getDeclaringClass().isAssignableFrom(clazz) && this.setMethod.getDeclaringClass().isAssignableFrom(clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Value {
        public Object get(Object var1);

        public void set(Object var1, Object var2);

        public boolean isAssignable(Class<?> var1);
    }

    public static interface Listener {
        public void eventPerformed(Object var1);
    }
}

