/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.SQLQueryComposer;
import java.util.ArrayList;
import java.util.HashMap;

public class QueryMetaData
extends CommandMetaData {
    private SQLQueryComposer oSQLQueryComposer = null;
    FieldColumn CurFieldColumn;
    public String Command;
    private PropertyValue[][] m_aFilterConditions;
    public PropertyValue[][] GroupByFilterConditions = new PropertyValue[0][];
    public String[] UniqueAggregateFieldNames = new String[0];
    public int Type = 1;

    public QueryMetaData(XMultiServiceFactory xMultiServiceFactory, Locale locale, NumberFormatter numberFormatter) {
        super(xMultiServiceFactory, locale, numberFormatter);
    }

    public QueryMetaData(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
    }

    public void setFilterConditions(PropertyValue[][] propertyValueArray) {
        this.m_aFilterConditions = propertyValueArray;
    }

    public PropertyValue[][] getFilterConditions() {
        if (this.m_aFilterConditions == null) {
            this.m_aFilterConditions = new PropertyValue[0][];
        }
        return this.m_aFilterConditions;
    }

    public void setGroupByFilterConditions(PropertyValue[][] propertyValueArray) {
        this.GroupByFilterConditions = propertyValueArray;
    }

    public PropertyValue[][] getGroupByFilterConditions() {
        return this.GroupByFilterConditions;
    }

    public void addSeveralFieldColumns(String[] stringArray, String string) {
        FieldColumn[] fieldColumnArray;
        int n;
        ArrayList<FieldColumn> arrayList = new ArrayList<FieldColumn>();
        for (n = 0; n < stringArray.length; ++n) {
            fieldColumnArray = this.getFieldColumn(stringArray[n], string);
            if (fieldColumnArray != null) continue;
            arrayList.add(new FieldColumn(this, stringArray[n], string, false));
        }
        if (arrayList.size() > 0) {
            n = this.FieldColumns.length;
            fieldColumnArray = new FieldColumn[n + arrayList.size()];
            System.arraycopy(this.FieldColumns, 0, fieldColumnArray, 0, n);
            for (int i = 0; i < arrayList.size(); ++i) {
                fieldColumnArray[n + i] = (FieldColumn)arrayList.get(i);
            }
            this.FieldColumns = fieldColumnArray;
        }
    }

    public void reorderFieldColumns(String[] stringArray) {
        FieldColumn[] fieldColumnArray = new FieldColumn[this.FieldColumns.length];
        for (int i = 0; i < stringArray.length; ++i) {
            FieldColumn fieldColumn;
            fieldColumnArray[i] = fieldColumn = this.getFieldColumnByDisplayName(stringArray[i]);
        }
        System.arraycopy(fieldColumnArray, 0, this.FieldColumns, 0, fieldColumnArray.length);
    }

    public void removeSeveralFieldColumnsByDisplayFieldName(String[] stringArray) {
        ArrayList<FieldColumn> arrayList = new ArrayList<FieldColumn>();
        boolean bl = false;
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            String string = this.FieldColumns[i].getDisplayFieldName();
            if (JavaTools.FieldInList(stringArray, string) > -1) continue;
            arrayList.add(this.FieldColumns[i]);
        }
        this.FieldColumns = new FieldColumn[arrayList.size()];
        arrayList.toArray(this.FieldColumns);
    }

    public void removeFieldColumn(String string, String string2) {
        FieldColumn fieldColumn = this.getFieldColumn(string, string2);
        int n = 0;
        if (fieldColumn != null) {
            FieldColumn[] fieldColumnArray = new FieldColumn[this.FieldColumns.length - 1];
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                if (this.FieldColumns[i].getFieldName().equals(string) || this.FieldColumns[i].getCommandName().equals(string2)) continue;
                fieldColumnArray[n] = this.FieldColumns[i];
                ++n;
            }
            this.FieldColumns = fieldColumnArray;
        }
    }

    public String[] getIncludedCommandNames() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            FieldColumn fieldColumn = this.FieldColumns[i];
            String string = fieldColumn.getCommandName();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getIncludedCommandNames(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = PropertyNames.EMPTY_STRING;
            String[] stringArray2 = JavaTools.ArrayoutofString(stringArray[i], ".");
            if (stringArray2.length <= 1) continue;
            for (int j = 0; j < stringArray2.length - 1; ++j) {
                string = string + stringArray2[j];
            }
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        String[] stringArray3 = new String[arrayList.size()];
        arrayList.toArray(stringArray3);
        return stringArray3;
    }

    public String[] getFieldNamesOfCommand(String string) {
        DBMetaData.CommandObject commandObject = this.getTableByName(string);
        return commandObject.getColumns().getElementNames();
    }

    public void initializeFieldTitleSet(boolean bl) {
        try {
            if (this.FieldTitleSet == null) {
                this.FieldTitleSet = new HashMap();
            }
            String[] stringArray = this.getIncludedCommandNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                DBMetaData.CommandObject commandObject = this.getTableByName(string);
                String string2 = commandObject.getName();
                String[] stringArray2 = commandObject.getColumns().getElementNames();
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string3 = FieldColumn.composeDisplayFieldName(string2, stringArray2[j]);
                    if (this.FieldTitleSet.containsKey(string3)) continue;
                    this.FieldTitleSet.put(string3, stringArray2[j]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public String[] getUniqueAggregateFieldNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.AggregateFieldNames.length; ++i) {
            if (arrayList.contains(this.AggregateFieldNames[i][0])) continue;
            arrayList.add(this.AggregateFieldNames[i][0]);
        }
        this.UniqueAggregateFieldNames = new String[arrayList.size()];
        arrayList.toArray(this.UniqueAggregateFieldNames);
        return this.UniqueAggregateFieldNames;
    }

    public boolean hasNumericalFields() {
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            if (!this.FieldColumns[i].isNumberFormat()) continue;
            return true;
        }
        return false;
    }

    public int getAggregateIndex(String string) {
        int n = -1;
        if (this.Type == 0) {
            n = JavaTools.FieldInTable(this.AggregateFieldNames, string);
        }
        return n;
    }

    public SQLQueryComposer getSQLQueryComposer() {
        if (this.oSQLQueryComposer == null) {
            this.oSQLQueryComposer = new SQLQueryComposer(this);
        }
        return this.oSQLQueryComposer;
    }

    public static interface QueryType {
        public static final int SOSUMMARYQUERY = 0;
        public static final int SODETAILQUERY = 1;
    }
}

