/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XChild;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XHierarchicalNameContainer;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.sdb.XCompletedConnection;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdb.XFormDocumentsSupplier;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sdb.XQueriesSupplier;
import com.sun.star.sdb.XQueryDefinitionsSupplier;
import com.sun.star.sdb.XReportDocumentsSupplier;
import com.sun.star.sdb.tools.XConnectionTools;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XDataSource;
import com.sun.star.sdbc.XDatabaseMetaData;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdbcx.XTablesSupplier;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NamedValueCollection;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.db.SQLQueryComposer;
import com.sun.star.wizards.db.TypeInspector;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBMetaData {
    private XNameAccess xQueryNames;
    public XDatabaseMetaData xDBMetaData;
    private XDataSource m_dataSource;
    private XPropertySet m_dataSourceSettings;
    private XOfficeDatabaseDocument xModel;
    private XPropertySet xDataSourcePropertySet;
    public String[] DataSourceNames;
    public String[] CommandNames;
    public ArrayList<CommandObject> CommandObjects = new ArrayList(1);
    public Locale aLocale;
    public int[] CommandTypes;
    public String DataSourceName;
    public XConnection DBConnection;
    private XConnectionTools m_connectionTools;
    public XMultiServiceFactory xMSF;
    public XComponent xConnectionComponent;
    private XNameAccess xNameAccess;
    private XInterface xDatabaseContext;
    private XWindowPeer xWindowPeer;
    private String[] TableNames = new String[0];
    private String[] QueryNames = new String[0];
    protected int[][] WidthList;
    protected static final int[] NumericTypes = new int[]{-6, -5, 2, 3, 4, 5, 6, 7, 8};
    protected static final int[] BinaryTypes = new int[]{-2, -3, -4, 2004, 0, 2000, 2001, 2002, 2003, 2005, 2006};
    private int iMaxColumnsInSelect;
    private int iMaxColumnsInGroupBy;
    private int iMaxColumnNameLength = -1;
    private int iMaxTableNameLength = -1;
    private boolean bPasswordIsRequired;
    private static final int NOLIMIT = 9999999;
    protected static final int RID_DB_COMMON = 1000;
    private static final int INVALID = 9999999;
    public TypeInspector oTypeInspector;
    private NumberFormatter oNumberFormatter = null;
    private long lDateCorrection = 9999999L;
    private boolean bdisposeConnection = false;

    public XPropertySet getDataSourcePropertySet() {
        return this.xDataSourcePropertySet;
    }

    public DBMetaData(XMultiServiceFactory xMultiServiceFactory) {
        this.getInterfaces(xMultiServiceFactory);
        this.InitializeWidthList();
    }

    public DBMetaData(XMultiServiceFactory xMultiServiceFactory, Locale locale, NumberFormatter numberFormatter) {
        this.oNumberFormatter = numberFormatter;
        this.aLocale = locale;
        this.getInterfaces(xMultiServiceFactory);
        this.InitializeWidthList();
    }

    public NumberFormatter getNumberFormatter() {
        if (this.oNumberFormatter == null) {
            try {
                XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)AnyConverter.toObject(XNumberFormatsSupplier.class, (Object)this.xDataSourcePropertySet.getPropertyValue("NumberFormatsSupplier"));
                this.aLocale = Configuration.getLocale(this.xMSF);
                this.oNumberFormatter = new NumberFormatter(this.xMSF, xNumberFormatsSupplier, this.aLocale);
                this.lDateCorrection = this.oNumberFormatter.getNullDateCorrection();
            }
            catch (Exception exception) {
                Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
        return this.oNumberFormatter;
    }

    public long getNullDateCorrection() {
        if (this.lDateCorrection == 9999999L) {
            if (this.oNumberFormatter == null) {
                this.oNumberFormatter = this.getNumberFormatter();
            }
            this.lDateCorrection = this.oNumberFormatter.getNullDateCorrection();
        }
        return this.lDateCorrection;
    }

    private void getInterfaces(XMultiServiceFactory xMultiServiceFactory) {
        try {
            this.xMSF = xMultiServiceFactory;
            this.xDatabaseContext = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.sdb.DatabaseContext");
            this.xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.xDatabaseContext);
            this.DataSourceNames = this.xNameAccess.getElementNames();
        }
        catch (Exception exception) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void setCommandTypes() {
        int n = JavaTools.getArraylength(this.TableNames);
        int n2 = JavaTools.getArraylength(this.QueryNames);
        int n3 = n + n2;
        this.CommandTypes = new int[n3];
        if (n > 0) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                this.CommandTypes[n4] = 0;
            }
            int n5 = n4;
            for (n4 = 0; n4 < n2; ++n4) {
                this.CommandTypes[n5] = 1;
                ++n5;
            }
        }
    }

    public boolean hasTableByName(String string) {
        return this.getTableNamesAsNameAccess().hasByName(string);
    }

    public void setTableByName(String string) {
        CommandObject commandObject = new CommandObject(string, 0);
        this.CommandObjects.add(commandObject);
    }

    public CommandObject getTableByName(String string) {
        return this.getCommandByName(string, 0);
    }

    public CommandObject getQueryByName(String string) {
        return this.getCommandByName(string, 1);
    }

    public CommandObject getCommandByName(String string, int n) {
        CommandObject commandObject = null;
        for (int i = 0; i < this.CommandObjects.size(); ++i) {
            commandObject = this.CommandObjects.get(i);
            if (!commandObject.Name.equals(string) || commandObject.CommandType != n) continue;
            return commandObject;
        }
        if (commandObject == null) {
            commandObject = new CommandObject(string, n);
            this.CommandObjects.add(commandObject);
        }
        return commandObject;
    }

    public void setQueryByName(String string) {
        CommandObject commandObject = new CommandObject(string, 1);
        this.CommandObjects.add(commandObject);
    }

    public boolean hasEscapeProcessing(XPropertySet xPropertySet) {
        boolean bl = false;
        try {
            if (xPropertySet.getPropertySetInfo().hasPropertyByName("EscapeProcessing")) {
                bl = AnyConverter.toBoolean((Object)xPropertySet.getPropertyValue("EscapeProcessing"));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
        }
        return bl;
    }

    public XNameAccess getQueryNamesAsNameAccess() {
        XQueriesSupplier xQueriesSupplier = (XQueriesSupplier)UnoRuntime.queryInterface(XQueriesSupplier.class, (Object)this.DBConnection);
        this.xQueryNames = xQueriesSupplier.getQueries();
        return this.xQueryNames;
    }

    public XNameAccess getTableNamesAsNameAccess() {
        XTablesSupplier xTablesSupplier = (XTablesSupplier)UnoRuntime.queryInterface(XTablesSupplier.class, (Object)this.DBConnection);
        return xTablesSupplier.getTables();
    }

    public String[] getQueryNames() {
        if (this.QueryNames != null && this.QueryNames.length > 0) {
            return this.QueryNames;
        }
        this.QueryNames = this.getQueryNamesAsNameAccess().getElementNames();
        return this.QueryNames;
    }

    public String[] getTableNames() {
        if (this.TableNames != null && this.TableNames.length > 0) {
            return this.TableNames;
        }
        this.TableNames = this.getTableNamesAsNameAccess().getElementNames();
        return this.TableNames;
    }

    private void InitializeWidthList() {
        this.WidthList = new int[17][2];
        this.WidthList[0][0] = -7;
        this.WidthList[1][0] = 16;
        this.WidthList[2][0] = -6;
        this.WidthList[3][0] = -5;
        this.WidthList[4][0] = -1;
        this.WidthList[5][0] = 1;
        this.WidthList[6][0] = 2;
        this.WidthList[7][0] = 3;
        this.WidthList[8][0] = 4;
        this.WidthList[9][0] = 5;
        this.WidthList[10][0] = 6;
        this.WidthList[11][0] = 7;
        this.WidthList[12][0] = 8;
        this.WidthList[13][0] = 12;
        this.WidthList[14][0] = 91;
        this.WidthList[15][0] = 92;
        this.WidthList[16][0] = 93;
    }

    public boolean isBinaryDataType(int n) {
        if (NumericTypes == null) {
            this.InitializeWidthList();
        }
        return JavaTools.FieldInIntTable(BinaryTypes, n) > -1;
    }

    public int getMaxTablesInSelect() {
        try {
            int n = this.xDBMetaData.getMaxTablesInSelect();
            if (n == 0) {
                return 9999999;
            }
            return n;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, sQLException);
            return -1;
        }
    }

    public int getMaxColumnsInSelect() {
        return this.iMaxColumnsInSelect;
    }

    public int getMaxColumnsInGroupBy() {
        return this.iMaxColumnsInGroupBy;
    }

    private void setMaxColumnsInSelect() throws SQLException {
        this.iMaxColumnsInSelect = this.xDBMetaData.getMaxColumnsInSelect();
        if (this.iMaxColumnsInSelect == 0) {
            this.iMaxColumnsInSelect = 9999999;
        }
    }

    private void setMaxColumnsInGroupBy() throws SQLException {
        this.iMaxColumnsInGroupBy = this.xDBMetaData.getMaxColumnsInGroupBy();
        if (this.iMaxColumnsInGroupBy == 0) {
            this.iMaxColumnsInGroupBy = 9999999;
        }
    }

    public int getMaxColumnsInTable() throws SQLException {
        int n = this.xDBMetaData.getMaxColumnsInTable();
        if (n == 0) {
            n = 9999999;
        }
        return n;
    }

    private void getDataSourceObjects() throws Exception {
        try {
            this.xDBMetaData = this.DBConnection.getMetaData();
            this.getDataSourceInterfaces();
            this.setMaxColumnsInGroupBy();
            this.setMaxColumnsInSelect();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, sQLException);
        }
    }

    private void ensureDataSourceSettings() throws UnknownPropertyException, WrappedTargetException {
        if (this.m_dataSourceSettings != null) {
            return;
        }
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.getDataSource());
        this.m_dataSourceSettings = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPropertySet.getPropertyValue("Settings"));
    }

    public boolean isSQL92CheckEnabled() {
        boolean bl = false;
        try {
            this.ensureDataSourceSettings();
            bl = AnyConverter.toBoolean((Object)this.m_dataSourceSettings.getPropertyValue("EnableSQL92Check"));
        }
        catch (Exception exception) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
        }
        return bl;
    }

    public String verifyName(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        if (this.isSQL92CheckEnabled()) {
            return Desktop.removeSpecialCharacters(this.xMSF, Configuration.getLocale(this.xMSF), string);
        }
        return string;
    }

    public XDataSource getDataSource() {
        if (this.m_dataSource == null) {
            try {
                Object object = this.xNameAccess.getByName(this.DataSourceName);
                this.m_dataSource = (XDataSource)UnoRuntime.queryInterface(XDataSource.class, (Object)object);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (WrappedTargetException wrappedTargetException) {
                // empty catch block
            }
        }
        return this.m_dataSource;
    }

    private void setDataSourceByName(String string) {
        try {
            this.DataSourceName = string;
            this.getDataSourceInterfaces();
            XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, (Object)this.getDataSource());
            if (xDocumentDataSource != null) {
                this.xModel = xDocumentDataSource.getDatabaseDocument();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void getDataSourceInterfaces() throws Exception {
        this.xDataSourcePropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.getDataSource());
        this.bPasswordIsRequired = (Boolean)this.xDataSourcePropertySet.getPropertyValue("IsPasswordRequired");
    }

    public boolean getConnection(PropertyValue[] propertyValueArray) {
        try {
            XConnection xConnection = null;
            if (Properties.hasPropertyValue(propertyValueArray, PropertyNames.ACTIVE_CONNECTION)) {
                xConnection = (XConnection)UnoRuntime.queryInterface(XConnection.class, (Object)Properties.getPropertyValue(propertyValueArray, PropertyNames.ACTIVE_CONNECTION));
                if (xConnection != null) {
                    XPropertySet xPropertySet;
                    XChild xChild = (XChild)UnoRuntime.queryInterface(XChild.class, (Object)xConnection);
                    this.m_dataSource = (XDataSource)UnoRuntime.queryInterface(XDataSource.class, (Object)xChild.getParent());
                    XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, (Object)this.m_dataSource);
                    if (xDocumentDataSource != null) {
                        this.xModel = xDocumentDataSource.getDatabaseDocument();
                    }
                    if ((xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_dataSource)) != null) {
                        this.DataSourceName = AnyConverter.toString((Object)xPropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME));
                    }
                    return this.getConnection(xConnection);
                }
                this.bdisposeConnection = true;
            } else {
                this.bdisposeConnection = true;
            }
            if (Properties.hasPropertyValue(propertyValueArray, "DataSourceName")) {
                String string = AnyConverter.toString((Object)Properties.getPropertyValue(propertyValueArray, "DataSourceName"));
                return this.getConnection(string);
            }
            if (Properties.hasPropertyValue(propertyValueArray, "DataSource")) {
                this.m_dataSource = (XDataSource)UnoRuntime.queryInterface(XDataSource.class, (Object)Properties.getPropertyValue(propertyValueArray, "DataSource"));
                XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, (Object)this.m_dataSource);
                if (xDocumentDataSource != null) {
                    this.xModel = xDocumentDataSource.getDatabaseDocument();
                }
                return this.getConnection(this.m_dataSource);
            }
            if (Properties.hasPropertyValue(propertyValueArray, "DatabaseLocation")) {
                String string = AnyConverter.toString((Object)Properties.getPropertyValue(propertyValueArray, "DatabaseLocation"));
                return this.getConnection(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, unknownPropertyException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, wrappedTargetException);
        }
        return false;
    }

    private boolean getConnection(String string) {
        this.setDataSourceByName(string);
        return this.getConnection(this.getDataSource());
    }

    private boolean getConnection(XConnection xConnection) {
        try {
            this.DBConnection = xConnection;
            this.m_connectionTools = (XConnectionTools)UnoRuntime.queryInterface(XConnectionTools.class, (Object)this.DBConnection);
            this.getDataSourceObjects();
            return true;
        }
        catch (Exception exception) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
            return false;
        }
    }

    private boolean getConnection(XDataSource xDataSource) {
        Resource resource = new Resource(this.xMSF, "Database", "dbw");
        try {
            Object object;
            int n = 0;
            boolean bl = false;
            if (this.DBConnection != null) {
                this.xConnectionComponent.dispose();
            }
            this.getDataSourceInterfaces();
            if (!this.bPasswordIsRequired) {
                this.DBConnection = xDataSource.getConnection(PropertyNames.EMPTY_STRING, PropertyNames.EMPTY_STRING);
                bl = true;
            } else {
                object = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)this.xMSF.createInstance("com.sun.star.task.InteractionHandler"));
                boolean bl2 = true;
                do {
                    XCompletedConnection xCompletedConnection = (XCompletedConnection)UnoRuntime.queryInterface(XCompletedConnection.class, (Object)xDataSource);
                    try {
                        this.DBConnection = xCompletedConnection.connectWithCompletion(object);
                        boolean bl3 = bl = this.DBConnection != null;
                        if (bl) continue;
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        String string = resource.getResText(1014);
                        n = this.showMessageBox("QueryBox", 0x4000000, string);
                        bl2 = n == 0;
                        bl = false;
                    }
                } while (!bl2);
            }
            if (!bl) {
                object = resource.getResText(1035);
                this.showMessageBox("ErrorBox", 0x400000, (String)object);
            } else {
                this.xConnectionComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.DBConnection);
                this.m_connectionTools = (XConnectionTools)UnoRuntime.queryInterface(XConnectionTools.class, (Object)this.DBConnection);
                this.getDataSourceObjects();
            }
            return bl;
        }
        catch (Exception exception) {
            String string = resource.getResText(1035);
            this.showMessageBox("ErrorBox", 0x400000, string);
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
            return false;
        }
    }

    public int getMaxColumnNameLength() {
        try {
            if (this.iMaxColumnNameLength <= 0) {
                this.iMaxColumnNameLength = this.xDBMetaData.getMaxColumnNameLength();
            }
            return this.iMaxColumnNameLength;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, sQLException);
            return 0;
        }
    }

    public int getMaxTableNameLength() {
        try {
            if (this.iMaxTableNameLength <= 0) {
                this.iMaxTableNameLength = this.xDBMetaData.getMaxTableNameLength();
            }
            return this.iMaxTableNameLength;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, sQLException);
            return 0;
        }
    }

    public boolean supportsPrimaryKeys() {
        boolean bl = false;
        try {
            this.ensureDataSourceSettings();
            Any any = (Any)this.m_dataSourceSettings.getPropertyValue("PrimaryKeySupport");
            bl = AnyConverter.isVoid((Object)any) ? this.supportsCoreSQLGrammar() : AnyConverter.toBoolean((Object)any);
        }
        catch (Exception exception) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
        }
        return bl;
    }

    public boolean supportsCoreSQLGrammar() {
        try {
            return this.xDBMetaData.supportsCoreSQLGrammar();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, sQLException);
            return false;
        }
    }

    public boolean supportsAutoIncrementation() {
        return false;
    }

    public boolean supportsQueriesInFrom() {
        return this.m_connectionTools.getDataSourceMetaData().supportsQueriesInFrom();
    }

    public String suggestName(int n, String string) throws IllegalArgumentException {
        return this.m_connectionTools.getObjectNames().suggestName(n, string);
    }

    public boolean createQuery(SQLQueryComposer sQLQueryComposer, String string) {
        try {
            XQueryDefinitionsSupplier xQueryDefinitionsSupplier = (XQueryDefinitionsSupplier)UnoRuntime.queryInterface(XQueryDefinitionsSupplier.class, (Object)this.m_dataSource);
            XNameAccess xNameAccess = xQueryDefinitionsSupplier.getQueryDefinitions();
            XSingleServiceFactory xSingleServiceFactory = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xNameAccess);
            Object object = xSingleServiceFactory.createInstance();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            String string2 = sQLQueryComposer.m_xQueryAnalyzer.getQuery();
            xPropertySet.setPropertyValue(PropertyNames.COMMAND, (Object)string2);
            XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xNameAccess);
            this.m_connectionTools.getObjectNames().checkNameForCreate(1, string);
            xNameContainer.insertByName(string, object);
            return true;
        }
        catch (WrappedTargetException wrappedTargetException) {
            SQLException sQLException = null;
            try {
                sQLException = (SQLException)((Object)wrappedTargetException.TargetException);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (sQLException != null) {
                this.callSQLErrorMessageDialog(sQLException, null);
                return false;
            }
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, wrappedTargetException);
        }
        catch (SQLException sQLException) {
            this.callSQLErrorMessageDialog(sQLException, null);
            return false;
        }
        catch (Exception exception) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
        }
        return false;
    }

    public void dispose() {
        if (this.DBConnection != null && this.bdisposeConnection) {
            this.xConnectionComponent.dispose();
        }
    }

    public XHierarchicalNameAccess getReportDocuments() {
        XReportDocumentsSupplier xReportDocumentsSupplier = (XReportDocumentsSupplier)UnoRuntime.queryInterface(XReportDocumentsSupplier.class, (Object)this.xModel);
        xReportDocumentsSupplier.getReportDocuments();
        return (XHierarchicalNameAccess)UnoRuntime.queryInterface(XHierarchicalNameAccess.class, (Object)xReportDocumentsSupplier.getReportDocuments());
    }

    public XHierarchicalNameAccess getFormDocuments() {
        XFormDocumentsSupplier xFormDocumentsSupplier = (XFormDocumentsSupplier)UnoRuntime.queryInterface(XFormDocumentsSupplier.class, (Object)this.xModel);
        return (XHierarchicalNameAccess)UnoRuntime.queryInterface(XHierarchicalNameAccess.class, (Object)xFormDocumentsSupplier.getFormDocuments());
    }

    public boolean hasFormDocumentByName(String string) {
        XFormDocumentsSupplier xFormDocumentsSupplier = (XFormDocumentsSupplier)UnoRuntime.queryInterface(XFormDocumentsSupplier.class, (Object)this.xModel);
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xFormDocumentsSupplier.getFormDocuments());
        return xNameAccess.hasByName(string);
    }

    public void addFormDocument(XComponent xComponent) {
        XHierarchicalNameAccess xHierarchicalNameAccess = this.getFormDocuments();
        this.addDatabaseDocument(xComponent, xHierarchicalNameAccess, false);
    }

    public void addReportDocument(XComponent xComponent, boolean bl) {
        XHierarchicalNameAccess xHierarchicalNameAccess = this.getReportDocuments();
        this.addDatabaseDocument(xComponent, xHierarchicalNameAccess, bl);
    }

    public void addDatabaseDocument(XComponent xComponent, XHierarchicalNameAccess xHierarchicalNameAccess, boolean bl) {
        try {
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            String string = xModel.getURL();
            String string2 = FileAccess.getBasename(string, "/");
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xComponent);
            xCloseable.close(false);
            NamedValueCollection namedValueCollection = new NamedValueCollection();
            namedValueCollection.put(PropertyNames.PROPERTY_NAME, string2);
            namedValueCollection.put(PropertyNames.URL, string);
            namedValueCollection.put("AsTemplate", bl);
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xHierarchicalNameAccess);
            Object object = xMultiServiceFactory.createInstanceWithArguments("com.sun.star.sdb.DocumentDefinition", (Object[])namedValueCollection.getPropertyValues());
            XHierarchicalNameContainer xHierarchicalNameContainer = (XHierarchicalNameContainer)UnoRuntime.queryInterface(XHierarchicalNameContainer.class, (Object)xHierarchicalNameAccess);
            String string3 = Desktop.getUniqueName(xHierarchicalNameAccess, string2);
            xHierarchicalNameContainer.insertByHierarchicalName(string3, object);
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            xSimpleFileAccess.kill(string);
        }
        catch (Exception exception) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void createTypeInspector() throws SQLException {
        this.oTypeInspector = new TypeInspector(this.xDBMetaData.getTypeInfo());
    }

    public TypeInspector getDBDataTypeInspector() {
        return this.oTypeInspector;
    }

    private String[] StringsFromResultSet(XResultSet xResultSet, int n) {
        String[] stringArray = null;
        try {
            XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)xResultSet);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (xResultSet.next()) {
                arrayList.add(xRow.getString(n));
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, sQLException);
        }
        return stringArray;
    }

    public String[] getCatalogNames() {
        try {
            XResultSet xResultSet = this.xDBMetaData.getCatalogs();
            return this.StringsFromResultSet(xResultSet, 1);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, sQLException);
            return null;
        }
    }

    public String[] getSchemaNames() {
        try {
            XResultSet xResultSet = this.xDBMetaData.getSchemas();
            return this.StringsFromResultSet(xResultSet, 1);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, sQLException);
            return null;
        }
    }

    public boolean storeDatabaseDocumentToTempPath(XComponent xComponent, String string) {
        try {
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            String string2 = FileAccess.getOfficePath(this.xMSF, "Temp", xSimpleFileAccess) + "/" + string;
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
            PropertyValue[] propertyValueArray = new PropertyValue[]{Properties.createProperty("FilterName", "writer8")};
            string2 = string2 + ".odt";
            xStorable.storeAsURL(string2, propertyValueArray);
            return true;
        }
        catch (Exception exception) {
            Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
            return false;
        }
    }

    public int showMessageBox(String string, int n, String string2) {
        if (this.getWindowPeer() != null) {
            return SystemDialog.showMessageBox(this.xMSF, this.xWindowPeer, string, n, string2);
        }
        return SystemDialog.showMessageBox(this.xMSF, string, n, string2);
    }

    public XWindowPeer getWindowPeer() {
        return this.xWindowPeer;
    }

    public void setWindowPeer(XWindowPeer xWindowPeer) {
        this.xWindowPeer = xWindowPeer;
    }

    public void callSQLErrorMessageDialog(SQLException sQLException, XWindow xWindow) {
        try {
            Object object = this.xMSF.createInstance("com.sun.star.sdb.ErrorMessageDialog");
            XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)object);
            Object[] objectArray = new PropertyValue[]{Properties.createProperty("SQLException", (Object)sQLException), Properties.createProperty("ParentWindow", xWindow)};
            xInitialization.initialize(objectArray);
            XExecutableDialog xExecutableDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)object);
            xExecutableDialog.execute();
        }
        catch (com.sun.star.uno.Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error calling the error dialog", exception);
        }
    }

    public void finish() {
        this.xQueryNames = null;
        this.xNameAccess = null;
        this.xDatabaseContext = null;
        this.xDBMetaData = null;
        this.m_dataSource = null;
        this.xModel = null;
        this.xDataSourcePropertySet = null;
        this.xWindowPeer = null;
        this.DBConnection = null;
        this.m_connectionTools = null;
        this.xMSF = null;
        this.xConnectionComponent = null;
        this.CommandObjects = null;
    }

    public class CommandObject {
        private XNameAccess xColumns;
        private XPropertySet xPropertySet;
        private String Name;
        private int CommandType;

        public CommandObject(String string, int n) {
            try {
                this.Name = string;
                this.CommandType = n;
                Object object = this.CommandType == 0 ? DBMetaData.this.getTableNamesAsNameAccess().getByName(this.Name) : DBMetaData.this.getQueryNamesAsNameAccess().getByName(this.Name);
                XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)object);
                this.xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
                this.xColumns = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xColumnsSupplier.getColumns());
            }
            catch (Exception exception) {
                Logger.getLogger(DBMetaData.class.getName()).log(Level.SEVERE, null, exception);
            }
        }

        public XNameAccess getColumns() {
            return this.xColumns;
        }

        public String getName() {
            return this.Name;
        }

        public XPropertySet getPropertySet() {
            return this.xPropertySet;
        }
    }
}

