/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatter;
import com.sun.star.wizards.common.Helper;
import java.util.Calendar;
import java.util.Date;

public class NumberFormatter {
    public int iDateFormatKey = -1;
    public int iDateTimeFormatKey = -1;
    public int iNumberFormatKey = -1;
    public int iTextFormatKey = -1;
    public int iTimeFormatKey = -1;
    public int iLogicalFormatKey = -1;
    public long lDateCorrection;
    public XNumberFormatter xNumberFormatter;
    public XNumberFormats xNumberFormats;
    public XNumberFormatTypes xNumberFormatTypes;
    public XPropertySet xNumberFormatSettings;
    private boolean bNullDateCorrectionIsDefined = false;
    private Locale aLocale;

    public NumberFormatter(XMultiServiceFactory xMultiServiceFactory, XNumberFormatsSupplier xNumberFormatsSupplier, Locale locale) throws Exception {
        this.aLocale = locale;
        Object object = xMultiServiceFactory.createInstance("com.sun.star.util.NumberFormatter");
        this.xNumberFormats = xNumberFormatsSupplier.getNumberFormats();
        this.xNumberFormatSettings = xNumberFormatsSupplier.getNumberFormatSettings();
        this.xNumberFormatter = (XNumberFormatter)UnoRuntime.queryInterface(XNumberFormatter.class, (Object)object);
        this.xNumberFormatter.attachNumberFormatsSupplier(xNumberFormatsSupplier);
        this.xNumberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface(XNumberFormatTypes.class, (Object)this.xNumberFormats);
    }

    public NumberFormatter(XNumberFormatsSupplier xNumberFormatsSupplier, Locale locale) throws Exception {
        this.aLocale = locale;
        this.xNumberFormats = xNumberFormatsSupplier.getNumberFormats();
        this.xNumberFormatSettings = xNumberFormatsSupplier.getNumberFormatSettings();
        this.xNumberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface(XNumberFormatTypes.class, (Object)this.xNumberFormats);
    }

    public static XNumberFormatter createNumberFormatter(XMultiServiceFactory xMultiServiceFactory, XNumberFormatsSupplier xNumberFormatsSupplier) throws Exception {
        Object object = xMultiServiceFactory.createInstance("com.sun.star.util.NumberFormatter");
        XNumberFormatter xNumberFormatter = (XNumberFormatter)UnoRuntime.queryInterface(XNumberFormatter.class, (Object)object);
        xNumberFormatter.attachNumberFormatsSupplier(xNumberFormatsSupplier);
        return xNumberFormatter;
    }

    public static int getNumberFormatterKey(Object object, short s) {
        XNumberFormats xNumberFormats = ((XNumberFormatsSupplier)UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)object)).getNumberFormats();
        Locale locale = new Locale();
        return ((XNumberFormatTypes)UnoRuntime.queryInterface(XNumberFormatTypes.class, (Object)xNumberFormats)).getFormatIndex(s, locale);
    }

    public String convertNumberToString(int n, double d) {
        return this.xNumberFormatter.convertNumberToString(n, d);
    }

    public static String convertNumberToString(XNumberFormatter xNumberFormatter, int n, double d) {
        return xNumberFormatter.convertNumberToString(n, d);
    }

    public double convertStringToNumber(int n, String string) throws Exception {
        return this.xNumberFormatter.convertStringToNumber(n, string);
    }

    public void setNullDateCorrection(long l) {
        this.lDateCorrection = l;
    }

    public int defineNumberFormat(String string) {
        try {
            int n = this.xNumberFormats.queryKey(string, this.aLocale, true);
            if (n == -1) {
                n = this.xNumberFormats.addNew(string, this.aLocale);
            }
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public int defineNumberFormat(String string, Locale locale) {
        try {
            int n = this.xNumberFormats.queryKey(string, locale, true);
            if (n == -1) {
                n = this.xNumberFormats.addNew(string, locale);
            }
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public void setNumberFormat(XInterface xInterface, int n, NumberFormatter numberFormatter) {
        block5: {
            try {
                XPropertySet xPropertySet = numberFormatter.xNumberFormats.getByKey(n);
                String string = AnyConverter.toString((Object)Helper.getUnoPropertyValue(xPropertySet, "FormatString"));
                Locale locale = (Locale)Helper.getUnoPropertyValue(xPropertySet, "Locale");
                int n2 = this.defineNumberFormat(string, locale);
                XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
                if (xPropertySet2.getPropertySetInfo().hasPropertyByName("FormatsSupplier")) {
                    xPropertySet2.setPropertyValue("FormatsSupplier", (Object)numberFormatter.xNumberFormatter.getNumberFormatsSupplier());
                }
                if (xPropertySet2.getPropertySetInfo().hasPropertyByName("NumberFormat")) {
                    xPropertySet2.setPropertyValue("NumberFormat", (Object)new Integer(n2));
                    break block5;
                }
                if (xPropertySet2.getPropertySetInfo().hasPropertyByName("FormatKey")) {
                    xPropertySet2.setPropertyValue("FormatKey", (Object)new Integer(n2));
                    break block5;
                }
                throw new Exception();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public long getNullDateCorrection() {
        if (!this.bNullDateCorrectionIsDefined) {
            com.sun.star.util.Date date = (com.sun.star.util.Date)Helper.getUnoStructValue(this.xNumberFormatSettings, "NullDate");
            long l = Helper.convertUnoDatetoInteger(date);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1900, 1, 1);
            Date date2 = calendar.getTime();
            long l2 = date2.getTime();
            long l3 = l2 / 86400000L;
            this.lDateCorrection = l3 - l;
            return this.lDateCorrection;
        }
        return this.lDateCorrection;
    }

    public int setBooleanReportDisplayNumberFormat() {
        String string = "[=1]\"\u2611\";[=0]\"\ue470\";0";
        this.iLogicalFormatKey = this.xNumberFormats.queryKey(string, this.aLocale, true);
        try {
            if (this.iLogicalFormatKey == -1) {
                this.iLogicalFormatKey = this.xNumberFormats.addNew(string, this.aLocale);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.iLogicalFormatKey = this.xNumberFormatTypes.getStandardFormat((short)1024, this.aLocale);
        }
        return this.iLogicalFormatKey;
    }

    public int getDateFormatKey() {
        if (this.iDateFormatKey == -1) {
            this.iDateFormatKey = this.xNumberFormatTypes.getStandardFormat((short)2, this.aLocale);
        }
        return this.iDateFormatKey;
    }

    public int getDateTimeFormatKey() {
        if (this.iDateTimeFormatKey == -1) {
            this.iDateTimeFormatKey = this.xNumberFormatTypes.getStandardFormat((short)6, this.aLocale);
        }
        return this.iDateTimeFormatKey;
    }

    public int getLogicalFormatKey() {
        if (this.iLogicalFormatKey == -1) {
            this.iLogicalFormatKey = this.xNumberFormatTypes.getStandardFormat((short)1024, this.aLocale);
        }
        return this.iLogicalFormatKey;
    }

    public int getNumberFormatKey() {
        if (this.iNumberFormatKey == -1) {
            this.iNumberFormatKey = this.xNumberFormatTypes.getStandardFormat((short)16, this.aLocale);
        }
        return this.iNumberFormatKey;
    }

    public int getTextFormatKey() {
        if (this.iTextFormatKey == -1) {
            this.iTextFormatKey = this.xNumberFormatTypes.getStandardFormat((short)256, this.aLocale);
        }
        return this.iTextFormatKey;
    }

    public int getTimeFormatKey() {
        if (this.iTimeFormatKey == -1) {
            this.iTimeFormatKey = this.xNumberFormatTypes.getStandardFormat((short)4, this.aLocale);
        }
        return this.iTimeFormatKey;
    }
}

