/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.codec;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.krypt.Base64;
import org.jruby.ext.krypt.Errors;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyBase64 {
    private RubyBase64() {
    }

    @JRubyMethod(meta=true, required=1, optional=1)
    public static IRubyObject encode(ThreadContext ctx, IRubyObject recv, IRubyObject[] args) {
        try {
            byte[] bytes = args[0].convertToString().getBytes();
            int cols = args.length == 2 ? RubyNumeric.num2int((IRubyObject)args[1]) : -1;
            byte[] encoded = Base64.encode(bytes, cols);
            return RubyString.newUsAsciiStringNoCopy((Ruby)ctx.getRuntime(), (ByteList)new ByteList(encoded, false));
        }
        catch (IOException ex) {
            throw Errors.newBase64Error(ctx.getRuntime(), ex.getMessage());
        }
        catch (RuntimeException ex) {
            throw Errors.newBase64Error(ctx.getRuntime(), ex.getMessage());
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject decode(ThreadContext ctx, IRubyObject recv, IRubyObject data) {
        try {
            byte[] bytes = data.convertToString().getBytes();
            byte[] decoded = Base64.decode(bytes);
            return ctx.getRuntime().newString(new ByteList(decoded, false));
        }
        catch (IOException ex) {
            throw Errors.newBase64Error(ctx.getRuntime(), ex.getMessage());
        }
        catch (RuntimeException ex) {
            throw Errors.newBase64Error(ctx.getRuntime(), ex.getMessage());
        }
    }

    public static void createBase64(Ruby runtime, RubyModule krypt, RubyClass kryptError) {
        RubyModule mBase64 = runtime.defineModuleUnder("Base64", krypt);
        mBase64.defineClassUnder("Base64Error", kryptError, kryptError.getAllocator());
        mBase64.defineAnnotatedMethods(RubyBase64.class);
    }
}

