/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class X509Extensions {
    public static void createX509Ext(Ruby runtime, RubyModule mX509) {
        RubyClass cX509ExtFactory = mX509.defineClassUnder("ExtensionFactory", runtime.getObject(), ExtensionFactory.ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("ExtensionError", openSSLError, openSSLError.getAllocator());
        cX509ExtFactory.attr_reader(runtime.getCurrentContext(), new IRubyObject[]{runtime.newString("issuer_certificate"), runtime.newString("subject_certificate"), runtime.newString("subject_request"), runtime.newString("crl"), runtime.newString("config")});
        cX509ExtFactory.defineAnnotatedMethods(ExtensionFactory.class);
        RubyClass cX509Ext = mX509.defineClassUnder("Extension", runtime.getObject(), Extension.ALLOCATOR);
        cX509Ext.defineAnnotatedMethods(Extension.class);
    }

    private static byte[] getSHA1Digest(Ruby runtime, byte[] bytes) {
        try {
            return MessageDigest.getInstance("SHA-1").digest(bytes);
        }
        catch (GeneralSecurityException gse) {
            throw X509Extensions.newX509ExtError(runtime, gse.getMessage());
        }
    }

    private static RaiseException newX509ExtError(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::X509::ExtensionError", message);
    }

    public static class Extension
    extends RubyObject {
        private static final long serialVersionUID = -1160318458085651926L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Extension(runtime, klass);
            }
        };
        private ASN1ObjectIdentifier oid;
        private Object value;
        private boolean critical;

        public Extension(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        void setRealOid(ASN1ObjectIdentifier oid) {
            this.oid = oid;
        }

        void setRealValue(Object value) {
            this.value = value;
        }

        void setRealCritical(boolean critical) {
            this.critical = critical;
        }

        ASN1ObjectIdentifier getRealOid() {
            return this.oid;
        }

        Object getRealValue() {
            return this.value;
        }

        byte[] getRealValueBytes() throws IOException {
            if (this.value instanceof RubyString) {
                return ((RubyString)this.value).convertToString().getBytes();
            }
            if (this.value instanceof String) {
                return ByteList.plain((CharSequence)((String)this.value));
            }
            if (this.value instanceof DEROctetString) {
                return ((DEROctetString)this.value).getOctets();
            }
            if (this.value instanceof ASN1Encodable) {
                return ((ASN1Encodable)this.value).toASN1Primitive().getEncoded("DER");
            }
            return ((ASN1.ASN1Data)((Object)this.value)).toASN1().toASN1Primitive().getEncoded("DER");
        }

        boolean getRealCritical() {
            return this.critical;
        }

        ASN1ObjectIdentifier getObjectIdentifier(String nameOrOid) {
            ASN1ObjectIdentifier val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
            if (null != val1) {
                return val1;
            }
            ASN1ObjectIdentifier val2 = new ASN1ObjectIdentifier(nameOrOid);
            return val2;
        }

        @JRubyMethod(name={"initialize"}, rest=true)
        public IRubyObject _initialize(IRubyObject[] args) {
            byte[] octets = null;
            if (args.length == 1) {
                try {
                    ASN1InputStream is = new ASN1InputStream(OpenSSLImpl.to_der_if_possible(args[0]).convertToString().getBytes());
                    ASN1Primitive obj = is.readObject();
                    ASN1Sequence seq = (ASN1Sequence)obj;
                    this.setRealOid((ASN1ObjectIdentifier)seq.getObjectAt(0));
                    this.setRealCritical(((DERBoolean)seq.getObjectAt(1)).isTrue());
                    octets = ((DEROctetString)seq.getObjectAt(2)).getOctets();
                }
                catch (IOException ioe) {
                    throw X509Extensions.newX509ExtError(this.getRuntime(), ioe.getMessage());
                }
            } else if (args.length > 1) {
                this.setRealOid(this.getObjectIdentifier(args[0].toString()));
                this.setRealValue(args[1]);
            }
            if (args.length > 2) {
                this.setRealCritical(args[2].isTrue());
            }
            if (args.length > 0 && octets != null) {
                this.setRealValue(new String(ByteList.plain(octets)));
            }
            return this;
        }

        @JRubyMethod(name={"oid="})
        public IRubyObject set_oid(IRubyObject arg) {
            System.err.println("WARNING: calling ext#oid=");
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"value="})
        public IRubyObject set_value(IRubyObject arg) {
            System.err.println("WARNING: calling ext#value=");
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"critical="})
        public IRubyObject set_critical(IRubyObject arg) {
            System.err.println("WARNING: calling ext#critical=");
            return this.getRuntime().getNil();
        }

        @JRubyMethod
        public IRubyObject oid() {
            String val = ASN1.getSymLookup(this.getRuntime()).get(this.oid);
            if (null == val) {
                val = this.oid.toString();
            }
            return this.getRuntime().newString(val);
        }

        @JRubyMethod
        public IRubyObject value() {
            Ruby runtime = this.getRuntime();
            try {
                if (this.getRealOid().equals((Object)new ASN1ObjectIdentifier("2.5.29.19"))) {
                    ASN1Sequence seq2 = (ASN1Sequence)new ASN1InputStream(this.getRealValueBytes()).readObject();
                    String c = "";
                    String path = "";
                    if (seq2.size() > 0) {
                        c = "CA:" + (((DERBoolean)seq2.getObjectAt(0)).isTrue() ? "TRUE" : "FALSE");
                    }
                    if (seq2.size() > 1) {
                        path = ", pathlen:" + seq2.getObjectAt(1).toString();
                    }
                    return runtime.newString(c + path);
                }
                if (this.getRealOid().equals((Object)new ASN1ObjectIdentifier("2.5.29.15"))) {
                    byte[] bx = this.getRealValueBytes();
                    byte[] bs = new byte[bx.length - 2];
                    System.arraycopy(bx, 2, bs, 0, bs.length);
                    byte b1 = 0;
                    byte b2 = bs[0];
                    if (bs.length > 1) {
                        b1 = bs[1];
                    }
                    StringBuilder sbe = new StringBuilder();
                    String sep = "";
                    if ((b2 & 0xFFFFFF80) != 0) {
                        sbe.append(sep).append("Decipher Only");
                        sep = ", ";
                    }
                    if ((b1 & 0xFFFFFF80) != 0) {
                        sbe.append(sep).append("Digital Signature");
                        sep = ", ";
                    }
                    if ((b1 & 0x40) != 0) {
                        sbe.append(sep).append("Non Repudiation");
                        sep = ", ";
                    }
                    if ((b1 & 0x20) != 0) {
                        sbe.append(sep).append("Key Encipherment");
                        sep = ", ";
                    }
                    if ((b1 & 0x10) != 0) {
                        sbe.append(sep).append("Data Encipherment");
                        sep = ", ";
                    }
                    if ((b1 & 8) != 0) {
                        sbe.append(sep).append("Key Agreement");
                        sep = ", ";
                    }
                    if ((b1 & 4) != 0) {
                        sbe.append(sep).append("Certificate Sign");
                        sep = ", ";
                    }
                    if ((b1 & 2) != 0) {
                        sbe.append(sep).append("CRL Sign");
                        sep = ", ";
                    }
                    if ((b1 & 1) != 0) {
                        sbe.append(sep).append("Encipher Only");
                    }
                    return runtime.newString(sbe.toString());
                }
                if (this.getRealOid().equals((Object)new ASN1ObjectIdentifier("2.16.840.1.113730.1.1"))) {
                    byte[] bx = this.getRealValueBytes();
                    byte b = bx[0];
                    StringBuilder sbe = new StringBuilder();
                    String sep = "";
                    if ((b & 0xFFFFFF80) != 0) {
                        sbe.append(sep).append("SSL Client");
                        sep = ", ";
                    }
                    if ((b & 0x40) != 0) {
                        sbe.append(sep).append("SSL Servern");
                        sep = ", ";
                    }
                    if ((b & 0x20) != 0) {
                        sbe.append(sep).append("S/MIME");
                        sep = ", ";
                    }
                    if ((b & 0x10) != 0) {
                        sbe.append(sep).append("Object Signing");
                        sep = ", ";
                    }
                    if ((b & 8) != 0) {
                        sbe.append(sep).append("Unused");
                        sep = ", ";
                    }
                    if ((b & 4) != 0) {
                        sbe.append(sep).append("SSL CA");
                        sep = ", ";
                    }
                    if ((b & 2) != 0) {
                        sbe.append(sep).append("S/MIME CA");
                        sep = ", ";
                    }
                    if ((b & 1) != 0) {
                        sbe.append(sep).append("Object Signing CA");
                    }
                    return runtime.newString(sbe.toString());
                }
                if (this.getRealOid().equals((Object)new ASN1ObjectIdentifier("2.5.29.14"))) {
                    byte[] b1 = this.getRealValueBytes();
                    byte[] b2 = new byte[b1.length - 2];
                    System.arraycopy(b1, 2, b2, 0, b2.length);
                    return runtime.newString(Utils.toHex(b2, ':'));
                }
                if (this.getRealOid().equals((Object)new ASN1ObjectIdentifier("2.5.29.35"))) {
                    ASN1Sequence seq = (ASN1Sequence)new ASN1InputStream(this.getRealValueBytes()).readObject();
                    StringBuilder out1 = new StringBuilder();
                    if (seq.size() > 0) {
                        out1.append("keyid:");
                        ASN1Primitive keyid = seq.getObjectAt(0).toASN1Primitive();
                        if (keyid instanceof DEROctetString) {
                            out1.append(Utils.toHex(((DEROctetString)keyid).getOctets(), ':'));
                        } else {
                            out1.append(Utils.toHex(keyid.getEncoded("DER"), ':'));
                        }
                    }
                    return runtime.newString(out1.toString());
                }
                if (this.getRealOid().equals((Object)new ASN1ObjectIdentifier("2.5.29.21"))) {
                    switch (RubyNumeric.fix2int((IRubyObject)((IRubyObject)this.value).callMethod(runtime.getCurrentContext(), "value"))) {
                        case 0: {
                            return runtime.newString("Unspecified");
                        }
                        case 1: {
                            return runtime.newString("Key Compromise");
                        }
                        case 2: {
                            return runtime.newString("CA Compromise");
                        }
                        case 3: {
                            return runtime.newString("Affiliation Changed");
                        }
                        case 4: {
                            return runtime.newString("Superseded");
                        }
                        case 5: {
                            return runtime.newString("Cessation Of Operation");
                        }
                        case 6: {
                            return runtime.newString("Certificate Hold");
                        }
                        case 8: {
                            return runtime.newString("Remove From CRL");
                        }
                        case 9: {
                            return runtime.newString("Privilege Withdrawn");
                        }
                    }
                    return runtime.newString("Unspecified");
                }
                if (this.getRealOid().equals((Object)new ASN1ObjectIdentifier("2.5.29.17"))) {
                    try {
                        ASN1Primitive seq = new ASN1InputStream(this.getRealValueBytes()).readObject();
                        GeneralName[] n1 = null;
                        n1 = seq instanceof ASN1TaggedObject ? new GeneralName[]{GeneralName.getInstance((Object)seq)} : GeneralNames.getInstance((Object)seq).getNames();
                        StringBuilder sbe = new StringBuilder();
                        String sep = "";
                        for (int i = 0; i < n1.length; ++i) {
                            sbe.append(sep);
                            if (n1[i].getTagNo() == 2) {
                                sbe.append("DNS:");
                                sbe.append(((ASN1String)n1[i].getName()).getString());
                            } else if (n1[i].getTagNo() == 7) {
                                sbe.append("IP Address:");
                                byte[] bs = ((DEROctetString)n1[i].getName()).getOctets();
                                String sep2 = "";
                                for (int j = 0; j < bs.length; ++j) {
                                    sbe.append(sep2);
                                    sbe.append(bs[j] & 0xFF);
                                    sep2 = ".";
                                }
                            } else {
                                sbe.append(n1[i].toString());
                            }
                            sep = ", ";
                        }
                        return runtime.newString(sbe.toString());
                    }
                    catch (Exception e) {
                        return runtime.newString(this.getRealValue().toString());
                    }
                }
                try {
                    return ASN1.decode((IRubyObject)runtime.getClassFromPath("OpenSSL::ASN1"), (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])this.getRealValueBytes())).callMethod(runtime.getCurrentContext(), "value").callMethod(runtime.getCurrentContext(), "to_s");
                }
                catch (Exception e) {
                    return runtime.newString(this.getRealValue().toString());
                }
            }
            catch (IOException ioe) {
                throw X509Extensions.newX509ExtError(runtime, ioe.getMessage());
            }
        }

        @JRubyMethod(name={"critical?"})
        public IRubyObject critical_p() {
            return this.critical ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod
        public IRubyObject to_der() {
            ASN1EncodableVector all = new ASN1EncodableVector();
            try {
                all.add((ASN1Encodable)this.getRealOid());
                all.add((ASN1Encodable)(this.getRealCritical() ? DERBoolean.TRUE : DERBoolean.FALSE));
                all.add((ASN1Encodable)new DEROctetString(this.getRealValueBytes()));
                return RubyString.newString((Ruby)this.getRuntime(), (byte[])new DLSequence(all).getEncoded("DER"));
            }
            catch (IOException ioe) {
                throw X509Extensions.newX509ExtError(this.getRuntime(), ioe.getMessage());
            }
        }
    }

    public static class ExtensionFactory
    extends RubyObject {
        private static final long serialVersionUID = 3180447029639456500L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ExtensionFactory(runtime, klass);
            }
        };

        public ExtensionFactory(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        @JRubyMethod(rest=true)
        public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
            Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)4);
            if (args.length > 0 && !args[0].isNil()) {
                this.set_issuer_cert(args[0]);
            }
            if (args.length > 1 && !args[1].isNil()) {
                this.set_subject_cert(args[1]);
            }
            if (args.length > 2 && !args[2].isNil()) {
                this.set_subject_req(args[2]);
            }
            if (args.length > 3 && !args[3].isNil()) {
                this.set_crl(args[3]);
            }
            return this;
        }

        @JRubyMethod(name={"issuer_certificate="})
        public IRubyObject set_issuer_cert(IRubyObject arg) {
            this.setInstanceVariable("@issuer_certificate", arg);
            return arg;
        }

        @JRubyMethod(name={"subject_certificate="})
        public IRubyObject set_subject_cert(IRubyObject arg) {
            this.setInstanceVariable("@subject_certificate", arg);
            return arg;
        }

        @JRubyMethod(name={"subject_request="})
        public IRubyObject set_subject_req(IRubyObject arg) {
            this.setInstanceVariable("@subject_request", arg);
            return arg;
        }

        @JRubyMethod(name={"crl="})
        public IRubyObject set_crl(IRubyObject arg) {
            this.setInstanceVariable("@crl", arg);
            return arg;
        }

        @JRubyMethod(name={"config="})
        public IRubyObject set_config(IRubyObject arg) {
            this.setInstanceVariable("@config", arg);
            return arg;
        }

        private ASN1ObjectIdentifier getObjectIdentifier(String nameOrOid) {
            ASN1ObjectIdentifier val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
            if (null != val1) {
                return val1;
            }
            ASN1ObjectIdentifier val2 = new ASN1ObjectIdentifier(nameOrOid);
            return val2;
        }

        private static boolean isHexDigit(char c) {
            return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
        }

        private boolean isHexString(String str) {
            for (int i = 0; i < str.length(); ++i) {
                if (ExtensionFactory.isHexDigit(str.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @JRubyMethod(rest=true)
        public IRubyObject create_ext(IRubyObject[] args) {
            RubyBoolean critical = this.getRuntime().getFalse();
            if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)2, (int)3) == 3 && !args[2].isNil()) {
                critical = args[2];
            }
            String oid = args[0].toString();
            String valuex = args[1].toString();
            Object value = valuex;
            ASN1ObjectIdentifier r_oid = null;
            try {
                r_oid = this.getObjectIdentifier(oid);
            }
            catch (IllegalArgumentException e) {
                throw X509Extensions.newX509ExtError(this.getRuntime(), "unknown OID `" + oid + "'");
            }
            Extension ext = (Extension)Utils.newRubyInstance(this.getRuntime(), "OpenSSL::X509::Extension");
            if (valuex.startsWith("critical,")) {
                critical = this.getRuntime().getTrue();
                valuex = valuex.substring(9).trim();
            }
            try {
                if (r_oid.equals((Object)new ASN1ObjectIdentifier("2.5.29.14"))) {
                    DEROctetString inp = this.parseSubjectKeyIdentifier(oid, valuex);
                    value = new String(ByteList.plain((byte[])inp.getEncoded("DER")));
                } else if (r_oid.equals((Object)new ASN1ObjectIdentifier("2.5.29.35"))) {
                    DLSequence inp = this.parseAuthorityKeyIdentifier(valuex);
                    value = new String(ByteList.plain((byte[])inp.getEncoded("DER")));
                } else if (r_oid.equals((Object)new ASN1ObjectIdentifier("2.5.29.18"))) {
                    value = this.parseIssuerAltName(valuex);
                } else if (r_oid.equals((Object)new ASN1ObjectIdentifier("2.5.29.19"))) {
                    DLSequence inp = this.parseBasicConstrains(valuex);
                    value = new String(ByteList.plain((byte[])inp.getEncoded("DER")));
                } else if (r_oid.equals((Object)new ASN1ObjectIdentifier("2.5.29.15"))) {
                    DERBitString inp = this.parseKeyUsage(oid, valuex);
                    value = new String(ByteList.plain((byte[])inp.getEncoded("DER")));
                } else {
                    value = r_oid.equals((Object)new ASN1ObjectIdentifier("2.16.840.1.113730.1.1")) ? this.parseNsCertType(oid, valuex) : (r_oid.equals((Object)new ASN1ObjectIdentifier("2.5.29.17")) ? this.parseSubjectAltName(valuex) : (r_oid.equals((Object)new ASN1ObjectIdentifier("2.5.29.37")) ? this.parseExtendedKeyUsage(valuex) : new DEROctetString(new DEROctetString(ByteList.plain((CharSequence)valuex)).getEncoded("DER"))));
                }
            }
            catch (IOException ex) {
                throw X509Extensions.newX509ExtError(this.getRuntime(), "Unable to create extension: " + ex.getMessage());
            }
            ext.setRealOid(r_oid);
            ext.setRealValue(value);
            ext.setRealCritical(critical.isTrue());
            return ext;
        }

        private DERBitString parseKeyUsage(String oid, String valuex) {
            int i;
            byte[] inp = null;
            try {
                String[] exx = valuex.split(":");
                if (exx != null) {
                    inp = new byte[exx.length];
                    for (i = 0; i < exx.length; ++i) {
                        inp[i] = (byte)Integer.parseInt(exx[i], 16);
                    }
                }
            }
            catch (Exception e) {
                inp = null;
            }
            if (null == inp && valuex.length() < 3) {
                inp = ByteList.plain((CharSequence)valuex);
            }
            if (inp == null) {
                int i2;
                byte v1 = 0;
                byte v2 = 0;
                String[] spl = valuex.split(",");
                for (i2 = 0; i2 < spl.length; ++i2) {
                    spl[i2] = spl[i2].trim();
                }
                for (i2 = 0; i2 < spl.length; ++i2) {
                    if ("decipherOnly".equals(spl[i2].trim()) || "Decipher Only".equals(spl[i2].trim())) {
                        v2 = (byte)(v2 | 0xFFFFFF80);
                        continue;
                    }
                    if ("digitalSignature".equals(spl[i2].trim()) || "Digital Signature".equals(spl[i2].trim())) {
                        v1 = (byte)(v1 | 0xFFFFFF80);
                        continue;
                    }
                    if ("nonRepudiation".equals(spl[i2].trim()) || "Non Repudiation".equals(spl[i2].trim())) {
                        v1 = (byte)(v1 | 0x40);
                        continue;
                    }
                    if ("keyEncipherment".equals(spl[i2].trim()) || "Key Encipherment".equals(spl[i2].trim())) {
                        v1 = (byte)(v1 | 0x20);
                        continue;
                    }
                    if ("dataEncipherment".equals(spl[i2].trim()) || "Data Encipherment".equals(spl[i2].trim())) {
                        v1 = (byte)(v1 | 0x10);
                        continue;
                    }
                    if ("keyAgreement".equals(spl[i2].trim()) || "Key Agreement".equals(spl[i2].trim())) {
                        v1 = (byte)(v1 | 8);
                        continue;
                    }
                    if ("keyCertSign".equals(spl[i2].trim()) || "Key Cert Sign".equals(spl[i2].trim())) {
                        v1 = (byte)(v1 | 4);
                        continue;
                    }
                    if ("cRLSign".equals(spl[i2].trim())) {
                        v1 = (byte)(v1 | 2);
                        continue;
                    }
                    if ("encipherOnly".equals(spl[i2].trim()) || "Encipher Only".equals(spl[i2].trim())) {
                        v1 = (byte)(v1 | 1);
                        continue;
                    }
                    throw X509Extensions.newX509ExtError(this.getRuntime(), oid + " = " + valuex + ": unknown bit string argument");
                }
                inp = v2 != 0 ? new byte[]{v1, v2} : new byte[]{v1};
            }
            int unused = 0;
            for (i = inp.length - 1; i > -1; --i) {
                if (inp[i] == 0) {
                    unused += 8;
                    continue;
                }
                byte a2 = inp[i];
                int x = 8;
                while (a2 != 0) {
                    a2 = (byte)(a2 << 1);
                    --x;
                }
                unused += x;
                break;
            }
            return new DERBitString(inp, unused);
        }

        private DERBitString parseNsCertType(String oid, String valuex) {
            byte v = 0;
            if (valuex.length() < 3) {
                byte[] inp = ByteList.plain((CharSequence)valuex);
                v = inp[0];
            } else {
                int i;
                String[] spl = valuex.split(",");
                for (i = 0; i < spl.length; ++i) {
                    spl[i] = spl[i].trim();
                }
                for (i = 0; i < spl.length; ++i) {
                    if ("SSL Client".equals(spl[i]) || "client".equals(spl[i])) {
                        v = (byte)(v | 0xFFFFFF80);
                        continue;
                    }
                    if ("SSL Server".equals(spl[i]) || "server".equals(spl[i])) {
                        v = (byte)(v | 0x40);
                        continue;
                    }
                    if ("S/MIME".equals(spl[i]) || "email".equals(spl[i])) {
                        v = (byte)(v | 0x20);
                        continue;
                    }
                    if ("Object Signing".equals(spl[i]) || "objsign".equals(spl[i])) {
                        v = (byte)(v | 0x10);
                        continue;
                    }
                    if ("Unused".equals(spl[i]) || "reserved".equals(spl[i])) {
                        v = (byte)(v | 8);
                        continue;
                    }
                    if ("SSL CA".equals(spl[i]) || "sslCA".equals(spl[i])) {
                        v = (byte)(v | 4);
                        continue;
                    }
                    if ("S/MIME CA".equals(spl[i]) || "emailCA".equals(spl[i])) {
                        v = (byte)(v | 2);
                        continue;
                    }
                    if ("Object Signing CA".equals(spl[i]) || "objCA".equals(spl[i])) {
                        v = (byte)(v | 1);
                        continue;
                    }
                    throw X509Extensions.newX509ExtError(this.getRuntime(), oid + " = " + valuex + ": unknown bit string argument");
                }
            }
            int unused = 0;
            if (v == 0) {
                unused += 8;
            } else {
                byte a2 = v;
                int x = 8;
                while (a2 != 0) {
                    a2 = (byte)(a2 << 1);
                    --x;
                }
                unused += x;
            }
            return new DERBitString(new byte[]{v}, unused);
        }

        private DLSequence parseBasicConstrains(String valuex) {
            int i;
            String[] spl = valuex.split(",");
            for (int i2 = 0; i2 < spl.length; ++i2) {
                spl[i2] = spl[i2].trim();
            }
            ASN1EncodableVector asnv = new ASN1EncodableVector();
            for (i = 0; i < spl.length; ++i) {
                if (spl[i].length() <= 3 || !spl[i].substring(0, 3).equalsIgnoreCase("CA:")) continue;
                asnv.add((ASN1Encodable)new DERBoolean("TRUE".equalsIgnoreCase(spl[i].substring(3).trim())));
            }
            for (i = 0; i < spl.length; ++i) {
                if (spl[i].length() <= 8 || !spl[i].substring(0, 8).equalsIgnoreCase("pathlen:")) continue;
                asnv.add((ASN1Encodable)new ASN1Integer(Integer.parseInt(spl[i].substring(8).trim())));
            }
            return new DLSequence(asnv);
        }

        private DLSequence parseAuthorityKeyIdentifier(String valuex) {
            ThreadContext tc = this.getRuntime().getCurrentContext();
            ASN1EncodableVector asnv = new ASN1EncodableVector();
            if (valuex.startsWith("keyid:always")) {
                IRubyObject pkey = this.getInstanceVariable("@issuer_certificate").callMethod(tc, "public_key");
                IRubyObject val = pkey instanceof PKeyRSA ? pkey.callMethod(tc, "to_der") : ASN1.decode((IRubyObject)this.getRuntime().getClassFromPath("OpenSSL::ASN1"), pkey.callMethod(tc, "to_der")).callMethod(tc, "value").callMethod(tc, "[]", (IRubyObject)this.getRuntime().newFixnum(1)).callMethod(tc, "value");
                byte[] b = X509Extensions.getSHA1Digest(this.getRuntime(), val.convertToString().getBytes());
                asnv.add((ASN1Encodable)new DEROctetString(b));
            } else if (valuex.startsWith("keyid")) {
                IRubyObject pkey = this.getInstanceVariable("@issuer_certificate").callMethod(tc, "public_key");
                IRubyObject val = pkey instanceof PKeyRSA ? pkey.callMethod(tc, "to_der") : ASN1.decode((IRubyObject)this.getRuntime().getClassFromPath("OpenSSL::ASN1"), pkey.callMethod(tc, "to_der")).callMethod(tc, "value").callMethod(tc, "[]", (IRubyObject)this.getRuntime().newFixnum(1)).callMethod(tc, "value");
                byte[] b = X509Extensions.getSHA1Digest(this.getRuntime(), val.convertToString().getBytes());
                asnv.add((ASN1Encodable)new DEROctetString(b));
            }
            return new DLSequence(asnv);
        }

        private Object parseIssuerAltName(String valuex) throws IOException {
            ThreadContext tc = this.getRuntime().getCurrentContext();
            if (valuex.startsWith("issuer:copy")) {
                RubyArray exts = (RubyArray)this.getInstanceVariable("@issuer_certificate").callMethod(tc, "extensions");
                for (IRubyObject obj : exts.toJavaArray()) {
                    Extension exta = (Extension)obj;
                    if (!exta.getRealOid().equals((Object)new ASN1ObjectIdentifier("2.5.29.17"))) continue;
                    return exta.getRealValue();
                }
            }
            throw new IOException("Malformed IssuerAltName: " + valuex);
        }

        private String parseSubjectAltName(String valuex) throws IOException {
            if (valuex.startsWith("DNS:")) {
                GeneralNames gn = new GeneralNames(new GeneralName(2, (ASN1Encodable)new DERIA5String(valuex.substring(4))));
                return new String(ByteList.plain((byte[])gn.getEncoded("DER")));
            }
            if (valuex.startsWith("IP:")) {
                String[] numbers = valuex.substring(3).split("\\.");
                byte[] bs = new byte[]{(byte)(Integer.parseInt(numbers[0]) & 0xFF), (byte)(Integer.parseInt(numbers[1]) & 0xFF), (byte)(Integer.parseInt(numbers[2]) & 0xFF), (byte)(Integer.parseInt(numbers[3]) & 0xFF)};
                GeneralNames gn = new GeneralNames(new GeneralName(7, (ASN1Encodable)new DEROctetString(bs)));
                return new String(ByteList.plain((byte[])gn.getEncoded("DER")));
            }
            if (valuex.startsWith("IP Address:")) {
                String[] numbers = valuex.substring(11).split("\\.");
                byte[] bs = new byte[]{(byte)(Integer.parseInt(numbers[0]) & 0xFF), (byte)(Integer.parseInt(numbers[1]) & 0xFF), (byte)(Integer.parseInt(numbers[2]) & 0xFF), (byte)(Integer.parseInt(numbers[3]) & 0xFF)};
                GeneralNames gn = new GeneralNames(new GeneralName(7, (ASN1Encodable)new DEROctetString(bs)));
                return new String(ByteList.plain((byte[])gn.getEncoded("DER")));
            }
            return valuex;
        }

        private DEROctetString parseSubjectKeyIdentifier(String oid, String valuex) {
            ThreadContext tc = this.getRuntime().getCurrentContext();
            if ("hash".equalsIgnoreCase(valuex)) {
                IRubyObject pkey = this.getInstanceVariable("@subject_certificate").callMethod(tc, "public_key");
                IRubyObject val = pkey instanceof PKeyRSA ? pkey.callMethod(tc, "to_der") : ASN1.decode((IRubyObject)this.getRuntime().getClassFromPath("OpenSSL::ASN1"), pkey.callMethod(tc, "to_der")).callMethod(tc, "value").callMethod(tc, "[]", (IRubyObject)this.getRuntime().newFixnum(1)).callMethod(tc, "value");
                byte[] b = X509Extensions.getSHA1Digest(this.getRuntime(), val.convertToString().getBytes());
                return new DEROctetString(b);
            }
            if (valuex.length() == 20 || !this.isHexString(valuex)) {
                return new DEROctetString(ByteList.plain((CharSequence)valuex));
            }
            StringBuilder nstr = new StringBuilder();
            for (int i = 0; i < valuex.length(); i += 2) {
                if (i + 1 >= valuex.length()) {
                    throw X509Extensions.newX509ExtError(this.getRuntime(), oid + " = " + valuex + ": odd number of digits");
                }
                char c1 = valuex.charAt(i);
                char c2 = valuex.charAt(i + 1);
                if (ExtensionFactory.isHexDigit(c1) && ExtensionFactory.isHexDigit(c2)) {
                    nstr.append(Character.toUpperCase(c1)).append(Character.toUpperCase(c2));
                } else {
                    throw X509Extensions.newX509ExtError(this.getRuntime(), oid + " = " + valuex + ": illegal hex digit");
                }
                while (i + 2 < valuex.length() && valuex.charAt(i + 2) == ':') {
                    ++i;
                }
            }
            String v = nstr.toString();
            byte[] arr = new byte[v.length() / 2];
            for (int i = 0; i < v.length(); i += 2) {
                arr[i / 2] = (byte)Integer.parseInt(v.substring(i, i + 2), 16);
            }
            return new DEROctetString(arr);
        }

        private DLSequence parseExtendedKeyUsage(String valuex) {
            String[] spl = valuex.split(", ?");
            ASN1EncodableVector vector = new ASN1EncodableVector();
            for (String name : spl) {
                vector.add((ASN1Encodable)ASN1Registry.sym2oid(name));
            }
            return new DLSequence(vector);
        }
    }
}

