/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.Base64;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class NetscapeSPKI
extends RubyObject {
    private static final long serialVersionUID = 3211242351810109432L;
    private static ObjectAllocator NETSCAPESPKI_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new NetscapeSPKI(runtime, klass);
        }
    };
    private IRubyObject public_key;
    private IRubyObject challenge;
    private NetscapeCertRequest cert;

    public static void createNetscapeSPKI(Ruby runtime, RubyModule ossl) {
        RubyModule mNetscape = ossl.defineModuleUnder("Netscape");
        RubyClass cSPKI = mNetscape.defineClassUnder("SPKI", runtime.getObject(), NETSCAPESPKI_ALLOCATOR);
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        mNetscape.defineClassUnder("SPKIError", openSSLError, openSSLError.getAllocator());
        cSPKI.defineAnnotatedMethods(NetscapeSPKI.class);
    }

    public NetscapeSPKI(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(name={"initialize"}, rest=true)
    public IRubyObject _initialize(IRubyObject[] args) {
        if (args.length > 0) {
            byte[] b = args[0].convertToString().getBytes();
            final byte[] b2 = b = this.tryBase64Decode(b);
            String algo = null;
            byte[] enc = null;
            try {
                PublicKey pkey = (PublicKey)OpenSSLReal.getWithBCProvider(new OpenSSLReal.Callable(){

                    @Override
                    public Object call() throws GeneralSecurityException {
                        try {
                            NetscapeSPKI.this.cert = new NetscapeCertRequest(b2);
                            NetscapeSPKI.this.challenge = (IRubyObject)NetscapeSPKI.this.getRuntime().newString(NetscapeSPKI.this.cert.getChallenge());
                            return NetscapeSPKI.this.cert.getPublicKey();
                        }
                        catch (IOException ioe) {
                            throw new GeneralSecurityException(ioe.getMessage(), ioe);
                        }
                    }
                });
                algo = pkey.getAlgorithm();
                enc = pkey.getEncoded();
            }
            catch (GeneralSecurityException gse) {
                throw NetscapeSPKI.newSPKIError(this.getRuntime(), gse.getMessage());
            }
            if ("RSA".equalsIgnoreCase(algo)) {
                this.public_key = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::PKey::RSA", (IRubyObject)RubyString.newString((Ruby)this.getRuntime(), (byte[])enc));
            } else if ("DSA".equalsIgnoreCase(algo)) {
                this.public_key = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::PKey::DSA", (IRubyObject)RubyString.newString((Ruby)this.getRuntime(), (byte[])enc));
            } else {
                throw this.getRuntime().newLoadError("not implemented algo for public key: " + algo);
            }
        }
        return this;
    }

    private byte[] tryBase64Decode(byte[] b) {
        try {
            b = Base64.decode(b, 0, b.length, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])this.internalToDer());
        }
        catch (IOException ioe) {
            throw NetscapeSPKI.newSPKIError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        try {
            byte[] source = this.internalToDer();
            return this.getRuntime().newString(Base64.encodeBytes(source, 0, source.length, 0));
        }
        catch (IOException ioe) {
            throw NetscapeSPKI.newSPKIError(this.getRuntime(), ioe.getMessage());
        }
    }

    private byte[] internalToDer() throws IOException {
        ASN1Sequence b = (ASN1Sequence)this.cert.toASN1Primitive();
        ASN1ObjectIdentifier encType = null;
        DERBitString publicKey = new DERBitString(((PKey)this.public_key).to_der().convertToString().getBytes());
        DERIA5String encodedChallenge = new DERIA5String(this.challenge.toString());
        ASN1ObjectIdentifier sigAlg = null;
        DERBitString sig = null;
        encType = (ASN1ObjectIdentifier)((ASN1Sequence)((ASN1Sequence)((ASN1Sequence)b.getObjectAt(0)).getObjectAt(0)).getObjectAt(0)).getObjectAt(0);
        sigAlg = ((AlgorithmIdentifier)b.getObjectAt(1)).getAlgorithm();
        sig = (DERBitString)b.getObjectAt(2);
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        ASN1EncodableVector v1_2 = new ASN1EncodableVector();
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        ASN1EncodableVector v3 = new ASN1EncodableVector();
        ASN1EncodableVector v4 = new ASN1EncodableVector();
        v4.add((ASN1Encodable)encType);
        v4.add((ASN1Encodable)new DERNull());
        v3.add((ASN1Encodable)new DLSequence(v4));
        v3.add((ASN1Encodable)publicKey);
        v2.add((ASN1Encodable)new DLSequence(v3));
        v2.add((ASN1Encodable)encodedChallenge);
        v1.add((ASN1Encodable)new DLSequence(v2));
        v1_2.add((ASN1Encodable)sigAlg);
        v1_2.add((ASN1Encodable)new DERNull());
        v1.add((ASN1Encodable)new DLSequence(v1_2));
        v1.add((ASN1Encodable)sig);
        return new DLSequence(v1).getEncoded();
    }

    @JRubyMethod
    public IRubyObject to_text() {
        System.err.println("WARNING: calling unimplemented method: to_text");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject public_key() {
        return this.public_key;
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject arg) {
        this.public_key = arg;
        return arg;
    }

    @JRubyMethod
    public IRubyObject sign(final IRubyObject key, IRubyObject digest) {
        String keyAlg = ((PKey)key).getAlgorithm();
        String digAlg = ((Digest)digest).getShortAlgorithm();
        final ASN1ObjectIdentifier alg = ASN1.getOIDLookup(this.getRuntime()).get(keyAlg.toLowerCase() + "-" + digAlg.toLowerCase());
        try {
            OpenSSLReal.doWithBCProvider(new OpenSSLReal.Runnable(){

                @Override
                public void run() throws GeneralSecurityException {
                    NetscapeSPKI.this.cert = new NetscapeCertRequest(NetscapeSPKI.this.challenge.toString(), new AlgorithmIdentifier(alg), ((PKey)NetscapeSPKI.this.public_key).getPublicKey());
                    NetscapeSPKI.this.cert.sign(((PKey)key).getPrivateKey());
                }
            });
        }
        catch (GeneralSecurityException gse) {
            throw NetscapeSPKI.newSPKIError(this.getRuntime(), gse.getMessage());
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(IRubyObject pkey) {
        this.cert.setPublicKey(((PKey)pkey).getPublicKey());
        try {
            Boolean result = (Boolean)OpenSSLReal.getWithBCProvider(new OpenSSLReal.Callable(){

                @Override
                public Boolean call() throws GeneralSecurityException {
                    return NetscapeSPKI.this.cert.verify(NetscapeSPKI.this.challenge.toString());
                }
            });
            return result != false ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        catch (GeneralSecurityException gse) {
            throw NetscapeSPKI.newSPKIError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject challenge() {
        return this.challenge;
    }

    @JRubyMethod(name={"challenge="})
    public IRubyObject set_challenge(IRubyObject arg) {
        this.challenge = arg;
        return arg;
    }

    private static RaiseException newSPKIError(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::Netscape::SPKIError", message);
    }
}

