/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ripper.ByteListLexerSource;
import org.jruby.ext.ripper.GetsLexerSource;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.ext.ripper.Ripper19Parser;
import org.jruby.ext.ripper.RipperParser;
import org.jruby.ext.ripper.SyntaxException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRipper
extends RubyObject {
    private RipperParser parser = null;
    private IRubyObject filename = null;
    private boolean parseStarted = false;

    public static void initRipper(Ruby runtime) {
        RubyClass ripper = runtime.defineClass("Ripper", runtime.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new RubyRipper(runtime, klazz);
            }
        });
        ripper.defineConstant("SCANNER_EVENT_TABLE", RubyRipper.createScannerEventTable(runtime, ripper));
        ripper.defineConstant("PARSER_EVENT_TABLE", RubyRipper.createParserEventTable(runtime, ripper));
        ripper.defineAnnotatedMethods(RubyRipper.class);
    }

    private static IRubyObject createScannerEventTable(Ruby runtime, RubyClass ripper) {
        RubyHash hash = new RubyHash(runtime);
        hash.fastASet((IRubyObject)runtime.newSymbol("CHAR"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("__end__"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("backref"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("backtick"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("comma"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("comment"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("const"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("cvar"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("embdoc"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("embdoc_beg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("embdoc_end"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("embexpr_beg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("embexpr_end"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("embvar"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("float"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("gvar"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("heredoc_beg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("heredoc_end"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("ident"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("ignored_nl"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("int"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("ivar"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("kw"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("label"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("lbrace"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("lbracket"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("lparen"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("nl"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("op"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("period"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("qwords_beg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("rbrace"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("rbracket"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("regexp_beg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("regexp_end"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("rparen"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("semicolon"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("sp"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("symbeg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("tlambda"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("tlambeg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("tstring_beg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("tstring_content"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("tstring_end"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("words_beg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("words_sep"), (IRubyObject)runtime.newFixnum(1));
        return hash;
    }

    private static IRubyObject createParserEventTable(Ruby runtime, RubyClass ripper) {
        RubyHash hash = new RubyHash(runtime);
        hash.fastASet((IRubyObject)runtime.newSymbol("BEGIN"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("END"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("alias"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("alias_error"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("aref"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("aref_field"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("arg_ambiguous"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("arg_paren"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("args_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("args_add_block"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("args_add_star"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("args_new"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("array"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("assign"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("assign_error"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("assoc_new"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("assoclist_from_args"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("bare_assoc_hash"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("begin"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("binary"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("block_var"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("block_var_add_block"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("block_var_add_star"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("blockarg"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("bodystmt"), (IRubyObject)runtime.newFixnum(4));
        hash.fastASet((IRubyObject)runtime.newSymbol("brace_block"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("break"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("call"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("case"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("class"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("class_name_error"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("command"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("command_call"), (IRubyObject)runtime.newFixnum(4));
        hash.fastASet((IRubyObject)runtime.newSymbol("const_path_field"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("const_path_ref"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("const_ref"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("def"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("defined"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("defs"), (IRubyObject)runtime.newFixnum(5));
        hash.fastASet((IRubyObject)runtime.newSymbol("do_block"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("dot2"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("dot3"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("dyna_symbol"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("else"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("elsif"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("ensure"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("excessed_comma"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("fcall"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("field"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("for"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("hash"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("if"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("if_mod"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("ifop"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("lambda"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("magic_comment"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("massign"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("method_add_arg"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("method_add_block"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("mlhs_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("mlhs_add_star"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("mlhs_new"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("mlhs_paren"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("module"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("mrhs_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("mrhs_add_star"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("mrhs_new"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("mrhs_new_from_args"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("next"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("opassign"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("operator_ambiguous"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("param_error"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("params"), (IRubyObject)runtime.newFixnum(5));
        hash.fastASet((IRubyObject)runtime.newSymbol("paren"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("parse_error"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("program"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("qwords_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("qwords_new"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("redo"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("regexp_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("regexp_literal"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("regexp_new"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("rescue"), (IRubyObject)runtime.newFixnum(4));
        hash.fastASet((IRubyObject)runtime.newSymbol("rescue_mod"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("rest_param"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("retry"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("return"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("return0"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("sclass"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("stmts_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("stmts_new"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("string_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("string_concat"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("string_content"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("string_dvar"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("string_embexpr"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("string_literal"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("super"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("symbol"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("symbol_literal"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("top_const_field"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("top_const_ref"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("unary"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("undef"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("unless"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("unless_mod"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("until"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("until_mod"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("var_alias"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("var_field"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("var_ref"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("vcall"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("void_stmt"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("when"), (IRubyObject)runtime.newFixnum(3));
        hash.fastASet((IRubyObject)runtime.newSymbol("while"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("while_mod"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("word_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("word_new"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("words_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("words_new"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("xstring_add"), (IRubyObject)runtime.newFixnum(2));
        hash.fastASet((IRubyObject)runtime.newSymbol("xstring_literal"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("xstring_new"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("yield"), (IRubyObject)runtime.newFixnum(1));
        hash.fastASet((IRubyObject)runtime.newSymbol("yield0"), (IRubyObject)runtime.newFixnum(0));
        hash.fastASet((IRubyObject)runtime.newSymbol("zsuper"), (IRubyObject)runtime.newFixnum(0));
        return hash;
    }

    private RubyRipper(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject src) {
        return this.initialize(context, src, null, null);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject file) {
        return this.initialize(context, src, file, null);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject file, IRubyObject line) {
        this.filename = this.filenameAsString(context, file);
        this.parser = new Ripper19Parser(context, (IRubyObject)this, this.source(context, src, this.filename.asJavaString(), this.lineAsInt(context, line)));
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject column(ThreadContext context) {
        if (!this.parser.hasStarted()) {
            context.runtime.newArgumentError("method called for uninitialized object");
        }
        if (!this.parseStarted) {
            return context.runtime.getNil();
        }
        return context.runtime.newFixnum(this.parser.getColumn());
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        return context.runtime.getEncodingService().getEncoding(this.parser.encoding());
    }

    @JRubyMethod(name={"end_seen?"})
    public IRubyObject end_seen_p(ThreadContext context) {
        return context.runtime.newBoolean(this.parser.isEndSeen());
    }

    @JRubyMethod
    public IRubyObject filename(ThreadContext context) {
        return this.filename;
    }

    @JRubyMethod
    public IRubyObject lineno(ThreadContext context) {
        if (!this.parser.hasStarted()) {
            context.runtime.newArgumentError("method called for uninitialized object");
        }
        if (!this.parseStarted) {
            return context.runtime.getNil();
        }
        return context.runtime.newFixnum(this.parser.getLineno());
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext context) {
        this.parseStarted = true;
        try {
            return this.parser.parse(true);
        }
        catch (IOException e) {
            System.out.println("ERRROR: " + e);
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject yydebug(ThreadContext context) {
        return context.runtime.newBoolean(this.parser.getYYDebug());
    }

    @JRubyMethod(name={"yydebug="})
    public IRubyObject yydebug_set(ThreadContext context, IRubyObject arg) {
        this.parser.setYYDebug(arg.isTrue());
        return arg;
    }

    private LexerSource source(ThreadContext context, IRubyObject src, String filename, int lineno) {
        DynamicMethod method = src.getMetaClass().searchMethod("gets");
        if (method.isUndefined() || method.getVisibility() == Visibility.PRIVATE) {
            return new ByteListLexerSource(filename, lineno, src.convertToString().getByteList());
        }
        return new GetsLexerSource(filename, lineno, src);
    }

    private IRubyObject filenameAsString(ThreadContext context, IRubyObject filename) {
        if (filename == null || filename.isNil()) {
            return context.runtime.newString("(ripper)");
        }
        return filename.convertToString();
    }

    private int lineAsInt(ThreadContext context, IRubyObject line) {
        if (line == null || line.isNil()) {
            return 0;
        }
        return RubyNumeric.fix2int((IRubyObject)line.convertToInteger());
    }
}

