/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.jdi.ClassLoaderReferenceImpl;
import sun.jvm.hotspot.jdi.FieldImpl;
import sun.jvm.hotspot.jdi.InterfaceTypeImpl;
import sun.jvm.hotspot.jdi.MethodImpl;
import sun.jvm.hotspot.jdi.SDE;
import sun.jvm.hotspot.jdi.TypeImpl;
import sun.jvm.hotspot.jdi.ValueImpl;
import sun.jvm.hotspot.jdi.VirtualMachineImpl;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.utilities.Assert;

public abstract class ReferenceTypeImpl
extends TypeImpl
implements ReferenceType {
    protected Klass saKlass;
    protected Symbol typeNameSymbol;
    private int modifiers = -1;
    private String signature = null;
    private SoftReference sdeRef = null;
    private SoftReference fieldsCache;
    private SoftReference allFieldsCache;
    private SoftReference methodsCache;
    private SoftReference allMethodsCache;
    private SoftReference nestedTypesCache;
    private SoftReference methodInvokesCache;
    static final SDE NO_SDE_INFO_MARK = new SDE();
    static Object prev;

    protected ReferenceTypeImpl(VirtualMachine aVm, Klass klass) {
        super(aVm);
        this.saKlass = klass;
        this.typeNameSymbol = this.saKlass.getName();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.typeNameSymbol != null, "null type name for a Klass");
        }
    }

    Symbol typeNameAsSymbol() {
        return this.typeNameSymbol;
    }

    com.sun.jdi.Method getMethodMirror(Method ref) {
        for (MethodImpl method : this.methods()) {
            if (!ref.equals(method.ref())) continue;
            return method;
        }
        if (ref.getMethodHolder().equals(SystemDictionary.getMethodHandleKlass())) {
            MethodImpl method2;
            List<MethodImpl> mis = null;
            if (this.methodInvokesCache == null) {
                mis = new ArrayList();
                this.methodInvokesCache = new SoftReference(mis);
            } else {
                mis = (List)this.methodInvokesCache.get();
            }
            for (MethodImpl method2 : mis) {
                if (!ref.equals(method2.ref())) continue;
                return method2;
            }
            method2 = MethodImpl.createMethodImpl(this.vm, this, ref);
            mis.add(method2);
            return method2;
        }
        throw new IllegalArgumentException("Invalid method id: " + ref);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ReferenceTypeImpl) {
            ReferenceTypeImpl other = (ReferenceTypeImpl)obj;
            return this.ref().equals(other.ref()) && this.vm.equals(other.virtualMachine());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.saKlass.hashCode();
    }

    @Override
    public int compareTo(ReferenceType refType) {
        ReferenceTypeImpl other = (ReferenceTypeImpl)refType;
        int comp = this.name().compareTo(other.name());
        if (comp == 0) {
            Klass rf2;
            Klass rf1 = this.ref();
            comp = rf1.equals(rf2 = other.ref()) ? this.vm.sequenceNumber - ((VirtualMachineImpl)other.virtualMachine()).sequenceNumber : (rf1.getHandle().minus(rf2.getHandle()) < 0L ? -1 : 1);
        }
        return comp;
    }

    @Override
    public String signature() {
        if (this.signature == null) {
            this.signature = this.saKlass.signature();
        }
        return this.signature;
    }

    @Override
    public String genericSignature() {
        if (this.saKlass instanceof ArrayKlass) {
            return null;
        }
        Symbol genSig = ((InstanceKlass)this.saKlass).getGenericSignature();
        return genSig != null ? genSig.asString() : null;
    }

    @Override
    public ClassLoaderReference classLoader() {
        Instance xx = (Instance)((InstanceKlass)this.saKlass).getClassLoader();
        return this.vm.classLoaderMirror(xx);
    }

    @Override
    public boolean isPublic() {
        return (this.modifiers() & 1) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.modifiers() & 4) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.modifiers() & 2) != 0;
    }

    @Override
    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public boolean isAbstract() {
        return (this.modifiers() & 0x400) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.modifiers() & 0x10) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.modifiers() & 8) != 0;
    }

    @Override
    public boolean isPrepared() {
        return (this.saKlass.getClassStatus() & 2) != 0;
    }

    final void checkPrepared() throws ClassNotPreparedException {
        if (!this.isPrepared()) {
            throw new ClassNotPreparedException();
        }
    }

    @Override
    public boolean isVerified() {
        return (this.saKlass.getClassStatus() & 1) != 0;
    }

    @Override
    public boolean isInitialized() {
        return (this.saKlass.getClassStatus() & 4) != 0;
    }

    @Override
    public boolean failedToInitialize() {
        return (this.saKlass.getClassStatus() & 8) != 0;
    }

    private boolean isThrowableBacktraceField(sun.jvm.hotspot.oops.Field fld) {
        return fld.getFieldHolder().getName().equals(this.vm.javaLangThrowable()) && fld.getID().getName().equals("backtrace");
    }

    public final List fields() throws ClassNotPreparedException {
        List<FieldImpl> fields;
        List list = fields = this.fieldsCache != null ? (ArrayList)this.fieldsCache.get() : null;
        if (fields == null) {
            this.checkPrepared();
            if (this.saKlass instanceof ArrayKlass) {
                fields = new ArrayList(0);
            } else {
                List saFields = ((InstanceKlass)this.saKlass).getImmediateFields();
                int len = saFields.size();
                fields = new ArrayList(len);
                for (int ii = 0; ii < len; ++ii) {
                    sun.jvm.hotspot.oops.Field curField = (sun.jvm.hotspot.oops.Field)saFields.get(ii);
                    if (this.isThrowableBacktraceField(curField)) continue;
                    fields.add(new FieldImpl(this.vm, this, curField));
                }
            }
            fields = Collections.unmodifiableList(fields);
            this.fieldsCache = new SoftReference(fields);
        }
        return fields;
    }

    public final List allFields() throws ClassNotPreparedException {
        List<FieldImpl> allFields;
        List list = allFields = this.allFieldsCache != null ? (ArrayList)this.allFieldsCache.get() : null;
        if (allFields == null) {
            this.checkPrepared();
            if (this.saKlass instanceof ArrayKlass) {
                allFields = new ArrayList(0);
            } else {
                List saFields = ((InstanceKlass)this.saKlass).getAllFields();
                int len = saFields.size();
                allFields = new ArrayList(len);
                for (int ii = 0; ii < len; ++ii) {
                    sun.jvm.hotspot.oops.Field curField = (sun.jvm.hotspot.oops.Field)saFields.get(ii);
                    if (this.isThrowableBacktraceField(curField)) continue;
                    allFields.add(new FieldImpl(this.vm, this.vm.referenceType(curField.getFieldHolder()), curField));
                }
            }
            allFields = Collections.unmodifiableList(allFields);
            this.allFieldsCache = new SoftReference(allFields);
        }
        return allFields;
    }

    abstract List inheritedTypes();

    void addVisibleFields(List visibleList, Map visibleTable, List ambiguousNames) {
        List list = this.visibleFields();
        for (Field field : list) {
            String name = field.name();
            if (ambiguousNames.contains(name)) continue;
            Field duplicate = (Field)visibleTable.get(name);
            if (duplicate == null) {
                visibleList.add(field);
                visibleTable.put(name, field);
                continue;
            }
            if (((Object)field).equals(duplicate)) continue;
            ambiguousNames.add(name);
            visibleTable.remove(name);
            visibleList.remove(duplicate);
        }
    }

    public final List visibleFields() throws ClassNotPreparedException {
        this.checkPrepared();
        ArrayList visibleList = new ArrayList();
        HashMap visibleTable = new HashMap();
        ArrayList ambiguousNames = new ArrayList();
        List types = this.inheritedTypes();
        for (ReferenceTypeImpl type : types) {
            type.addVisibleFields(visibleList, visibleTable, ambiguousNames);
        }
        ArrayList retList = new ArrayList(this.fields());
        for (Field field : retList) {
            Field hidden = (Field)visibleTable.get(field.name());
            if (hidden == null) continue;
            visibleList.remove(hidden);
        }
        retList.addAll(visibleList);
        return retList;
    }

    @Override
    public final Field fieldByName(String fieldName) throws ClassNotPreparedException {
        List searchList = this.visibleFields();
        for (int i = 0; i < searchList.size(); ++i) {
            Field f = (Field)searchList.get(i);
            if (!f.name().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    public final List methods() throws ClassNotPreparedException {
        List<MethodImpl> methods;
        List list = methods = this.methodsCache != null ? (ArrayList)this.methodsCache.get() : null;
        if (methods == null) {
            this.checkPrepared();
            if (this.saKlass instanceof ArrayKlass) {
                methods = new ArrayList(0);
            } else {
                List saMethods = ((InstanceKlass)this.saKlass).getImmediateMethods();
                int len = saMethods.size();
                methods = new ArrayList(len);
                for (int ii = 0; ii < len; ++ii) {
                    methods.add(MethodImpl.createMethodImpl(this.vm, this, (Method)saMethods.get(ii)));
                }
            }
            methods = Collections.unmodifiableList(methods);
            this.methodsCache = new SoftReference(methods);
        }
        return methods;
    }

    abstract List getAllMethods();

    public final List allMethods() throws ClassNotPreparedException {
        List allMethods;
        List list = allMethods = this.allMethodsCache != null ? (List)this.allMethodsCache.get() : null;
        if (allMethods == null) {
            this.checkPrepared();
            allMethods = Collections.unmodifiableList(this.getAllMethods());
            this.allMethodsCache = new SoftReference(allMethods);
        }
        return allMethods;
    }

    void addToMethodMap(Map methodMap, List methodList) {
        for (com.sun.jdi.Method method : methodList) {
            methodMap.put(method.name().concat(method.signature()), method);
        }
    }

    abstract void addVisibleMethods(Map var1);

    public final List visibleMethods() throws ClassNotPreparedException {
        this.checkPrepared();
        HashMap map = new HashMap();
        this.addVisibleMethods(map);
        ArrayList list = new ArrayList(this.allMethods());
        list.retainAll(map.values());
        return list;
    }

    public static String jjstr(Collection cc) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = cc.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object o = i.next();
            if (prev == null) {
                prev = o;
            } else {
                System.out.println("prev == curr?" + prev.equals(o));
                System.out.println("prev == curr?" + (prev == o));
            }
            buf.append(o + "@" + o.hashCode());
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public final List methodsByName(String name) throws ClassNotPreparedException {
        List methods = this.visibleMethods();
        ArrayList<com.sun.jdi.Method> retList = new ArrayList<com.sun.jdi.Method>(methods.size());
        for (com.sun.jdi.Method candidate : methods) {
            if (!candidate.name().equals(name)) continue;
            retList.add(candidate);
        }
        retList.trimToSize();
        return retList;
    }

    public final List methodsByName(String name, String signature) throws ClassNotPreparedException {
        List methods = this.visibleMethods();
        ArrayList<com.sun.jdi.Method> retList = new ArrayList<com.sun.jdi.Method>(methods.size());
        for (com.sun.jdi.Method candidate : methods) {
            if (!candidate.name().equals(name) || !candidate.signature().equals(signature)) continue;
            retList.add(candidate);
        }
        retList.trimToSize();
        return retList;
    }

    List getInterfaces() {
        ArrayList<InterfaceTypeImpl> myInterfaces;
        if (this.saKlass instanceof ArrayKlass) {
            myInterfaces = new ArrayList<InterfaceTypeImpl>(0);
        } else {
            List saInterfaces = ((InstanceKlass)this.saKlass).getDirectImplementedInterfaces();
            int len = saInterfaces.size();
            myInterfaces = new ArrayList(len);
            for (int ii = 0; ii < len; ++ii) {
                myInterfaces.add(new InterfaceTypeImpl((VirtualMachine)this.vm, (InstanceKlass)saInterfaces.get(ii)));
            }
        }
        return myInterfaces;
    }

    public final List nestedTypes() {
        List<ReferenceTypeImpl> nestedTypes;
        List list = nestedTypes = this.nestedTypesCache != null ? (ArrayList)this.nestedTypesCache.get() : null;
        if (nestedTypes == null) {
            if (this.saKlass instanceof ArrayKlass) {
                nestedTypes = new ArrayList(0);
            } else {
                ClassLoaderReference cl = this.classLoader();
                List classes = null;
                classes = cl != null ? cl.visibleClasses() : this.vm.bootstrapClasses();
                nestedTypes = new ArrayList();
                for (ReferenceTypeImpl refType : classes) {
                    Symbol candidateName = refType.ref().getName();
                    if (!((InstanceKlass)this.saKlass).isInnerOrLocalClassName(candidateName)) continue;
                    nestedTypes.add(refType);
                }
            }
            nestedTypes = Collections.unmodifiableList(nestedTypes);
            this.nestedTypesCache = new SoftReference(nestedTypes);
        }
        return nestedTypes;
    }

    @Override
    public Value getValue(Field sig) {
        ArrayList<Field> list = new ArrayList<Field>(1);
        list.add(sig);
        Map map = this.getValues(list);
        return (Value)map.get(sig);
    }

    public Map getValues(List theFields) {
        int size = theFields.size();
        HashMap<FieldImpl, ValueImpl> map = new HashMap<FieldImpl, ValueImpl>(size);
        for (int ii = 0; ii < size; ++ii) {
            FieldImpl fieldImpl = (FieldImpl)theFields.get(ii);
            this.validateFieldAccess(fieldImpl);
            if (!fieldImpl.isStatic()) {
                throw new IllegalArgumentException("Attempt to use non-static field with ReferenceType: " + fieldImpl.name());
            }
            map.put(fieldImpl, fieldImpl.getValue());
        }
        return map;
    }

    void validateFieldAccess(Field field) {
        ReferenceTypeImpl declType = (ReferenceTypeImpl)field.declaringType();
        if (!declType.isAssignableFrom(this)) {
            throw new IllegalArgumentException("Invalid field");
        }
    }

    @Override
    public ClassObjectReference classObject() {
        return this.vm.classObjectMirror(this.ref().getJavaMirror());
    }

    SDE.Stratum stratum(String stratumID) {
        SDE sde = this.sourceDebugExtensionInfo();
        if (!sde.isValid()) {
            sde = NO_SDE_INFO_MARK;
        }
        return sde.stratum(stratumID);
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        return (String)this.sourceNames(this.vm.getDefaultStratum()).get(0);
    }

    public List sourceNames(String stratumID) throws AbsentInformationException {
        SDE.Stratum stratum = this.stratum(stratumID);
        if (stratum.isJava()) {
            ArrayList<String> result = new ArrayList<String>(1);
            result.add(this.baseSourceName());
            return result;
        }
        return stratum.sourceNames(this);
    }

    public List sourcePaths(String stratumID) throws AbsentInformationException {
        SDE.Stratum stratum = this.stratum(stratumID);
        if (stratum.isJava()) {
            ArrayList<String> result = new ArrayList<String>(1);
            result.add(this.baseSourceDir() + this.baseSourceName());
            return result;
        }
        return stratum.sourcePaths(this);
    }

    String baseSourceName() throws AbsentInformationException {
        if (this.saKlass instanceof ArrayKlass) {
            throw new AbsentInformationException();
        }
        Symbol sym = ((InstanceKlass)this.saKlass).getSourceFileName();
        if (sym != null) {
            return sym.asString();
        }
        throw new AbsentInformationException();
    }

    String baseSourcePath() throws AbsentInformationException {
        return this.baseSourceDir() + this.baseSourceName();
    }

    String baseSourceDir() {
        int nextIndex;
        String typeName = this.name();
        StringBuffer sb = new StringBuffer(typeName.length() + 10);
        int index = 0;
        while ((nextIndex = typeName.indexOf(46, index)) > 0) {
            sb.append(typeName.substring(index, nextIndex));
            sb.append(File.separatorChar);
            index = nextIndex + 1;
        }
        return sb.toString();
    }

    @Override
    public String sourceDebugExtension() throws AbsentInformationException {
        if (!this.vm.canGetSourceDebugExtension()) {
            throw new UnsupportedOperationException();
        }
        SDE sde = this.sourceDebugExtensionInfo();
        if (sde == NO_SDE_INFO_MARK) {
            throw new AbsentInformationException();
        }
        return sde.sourceDebugExtension;
    }

    private SDE sourceDebugExtensionInfo() {
        if (!this.vm.canGetSourceDebugExtension()) {
            return NO_SDE_INFO_MARK;
        }
        SDE sde = null;
        SDE sDE = sde = this.sdeRef == null ? null : (SDE)this.sdeRef.get();
        if (sde == null) {
            String extension = null;
            if (this.saKlass instanceof InstanceKlass) {
                Symbol sdeSym = ((InstanceKlass)this.saKlass).getSourceDebugExtension();
                extension = sdeSym != null ? sdeSym.asString() : null;
            }
            sde = extension == null ? NO_SDE_INFO_MARK : new SDE(extension);
            this.sdeRef = new SoftReference<SDE>(sde);
        }
        return sde;
    }

    public List availableStrata() {
        SDE sde = this.sourceDebugExtensionInfo();
        if (sde.isValid()) {
            return sde.availableStrata();
        }
        ArrayList<String> strata = new ArrayList<String>();
        strata.add("Java");
        return strata;
    }

    @Override
    public String defaultStratum() {
        SDE sdei = this.sourceDebugExtensionInfo();
        if (sdei.isValid()) {
            return sdei.defaultStratumId;
        }
        return "Java";
    }

    @Override
    public final int modifiers() {
        if (this.modifiers == -1) {
            this.modifiers = this.getModifiers();
        }
        return this.modifiers;
    }

    public List instances(long maxInstances) {
        if (!this.vm.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        if (maxInstances < 0L) {
            throw new IllegalArgumentException("maxInstances is less than zero: " + maxInstances);
        }
        final ArrayList objects = new ArrayList(0);
        if (this.isAbstract() || this instanceof InterfaceType) {
            return objects;
        }
        final Klass givenKls = this.ref();
        final long max = maxInstances;
        this.vm.saObjectHeap().iterate(new DefaultHeapVisitor(){
            private long instCount = 0L;

            @Override
            public boolean doObj(Oop oop) {
                if (givenKls.equals(oop.getKlass())) {
                    objects.add(ReferenceTypeImpl.this.vm.objectMirror(oop));
                    ++this.instCount;
                }
                return max > 0L && this.instCount >= max;
            }
        });
        return objects;
    }

    int getModifiers() {
        return (int)this.saKlass.getClassModifiers();
    }

    public List allLineLocations() throws AbsentInformationException {
        return this.allLineLocations(this.vm.getDefaultStratum(), null);
    }

    public List allLineLocations(String stratumID, String sourceName) throws AbsentInformationException {
        this.checkPrepared();
        boolean someAbsent = false;
        SDE.Stratum stratum = this.stratum(stratumID);
        ArrayList list = new ArrayList();
        for (MethodImpl method : this.methods()) {
            try {
                list.addAll(method.allLineLocations(stratum.id(), sourceName));
            }
            catch (AbsentInformationException exc) {
                someAbsent = true;
            }
        }
        if (someAbsent && list.size() == 0) {
            throw new AbsentInformationException();
        }
        return list;
    }

    public List locationsOfLine(int lineNumber) throws AbsentInformationException {
        return this.locationsOfLine(this.vm.getDefaultStratum(), null, lineNumber);
    }

    public List locationsOfLine(String stratumID, String sourceName, int lineNumber) throws AbsentInformationException {
        this.checkPrepared();
        boolean someAbsent = false;
        boolean somePresent = false;
        List methods = this.methods();
        SDE.Stratum stratum = this.stratum(stratumID);
        ArrayList list = new ArrayList();
        for (MethodImpl method : methods) {
            if (method.isAbstract() || method.isNative()) continue;
            try {
                list.addAll(method.locationsOfLine(stratum.id(), sourceName, lineNumber));
                somePresent = true;
            }
            catch (AbsentInformationException exc) {
                someAbsent = true;
            }
        }
        if (someAbsent && !somePresent) {
            throw new AbsentInformationException();
        }
        return list;
    }

    Klass ref() {
        return this.saKlass;
    }

    abstract boolean isAssignableTo(ReferenceType var1);

    boolean isAssignableFrom(ReferenceType type) {
        return ((ReferenceTypeImpl)type).isAssignableTo(this);
    }

    boolean isAssignableFrom(ObjectReference object) {
        return object == null || this.isAssignableFrom(object.referenceType());
    }

    int indexOf(com.sun.jdi.Method method) {
        return this.methods().indexOf(method);
    }

    int indexOf(Field field) {
        return this.fields().indexOf(field);
    }

    private static boolean isPrimitiveArray(String signature) {
        char c;
        int i = signature.lastIndexOf(91);
        boolean isPA = i < 0 ? false : (c = signature.charAt(i + 1)) != 'L';
        return isPA;
    }

    Type findType(String signature) throws ClassNotLoadedException {
        ClassLoaderReferenceImpl loader;
        char sig;
        Type type = signature.length() == 1 ? ((sig = signature.charAt(0)) == 'V' ? this.vm.theVoidType() : this.vm.primitiveTypeMirror(sig)) : ((loader = (ClassLoaderReferenceImpl)this.classLoader()) == null || ReferenceTypeImpl.isPrimitiveArray(signature) ? this.vm.findBootType(signature) : loader.findType(signature));
        return type;
    }

    String loaderString() {
        if (this.classLoader() != null) {
            return "loaded by " + this.classLoader().toString();
        }
        return "loaded by bootstrap loader";
    }

    long uniqueID() {
        return this.vm.getAddressValue(this.ref());
    }

    @Override
    public int majorVersion() {
        if (!this.vm.canGetClassFileVersion()) {
            throw new UnsupportedOperationException("Cannot get class file version");
        }
        return (int)((InstanceKlass)this.saKlass).majorVersion();
    }

    @Override
    public int minorVersion() {
        if (!this.vm.canGetClassFileVersion()) {
            throw new UnsupportedOperationException("Cannot get class file version");
        }
        return (int)((InstanceKlass)this.saKlass).minorVersion();
    }

    @Override
    public int constantPoolCount() {
        if (!this.vm.canGetConstantPool()) {
            throw new UnsupportedOperationException("Cannot get constant pool");
        }
        if (this.saKlass instanceof ArrayKlass) {
            return 0;
        }
        return ((InstanceKlass)this.saKlass).getConstants().getLength();
    }

    @Override
    public byte[] constantPool() {
        if (!this.vm.canGetConstantPool()) {
            throw new UnsupportedOperationException("Cannot get constant pool");
        }
        if (this instanceof ArrayType || this instanceof PrimitiveType) {
            byte[] bytes = new byte[]{};
            return bytes;
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            ((InstanceKlass)this.saKlass).getConstants().writeBytes(bs);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            byte[] bytes = new byte[]{};
            return bytes;
        }
        return bs.toByteArray();
    }
}

