/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import sun.jvm.hotspot.jdi.ConnectorImpl;

public class SAPIDAttachingConnector
extends ConnectorImpl
implements AttachingConnector {
    static final String ARG_PID = "pid";
    private Transport transport;

    public SAPIDAttachingConnector(VirtualMachineManagerService ignored) {
        this();
    }

    public SAPIDAttachingConnector() {
        this.addStringArgument(ARG_PID, "PID", "PID of a Java process", "", true);
        this.transport = new Transport(){

            public String name() {
                return "local process";
            }
        };
    }

    private void checkProcessAttach(int pid) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String os = System.getProperty("os.name");
            try {
                this.checkNativeLink(sm, os);
                if (os.equals("SunOS") || os.equals("Linux") || os.equals("FreeBSD")) {
                    sm.checkRead("/proc/" + pid);
                }
            }
            catch (SecurityException se) {
                throw new SecurityException("permission denied to attach to " + pid);
            }
        }
    }

    private VirtualMachine createVirtualMachine(Class virtualMachineImplClass, int pid) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method createByPIDMethod = virtualMachineImplClass.getMethod("createVirtualMachineForPID", VirtualMachineManager.class, Integer.TYPE, Integer.TYPE);
        return (VirtualMachine)createByPIDMethod.invoke(null, Bootstrap.virtualMachineManager(), new Integer(pid), new Integer(0));
    }

    public VirtualMachine attach(Map arguments) throws IOException, IllegalConnectorArgumentsException {
        int pid = 0;
        try {
            pid = Integer.parseInt(this.argument(ARG_PID, arguments).value());
        }
        catch (NumberFormatException nfe) {
            throw (IllegalConnectorArgumentsException)new IllegalConnectorArgumentsException(nfe.getMessage(), ARG_PID).initCause(nfe);
        }
        this.checkProcessAttach(pid);
        VirtualMachine myVM = null;
        try {
            try {
                Class vmImplClass = SAPIDAttachingConnector.loadVirtualMachineImplClass();
                myVM = this.createVirtualMachine(vmImplClass, pid);
            }
            catch (InvocationTargetException ite) {
                Class vmImplClass = SAPIDAttachingConnector.handleVMVersionMismatch(ite);
                if (vmImplClass != null) {
                    return this.createVirtualMachine(vmImplClass, pid);
                }
                throw ite;
            }
        }
        catch (Exception ee) {
            if (DEBUG) {
                System.out.println("VirtualMachineImpl() got an exception:");
                ee.printStackTrace();
                System.out.println("pid = " + pid);
            }
            throw (IOException)new IOException().initCause(ee);
        }
        SAPIDAttachingConnector.setVMDisposeObserver(myVM);
        return myVM;
    }

    public String name() {
        return "sun.jvm.hotspot.jdi.SAPIDAttachingConnector";
    }

    public String description() {
        return this.getString("This connector allows you to attach to a Java process using the Serviceability Agent");
    }

    public Transport transport() {
        return this.transport;
    }
}

