/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import sun.awt.image.BufImgVolatileSurfaceManager;
import sun.awt.image.BufferedImageGraphicsConfig;
import sun.awt.image.SurfaceManager;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceManagerFactory;
import sun.print.PrinterGraphicsConfig;

public class SunVolatileImage
extends VolatileImage {
    protected VolatileSurfaceManager volSurfaceManager;
    protected Component comp;
    private GraphicsConfiguration graphicsConfig;
    private Font defaultFont;
    private int width;
    private int height;

    private SunVolatileImage(Component component, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object object, int n3, ImageCapabilities imageCapabilities) {
        this.comp = component;
        this.graphicsConfig = graphicsConfiguration;
        this.width = n;
        this.height = n2;
        if (n3 != 1 && n3 != 2 && n3 != 3) {
            throw new IllegalArgumentException("Unknown transparency type:" + n3);
        }
        this.transparency = n3;
        this.volSurfaceManager = this.createSurfaceManager(object, imageCapabilities);
        SurfaceManager.setManager(this, this.volSurfaceManager);
        this.volSurfaceManager.initialize();
        this.volSurfaceManager.initContents();
    }

    private SunVolatileImage(Component component, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object object, ImageCapabilities imageCapabilities) {
        this(component, graphicsConfiguration, n, n2, object, 1, imageCapabilities);
    }

    public SunVolatileImage(Component component, int n, int n2) {
        this(component, n, n2, null);
    }

    public SunVolatileImage(Component component, int n, int n2, Object object) {
        this(component, component.getGraphicsConfiguration(), n, n2, object, null);
    }

    public SunVolatileImage(GraphicsConfiguration graphicsConfiguration, int n, int n2, int n3, ImageCapabilities imageCapabilities) {
        this(null, graphicsConfiguration, n, n2, null, n3, imageCapabilities);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public GraphicsConfiguration getGraphicsConfig() {
        return this.graphicsConfig;
    }

    public void updateGraphicsConfig() {
        GraphicsConfiguration graphicsConfiguration;
        if (this.comp != null && (graphicsConfiguration = this.comp.getGraphicsConfiguration()) != null) {
            this.graphicsConfig = graphicsConfiguration;
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    protected VolatileSurfaceManager createSurfaceManager(Object object, ImageCapabilities imageCapabilities) {
        if (this.graphicsConfig instanceof BufferedImageGraphicsConfig || this.graphicsConfig instanceof PrinterGraphicsConfig || imageCapabilities != null && !imageCapabilities.isAccelerated()) {
            return new BufImgVolatileSurfaceManager(this, object);
        }
        return SurfaceManagerFactory.createVolatileManager(this, object);
    }

    private Color getForeground() {
        if (this.comp != null) {
            return this.comp.getForeground();
        }
        return Color.black;
    }

    private Color getBackground() {
        if (this.comp != null) {
            return this.comp.getBackground();
        }
        return Color.white;
    }

    private Font getFont() {
        if (this.comp != null) {
            return this.comp.getFont();
        }
        if (this.defaultFont == null) {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        return this.defaultFont;
    }

    public Graphics2D createGraphics() {
        return new SunGraphics2D(this.volSurfaceManager.getPrimarySurfaceData(), this.getForeground(), this.getBackground(), this.getFont());
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        if (string == null) {
            throw new NullPointerException("null property name is not allowed");
        }
        return Image.UndefinedProperty;
    }

    public int getWidth(ImageObserver imageObserver) {
        return this.getWidth();
    }

    public int getHeight(ImageObserver imageObserver) {
        return this.getHeight();
    }

    public BufferedImage getBackupImage() {
        return this.graphicsConfig.createCompatibleImage(this.getWidth(), this.getHeight(), this.getTransparency());
    }

    public BufferedImage getSnapshot() {
        BufferedImage bufferedImage = this.getBackupImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(this, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public int validate(GraphicsConfiguration graphicsConfiguration) {
        return this.volSurfaceManager.validate(graphicsConfiguration);
    }

    public boolean contentsLost() {
        return this.volSurfaceManager.contentsLost();
    }

    public ImageCapabilities getCapabilities() {
        return this.volSurfaceManager.getCapabilities(this.graphicsConfig);
    }
}

