/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Certificate;
import java.security.IdentityScope;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Vector;

@Deprecated
public abstract class Identity
implements Principal,
Serializable {
    private static final long serialVersionUID = 3609922007826600659L;
    private String name;
    private PublicKey publicKey;
    String info = "No further information available.";
    IdentityScope scope;
    Vector<Certificate> certificates;

    protected Identity() {
        this("restoring...");
    }

    public Identity(String string, IdentityScope identityScope) throws KeyManagementException {
        this(string);
        if (identityScope != null) {
            identityScope.addIdentity(this);
        }
        this.scope = identityScope;
    }

    public Identity(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final IdentityScope getScope() {
        return this.scope;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) throws KeyManagementException {
        Identity.check("setIdentityPublicKey");
        this.publicKey = publicKey;
        this.certificates = new Vector();
    }

    public void setInfo(String string) {
        Identity.check("setIdentityInfo");
        this.info = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void addCertificate(Certificate certificate) throws KeyManagementException {
        Identity.check("addIdentityCertificate");
        if (this.certificates == null) {
            this.certificates = new Vector();
        }
        if (this.publicKey != null) {
            if (!this.keyEquals(this.publicKey, certificate.getPublicKey())) {
                throw new KeyManagementException("public key different from cert public key");
            }
        } else {
            this.publicKey = certificate.getPublicKey();
        }
        this.certificates.addElement(certificate);
    }

    private boolean keyEquals(Key key, Key key2) {
        String string;
        String string2 = key.getFormat();
        if (string2 == null ^ (string = key2.getFormat()) == null) {
            return false;
        }
        if (string2 != null && string != null && !string2.equalsIgnoreCase(string)) {
            return false;
        }
        return Arrays.equals(key.getEncoded(), key2.getEncoded());
    }

    public void removeCertificate(Certificate certificate) throws KeyManagementException {
        Identity.check("removeIdentityCertificate");
        if (this.certificates != null) {
            this.certificates.removeElement(certificate);
        }
    }

    public Certificate[] certificates() {
        if (this.certificates == null) {
            return new Certificate[0];
        }
        int n = this.certificates.size();
        Object[] objectArray = new Certificate[n];
        this.certificates.copyInto(objectArray);
        return objectArray;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Identity) {
            Identity identity = (Identity)object;
            if (this.fullName().equals(identity.fullName())) {
                return true;
            }
            return this.identityEquals(identity);
        }
        return false;
    }

    protected boolean identityEquals(Identity identity) {
        if (!this.name.equalsIgnoreCase(identity.name)) {
            return false;
        }
        if (this.publicKey == null ^ identity.publicKey == null) {
            return false;
        }
        return this.publicKey == null || identity.publicKey == null || this.publicKey.equals(identity.publicKey);
    }

    String fullName() {
        String string = this.name;
        if (this.scope != null) {
            string = string + "." + this.scope.getName();
        }
        return string;
    }

    public String toString() {
        Identity.check("printIdentity");
        String string = this.name;
        if (this.scope != null) {
            string = string + "[" + this.scope.getName() + "]";
        }
        return string;
    }

    public String toString(boolean bl) {
        String string = this.toString();
        if (bl) {
            string = string + "\n";
            string = string + this.printKeys();
            string = string + "\n" + this.printCertificates();
            string = this.info != null ? string + "\n\t" + this.info : string + "\n\tno additional information available.";
        }
        return string;
    }

    String printKeys() {
        String string = "";
        string = this.publicKey != null ? "\tpublic key initialized" : "\tno public key";
        return string;
    }

    String printCertificates() {
        String string = "";
        if (this.certificates == null) {
            return "\tno certificates";
        }
        string = string + "\tcertificates: \n";
        int n = 1;
        for (Certificate certificate : this.certificates) {
            string = string + "\tcertificate " + n++ + "\tfor  : " + certificate.getPrincipal() + "\n";
            string = string + "\t\t\tfrom : " + certificate.getGuarantor() + "\n";
        }
        return string;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }
}

