/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKRegion;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import sun.awt.UNIXToolkit;
import sun.awt.image.SunWritableRaster;
import sun.swing.ImageCache;

class GTKEngine {
    static final GTKEngine INSTANCE = new GTKEngine();
    private static final int CACHE_SIZE = 50;
    private static HashMap regionToWidgetTypeMap;
    private ImageCache cache = new ImageCache(50);
    private int x0;
    private int y0;
    private int w0;
    private int h0;
    private Graphics graphics;
    private Object[] cacheArgs;
    private static final ColorModel[] COLOR_MODELS;
    private static final int[][] BAND_OFFSETS;

    GTKEngine() {
    }

    private native void native_paint_arrow(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9);

    private native void native_paint_box(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native void native_paint_box_gap(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private native void native_paint_check(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_expander(int var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8);

    private native void native_paint_extension(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9);

    private native void native_paint_flat_box(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, boolean var9);

    private native void native_paint_focus(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_handle(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9);

    private native void native_paint_hline(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_option(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_shadow(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native void native_paint_slider(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9);

    private native void native_paint_vline(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_background(int var1, int var2, int var3, int var4, int var5, int var6);

    private native Object native_get_gtk_setting(int var1);

    private native void nativeSetRangeValue(int var1, double var2, double var4, double var6, double var8);

    private native void nativeStartPainting(int var1, int var2);

    private native int nativeFinishPainting(int[] var1, int var2, int var3);

    private native void native_switch_theme();

    static WidgetType getWidgetType(JComponent jComponent, Region region) {
        Object v = regionToWidgetTypeMap.get(region);
        if (v instanceof WidgetType) {
            return (WidgetType)((Object)v);
        }
        WidgetType[] widgetTypeArray = (WidgetType[])v;
        if (jComponent == null) {
            return widgetTypeArray[0];
        }
        if (jComponent instanceof JScrollBar) {
            return ((JScrollBar)jComponent).getOrientation() == 0 ? widgetTypeArray[0] : widgetTypeArray[1];
        }
        if (jComponent instanceof JSeparator) {
            JSeparator jSeparator = (JSeparator)jComponent;
            if (jSeparator.getParent() instanceof JPopupMenu) {
                return WidgetType.POPUP_MENU_SEPARATOR;
            }
            if (jSeparator.getParent() instanceof JToolBar) {
                return WidgetType.TOOL_BAR_SEPARATOR;
            }
            return jSeparator.getOrientation() == 0 ? widgetTypeArray[0] : widgetTypeArray[1];
        }
        if (jComponent instanceof JSlider) {
            return ((JSlider)jComponent).getOrientation() == 0 ? widgetTypeArray[0] : widgetTypeArray[1];
        }
        if (jComponent instanceof JProgressBar) {
            return ((JProgressBar)jComponent).getOrientation() == 0 ? widgetTypeArray[0] : widgetTypeArray[1];
        }
        if (jComponent instanceof JSplitPane) {
            return ((JSplitPane)jComponent).getOrientation() == 1 ? widgetTypeArray[1] : widgetTypeArray[0];
        }
        if (region == Region.LABEL) {
            if (jComponent instanceof ListCellRenderer) {
                return widgetTypeArray[1];
            }
            return widgetTypeArray[0];
        }
        if (region == Region.TEXT_FIELD) {
            String string = jComponent.getName();
            if (string != null && string.startsWith("ComboBox")) {
                return widgetTypeArray[1];
            }
            return widgetTypeArray[0];
        }
        if (region == Region.FORMATTED_TEXT_FIELD) {
            String string = jComponent.getName();
            if (string != null && string.startsWith("Spinner")) {
                return widgetTypeArray[1];
            }
            return widgetTypeArray[0];
        }
        if (region == Region.ARROW_BUTTON) {
            if (jComponent.getParent() instanceof JScrollBar) {
                Integer n = (Integer)jComponent.getClientProperty("__arrow_direction__");
                int n2 = n != null ? n : 7;
                switch (n2) {
                    case 7: {
                        return WidgetType.HSCROLL_BAR_BUTTON_LEFT;
                    }
                    case 3: {
                        return WidgetType.HSCROLL_BAR_BUTTON_RIGHT;
                    }
                    case 1: {
                        return WidgetType.VSCROLL_BAR_BUTTON_UP;
                    }
                    case 5: {
                        return WidgetType.VSCROLL_BAR_BUTTON_DOWN;
                    }
                }
                return null;
            }
            if (jComponent.getParent() instanceof JComboBox) {
                return WidgetType.COMBO_BOX_ARROW_BUTTON;
            }
            return WidgetType.SPINNER_ARROW_BUTTON;
        }
        return null;
    }

    private static int getTextDirection(SynthContext synthContext) {
        ComponentOrientation componentOrientation;
        GTKConstants.TextDirection textDirection = GTKConstants.TextDirection.NONE;
        JComponent jComponent = synthContext.getComponent();
        if (jComponent != null && (componentOrientation = jComponent.getComponentOrientation()) != null) {
            textDirection = componentOrientation.isLeftToRight() ? GTKConstants.TextDirection.LTR : GTKConstants.TextDirection.RTL;
        }
        return textDirection.ordinal();
    }

    public void paintArrow(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, GTKConstants.ArrowType arrowType, String string, int n2, int n3, int n4, int n5) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_arrow(n6, n, shadowType.ordinal(), string, n2 - this.x0, n3 - this.y0, n4, n5, arrowType.ordinal());
    }

    public void paintBox(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n7 = synthContext.getComponentState();
        int n8 = GTKEngine.getTextDirection(synthContext);
        int n9 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_box(n9, n6, shadowType.ordinal(), string, n2 - this.x0, n3 - this.y0, n4, n5, n7, n8);
    }

    public void paintBoxGap(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, GTKConstants.PositionType positionType, int n6, int n7) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n8 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_box_gap(n8, n, shadowType.ordinal(), string, n2 - this.x0, n3 - this.y0, n4, n5, positionType.ordinal(), n6, n7);
    }

    public void paintCheck(Graphics graphics, SynthContext synthContext, Region region, String string, int n, int n2, int n3, int n4) {
        int n5 = synthContext.getComponentState();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_check(n6, n5, string, n - this.x0, n2 - this.y0, n3, n4);
    }

    public void paintExpander(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ExpanderStyle expanderStyle, String string, int n2, int n3, int n4, int n5) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_expander(n6, n, string, n2 - this.x0, n3 - this.y0, n4, n5, expanderStyle.ordinal());
    }

    public void paintExtension(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, GTKConstants.PositionType positionType, int n6) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n7 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_extension(n7, n, shadowType.ordinal(), string, n2 - this.x0, n3 - this.y0, n4, n5, positionType.ordinal());
    }

    public void paintFlatBox(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, ColorType colorType) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_flat_box(n6, n, shadowType.ordinal(), string, n2 - this.x0, n3 - this.y0, n4, n5, synthContext.getComponent().hasFocus());
    }

    public void paintFocus(Graphics graphics, SynthContext synthContext, Region region, int n, String string, int n2, int n3, int n4, int n5) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_focus(n6, n, string, n2 - this.x0, n3 - this.y0, n4, n5);
    }

    public void paintHandle(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, GTKConstants.Orientation orientation) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_handle(n6, n, shadowType.ordinal(), string, n2 - this.x0, n3 - this.y0, n4, n5, orientation.ordinal());
    }

    public void paintHline(Graphics graphics, SynthContext synthContext, Region region, int n, String string, int n2, int n3, int n4, int n5) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_hline(n6, n, string, n2 - this.x0, n3 - this.y0, n4, n5);
    }

    public void paintOption(Graphics graphics, SynthContext synthContext, Region region, String string, int n, int n2, int n3, int n4) {
        int n5 = synthContext.getComponentState();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_option(n6, n5, string, n - this.x0, n2 - this.y0, n3, n4);
    }

    public void paintShadow(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n7 = synthContext.getComponentState();
        int n8 = GTKEngine.getTextDirection(synthContext);
        int n9 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_shadow(n9, n6, shadowType.ordinal(), string, n2 - this.x0, n3 - this.y0, n4, n5, n7, n8);
    }

    public void paintSlider(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, GTKConstants.Orientation orientation) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_slider(n6, n, shadowType.ordinal(), string, n2 - this.x0, n3 - this.y0, n4, n5, orientation.ordinal());
    }

    public void paintVline(Graphics graphics, SynthContext synthContext, Region region, int n, String string, int n2, int n3, int n4, int n5) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_vline(n6, n, string, n2 - this.x0, n3 - this.y0, n4, n5);
    }

    public void paintBackground(Graphics graphics, SynthContext synthContext, Region region, int n, Color color, int n2, int n3, int n4, int n5) {
        n = GTKLookAndFeel.synthStateToGTKStateType(n).ordinal();
        int n6 = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.native_paint_background(n6, n, n2 - this.x0, n3 - this.y0, n4, n5);
    }

    public boolean paintCachedImage(Graphics graphics, int n, int n2, int n3, int n4, Object ... objectArray) {
        if (n3 <= 0 || n4 <= 0) {
            return true;
        }
        Image image = this.cache.getImage(this.getClass(), null, n3, n4, objectArray);
        if (image != null) {
            graphics.drawImage(image, n, n2, null);
            return true;
        }
        return false;
    }

    public void startPainting(Graphics graphics, int n, int n2, int n3, int n4, Object ... objectArray) {
        this.nativeStartPainting(n3, n4);
        this.x0 = n;
        this.y0 = n2;
        this.w0 = n3;
        this.h0 = n4;
        this.graphics = graphics;
        this.cacheArgs = objectArray;
    }

    public void finishPainting() {
        this.finishPainting(true);
    }

    public void finishPainting(boolean bl) {
        DataBufferInt dataBufferInt = new DataBufferInt(this.w0 * this.h0);
        int n = this.nativeFinishPainting(SunWritableRaster.stealData(dataBufferInt, 0), this.w0, this.h0);
        SunWritableRaster.markDirty(dataBufferInt);
        int[] nArray = BAND_OFFSETS[n - 1];
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, this.w0, this.h0, this.w0, nArray, null);
        ColorModel colorModel = COLOR_MODELS[n - 1];
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        if (bl) {
            this.cache.setImage(this.getClass(), null, this.w0, this.h0, this.cacheArgs, bufferedImage);
        }
        this.graphics.drawImage(bufferedImage, this.x0, this.y0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void themeChanged() {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            this.native_switch_theme();
        }
        this.cache.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSetting(Settings settings) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            return this.native_get_gtk_setting(settings.ordinal());
        }
    }

    void setRangeValue(SynthContext synthContext, Region region, double d, double d2, double d3, double d4) {
        int n = GTKEngine.getWidgetType(synthContext.getComponent(), region).ordinal();
        this.nativeSetRangeValue(n, d, d2, d3, d4);
    }

    static {
        Toolkit.getDefaultToolkit();
        regionToWidgetTypeMap = new HashMap(50);
        regionToWidgetTypeMap.put(Region.ARROW_BUTTON, new WidgetType[]{WidgetType.SPINNER_ARROW_BUTTON, WidgetType.COMBO_BOX_ARROW_BUTTON, WidgetType.HSCROLL_BAR_BUTTON_LEFT, WidgetType.HSCROLL_BAR_BUTTON_RIGHT, WidgetType.VSCROLL_BAR_BUTTON_UP, WidgetType.VSCROLL_BAR_BUTTON_DOWN});
        regionToWidgetTypeMap.put(Region.BUTTON, WidgetType.BUTTON);
        regionToWidgetTypeMap.put(Region.CHECK_BOX, WidgetType.CHECK_BOX);
        regionToWidgetTypeMap.put(Region.CHECK_BOX_MENU_ITEM, WidgetType.CHECK_BOX_MENU_ITEM);
        regionToWidgetTypeMap.put(Region.COLOR_CHOOSER, WidgetType.COLOR_CHOOSER);
        regionToWidgetTypeMap.put(Region.FILE_CHOOSER, WidgetType.OPTION_PANE);
        regionToWidgetTypeMap.put(Region.COMBO_BOX, WidgetType.COMBO_BOX);
        regionToWidgetTypeMap.put(Region.DESKTOP_ICON, WidgetType.DESKTOP_ICON);
        regionToWidgetTypeMap.put(Region.DESKTOP_PANE, WidgetType.DESKTOP_PANE);
        regionToWidgetTypeMap.put(Region.EDITOR_PANE, WidgetType.EDITOR_PANE);
        regionToWidgetTypeMap.put(Region.FORMATTED_TEXT_FIELD, new WidgetType[]{WidgetType.FORMATTED_TEXT_FIELD, WidgetType.SPINNER_TEXT_FIELD});
        regionToWidgetTypeMap.put(GTKRegion.HANDLE_BOX, WidgetType.HANDLE_BOX);
        regionToWidgetTypeMap.put(Region.INTERNAL_FRAME, WidgetType.INTERNAL_FRAME);
        regionToWidgetTypeMap.put(Region.INTERNAL_FRAME_TITLE_PANE, WidgetType.INTERNAL_FRAME_TITLE_PANE);
        regionToWidgetTypeMap.put(Region.LABEL, new WidgetType[]{WidgetType.LABEL, WidgetType.COMBO_BOX_TEXT_FIELD});
        regionToWidgetTypeMap.put(Region.LIST, WidgetType.LIST);
        regionToWidgetTypeMap.put(Region.MENU, WidgetType.MENU);
        regionToWidgetTypeMap.put(Region.MENU_BAR, WidgetType.MENU_BAR);
        regionToWidgetTypeMap.put(Region.MENU_ITEM, WidgetType.MENU_ITEM);
        regionToWidgetTypeMap.put(Region.MENU_ITEM_ACCELERATOR, WidgetType.MENU_ITEM_ACCELERATOR);
        regionToWidgetTypeMap.put(Region.OPTION_PANE, WidgetType.OPTION_PANE);
        regionToWidgetTypeMap.put(Region.PANEL, WidgetType.PANEL);
        regionToWidgetTypeMap.put(Region.PASSWORD_FIELD, WidgetType.PASSWORD_FIELD);
        regionToWidgetTypeMap.put(Region.POPUP_MENU, WidgetType.POPUP_MENU);
        regionToWidgetTypeMap.put(Region.POPUP_MENU_SEPARATOR, WidgetType.POPUP_MENU_SEPARATOR);
        regionToWidgetTypeMap.put(Region.PROGRESS_BAR, new WidgetType[]{WidgetType.HPROGRESS_BAR, WidgetType.VPROGRESS_BAR});
        regionToWidgetTypeMap.put(Region.RADIO_BUTTON, WidgetType.RADIO_BUTTON);
        regionToWidgetTypeMap.put(Region.RADIO_BUTTON_MENU_ITEM, WidgetType.RADIO_BUTTON_MENU_ITEM);
        regionToWidgetTypeMap.put(Region.ROOT_PANE, WidgetType.ROOT_PANE);
        regionToWidgetTypeMap.put(Region.SCROLL_BAR, new WidgetType[]{WidgetType.HSCROLL_BAR, WidgetType.VSCROLL_BAR});
        regionToWidgetTypeMap.put(Region.SCROLL_BAR_THUMB, new WidgetType[]{WidgetType.HSCROLL_BAR_THUMB, WidgetType.VSCROLL_BAR_THUMB});
        regionToWidgetTypeMap.put(Region.SCROLL_BAR_TRACK, new WidgetType[]{WidgetType.HSCROLL_BAR_TRACK, WidgetType.VSCROLL_BAR_TRACK});
        regionToWidgetTypeMap.put(Region.SCROLL_PANE, WidgetType.SCROLL_PANE);
        regionToWidgetTypeMap.put(Region.SEPARATOR, new WidgetType[]{WidgetType.HSEPARATOR, WidgetType.VSEPARATOR});
        regionToWidgetTypeMap.put(Region.SLIDER, new WidgetType[]{WidgetType.HSLIDER, WidgetType.VSLIDER});
        regionToWidgetTypeMap.put(Region.SLIDER_THUMB, new WidgetType[]{WidgetType.HSLIDER_THUMB, WidgetType.VSLIDER_THUMB});
        regionToWidgetTypeMap.put(Region.SLIDER_TRACK, new WidgetType[]{WidgetType.HSLIDER_TRACK, WidgetType.VSLIDER_TRACK});
        regionToWidgetTypeMap.put(Region.SPINNER, WidgetType.SPINNER);
        regionToWidgetTypeMap.put(Region.SPLIT_PANE, WidgetType.SPLIT_PANE);
        regionToWidgetTypeMap.put(Region.SPLIT_PANE_DIVIDER, new WidgetType[]{WidgetType.HSPLIT_PANE_DIVIDER, WidgetType.VSPLIT_PANE_DIVIDER});
        regionToWidgetTypeMap.put(Region.TABBED_PANE, WidgetType.TABBED_PANE);
        regionToWidgetTypeMap.put(Region.TABBED_PANE_CONTENT, WidgetType.TABBED_PANE_CONTENT);
        regionToWidgetTypeMap.put(Region.TABBED_PANE_TAB, WidgetType.TABBED_PANE_TAB);
        regionToWidgetTypeMap.put(Region.TABBED_PANE_TAB_AREA, WidgetType.TABBED_PANE_TAB_AREA);
        regionToWidgetTypeMap.put(Region.TABLE, WidgetType.TABLE);
        regionToWidgetTypeMap.put(Region.TABLE_HEADER, WidgetType.TABLE_HEADER);
        regionToWidgetTypeMap.put(Region.TEXT_AREA, WidgetType.TEXT_AREA);
        regionToWidgetTypeMap.put(Region.TEXT_FIELD, new WidgetType[]{WidgetType.TEXT_FIELD, WidgetType.COMBO_BOX_TEXT_FIELD});
        regionToWidgetTypeMap.put(Region.TEXT_PANE, WidgetType.TEXT_PANE);
        regionToWidgetTypeMap.put(CustomRegion.TITLED_BORDER, WidgetType.TITLED_BORDER);
        regionToWidgetTypeMap.put(Region.TOGGLE_BUTTON, WidgetType.TOGGLE_BUTTON);
        regionToWidgetTypeMap.put(Region.TOOL_BAR, WidgetType.TOOL_BAR);
        regionToWidgetTypeMap.put(Region.TOOL_BAR_CONTENT, WidgetType.TOOL_BAR);
        regionToWidgetTypeMap.put(Region.TOOL_BAR_DRAG_WINDOW, WidgetType.TOOL_BAR_DRAG_WINDOW);
        regionToWidgetTypeMap.put(Region.TOOL_BAR_SEPARATOR, WidgetType.TOOL_BAR_SEPARATOR);
        regionToWidgetTypeMap.put(Region.TOOL_TIP, WidgetType.TOOL_TIP);
        regionToWidgetTypeMap.put(Region.TREE, WidgetType.TREE);
        regionToWidgetTypeMap.put(Region.TREE_CELL, WidgetType.TREE_CELL);
        regionToWidgetTypeMap.put(Region.VIEWPORT, WidgetType.VIEWPORT);
        COLOR_MODELS = new ColorModel[]{new DirectColorModel(24, 0xFF0000, 65280, 255, 0), new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000), ColorModel.getRGBdefault()};
        BAND_OFFSETS = new int[][]{{0xFF0000, 65280, 255}, {0xFF0000, 65280, 255, 0x1000000}, {0xFF0000, 65280, 255, -16777216}};
    }

    static class CustomRegion
    extends Region {
        static Region TITLED_BORDER = new CustomRegion("TitledBorder");

        private CustomRegion(String string) {
            super(string, null, false);
        }
    }

    static enum Settings {
        GTK_FONT_NAME,
        GTK_ICON_SIZES;

    }

    static enum WidgetType {
        BUTTON,
        CHECK_BOX,
        CHECK_BOX_MENU_ITEM,
        COLOR_CHOOSER,
        COMBO_BOX,
        COMBO_BOX_ARROW_BUTTON,
        COMBO_BOX_TEXT_FIELD,
        DESKTOP_ICON,
        DESKTOP_PANE,
        EDITOR_PANE,
        FORMATTED_TEXT_FIELD,
        HANDLE_BOX,
        HPROGRESS_BAR,
        HSCROLL_BAR,
        HSCROLL_BAR_BUTTON_LEFT,
        HSCROLL_BAR_BUTTON_RIGHT,
        HSCROLL_BAR_TRACK,
        HSCROLL_BAR_THUMB,
        HSEPARATOR,
        HSLIDER,
        HSLIDER_TRACK,
        HSLIDER_THUMB,
        HSPLIT_PANE_DIVIDER,
        INTERNAL_FRAME,
        INTERNAL_FRAME_TITLE_PANE,
        IMAGE,
        LABEL,
        LIST,
        MENU,
        MENU_BAR,
        MENU_ITEM,
        MENU_ITEM_ACCELERATOR,
        OPTION_PANE,
        PANEL,
        PASSWORD_FIELD,
        POPUP_MENU,
        POPUP_MENU_SEPARATOR,
        RADIO_BUTTON,
        RADIO_BUTTON_MENU_ITEM,
        ROOT_PANE,
        SCROLL_PANE,
        SPINNER,
        SPINNER_ARROW_BUTTON,
        SPINNER_TEXT_FIELD,
        SPLIT_PANE,
        TABBED_PANE,
        TABBED_PANE_TAB_AREA,
        TABBED_PANE_CONTENT,
        TABBED_PANE_TAB,
        TABLE,
        TABLE_HEADER,
        TEXT_AREA,
        TEXT_FIELD,
        TEXT_PANE,
        TITLED_BORDER,
        TOGGLE_BUTTON,
        TOOL_BAR,
        TOOL_BAR_DRAG_WINDOW,
        TOOL_BAR_SEPARATOR,
        TOOL_TIP,
        TREE,
        TREE_CELL,
        VIEWPORT,
        VPROGRESS_BAR,
        VSCROLL_BAR,
        VSCROLL_BAR_BUTTON_UP,
        VSCROLL_BAR_BUTTON_DOWN,
        VSCROLL_BAR_TRACK,
        VSCROLL_BAR_THUMB,
        VSEPARATOR,
        VSLIDER,
        VSLIDER_TRACK,
        VSLIDER_THUMB,
        VSPLIT_PANE_DIVIDER;

    }
}

