/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component.broker;

import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.camel.component.broker.BrokerEndpoint;
import org.apache.activemq.camel.converter.ActiveMQMessageConverter;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultAsyncProducer;

public class BrokerProducer
extends DefaultAsyncProducer {
    private final ActiveMQMessageConverter activeMQConverter = new ActiveMQMessageConverter();
    private final BrokerEndpoint brokerEndpoint;

    public BrokerProducer(BrokerEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.brokerEndpoint = endpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        try {
            return this.processInOnly(exchange, callback);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected boolean processInOnly(Exchange exchange, AsyncCallback callback) {
        try {
            ActiveMQMessage message = this.getMessage(exchange);
            if (message != null) {
                message.setDestination(this.brokerEndpoint.getDestination());
                ProducerBrokerExchange producerBrokerExchange = (ProducerBrokerExchange)exchange.getProperty("producerBrokerExchange");
                this.brokerEndpoint.inject(producerBrokerExchange, (org.apache.activemq.command.Message)message);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    private ActiveMQMessage getMessage(Exchange exchange) throws Exception {
        JmsMessage jmsMessage;
        ActiveMQMessage result = null;
        Message camelMesssage = null;
        camelMesssage = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        Map headers = camelMesssage.getHeaders();
        if (camelMesssage instanceof JmsMessage) {
            jmsMessage = (JmsMessage)camelMesssage;
            if (!(jmsMessage.getJmsMessage() instanceof ActiveMQMessage)) {
                throw new IllegalStateException("not the original message from the broker " + jmsMessage.getJmsMessage());
            }
        } else {
            throw new IllegalStateException("not the original message from the broker " + camelMesssage);
        }
        result = (ActiveMQMessage)jmsMessage.getJmsMessage();
        this.setJmsHeaders(result, headers);
        return result;
    }

    private void setJmsHeaders(ActiveMQMessage message, Map<String, Object> headers) {
        message.setReadOnlyProperties(false);
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            Object value;
            if (entry.getKey().equalsIgnoreCase("JMSDeliveryMode") && (value = entry.getValue()) instanceof Number) {
                Number number = (Number)value;
                message.setJMSDeliveryMode(number.intValue());
            }
            if (entry.getKey().equalsIgnoreCase("JmsPriority") && (value = ObjectConverter.toInteger((Object)entry.getValue())) != null) {
                message.setJMSPriority(((Integer)value).intValue());
            }
            if (entry.getKey().equalsIgnoreCase("JMSTimestamp") && (value = ObjectConverter.toLong((Object)entry.getValue())) != null) {
                message.setJMSTimestamp(((Long)value).longValue());
            }
            if (entry.getKey().equalsIgnoreCase("JMSExpiration") && (value = ObjectConverter.toLong((Object)entry.getValue())) != null) {
                message.setJMSExpiration(((Long)value).longValue());
            }
            if (entry.getKey().equalsIgnoreCase("JMSRedelivered")) {
                message.setJMSRedelivered(ObjectConverter.toBool((Object)entry.getValue()));
            }
            if (!entry.getKey().equalsIgnoreCase("JMSType") || (value = entry.getValue()) == null) continue;
            message.setJMSType(value.toString());
        }
    }
}

