/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class URISupport {
    public static final String RAW_TOKEN_START = "RAW(";
    public static final String RAW_TOKEN_END = ")";
    private static final Pattern SECRETS = Pattern.compile("([?&][^=]*(?:passphrase|password|secretKey)[^=]*)=([^&]*)", 2);
    private static final Pattern USERINFO_PASSWORD = Pattern.compile("(.*://.*:)(.*)(@)");
    private static final Pattern PATH_USERINFO_PASSWORD = Pattern.compile("(.*:)(.*)(@)");
    private static final String CHARSET = "UTF-8";

    private URISupport() {
    }

    public static String sanitizeUri(String uri) {
        String sanitized = uri;
        if (uri != null) {
            sanitized = SECRETS.matcher(sanitized).replaceAll("$1=xxxxxx");
            sanitized = USERINFO_PASSWORD.matcher(sanitized).replaceFirst("$1xxxxxx$3");
        }
        return sanitized;
    }

    public static String sanitizePath(String path) {
        String sanitized = path;
        if (path != null) {
            sanitized = PATH_USERINFO_PASSWORD.matcher(sanitized).replaceFirst("$1xxxxxx$3");
        }
        return sanitized;
    }

    public static Map<String, Object> parseQuery(String uri) throws URISyntaxException {
        return URISupport.parseQuery(uri, false);
    }

    public static Map<String, Object> parseQuery(String uri, boolean useRaw) throws URISyntaxException {
        if (uri != null && uri.endsWith("&")) {
            throw new URISyntaxException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
        if (ObjectHelper.isEmpty(uri)) {
            return new LinkedHashMap<String, Object>(0);
        }
        try {
            LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>();
            boolean isKey = true;
            boolean isValue = false;
            boolean isRaw = false;
            StringBuilder key = new StringBuilder();
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < uri.length(); ++i) {
                char ch = uri.charAt(i);
                char next = i < uri.length() - 2 ? uri.charAt(i + 1) : (char)'\u0000';
                isRaw = value.toString().startsWith(RAW_TOKEN_START);
                if (isRaw) {
                    boolean end;
                    if (isKey) {
                        key.append(ch);
                    } else if (isValue) {
                        value.append(ch);
                    }
                    boolean bl = end = ch == RAW_TOKEN_END.charAt(0) && (next == '&' || next == '\u0000');
                    if (!end) continue;
                    URISupport.addParameter(key.toString(), value.toString(), rc, useRaw || isRaw);
                    key.setLength(0);
                    value.setLength(0);
                    isKey = true;
                    isValue = false;
                    isRaw = false;
                    ++i;
                    continue;
                }
                if (isKey && ch == '=') {
                    isKey = false;
                    isValue = true;
                    isRaw = false;
                    continue;
                }
                if (ch == '&') {
                    URISupport.addParameter(key.toString(), value.toString(), rc, useRaw || isRaw);
                    key.setLength(0);
                    value.setLength(0);
                    isKey = true;
                    isValue = false;
                    isRaw = false;
                    continue;
                }
                if (isKey) {
                    key.append(ch);
                    continue;
                }
                if (!isValue) continue;
                value.append(ch);
            }
            if (key.length() > 0) {
                URISupport.addParameter(key.toString(), value.toString(), rc, useRaw || isRaw);
            }
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private static void addParameter(String name, String value, Map<String, Object> map, boolean isRaw) throws UnsupportedEncodingException {
        name = URLDecoder.decode(name, CHARSET);
        if (!isRaw) {
            value = URLDecoder.decode(value.replaceAll("%", "%25"), CHARSET);
        }
        if (map.containsKey(name)) {
            List list;
            Object existing = map.get(name);
            if (existing instanceof List) {
                list = CastUtils.cast((List)existing);
            } else {
                String s;
                list = new ArrayList();
                String string = s = existing != null ? existing.toString() : null;
                if (s != null) {
                    list.add(s);
                }
            }
            list.add(value);
            map.put(name, list);
        } else {
            map.put(name, value);
        }
    }

    public static Map<String, Object> parseParameters(URI uri) throws URISyntaxException {
        String query = uri.getQuery();
        if (query == null) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int idx = schemeSpecificPart.indexOf(63);
            if (idx < 0) {
                return new LinkedHashMap<String, Object>(0);
            }
            query = schemeSpecificPart.substring(idx + 1);
        } else {
            query = URISupport.stripPrefix(query, "?");
        }
        return URISupport.parseQuery(query);
    }

    public static void resolveRawParameterValues(Map<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String value;
            if (entry.getValue() == null || !(value = entry.getValue().toString()).startsWith(RAW_TOKEN_START) || !value.endsWith(RAW_TOKEN_END)) continue;
            value = value.substring(4, value.length() - 1);
            entry.setValue(value);
        }
    }

    public static URI createURIWithQuery(URI uri, String query) throws URISyntaxException {
        ObjectHelper.notNull(uri, "uri");
        String s = uri.toString();
        String before = ObjectHelper.before(s, "?");
        if (before != null) {
            s = before;
        }
        if (query != null) {
            s = s + "?" + query;
        }
        if (!s.contains("#") && uri.getFragment() != null) {
            s = s + "#" + uri.getFragment();
        }
        return new URI(s);
    }

    public static String stripPrefix(String value, String prefix) {
        if (value != null && value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static String createQueryString(Map<String, Object> options) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuilder rc = new StringBuilder();
                boolean first = true;
                for (String o : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append("&");
                    }
                    String key = o;
                    Object value = options.get(key);
                    if (value instanceof List) {
                        List list = (List)value;
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            String s = (String)it.next();
                            URISupport.appendQueryStringParameter(key, s, rc);
                            if (!it.hasNext()) continue;
                            rc.append("&");
                        }
                        continue;
                    }
                    String s = value != null ? value.toString() : null;
                    URISupport.appendQueryStringParameter(key, s, rc);
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private static void appendQueryStringParameter(String key, String value, StringBuilder rc) throws UnsupportedEncodingException {
        rc.append(URLEncoder.encode(key, CHARSET));
        if (value != null) {
            rc.append("=");
            if (value.startsWith(RAW_TOKEN_START) && value.endsWith(RAW_TOKEN_END)) {
                rc.append(value);
            } else {
                rc.append(URLEncoder.encode(value, CHARSET));
            }
        }
    }

    public static URI createRemainingURI(URI originalURI, Map<String, Object> params) throws URISyntaxException {
        String s = URISupport.createQueryString(params);
        if (s.length() == 0) {
            s = null;
        }
        return URISupport.createURIWithQuery(originalURI, s);
    }

    public static String normalizeUri(String uri) throws URISyntaxException, UnsupportedEncodingException {
        Map<String, Object> parameters;
        String userInfoPath;
        int idx;
        URI u = new URI(UnsafeUriCharactersEncoder.encode(uri));
        String path = u.getSchemeSpecificPart();
        String scheme = u.getScheme();
        if (scheme == null || path == null) {
            return uri;
        }
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        if ((idx = path.indexOf(63)) != -1) {
            path = path.substring(0, idx);
        }
        if ((userInfoPath = (path = UnsafeUriCharactersEncoder.encode(path))).contains("/")) {
            userInfoPath = userInfoPath.substring(0, userInfoPath.indexOf("/"));
        }
        if (StringHelper.countChar(userInfoPath, '@') > 1) {
            int max = userInfoPath.lastIndexOf(64);
            String before = userInfoPath.substring(0, max);
            String after = path.substring(max);
            before = StringHelper.replaceAll(before, "@", "%40");
            path = before + after;
        }
        if ((parameters = URISupport.parseParameters(u)).isEmpty()) {
            return URISupport.buildUri(scheme, path, null);
        }
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        Collections.sort(keys);
        LinkedHashMap<String, Object> sorted = new LinkedHashMap<String, Object>(parameters.size());
        for (String key : keys) {
            sorted.put(key, parameters.get(key));
        }
        String query = URISupport.createQueryString(sorted);
        return URISupport.buildUri(scheme, path, query);
    }

    private static String buildUri(String scheme, String path, String query) {
        return scheme + "://" + path + (query != null ? "?" + query : "");
    }
}

