/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.transport.mqtt.MQTTTransport;
import org.apache.activemq.transport.mqtt.MQTTWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.eclipse.jetty.websocket.WebSocket;
import org.fusesource.mqtt.codec.DISCONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSocket
extends TransportSupport
implements WebSocket.OnBinaryMessage,
MQTTTransport {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTSocket.class);
    WebSocket.Connection outbound;
    MQTTProtocolConverter protocolConverter = new MQTTProtocolConverter((MQTTTransport)this, null);
    MQTTWireFormat wireFormat = new MQTTWireFormat();
    private final CountDownLatch socketTransportStarted = new CountDownLatch(1);

    public void onMessage(byte[] bytes, int offset, int length) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for StompSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for StompSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        try {
            MQTTFrame frame = (MQTTFrame)this.wireFormat.unmarshal(new ByteSequence(bytes, offset, length));
            this.protocolConverter.onMQTTCommand(frame);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
    }

    public void onOpen(WebSocket.Connection connection) {
        this.outbound = connection;
    }

    public void onClose(int closeCode, String message) {
        try {
            this.protocolConverter.onMQTTCommand(new DISCONNECT().encode());
        }
        catch (Exception e) {
            LOG.warn("Failed to close WebSocket", (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        this.socketTransportStarted.countDown();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    private boolean transportStartedAtLeastOnce() {
        return this.socketTransportStarted.getCount() == 0L;
    }

    public int getReceiveCounter() {
        return 0;
    }

    public String getRemoteAddress() {
        return "MQTTSocket_" + ((Object)((Object)this)).hashCode();
    }

    public void oneway(Object command) throws IOException {
        try {
            this.protocolConverter.onActiveMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
    }

    public void sendToActiveMQ(Command command) {
        this.doConsume(command);
    }

    public void sendToMQTT(MQTTFrame command) throws IOException {
        ByteSequence bytes = this.wireFormat.marshal((Object)command);
        this.outbound.sendMessage(bytes.getData(), 0, bytes.getLength());
    }

    public X509Certificate[] getPeerCertificates() {
        return new X509Certificate[0];
    }

    public MQTTInactivityMonitor getInactivityMonitor() {
        return null;
    }

    public MQTTWireFormat getWireFormat() {
        return this.wireFormat;
    }
}

