/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTNIOTransport;
import org.apache.activemq.transport.mqtt.MQTTTransportFilter;
import org.apache.activemq.transport.nio.NIOTransportFactory;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.tcp.TcpTransportFactory;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class MQTTNIOTransportFactory
extends NIOTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    protected String getDefaultWireFormatType() {
        return "mqtt";
    }

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer((TcpTransportFactory)this, location, serverSocketFactory){

            protected Transport createTransport(Socket socket, WireFormat format) throws IOException {
                return new MQTTNIOTransport(format, socket);
            }
        };
    }

    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new MQTTNIOTransport(wf, socketFactory, location, localLocation);
    }

    public Transport serverConfigure(Transport transport, WireFormat format, HashMap options) throws Exception {
        MutexTransport mutex = (MutexTransport)(transport = super.serverConfigure(transport, format, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        transport = new MQTTTransportFilter((Transport)transport, format, this.brokerContext);
        IntrospectionSupport.setProperties((Object)transport, (Map)options);
        return super.compositeConfigure(transport, format, options);
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    protected Transport createInactivityMonitor(Transport transport, WireFormat format) {
        MQTTInactivityMonitor monitor = new MQTTInactivityMonitor(transport, format);
        MQTTTransportFilter filter = (MQTTTransportFilter)transport.narrow(MQTTTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

