/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

public class Strings {
    public static String trimString(String value, int max) {
        if (value == null) {
            return "";
        }
        if (value.length() <= max) {
            return value;
        }
        return value.substring(0, max - 3) + "...";
    }

    public static boolean isBlank(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static boolean isNotBlank(String text) {
        return text != null && text.trim().length() > 0;
    }

    public static String sanitize(String name) {
        if (Strings.isBlank(name)) {
            return name;
        }
        return name.replaceAll("[^0-9a-zA-Z\\+\\.\\(\\)_\\-]", "");
    }

    public static String sanitizeDirectory(String name) {
        if (Strings.isBlank(name)) {
            return name;
        }
        return Strings.sanitize(name).replace(".", "");
    }
}

