require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_BUS_H_)) {
    eval 'sub _MACHINE_BUS_H_ () {1;}' unless defined(&_MACHINE_BUS_H_);
    eval 'sub BUS_SPACE_MAP_CACHEABLE () {0x1;}' unless defined(&BUS_SPACE_MAP_CACHEABLE);
    eval 'sub BUS_SPACE_MAP_LINEAR () {0x2;}' unless defined(&BUS_SPACE_MAP_LINEAR);
    eval 'sub BUS_SPACE_MAP_PREFETCHABLE () {0x4;}' unless defined(&BUS_SPACE_MAP_PREFETCHABLE);
    eval 'sub bus_space_map {
        my($t, $a, $s, $f, $hp) = @_;
	    eval q((*($t)-> &vbs_map)(($t)-> &vbs_cookie, ($a), ($s), ($f), ($hp)));
    }' unless defined(&bus_space_map);
    eval 'sub bus_space_unmap {
        my($t, $h, $s) = @_;
	    eval q((*($t)-> &vbs_unmap)(($t)-> &vbs_cookie, ($h), ($s)));
    }' unless defined(&bus_space_unmap);
    eval 'sub bus_space_subregion {
        my($t, $h, $o, $s, $nhp) = @_;
	    eval q((*($t)-> &vbs_subregion)(($t)-> &vbs_cookie, ($h), ($o), ($s), ($nhp)));
    }' unless defined(&bus_space_subregion);
    eval 'sub bus_space_alloc {
        my($t, $rs, $re, $s, $a, $b, $f, $ap, $hp) = @_;
	    eval q((*($t)-> &vbs_alloc)(($t)-> &vbs_cookie, ($rs), ($re), ($s), ($a), ($b), ($f), ($ap), ($hp)));
    }' unless defined(&bus_space_alloc);
    eval 'sub bus_space_free {
        my($t, $h, $s) = @_;
	    eval q((*($t)-> &vbs_free)(($t)-> &vbs_cookie, ($h), ($s)));
    }' unless defined(&bus_space_free);
    eval 'sub bus_space_vaddr {
        my($t, $h) = @_;
	    eval q((*($t)-> &vbs_vaddr)(($t)-> &vbs_cookie, ($h)));
    }' unless defined(&bus_space_vaddr);
    eval 'sub bus_space_read_1 {
        my($t, $h, $o) = @_;
	    eval q((*( &volatile  &u_int8_t *)(($h) + ($o))));
    }' unless defined(&bus_space_read_1);
    eval 'sub bus_space_read_2 {
        my($t, $h, $o) = @_;
	    eval q((*( &volatile  &u_int16_t *)(($h) + ($o))));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_read_4 {
        my($t, $h, $o) = @_;
	    eval q((*( &volatile  &u_int32_t *)(($h) + ($o))));
    }' unless defined(&bus_space_read_4);
    if(0) {
	eval 'sub bus_space_read_8 {
	    my($t, $h, $o) = @_;
    	    eval q(!!!  &bus_space_read_8  &unimplemented !!!);
	}' unless defined(&bus_space_read_8);
    }
    eval 'sub bus_space_read_multi_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_read_multi_1(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_read_multi_1);
    eval 'sub bus_space_read_multi_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_read_multi_2(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_read_multi_2);
    eval 'sub bus_space_read_multi_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_read_multi_4(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_read_multi_4);
    if(0) {
	eval 'sub bus_space_read_multi_8 () {!!!  &bus_space_read_multi_8  &unimplemented !!!;}' unless defined(&bus_space_read_multi_8);
    }
    eval 'sub vax_mem_read_multi_1 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int8_t *$a; \'size_t\' $c; {  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *$a = *( &volatile  &u_int8_t *)( &addr); });
    }' unless defined(&vax_mem_read_multi_1);
    eval 'sub vax_mem_read_multi_2 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int16_t *$a; \'size_t\' $c; {  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *$a = *( &volatile  &u_int16_t *)( &addr); });
    }' unless defined(&vax_mem_read_multi_2);
    eval 'sub vax_mem_read_multi_4 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int32_t *$a; \'size_t\' $c; {  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *$a = *( &volatile  &u_int32_t *)( &addr); });
    }' unless defined(&vax_mem_read_multi_4);
    eval 'sub bus_space_read_region_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_read_region_1(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_read_region_1);
    eval 'sub bus_space_read_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_read_region_2(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_read_region_2);
    eval 'sub bus_space_read_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_read_region_4(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_read_region_4);
    if(0) {
	eval 'sub bus_space_read_region_8 () {!!!  &bus_space_read_region_8  &unimplemented !!!;}' unless defined(&bus_space_read_region_8);
    }
    eval 'sub vax_mem_read_region_1 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int8_t *$a; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *$a = *( &volatile  &u_int8_t *)( &addr); });
    }' unless defined(&vax_mem_read_region_1);
    eval 'sub vax_mem_read_region_2 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int16_t *$a; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *$a = *( &volatile  &u_int16_t *)( &addr); });
    }' unless defined(&vax_mem_read_region_2);
    eval 'sub vax_mem_read_region_4 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int32_t *$a; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *$a = *( &volatile  &u_int32_t *)( &addr); });
    }' unless defined(&vax_mem_read_region_4);
    eval 'sub bus_space_write_1 {
        my($t, $h, $o, $v) = @_;
	    eval q((( &void)(*( &volatile  &u_int8_t *)(($h) + ($o)) = ($v))));
    }' unless defined(&bus_space_write_1);
    eval 'sub bus_space_write_2 {
        my($t, $h, $o, $v) = @_;
	    eval q((( &void)(*( &volatile  &u_int16_t *)(($h) + ($o)) = ($v))));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_write_4 {
        my($t, $h, $o, $v) = @_;
	    eval q((( &void)(*( &volatile  &u_int32_t *)(($h) + ($o)) = ($v))));
    }' unless defined(&bus_space_write_4);
    if(0) {
	eval 'sub bus_space_write_8 () {!!!  &bus_space_write_8  &not  &implemented !!!;}' unless defined(&bus_space_write_8);
    }
    eval 'sub bus_space_write_multi_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_write_multi_1(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_write_multi_1);
    eval 'sub bus_space_write_multi_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_write_multi_2(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_write_multi_2);
    eval 'sub bus_space_write_multi_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_write_multi_4(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_write_multi_4);
    if(0) {
	eval 'sub bus_space_write_multi_8 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q(!!!  &bus_space_write_multi_8  &unimplemented !!!);
	}' unless defined(&bus_space_write_multi_8);
    }
    eval 'sub vax_mem_write_multi_1 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &const  &u_int8_t *$a; \'size_t\' $c; {  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *( &volatile  &u_int8_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_multi_1);
    eval 'sub vax_mem_write_multi_2 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &const  &u_int16_t *$a; \'size_t\' $c; {  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *( &volatile  &u_int16_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_multi_2);
    eval 'sub vax_mem_write_multi_4 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &const  &u_int32_t *$a; \'size_t\' $c; {  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *( &volatile  &u_int32_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_multi_4);
    eval 'sub bus_space_write_region_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_write_region_1(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_write_region_1);
    eval 'sub bus_space_write_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_write_region_2(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_write_region_2);
    eval 'sub bus_space_write_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_write_region_4(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_write_region_4);
    if(0) {
	eval 'sub bus_space_write_region_8 () {!!!  &bus_space_write_region_8  &unimplemented !!!;}' unless defined(&bus_space_write_region_8);
    }
    eval 'sub vax_mem_write_region_1 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &const  &u_int8_t *$a; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *( &volatile  &u_int8_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_region_1);
    eval 'sub vax_mem_write_region_2 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &const  &u_int16_t *$a; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *( &volatile  &u_int16_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_region_2);
    eval 'sub vax_mem_write_region_4 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &const  &u_int32_t *$a; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *( &volatile  &u_int32_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_region_4);
    eval 'sub bus_space_set_multi_1 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &vax_mem_set_multi_1(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_multi_1);
    eval 'sub bus_space_set_multi_2 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &vax_mem_set_multi_2(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_multi_2);
    eval 'sub bus_space_set_multi_4 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &vax_mem_set_multi_4(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_multi_4);
    eval 'sub vax_mem_set_multi_1 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int8_t $v; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &while ($c--) *( &volatile  &u_int8_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_multi_1);
    eval 'sub vax_mem_set_multi_2 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int16_t $v; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &while ($c--) *( &volatile  &u_int16_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_multi_2);
    eval 'sub vax_mem_set_multi_4 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int32_t $v; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &while ($c--) *( &volatile  &u_int32_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_multi_4);
    if(0) {
	eval 'sub bus_space_set_multi_8 () {!!!  &bus_space_set_multi_8  &unimplemented !!!;}' unless defined(&bus_space_set_multi_8);
    }
    eval 'sub bus_space_set_region_1 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &vax_mem_set_region_1(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_region_1);
    eval 'sub bus_space_set_region_2 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &vax_mem_set_region_2(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_region_2);
    eval 'sub bus_space_set_region_4 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &vax_mem_set_region_4(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_region_4);
    eval 'sub vax_mem_set_region_1 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int8_t $v; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++) *( &volatile  &u_int8_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_region_1);
    eval 'sub vax_mem_set_region_2 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int16_t $v; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr += 2) *( &volatile  &u_int16_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_region_2);
    eval 'sub vax_mem_set_region_4 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q(;  &bus_space_handle_t $h;  &bus_size_t $o;  &u_int32_t $v; \'size_t\' $c; {  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr += 4) *( &volatile  &u_int32_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_region_4);
    if(0) {
	eval 'sub bus_space_set_region_8 () {!!!  &bus_space_set_region_8  &unimplemented !!!;}' unless defined(&bus_space_set_region_8);
    }
    eval 'sub bus_space_copy_1 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &vax_mem_copy_1(($t), ($h1), ($o1), ($h2), ($o2), ($c)));
    }' unless defined(&bus_space_copy_1);
    eval 'sub bus_space_copy_2 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &vax_mem_copy_2(($t), ($h1), ($o1), ($h2), ($o2), ($c)));
    }' unless defined(&bus_space_copy_2);
    eval 'sub bus_space_copy_4 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &vax_mem_copy_4(($t), ($h1), ($o1), ($h2), ($o2), ($c)));
    }' unless defined(&bus_space_copy_4);
    eval 'sub vax_mem_copy_1 {
        my($t,$h1,$o1,$h2,$o2,$c) = @_;
	    eval q(;  &bus_space_handle_t $h1;  &bus_size_t $o1;  &bus_space_handle_t $h2;  &bus_size_t $o2; \'size_t\' $c; {  &bus_addr_t  &addr1 = $h1 + $o1;  &bus_addr_t  &addr2 = $h2 + $o2;  &if ( &addr1 >=  &addr2) {  &for (; $c != 0; $c--,  &addr1++,  &addr2++) *( &volatile  &u_int8_t *)( &addr2) = *( &volatile  &u_int8_t *)( &addr1); }  &else {  &for ( &addr1 += ($c - 1),  &addr2 += ($c - 1); $c != 0; $c--,  &addr1--,  &addr2--) *( &volatile  &u_int8_t *)( &addr2) = *( &volatile  &u_int8_t *)( &addr1); } });
    }' unless defined(&vax_mem_copy_1);
    eval 'sub vax_mem_copy_2 {
        my($t,$h1,$o1,$h2,$o2,$c) = @_;
	    eval q(;  &bus_space_handle_t $h1;  &bus_size_t $o1;  &bus_space_handle_t $h2;  &bus_size_t $o2; \'size_t\' $c; {  &bus_addr_t  &addr1 = $h1 + $o1;  &bus_addr_t  &addr2 = $h2 + $o2;  &if ( &addr1 >=  &addr2) {  &for (; $c != 0; $c--,  &addr1 += 2,  &addr2 += 2) *( &volatile  &u_int16_t *)( &addr2) = *( &volatile  &u_int16_t *)( &addr1); }  &else {  &for ( &addr1 += 2* ($c - 1),  &addr2 += 2* ($c - 1); $c != 0; $c--,  &addr1 -= 2,  &addr2 -= 2) *( &volatile  &u_int16_t *)( &addr2) = *( &volatile  &u_int16_t *)( &addr1); } });
    }' unless defined(&vax_mem_copy_2);
    eval 'sub vax_mem_copy_4 {
        my($t,$h1,$o1,$h2,$o2,$c) = @_;
	    eval q(;  &bus_space_handle_t $h1;  &bus_size_t $o1;  &bus_space_handle_t $h2;  &bus_size_t $o2; \'size_t\' $c; {  &bus_addr_t  &addr1 = $h1 + $o1;  &bus_addr_t  &addr2 = $h2 + $o2;  &if ( &addr1 >=  &addr2) {  &for (; $c != 0; $c--,  &addr1 += 4,  &addr2 += 4) *( &volatile  &u_int32_t *)( &addr2) = *( &volatile  &u_int32_t *)( &addr1); }  &else {  &for ( &addr1 += 4* ($c - 1),  &addr2 += 4* ($c - 1); $c != 0; $c--,  &addr1 -= 4,  &addr2 -= 4) *( &volatile  &u_int32_t *)( &addr2) = *( &volatile  &u_int32_t *)( &addr1); } });
    }' unless defined(&vax_mem_copy_4);
    if(0) {
	eval 'sub bus_space_copy_8 () {!!!  &bus_space_copy_8  &unimplemented !!!;}' unless defined(&bus_space_copy_8);
    }
    eval 'sub bus_space_barrier {
        my($t, $h, $o, $l, $f) = @_;
	    eval q((( &void)(( &void)($t), ( &void)($h), ( &void)($o), ( &void)($l), ( &void)($f))));
    }' unless defined(&bus_space_barrier);
    eval 'sub BUS_SPACE_BARRIER_READ () {0x1;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x2;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub BUS_DMA_WAITOK () {0x;}' unless defined(&BUS_DMA_WAITOK);
    eval 'sub BUS_DMA_NOWAIT () {0x1;}' unless defined(&BUS_DMA_NOWAIT);
    eval 'sub BUS_DMA_ALLOCNOW () {0x2;}' unless defined(&BUS_DMA_ALLOCNOW);
    eval 'sub BUS_DMA_COHERENT () {0x4;}' unless defined(&BUS_DMA_COHERENT);
    eval 'sub BUS_DMA_BUS1 () {0x10;}' unless defined(&BUS_DMA_BUS1);
    eval 'sub BUS_DMA_BUS2 () {0x20;}' unless defined(&BUS_DMA_BUS2);
    eval 'sub BUS_DMA_BUS3 () {0x40;}' unless defined(&BUS_DMA_BUS3);
    eval 'sub BUS_DMA_BUS4 () {0x80;}' unless defined(&BUS_DMA_BUS4);
    eval 'sub BUS_DMA_STREAMING () {0x100;}' unless defined(&BUS_DMA_STREAMING);
    eval 'sub BUS_DMA_READ () {0x200;}' unless defined(&BUS_DMA_READ);
    eval 'sub BUS_DMA_WRITE () {0x400;}' unless defined(&BUS_DMA_WRITE);
    eval 'sub BUS_DMA_ZERO () {0x800;}' unless defined(&BUS_DMA_ZERO);
    eval 'sub VAX_BUS_DMA_SPILLPAGE () { &BUS_DMA_BUS1;}' unless defined(&VAX_BUS_DMA_SPILLPAGE);
    eval 'sub DMAMAP_HAS_SGMAP () {0x80000000;}' unless defined(&DMAMAP_HAS_SGMAP);
    eval 'sub BUS_DMASYNC_PREREAD () {0x1;}' unless defined(&BUS_DMASYNC_PREREAD);
    eval 'sub BUS_DMASYNC_POSTREAD () {0x2;}' unless defined(&BUS_DMASYNC_POSTREAD);
    eval 'sub BUS_DMASYNC_PREWRITE () {0x4;}' unless defined(&BUS_DMASYNC_PREWRITE);
    eval 'sub BUS_DMASYNC_POSTWRITE () {0x8;}' unless defined(&BUS_DMASYNC_POSTWRITE);
    eval 'sub bus_dmamap_create {
        my($t, $s, $n, $m, $b, $f, $p) = @_;
	    eval q((*($t)-> &_dmamap_create)(($t), ($s), ($n), ($m), ($b), ($f), ($p)));
    }' unless defined(&bus_dmamap_create);
    eval 'sub bus_dmamap_destroy {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_destroy)(($t), ($p)));
    }' unless defined(&bus_dmamap_destroy);
    eval 'sub bus_dmamap_load {
        my($t, $m, $b, $s, $p, $f) = @_;
	    eval q((*($t)-> &_dmamap_load)(($t), ($m), ($b), ($s), ($p), ($f)));
    }' unless defined(&bus_dmamap_load);
    eval 'sub bus_dmamap_load_mbuf {
        my($t, $m, $b, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_mbuf)(($t), ($m), ($b), ($f)));
    }' unless defined(&bus_dmamap_load_mbuf);
    eval 'sub bus_dmamap_load_uio {
        my($t, $m, $u, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_uio)(($t), ($m), ($u), ($f)));
    }' unless defined(&bus_dmamap_load_uio);
    eval 'sub bus_dmamap_load_raw {
        my($t, $m, $sg, $n, $s, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_raw)(($t), ($m), ($sg), ($n), ($s), ($f)));
    }' unless defined(&bus_dmamap_load_raw);
    eval 'sub bus_dmamap_unload {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_unload)(($t), ($p)));
    }' unless defined(&bus_dmamap_unload);
    eval 'sub bus_dmamap_sync {
        my($t, $p, $o, $l, $ops) = @_;
	    eval q((*($t)-> &_dmamap_sync)(($t), ($p), ($o), ($l), ($ops)));
    }' unless defined(&bus_dmamap_sync);
    eval 'sub bus_dmamem_alloc {
        my($t, $s, $a, $b, $sg, $n, $r, $f) = @_;
	    eval q((*($t)-> &_dmamem_alloc)(($t), ($s), ($a), ($b), ($sg), ($n), ($r), ($f)));
    }' unless defined(&bus_dmamem_alloc);
    eval 'sub bus_dmamem_free {
        my($t, $sg, $n) = @_;
	    eval q((*($t)-> &_dmamem_free)(($t), ($sg), ($n)));
    }' unless defined(&bus_dmamem_free);
    eval 'sub bus_dmamem_map {
        my($t, $sg, $n, $s, $k, $f) = @_;
	    eval q((*($t)-> &_dmamem_map)(($t), ($sg), ($n), ($s), ($k), ($f)));
    }' unless defined(&bus_dmamem_map);
    eval 'sub bus_dmamem_unmap {
        my($t, $k, $s) = @_;
	    eval q((*($t)-> &_dmamem_unmap)(($t), ($k), ($s)));
    }' unless defined(&bus_dmamem_unmap);
    eval 'sub bus_dmamem_mmap {
        my($t, $sg, $n, $o, $p, $f) = @_;
	    eval q((*($t)-> &_dmamem_mmap)(($t), ($sg), ($n), ($o), ($p), ($f)));
    }' unless defined(&bus_dmamem_mmap);
    if(defined(&_VAX_BUS_DMA_PRIVATE)) {
    }
}
1;
