require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&NGE_CSR)) {
    sub NGE_CSR () {	0x;}
}
unless(defined(&NGE_CFG)) {
    sub NGE_CFG () {	0x4;}
}
unless(defined(&NGE_MEAR)) {
    sub NGE_MEAR () {	0x8;}
}
unless(defined(&NGE_PCITST)) {
    sub NGE_PCITST () {	0xc;}
}
unless(defined(&NGE_ISR)) {
    sub NGE_ISR () {	0x10;}
}
unless(defined(&NGE_IMR)) {
    sub NGE_IMR () {	0x14;}
}
unless(defined(&NGE_IER)) {
    sub NGE_IER () {	0x18;}
}
unless(defined(&NGE_IHR)) {
    sub NGE_IHR () {	0x1c;}
}
unless(defined(&NGE_TX_LISTPTR_LO)) {
    sub NGE_TX_LISTPTR_LO () {	0x20;}
}
unless(defined(&NGE_TX_LISTPTR_HI)) {
    sub NGE_TX_LISTPTR_HI () {	0x24;}
}
unless(defined(&NGE_TX_LISTPTR)) {
    sub NGE_TX_LISTPTR () {	 &NGE_TX_LISTPTR_LO;}
}
unless(defined(&NGE_TX_CFG)) {
    sub NGE_TX_CFG () {	0x28;}
}
unless(defined(&NGE_GPIO)) {
    sub NGE_GPIO () {	0x2c;}
}
unless(defined(&NGE_RX_LISTPTR_LO)) {
    sub NGE_RX_LISTPTR_LO () {	0x30;}
}
unless(defined(&NGE_RX_LISTPTR_HI)) {
    sub NGE_RX_LISTPTR_HI () {	0x34;}
}
unless(defined(&NGE_RX_LISTPTR)) {
    sub NGE_RX_LISTPTR () {	 &NGE_RX_LISTPTR_LO;}
}
unless(defined(&NGE_RX_CFG)) {
    sub NGE_RX_CFG () {	0x38;}
}
unless(defined(&NGE_PRIOQCTL)) {
    sub NGE_PRIOQCTL () {	0x3c;}
}
unless(defined(&NGE_WOLCSR)) {
    sub NGE_WOLCSR () {	0x40;}
}
unless(defined(&NGE_PAUSECSR)) {
    sub NGE_PAUSECSR () {	0x44;}
}
unless(defined(&NGE_RXFILT_CTL)) {
    sub NGE_RXFILT_CTL () {	0x48;}
}
unless(defined(&NGE_RXFILT_DATA)) {
    sub NGE_RXFILT_DATA () {	0x4c;}
}
unless(defined(&NGE_BOOTROM_ADDR)) {
    sub NGE_BOOTROM_ADDR () {	0x50;}
}
unless(defined(&NGE_BOOTROM_DATA)) {
    sub NGE_BOOTROM_DATA () {	0x54;}
}
unless(defined(&NGE_SILICONREV)) {
    sub NGE_SILICONREV () {	0x58;}
}
unless(defined(&NGE_MIBCTL)) {
    sub NGE_MIBCTL () {	0x5c;}
}
unless(defined(&NGE_MIB_RXERRPKT)) {
    sub NGE_MIB_RXERRPKT () {	0x60;}
}
unless(defined(&NGE_MIB_RXERRFCS)) {
    sub NGE_MIB_RXERRFCS () {	0x64;}
}
unless(defined(&NGE_MIB_RXERRMISSEDPKT)) {
    sub NGE_MIB_RXERRMISSEDPKT () {	0x68;}
}
unless(defined(&NGE_MIB_RXERRALIGN)) {
    sub NGE_MIB_RXERRALIGN () {	0x6c;}
}
unless(defined(&NGE_MIB_RXERRSYM)) {
    sub NGE_MIB_RXERRSYM () {	0x70;}
}
unless(defined(&NGE_MIB_RXERRGIANT)) {
    sub NGE_MIB_RXERRGIANT () {	0x74;}
}
unless(defined(&NGE_MIB_RXERRRANGLEN)) {
    sub NGE_MIB_RXERRRANGLEN () {	0x78;}
}
unless(defined(&NGE_MIB_RXBADOPCODE)) {
    sub NGE_MIB_RXBADOPCODE () {	0x7c;}
}
unless(defined(&NGE_MIB_RXPAUSEPKTS)) {
    sub NGE_MIB_RXPAUSEPKTS () {	0x80;}
}
unless(defined(&NGE_MIB_TXPAUSEPKTS)) {
    sub NGE_MIB_TXPAUSEPKTS () {	0x84;}
}
unless(defined(&NGE_MIB_TXERRSQE)) {
    sub NGE_MIB_TXERRSQE () {	0x88;}
}
unless(defined(&NGE_TXPRIOQ_PTR1)) {
    sub NGE_TXPRIOQ_PTR1 () {	0xa0;}
}
unless(defined(&NGE_TXPRIOQ_PTR2)) {
    sub NGE_TXPRIOQ_PTR2 () {	0xa4;}
}
unless(defined(&NGE_TXPRIOQ_PTR3)) {
    sub NGE_TXPRIOQ_PTR3 () {	0xa8;}
}
unless(defined(&NGE_RXPRIOQ_PTR1)) {
    sub NGE_RXPRIOQ_PTR1 () {	0xb0;}
}
unless(defined(&NGE_RXPRIOQ_PTR2)) {
    sub NGE_RXPRIOQ_PTR2 () {	0xb4;}
}
unless(defined(&NGE_RXPRIOQ_PTR3)) {
    sub NGE_RXPRIOQ_PTR3 () {	0xb8;}
}
unless(defined(&NGE_VLAN_IP_RXCTL)) {
    sub NGE_VLAN_IP_RXCTL () {	0xbc;}
}
unless(defined(&NGE_VLAN_IP_TXCTL)) {
    sub NGE_VLAN_IP_TXCTL () {	0xc0;}
}
unless(defined(&NGE_VLAN_DATA)) {
    sub NGE_VLAN_DATA () {	0xc4;}
}
unless(defined(&NGE_CLKRUN)) {
    sub NGE_CLKRUN () {	0xcc;}
}
unless(defined(&NGE_TBI_BMCR)) {
    sub NGE_TBI_BMCR () {	0xe0;}
}
unless(defined(&NGE_TBI_BMSR)) {
    sub NGE_TBI_BMSR () {	0xe4;}
}
unless(defined(&NGE_TBI_ANAR)) {
    sub NGE_TBI_ANAR () {	0xe8;}
}
unless(defined(&NGE_TBI_ANLPAR)) {
    sub NGE_TBI_ANLPAR () {	0xec;}
}
unless(defined(&NGE_TBI_ANER)) {
    sub NGE_TBI_ANER () {	0xf0;}
}
unless(defined(&NGE_TBI_ESR)) {
    sub NGE_TBI_ESR () {	0xf4;}
}
unless(defined(&NGE_CSR_TX_ENABLE)) {
    sub NGE_CSR_TX_ENABLE () {	0x1;}
}
unless(defined(&NGE_CSR_TX_DISABLE)) {
    sub NGE_CSR_TX_DISABLE () {	0x2;}
}
unless(defined(&NGE_CSR_RX_ENABLE)) {
    sub NGE_CSR_RX_ENABLE () {	0x4;}
}
unless(defined(&NGE_CSR_RX_DISABLE)) {
    sub NGE_CSR_RX_DISABLE () {	0x8;}
}
unless(defined(&NGE_CSR_TX_RESET)) {
    sub NGE_CSR_TX_RESET () {	0x10;}
}
unless(defined(&NGE_CSR_RX_RESET)) {
    sub NGE_CSR_RX_RESET () {	0x20;}
}
unless(defined(&NGE_CSR_SOFTINTR)) {
    sub NGE_CSR_SOFTINTR () {	0x80;}
}
unless(defined(&NGE_CSR_RESET)) {
    sub NGE_CSR_RESET () {	0x100;}
}
unless(defined(&NGE_CSR_TX_PRIOQ_ENB0)) {
    sub NGE_CSR_TX_PRIOQ_ENB0 () {	0x200;}
}
unless(defined(&NGE_CSR_TX_PRIOQ_ENB1)) {
    sub NGE_CSR_TX_PRIOQ_ENB1 () {	0x400;}
}
unless(defined(&NGE_CSR_TX_PRIOQ_ENB2)) {
    sub NGE_CSR_TX_PRIOQ_ENB2 () {	0x800;}
}
unless(defined(&NGE_CSR_TX_PRIOQ_ENB3)) {
    sub NGE_CSR_TX_PRIOQ_ENB3 () {	0x1000;}
}
unless(defined(&NGE_CSR_RX_PRIOQ_ENB0)) {
    sub NGE_CSR_RX_PRIOQ_ENB0 () {	0x2000;}
}
unless(defined(&NGE_CSR_RX_PRIOQ_ENB1)) {
    sub NGE_CSR_RX_PRIOQ_ENB1 () {	0x4000;}
}
unless(defined(&NGE_CSR_RX_PRIOQ_ENB2)) {
    sub NGE_CSR_RX_PRIOQ_ENB2 () {	0x8000;}
}
unless(defined(&NGE_CSR_RX_PRIOQ_ENB3)) {
    sub NGE_CSR_RX_PRIOQ_ENB3 () {	0x10000;}
}
unless(defined(&NGE_CFG_BIGENDIAN)) {
    sub NGE_CFG_BIGENDIAN () {	0x1;}
}
unless(defined(&NGE_CFG_EXT_125MHZ)) {
    sub NGE_CFG_EXT_125MHZ () {	0x2;}
}
unless(defined(&NGE_CFG_BOOTROM_DIS)) {
    sub NGE_CFG_BOOTROM_DIS () {	0x4;}
}
unless(defined(&NGE_CFG_PERR_DETECT)) {
    sub NGE_CFG_PERR_DETECT () {	0x8;}
}
unless(defined(&NGE_CFG_DEFER_DISABLE)) {
    sub NGE_CFG_DEFER_DISABLE () {	0x10;}
}
unless(defined(&NGE_CFG_OUTOFWIN_TIMER)) {
    sub NGE_CFG_OUTOFWIN_TIMER () {	0x20;}
}
unless(defined(&NGE_CFG_SINGLE_BACKOFF)) {
    sub NGE_CFG_SINGLE_BACKOFF () {	0x40;}
}
unless(defined(&NGE_CFG_PCIREQ_ALG)) {
    sub NGE_CFG_PCIREQ_ALG () {	0x80;}
}
unless(defined(&NGE_CFG_EXTSTS_ENB)) {
    sub NGE_CFG_EXTSTS_ENB () {	0x100;}
}
unless(defined(&NGE_CFG_PHY_DIS)) {
    sub NGE_CFG_PHY_DIS () {	0x200;}
}
unless(defined(&NGE_CFG_PHY_RST)) {
    sub NGE_CFG_PHY_RST () {	0x400;}
}
unless(defined(&NGE_CFG_64BIT_ADDR_ENB)) {
    sub NGE_CFG_64BIT_ADDR_ENB () {	0x800;}
}
unless(defined(&NGE_CFG_64BIT_DATA_ENB)) {
    sub NGE_CFG_64BIT_DATA_ENB () {	0x1000;}
}
unless(defined(&NGE_CFG_64BIT_PCI_DET)) {
    sub NGE_CFG_64BIT_PCI_DET () {	0x2000;}
}
unless(defined(&NGE_CFG_64BIT_TARG)) {
    sub NGE_CFG_64BIT_TARG () {	0x4000;}
}
unless(defined(&NGE_CFG_MWI_DIS)) {
    sub NGE_CFG_MWI_DIS () {	0x8000;}
}
unless(defined(&NGE_CFG_MRM_DIS)) {
    sub NGE_CFG_MRM_DIS () {	0x10000;}
}
unless(defined(&NGE_CFG_TMRTST)) {
    sub NGE_CFG_TMRTST () {	0x20000;}
}
unless(defined(&NGE_CFG_PHYINTR_SPD)) {
    sub NGE_CFG_PHYINTR_SPD () {	0x40000;}
}
unless(defined(&NGE_CFG_PHYINTR_LNK)) {
    sub NGE_CFG_PHYINTR_LNK () {	0x80000;}
}
unless(defined(&NGE_CFG_PHYINTR_DUP)) {
    sub NGE_CFG_PHYINTR_DUP () {	0x100000;}
}
unless(defined(&NGE_CFG_MODE_1000)) {
    sub NGE_CFG_MODE_1000 () {	0x400000;}
}
unless(defined(&NGE_CFG_TBI_EN)) {
    sub NGE_CFG_TBI_EN () {	0x1000000;}
}
unless(defined(&NGE_CFG_DUPLEX_STS)) {
    sub NGE_CFG_DUPLEX_STS () {	0x10000000;}
}
unless(defined(&NGE_CFG_SPEED_STS)) {
    sub NGE_CFG_SPEED_STS () {	0x60000000;}
}
unless(defined(&NGE_CFG_LINK_STS)) {
    sub NGE_CFG_LINK_STS () {	0x80000000;}
}
unless(defined(&NGE_MEAR_EE_DIN)) {
    sub NGE_MEAR_EE_DIN () {	0x1;}
}
unless(defined(&NGE_MEAR_EE_DOUT)) {
    sub NGE_MEAR_EE_DOUT () {	0x2;}
}
unless(defined(&NGE_MEAR_EE_CLK)) {
    sub NGE_MEAR_EE_CLK () {	0x4;}
}
unless(defined(&NGE_MEAR_EE_CSEL)) {
    sub NGE_MEAR_EE_CSEL () {	0x8;}
}
unless(defined(&NGE_MEAR_MII_DATA)) {
    sub NGE_MEAR_MII_DATA () {	0x10;}
}
unless(defined(&NGE_MEAR_MII_DIR)) {
    sub NGE_MEAR_MII_DIR () {	0x20;}
}
unless(defined(&NGE_MEAR_MII_CLK)) {
    sub NGE_MEAR_MII_CLK () {	0x40;}
}
unless(defined(&NGE_EECMD_WRITE)) {
    sub NGE_EECMD_WRITE () {	0x140;}
}
unless(defined(&NGE_EECMD_READ)) {
    sub NGE_EECMD_READ () {	0x180;}
}
unless(defined(&NGE_EECMD_ERASE)) {
    sub NGE_EECMD_ERASE () {	0x1c0;}
}
unless(defined(&NGE_EE_NODEADDR)) {
    sub NGE_EE_NODEADDR () {	0xa;}
}
unless(defined(&NGE_EE_GPIOR)) {
    sub NGE_EE_GPIOR () {	0x4;}
}
unless(defined(&NGE_PCICTL_SRAMADDR)) {
    sub NGE_PCICTL_SRAMADDR () {	0x1f;}
}
unless(defined(&NGE_PCICTL_RAMTSTENB)) {
    sub NGE_PCICTL_RAMTSTENB () {	0x20;}
}
unless(defined(&NGE_PCICTL_TXTSTENB)) {
    sub NGE_PCICTL_TXTSTENB () {	0x40;}
}
unless(defined(&NGE_PCICTL_RXTSTENB)) {
    sub NGE_PCICTL_RXTSTENB () {	0x80;}
}
unless(defined(&NGE_PCICTL_BMTSTENB)) {
    sub NGE_PCICTL_BMTSTENB () {	0x200;}
}
unless(defined(&NGE_PCICTL_RAMADDR)) {
    sub NGE_PCICTL_RAMADDR () {	0x1f0000;}
}
unless(defined(&NGE_PCICTL_ROMTIME)) {
    sub NGE_PCICTL_ROMTIME () {	0xf000000;}
}
unless(defined(&NGE_PCICTL_DISCTEST)) {
    sub NGE_PCICTL_DISCTEST () {	0x40000000;}
}
unless(defined(&NGE_ISR_RX_OK)) {
    sub NGE_ISR_RX_OK () {	0x1;}
}
unless(defined(&NGE_ISR_RX_DESC_OK)) {
    sub NGE_ISR_RX_DESC_OK () {	0x2;}
}
unless(defined(&NGE_ISR_RX_ERR)) {
    sub NGE_ISR_RX_ERR () {	0x4;}
}
unless(defined(&NGE_ISR_RX_EARLY)) {
    sub NGE_ISR_RX_EARLY () {	0x8;}
}
unless(defined(&NGE_ISR_RX_IDLE)) {
    sub NGE_ISR_RX_IDLE () {	0x10;}
}
unless(defined(&NGE_ISR_RX_OFLOW)) {
    sub NGE_ISR_RX_OFLOW () {	0x20;}
}
unless(defined(&NGE_ISR_TX_OK)) {
    sub NGE_ISR_TX_OK () {	0x40;}
}
unless(defined(&NGE_ISR_TX_DESC_OK)) {
    sub NGE_ISR_TX_DESC_OK () {	0x80;}
}
unless(defined(&NGE_ISR_TX_ERR)) {
    sub NGE_ISR_TX_ERR () {	0x100;}
}
unless(defined(&NGE_ISR_TX_IDLE)) {
    sub NGE_ISR_TX_IDLE () {	0x200;}
}
unless(defined(&NGE_ISR_TX_UFLOW)) {
    sub NGE_ISR_TX_UFLOW () {	0x400;}
}
unless(defined(&NGE_ISR_MIB_SERVICE)) {
    sub NGE_ISR_MIB_SERVICE () {	0x800;}
}
unless(defined(&NGE_ISR_SOFTINTR)) {
    sub NGE_ISR_SOFTINTR () {	0x1000;}
}
unless(defined(&NGE_ISR_PME_EVENT)) {
    sub NGE_ISR_PME_EVENT () {	0x2000;}
}
unless(defined(&NGE_ISR_PHY_INTR)) {
    sub NGE_ISR_PHY_INTR () {	0x4000;}
}
unless(defined(&NGE_ISR_HIBITS)) {
    sub NGE_ISR_HIBITS () {	0x8000;}
}
unless(defined(&NGE_ISR_RX_FIFO_OFLOW)) {
    sub NGE_ISR_RX_FIFO_OFLOW () {	0x10000;}
}
unless(defined(&NGE_ISR_TGT_ABRT)) {
    sub NGE_ISR_TGT_ABRT () {	0x20000;}
}
unless(defined(&NGE_ISR_BM_ABRT)) {
    sub NGE_ISR_BM_ABRT () {	0x40000;}
}
unless(defined(&NGE_ISR_SYSERR)) {
    sub NGE_ISR_SYSERR () {	0x80000;}
}
unless(defined(&NGE_ISR_PARITY_ERR)) {
    sub NGE_ISR_PARITY_ERR () {	0x100000;}
}
unless(defined(&NGE_ISR_RX_RESET_DONE)) {
    sub NGE_ISR_RX_RESET_DONE () {	0x200000;}
}
unless(defined(&NGE_ISR_TX_RESET_DONE)) {
    sub NGE_ISR_TX_RESET_DONE () {	0x400000;}
}
unless(defined(&NGE_ISR_RX_PRIOQ_DESC0)) {
    sub NGE_ISR_RX_PRIOQ_DESC0 () {	0x800000;}
}
unless(defined(&NGE_ISR_RX_PRIOQ_DESC1)) {
    sub NGE_ISR_RX_PRIOQ_DESC1 () {	0x1000000;}
}
unless(defined(&NGE_ISR_RX_PRIOQ_DESC2)) {
    sub NGE_ISR_RX_PRIOQ_DESC2 () {	0x2000000;}
}
unless(defined(&NGE_ISR_RX_PRIOQ_DESC3)) {
    sub NGE_ISR_RX_PRIOQ_DESC3 () {	0x4000000;}
}
unless(defined(&NGE_ISR_TX_PRIOQ_DESC0)) {
    sub NGE_ISR_TX_PRIOQ_DESC0 () {	0x8000000;}
}
unless(defined(&NGE_ISR_TX_PRIOQ_DESC1)) {
    sub NGE_ISR_TX_PRIOQ_DESC1 () {	0x10000000;}
}
unless(defined(&NGE_ISR_TX_PRIOQ_DESC2)) {
    sub NGE_ISR_TX_PRIOQ_DESC2 () {	0x20000000;}
}
unless(defined(&NGE_ISR_TX_PRIOQ_DESC3)) {
    sub NGE_ISR_TX_PRIOQ_DESC3 () {	0x40000000;}
}
unless(defined(&NGE_IMR_RX_OK)) {
    sub NGE_IMR_RX_OK () {	0x1;}
}
unless(defined(&NGE_IMR_RX_DESC_OK)) {
    sub NGE_IMR_RX_DESC_OK () {	0x2;}
}
unless(defined(&NGE_IMR_RX_ERR)) {
    sub NGE_IMR_RX_ERR () {	0x4;}
}
unless(defined(&NGE_IMR_RX_EARLY)) {
    sub NGE_IMR_RX_EARLY () {	0x8;}
}
unless(defined(&NGE_IMR_RX_IDLE)) {
    sub NGE_IMR_RX_IDLE () {	0x10;}
}
unless(defined(&NGE_IMR_RX_OFLOW)) {
    sub NGE_IMR_RX_OFLOW () {	0x20;}
}
unless(defined(&NGE_IMR_TX_OK)) {
    sub NGE_IMR_TX_OK () {	0x40;}
}
unless(defined(&NGE_IMR_TX_DESC_OK)) {
    sub NGE_IMR_TX_DESC_OK () {	0x80;}
}
unless(defined(&NGE_IMR_TX_ERR)) {
    sub NGE_IMR_TX_ERR () {	0x100;}
}
unless(defined(&NGE_IMR_TX_IDLE)) {
    sub NGE_IMR_TX_IDLE () {	0x200;}
}
unless(defined(&NGE_IMR_TX_UFLOW)) {
    sub NGE_IMR_TX_UFLOW () {	0x400;}
}
unless(defined(&NGE_IMR_MIB_SERVICE)) {
    sub NGE_IMR_MIB_SERVICE () {	0x800;}
}
unless(defined(&NGE_IMR_SOFTINTR)) {
    sub NGE_IMR_SOFTINTR () {	0x1000;}
}
unless(defined(&NGE_IMR_PME_EVENT)) {
    sub NGE_IMR_PME_EVENT () {	0x2000;}
}
unless(defined(&NGE_IMR_PHY_INTR)) {
    sub NGE_IMR_PHY_INTR () {	0x4000;}
}
unless(defined(&NGE_IMR_HIBITS)) {
    sub NGE_IMR_HIBITS () {	0x8000;}
}
unless(defined(&NGE_IMR_RX_FIFO_OFLOW)) {
    sub NGE_IMR_RX_FIFO_OFLOW () {	0x10000;}
}
unless(defined(&NGE_IMR_TGT_ABRT)) {
    sub NGE_IMR_TGT_ABRT () {	0x20000;}
}
unless(defined(&NGE_IMR_BM_ABRT)) {
    sub NGE_IMR_BM_ABRT () {	0x40000;}
}
unless(defined(&NGE_IMR_SYSERR)) {
    sub NGE_IMR_SYSERR () {	0x80000;}
}
unless(defined(&NGE_IMR_PARITY_ERR)) {
    sub NGE_IMR_PARITY_ERR () {	0x100000;}
}
unless(defined(&NGE_IMR_RX_RESET_DONE)) {
    sub NGE_IMR_RX_RESET_DONE () {	0x200000;}
}
unless(defined(&NGE_IMR_TX_RESET_DONE)) {
    sub NGE_IMR_TX_RESET_DONE () {	0x400000;}
}
unless(defined(&NGE_IMR_RX_PRIOQ_DESC0)) {
    sub NGE_IMR_RX_PRIOQ_DESC0 () {	0x800000;}
}
unless(defined(&NGE_IMR_RX_PRIOQ_DESC1)) {
    sub NGE_IMR_RX_PRIOQ_DESC1 () {	0x1000000;}
}
unless(defined(&NGE_IMR_RX_PRIOQ_DESC2)) {
    sub NGE_IMR_RX_PRIOQ_DESC2 () {	0x2000000;}
}
unless(defined(&NGE_IMR_RX_PRIOQ_DESC3)) {
    sub NGE_IMR_RX_PRIOQ_DESC3 () {	0x4000000;}
}
unless(defined(&NGE_IMR_TX_PRIOQ_DESC0)) {
    sub NGE_IMR_TX_PRIOQ_DESC0 () {	0x8000000;}
}
unless(defined(&NGE_IMR_TX_PRIOQ_DESC1)) {
    sub NGE_IMR_TX_PRIOQ_DESC1 () {	0x10000000;}
}
unless(defined(&NGE_IMR_TX_PRIOQ_DESC2)) {
    sub NGE_IMR_TX_PRIOQ_DESC2 () {	0x20000000;}
}
unless(defined(&NGE_IMR_TX_PRIOQ_DESC3)) {
    sub NGE_IMR_TX_PRIOQ_DESC3 () {	0x40000000;}
}
unless(defined(&NGE_INTRS)) {
    sub NGE_INTRS () {	( &NGE_IMR_RX_OFLOW| &NGE_IMR_TX_UFLOW| &NGE_IMR_TX_OK|  &NGE_IMR_TX_IDLE| &NGE_IMR_RX_OK| &NGE_IMR_RX_ERR|  &NGE_IMR_SYSERR| &NGE_IMR_PHY_INTR|  &NGE_IMR_RX_DESC_OK| &NGE_IMR_TX_DESC_OK|  &NGE_IMR_RX_IDLE| &NGE_IMR_RX_FIFO_OFLOW);}
}
unless(defined(&NGE_IER_INTRENB)) {
    sub NGE_IER_INTRENB () {	0x1;}
}
unless(defined(&NGE_IHR_HOLDOFF)) {
    sub NGE_IHR_HOLDOFF () {	0xff;}
}
unless(defined(&NGE_IHR_HOLDCTL)) {
    sub NGE_IHR_HOLDCTL () {	0x100;}
}
unless(defined(&NGE_TXCFG_DRAIN_THRESH)) {
    sub NGE_TXCFG_DRAIN_THRESH () {	0xff;}
}
unless(defined(&NGE_TXCFG_FILL_THRESH)) {
    sub NGE_TXCFG_FILL_THRESH () {	0xff00;}
}
unless(defined(&NGE_1000MB_BURST_DIS)) {
    sub NGE_1000MB_BURST_DIS () {	0x80000;}
}
unless(defined(&NGE_TXCFG_DMABURST)) {
    sub NGE_TXCFG_DMABURST () {	0x700000;}
}
unless(defined(&NGE_TXCFG_ECRETRY)) {
    sub NGE_TXCFG_ECRETRY () {	0x800000;}
}
unless(defined(&NGE_TXCFG_AUTOPAD)) {
    sub NGE_TXCFG_AUTOPAD () {	0x10000000;}
}
unless(defined(&NGE_TXCFG_LOOPBK)) {
    sub NGE_TXCFG_LOOPBK () {	0x20000000;}
}
unless(defined(&NGE_TXCFG_IGN_HBEAT)) {
    sub NGE_TXCFG_IGN_HBEAT () {	0x40000000;}
}
unless(defined(&NGE_TXCFG_IGN_CARR)) {
    sub NGE_TXCFG_IGN_CARR () {	0x80000000;}
}
unless(defined(&NGE_TXCFG_DRAIN)) {
    sub NGE_TXCFG_DRAIN {
	my($x) = @_;
	eval q(((($x) >> 5) &  &NGE_TXCFG_DRAIN_THRESH));
    }
}
unless(defined(&NGE_TXCFG_FILL)) {
    sub NGE_TXCFG_FILL {
	my($x) = @_;
	eval q((((($x) >> 5) << 8) &  &NGE_TXCFG_FILL_THRESH));
    }
}
unless(defined(&NGE_TXDMA_1024BYTES)) {
    sub NGE_TXDMA_1024BYTES () {	0x;}
}
unless(defined(&NGE_TXDMA_8BYTES)) {
    sub NGE_TXDMA_8BYTES () {	0x100000;}
}
unless(defined(&NGE_TXDMA_16BYTES)) {
    sub NGE_TXDMA_16BYTES () {	0x200000;}
}
unless(defined(&NGE_TXDMA_32BYTES)) {
    sub NGE_TXDMA_32BYTES () {	0x300000;}
}
unless(defined(&NGE_TXDMA_64BYTES)) {
    sub NGE_TXDMA_64BYTES () {	0x400000;}
}
unless(defined(&NGE_TXDMA_128BYTES)) {
    sub NGE_TXDMA_128BYTES () {	0x500000;}
}
unless(defined(&NGE_TXDMA_256BYTES)) {
    sub NGE_TXDMA_256BYTES () {	0x600000;}
}
unless(defined(&NGE_TXDMA_512BYTES)) {
    sub NGE_TXDMA_512BYTES () {	0x700000;}
}
unless(defined(&NGE_TXCFG)) {
    sub NGE_TXCFG () {	( &NGE_TXDMA_512BYTES| &NGE_TXCFG_AUTOPAD|  &NGE_TXCFG_FILL(64)| &NGE_TXCFG_DRAIN(6400));}
}
unless(defined(&NGE_GPIO_GP1_OUT)) {
    sub NGE_GPIO_GP1_OUT () {	0x1;}
}
unless(defined(&NGE_GPIO_GP2_OUT)) {
    sub NGE_GPIO_GP2_OUT () {	0x2;}
}
unless(defined(&NGE_GPIO_GP3_OUT)) {
    sub NGE_GPIO_GP3_OUT () {	0x4;}
}
unless(defined(&NGE_GPIO_GP4_OUT)) {
    sub NGE_GPIO_GP4_OUT () {	0x8;}
}
unless(defined(&NGE_GPIO_GP5_OUT)) {
    sub NGE_GPIO_GP5_OUT () {	0x10;}
}
unless(defined(&NGE_GPIO_GP1_OUTENB)) {
    sub NGE_GPIO_GP1_OUTENB () {	0x20;}
}
unless(defined(&NGE_GPIO_GP2_OUTENB)) {
    sub NGE_GPIO_GP2_OUTENB () {	0x40;}
}
unless(defined(&NGE_GPIO_GP3_OUTENB)) {
    sub NGE_GPIO_GP3_OUTENB () {	0x80;}
}
unless(defined(&NGE_GPIO_GP4_OUTENB)) {
    sub NGE_GPIO_GP4_OUTENB () {	0x100;}
}
unless(defined(&NGE_GPIO_GP5_OUTENB)) {
    sub NGE_GPIO_GP5_OUTENB () {	0x200;}
}
unless(defined(&NGE_GPIO_GP1_IN)) {
    sub NGE_GPIO_GP1_IN () {	0x400;}
}
unless(defined(&NGE_GPIO_GP2_IN)) {
    sub NGE_GPIO_GP2_IN () {	0x800;}
}
unless(defined(&NGE_GPIO_GP3_IN)) {
    sub NGE_GPIO_GP3_IN () {	0x1000;}
}
unless(defined(&NGE_GPIO_GP4_IN)) {
    sub NGE_GPIO_GP4_IN () {	0x2000;}
}
unless(defined(&NGE_GPIO_GP5_IN)) {
    sub NGE_GPIO_GP5_IN () {	0x4000;}
}
unless(defined(&NGE_RXCFG_DRAIN_THRESH)) {
    sub NGE_RXCFG_DRAIN_THRESH () {	0x3e;}
}
unless(defined(&NGE_RXCFG_DMABURST)) {
    sub NGE_RXCFG_DMABURST () {	0x700000;}
}
unless(defined(&NGE_RXCFG_RX_RANGEERR)) {
    sub NGE_RXCFG_RX_RANGEERR () {	0x4000000;}
}
unless(defined(&NGE_RXCFG_RX_GIANTS)) {
    sub NGE_RXCFG_RX_GIANTS () {	0x8000000;}
}
unless(defined(&NGE_RXCFG_RX_FDX)) {
    sub NGE_RXCFG_RX_FDX () {	0x10000000;}
}
unless(defined(&NGE_RXCFG_RX_NOCRC)) {
    sub NGE_RXCFG_RX_NOCRC () {	0x20000000;}
}
unless(defined(&NGE_RXCFG_RX_RUNT)) {
    sub NGE_RXCFG_RX_RUNT () {	0x40000000;}
}
unless(defined(&NGE_RXCFG_RX_BADPKTS)) {
    sub NGE_RXCFG_RX_BADPKTS () {	0x80000000;}
}
unless(defined(&NGE_RXCFG_DRAIN)) {
    sub NGE_RXCFG_DRAIN {
	my($x) = @_;
	eval q((((($x) >> 3) << 1) &  &NGE_RXCFG_DRAIN_THRESH));
    }
}
unless(defined(&NGE_RXDMA_1024BYTES)) {
    sub NGE_RXDMA_1024BYTES () {	0x;}
}
unless(defined(&NGE_RXDMA_8BYTES)) {
    sub NGE_RXDMA_8BYTES () {	0x100000;}
}
unless(defined(&NGE_RXDMA_16BYTES)) {
    sub NGE_RXDMA_16BYTES () {	0x200000;}
}
unless(defined(&NGE_RXDMA_32YTES)) {
    sub NGE_RXDMA_32YTES () {	0x300000;}
}
unless(defined(&NGE_RXDMA_64BYTES)) {
    sub NGE_RXDMA_64BYTES () {	0x400000;}
}
unless(defined(&NGE_RXDMA_128BYTES)) {
    sub NGE_RXDMA_128BYTES () {	0x500000;}
}
unless(defined(&NGE_RXDMA_256BYTES)) {
    sub NGE_RXDMA_256BYTES () {	0x600000;}
}
unless(defined(&NGE_RXDMA_512BYTES)) {
    sub NGE_RXDMA_512BYTES () {	0x700000;}
}
unless(defined(&NGE_RXCFG)) {
    sub NGE_RXCFG () {	( &NGE_RXCFG_DRAIN(64)| &NGE_RXDMA_256BYTES|  &NGE_RXCFG_RX_GIANTS| &NGE_RXCFG_RX_NOCRC);}
}
unless(defined(&NGE_PRIOQCTL_TXPRIO_ENB)) {
    sub NGE_PRIOQCTL_TXPRIO_ENB () {	0x1;}
}
unless(defined(&NGE_PRIOQCTL_TXFAIR_ENB)) {
    sub NGE_PRIOQCTL_TXFAIR_ENB () {	0x2;}
}
unless(defined(&NGE_PRIOQCTL_RXPRIO)) {
    sub NGE_PRIOQCTL_RXPRIO () {	0xc;}
}
unless(defined(&NGE_RXPRIOQ_DISABLED)) {
    sub NGE_RXPRIOQ_DISABLED () {	0x;}
}
unless(defined(&NGE_RXPRIOQ_TWOQS)) {
    sub NGE_RXPRIOQ_TWOQS () {	0x4;}
}
unless(defined(&NGE_RXPRIOQ_THREEQS)) {
    sub NGE_RXPRIOQ_THREEQS () {	0x8;}
}
unless(defined(&NGE_RXPRIOQ_FOURQS)) {
    sub NGE_RXPRIOQ_FOURQS () {	0xc;}
}
unless(defined(&NGE_WOLCSR_WAKE_ON_PHYINTR)) {
    sub NGE_WOLCSR_WAKE_ON_PHYINTR () {	0x1;}
}
unless(defined(&NGE_WOLCSR_WAKE_ON_UNICAST)) {
    sub NGE_WOLCSR_WAKE_ON_UNICAST () {	0x2;}
}
unless(defined(&NGE_WOLCSR_WAKE_ON_MULTICAST)) {
    sub NGE_WOLCSR_WAKE_ON_MULTICAST () {	0x4;}
}
unless(defined(&NGR_WOLCSR_WAKE_ON_BROADCAST)) {
    sub NGR_WOLCSR_WAKE_ON_BROADCAST () {	0x8;}
}
unless(defined(&NGE_WOLCSR_WAKE_ON_ARP)) {
    sub NGE_WOLCSR_WAKE_ON_ARP () {	0x10;}
}
unless(defined(&NGE_WOLCSR_WAKE_ON_PAT0_MATCH)) {
    sub NGE_WOLCSR_WAKE_ON_PAT0_MATCH () {	0x20;}
}
unless(defined(&NGE_WOLCSR_WAKE_ON_PAT1_MATCH)) {
    sub NGE_WOLCSR_WAKE_ON_PAT1_MATCH () {	0x40;}
}
unless(defined(&NGE_WOLCSR_WAKE_ON_PAT2_MATCH)) {
    sub NGE_WOLCSR_WAKE_ON_PAT2_MATCH () {	0x80;}
}
unless(defined(&NGE_WOLCSR_WAKE_ON_PAT3_MATCH)) {
    sub NGE_WOLCSR_WAKE_ON_PAT3_MATCH () {	0x100;}
}
unless(defined(&NGE_WOLCSR_SECUREON_ENB)) {
    sub NGE_WOLCSR_SECUREON_ENB () {	0x200;}
}
unless(defined(&NGE_WOLCSR_SECUREON_HACK)) {
    sub NGE_WOLCSR_SECUREON_HACK () {	0x200000;}
}
unless(defined(&NGE_WOLCSR_PHYINTR)) {
    sub NGE_WOLCSR_PHYINTR () {	0x400000;}
}
unless(defined(&NGE_WOLCSR_UNICAST)) {
    sub NGE_WOLCSR_UNICAST () {	0x800000;}
}
unless(defined(&NGE_WOLCSR_MULTICAST)) {
    sub NGE_WOLCSR_MULTICAST () {	0x1000000;}
}
unless(defined(&NGE_WOLCSR_BROADCAST)) {
    sub NGE_WOLCSR_BROADCAST () {	0x2000000;}
}
unless(defined(&NGE_WOLCSR_ARP_RCVD)) {
    sub NGE_WOLCSR_ARP_RCVD () {	0x4000000;}
}
unless(defined(&NGE_WOLCSR_PAT0_MATCH)) {
    sub NGE_WOLCSR_PAT0_MATCH () {	0x8000000;}
}
unless(defined(&NGE_WOLCSR_PAT1_MATCH)) {
    sub NGE_WOLCSR_PAT1_MATCH () {	0x10000000;}
}
unless(defined(&NGE_WOLCSR_PAT2_MATCH)) {
    sub NGE_WOLCSR_PAT2_MATCH () {	0x20000000;}
}
unless(defined(&NGE_WOLCSR_PAT3_MATCH)) {
    sub NGE_WOLCSR_PAT3_MATCH () {	0x40000000;}
}
unless(defined(&NGE_WOLCSR_MAGICPKT)) {
    sub NGE_WOLCSR_MAGICPKT () {	0x80000000;}
}
unless(defined(&NGE_PAUSECSR_CNT)) {
    sub NGE_PAUSECSR_CNT () {	0xffff;}
}
unless(defined(&NGE_PAUSECSR_PFRAME_SENT)) {
    sub NGE_PAUSECSR_PFRAME_SENT () {	0x20000;}
}
unless(defined(&NGE_PAUSECSR_RX_DATAFIFO_THR_LO)) {
    sub NGE_PAUSECSR_RX_DATAFIFO_THR_LO () {	0xc0000;}
}
unless(defined(&NGE_PAUSECSR_RX_DATAFIFO_THR_HI)) {
    sub NGE_PAUSECSR_RX_DATAFIFO_THR_HI () {	0x300000;}
}
unless(defined(&NGE_PAUSECSR_RX_STATFIFO_THR_LO)) {
    sub NGE_PAUSECSR_RX_STATFIFO_THR_LO () {	0xc00000;}
}
unless(defined(&NGE_PAUSECSR_RX_STATFIFO_THR_HI)) {
    sub NGE_PAUSECSR_RX_STATFIFO_THR_HI () {	0x3000000;}
}
unless(defined(&NGE_PAUSECSR_PFRAME_RCVD)) {
    sub NGE_PAUSECSR_PFRAME_RCVD () {	0x8000000;}
}
unless(defined(&NGE_PAUSECSR_PAUSE_ACTIVE)) {
    sub NGE_PAUSECSR_PAUSE_ACTIVE () {	0x10000000;}
}
unless(defined(&NGE_PAUSECSR_PAUSE_ON_DA)) {
    sub NGE_PAUSECSR_PAUSE_ON_DA () {	0x20000000;}
}
unless(defined(&NGE_PAUSECSR_PAUSE_ON_MCAST)) {
    sub NGE_PAUSECSR_PAUSE_ON_MCAST () {	0x40000000;}
}
unless(defined(&NGE_PAUSECSR_PAUSE_ENB)) {
    sub NGE_PAUSECSR_PAUSE_ENB () {	0x80000000;}
}
unless(defined(&MGE_RXFILTCTL_ADDR)) {
    sub MGE_RXFILTCTL_ADDR () {	0x3ff;}
}
unless(defined(&NGE_RXFILTCTL_ULMASK)) {
    sub NGE_RXFILTCTL_ULMASK () {	0x80000;}
}
unless(defined(&NGE_RXFILTCTL_UCHASH)) {
    sub NGE_RXFILTCTL_UCHASH () {	0x100000;}
}
unless(defined(&NGE_RXFILTCTL_MCHASH)) {
    sub NGE_RXFILTCTL_MCHASH () {	0x200000;}
}
unless(defined(&NGE_RXFILTCTL_ARP)) {
    sub NGE_RXFILTCTL_ARP () {	0x400000;}
}
unless(defined(&NGE_RXFILTCTL_PMATCH0)) {
    sub NGE_RXFILTCTL_PMATCH0 () {	0x800000;}
}
unless(defined(&NGE_RXFILTCTL_PMATCH1)) {
    sub NGE_RXFILTCTL_PMATCH1 () {	0x1000000;}
}
unless(defined(&NGE_RXFILTCTL_PMATCH2)) {
    sub NGE_RXFILTCTL_PMATCH2 () {	0x2000000;}
}
unless(defined(&NGE_RXFILTCTL_PMATCH3)) {
    sub NGE_RXFILTCTL_PMATCH3 () {	0x4000000;}
}
unless(defined(&NGE_RXFILTCTL_PERFECT)) {
    sub NGE_RXFILTCTL_PERFECT () {	0x8000000;}
}
unless(defined(&NGE_RXFILTCTL_ALLPHYS)) {
    sub NGE_RXFILTCTL_ALLPHYS () {	0x10000000;}
}
unless(defined(&NGE_RXFILTCTL_ALLMULTI)) {
    sub NGE_RXFILTCTL_ALLMULTI () {	0x20000000;}
}
unless(defined(&NGE_RXFILTCTL_BROAD)) {
    sub NGE_RXFILTCTL_BROAD () {	0x40000000;}
}
unless(defined(&NGE_RXFILTCTL_ENABLE)) {
    sub NGE_RXFILTCTL_ENABLE () {	0x80000000;}
}
unless(defined(&NGE_FILTADDR_PAR0)) {
    sub NGE_FILTADDR_PAR0 () {	0x;}
}
unless(defined(&NGE_FILTADDR_PAR1)) {
    sub NGE_FILTADDR_PAR1 () {	0x2;}
}
unless(defined(&NGE_FILTADDR_PAR2)) {
    sub NGE_FILTADDR_PAR2 () {	0x4;}
}
unless(defined(&NGE_FILTADDR_PMATCH0)) {
    sub NGE_FILTADDR_PMATCH0 () {	0x6;}
}
unless(defined(&NGE_FILTADDR_PMATCH1)) {
    sub NGE_FILTADDR_PMATCH1 () {	0x8;}
}
unless(defined(&NGE_FILTADDR_SOPASS0)) {
    sub NGE_FILTADDR_SOPASS0 () {	0xa;}
}
unless(defined(&NGE_FILTADDR_SOPASS1)) {
    sub NGE_FILTADDR_SOPASS1 () {	0xc;}
}
unless(defined(&NGE_FILTADDR_SOPASS2)) {
    sub NGE_FILTADDR_SOPASS2 () {	0xe;}
}
unless(defined(&NGE_FILTADDR_FMEM_LO)) {
    sub NGE_FILTADDR_FMEM_LO () {	0x100;}
}
unless(defined(&NGE_FILTADDR_FMEM_HI)) {
    sub NGE_FILTADDR_FMEM_HI () {	0x3fe;}
}
unless(defined(&NGE_FILTADDR_MCAST_LO)) {
    sub NGE_FILTADDR_MCAST_LO () {	0x100;}
}
unless(defined(&NGE_FILTADDR_MCAST_HI)) {
    sub NGE_FILTADDR_MCAST_HI () {	0x1fe;}
}
unless(defined(&NGE_MCAST_FILTER_LEN)) {
    sub NGE_MCAST_FILTER_LEN () {	256;}
}
unless(defined(&NGE_FILTADDR_PBUF0)) {
    sub NGE_FILTADDR_PBUF0 () {	0x200;}
}
unless(defined(&NGE_FILTADDR_PBUF1)) {
    sub NGE_FILTADDR_PBUF1 () {	0x280;}
}
unless(defined(&NGE_FILTADDR_PBUF2)) {
    sub NGE_FILTADDR_PBUF2 () {	0x300;}
}
unless(defined(&NGE_FILTADDR_PBUF3)) {
    sub NGE_FILTADDR_PBUF3 () {	0x380;}
}
unless(defined(&NGE_MIBCTL_WARNTEST)) {
    sub NGE_MIBCTL_WARNTEST () {	0x1;}
}
unless(defined(&NGE_MIBCTL_FREEZE_CNT)) {
    sub NGE_MIBCTL_FREEZE_CNT () {	0x2;}
}
unless(defined(&NGE_MIBCTL_CLEAR_CNT)) {
    sub NGE_MIBCTL_CLEAR_CNT () {	0x4;}
}
unless(defined(&NGE_MIBCTL_STROBE_CNT)) {
    sub NGE_MIBCTL_STROBE_CNT () {	0x8;}
}
unless(defined(&NGE_VIPRXCTL_TAG_DETECT_ENB)) {
    sub NGE_VIPRXCTL_TAG_DETECT_ENB () {	0x1;}
}
unless(defined(&NGE_VIPRXCTL_TAG_STRIP_ENB)) {
    sub NGE_VIPRXCTL_TAG_STRIP_ENB () {	0x2;}
}
unless(defined(&NGE_VIPRXCTL_DROP_TAGGEDPKTS)) {
    sub NGE_VIPRXCTL_DROP_TAGGEDPKTS () {	0x4;}
}
unless(defined(&NGE_VIPRXCTL_DROP_UNTAGGEDPKTS)) {
    sub NGE_VIPRXCTL_DROP_UNTAGGEDPKTS () {	0x8;}
}
unless(defined(&NGE_VIPRXCTL_IPCSUM_ENB)) {
    sub NGE_VIPRXCTL_IPCSUM_ENB () {	0x10;}
}
unless(defined(&NGE_VIPRXCTL_REJECT_BADIPCSUM)) {
    sub NGE_VIPRXCTL_REJECT_BADIPCSUM () {	0x20;}
}
unless(defined(&NGE_VIPRXCTL_REJECT_BADTCPCSUM)) {
    sub NGE_VIPRXCTL_REJECT_BADTCPCSUM () {	0x40;}
}
unless(defined(&NGE_VIPRXCTL_REJECT_BADUDPCSUM)) {
    sub NGE_VIPRXCTL_REJECT_BADUDPCSUM () {	0x80;}
}
unless(defined(&NGE_VIPTXCTL_TAG_ALL)) {
    sub NGE_VIPTXCTL_TAG_ALL () {	0x1;}
}
unless(defined(&NGE_VIPTXCTL_TAG_PER_PKT)) {
    sub NGE_VIPTXCTL_TAG_PER_PKT () {	0x2;}
}
unless(defined(&NGE_VIPTXCTL_CSUM_ALL)) {
    sub NGE_VIPTXCTL_CSUM_ALL () {	0x4;}
}
unless(defined(&NGE_VIPTXCTL_CSUM_PER_PKT)) {
    sub NGE_VIPTXCTL_CSUM_PER_PKT () {	0x8;}
}
unless(defined(&NGE_VLANDATA_VTYPE)) {
    sub NGE_VLANDATA_VTYPE () {	0xffff;}
}
unless(defined(&NGE_VLANDATA_VTCI)) {
    sub NGE_VLANDATA_VTCI () {	0xffff0000;}
}
unless(defined(&NGE_CLKRUN_PMESTS)) {
    sub NGE_CLKRUN_PMESTS () {	0x8000;}
}
unless(defined(&NGE_CLKRUN_PMEENB)) {
    sub NGE_CLKRUN_PMEENB () {	0x100;}
}
unless(defined(&NGE_CLNRUN_CLKRUN_ENB)) {
    sub NGE_CLNRUN_CLKRUN_ENB () {	0x1;}
}
unless(defined(&NGE_TBIBMCR_RESTART_ANEG)) {
    sub NGE_TBIBMCR_RESTART_ANEG () {	0x200;}
}
unless(defined(&NGE_TBIBMCR_ENABLE_ANEG)) {
    sub NGE_TBIBMCR_ENABLE_ANEG () {	0x1000;}
}
unless(defined(&NGE_TBIBMCR_LOOPBACK)) {
    sub NGE_TBIBMCR_LOOPBACK () {	0x4000;}
}
unless(defined(&NGE_TBIBMSR_ANEG_DONE)) {
    sub NGE_TBIBMSR_ANEG_DONE () {	0x4;}
}
unless(defined(&NGE_TBIBMSR_LINKSTAT)) {
    sub NGE_TBIBMSR_LINKSTAT () {	0x20;}
}
unless(defined(&NGE_TBIANAR_HDX)) {
    sub NGE_TBIANAR_HDX () {	0x20;}
}
unless(defined(&NGE_TBIANAR_FDX)) {
    sub NGE_TBIANAR_FDX () {	0x40;}
}
unless(defined(&NGE_TBIANAR_PS1)) {
    sub NGE_TBIANAR_PS1 () {	0x80;}
}
unless(defined(&NGE_TBIANAR_PS2)) {
    sub NGE_TBIANAR_PS2 () {	0x100;}
}
unless(defined(&NGE_TBIANAR_PCAP)) {
    sub NGE_TBIANAR_PCAP () {	0x180;}
}
unless(defined(&NGE_TBIANAR_REMFAULT)) {
    sub NGE_TBIANAR_REMFAULT () {	0x3000;}
}
unless(defined(&NGE_TBIANAR_NEXTPAGE)) {
    sub NGE_TBIANAR_NEXTPAGE () {	0x8000;}
}
unless(defined(&NGE_TBIANLPAR_HDX)) {
    sub NGE_TBIANLPAR_HDX () {	0x20;}
}
unless(defined(&NGE_TBIANLPAR_FDX)) {
    sub NGE_TBIANLPAR_FDX () {	0x40;}
}
unless(defined(&NGE_TBIANLPAR_PS1)) {
    sub NGE_TBIANLPAR_PS1 () {	0x80;}
}
unless(defined(&NGE_TBIANLPAR_PS2)) {
    sub NGE_TBIANLPAR_PS2 () {	0x100;}
}
unless(defined(&NGE_TBIANLPAR_PCAP)) {
    sub NGE_TBIANLPAR_PCAP () {	0x180;}
}
unless(defined(&NGE_TBIANLPAR_REMFAULT)) {
    sub NGE_TBIANLPAR_REMFAULT () {	0x3000;}
}
unless(defined(&NGE_TBIANLPAR_NEXTPAGE)) {
    sub NGE_TBIANLPAR_NEXTPAGE () {	0x8000;}
}
unless(defined(&NGE_TBIANER_PAGERCVD)) {
    sub NGE_TBIANER_PAGERCVD () {	0x2;}
}
unless(defined(&NGE_TBIANER_NEXTPGABLE)) {
    sub NGE_TBIANER_NEXTPGABLE () {	0x4;}
}
unless(defined(&NGE_TBIEXTSTS_HXD)) {
    sub NGE_TBIEXTSTS_HXD () {	0x4000;}
}
unless(defined(&NGE_TBIEXTSTS_FXD)) {
    sub NGE_TBIEXTSTS_FXD () {	0x8000;}
}
unless(defined(&nge_rxstat)) {
    sub nge_rxstat () {	 &nge_cmdsts;}
}
unless(defined(&nge_txstat)) {
    sub nge_txstat () {	 &nge_cmdsts;}
}
unless(defined(&nge_ctl)) {
    sub nge_ctl () {	 &nge_cmdsts;}
}
unless(defined(&nge_rxstat)) {
    sub nge_rxstat () {	 &nge_cmdsts;}
}
unless(defined(&nge_txstat)) {
    sub nge_txstat () {	 &nge_cmdsts;}
}
unless(defined(&nge_ctl)) {
    sub nge_ctl () {	 &nge_cmdsts;}
}
unless(defined(&nge_desc)) {
    sub nge_desc () {	 &nge_desc_32;}
}
unless(defined(&nge_mbuf)) {
    sub nge_mbuf () {	 ($nge_mb_u->{nge_mbuf});}
}
unless(defined(&nge_nextdesc)) {
    sub nge_nextdesc () {	 ($nge_nd_u->{nge_nextdesc});}
}
unless(defined(&NGE_CMDSTS_BUFLEN)) {
    sub NGE_CMDSTS_BUFLEN () {	0xffff;}
}
unless(defined(&NGE_CMDSTS_PKT_OK)) {
    sub NGE_CMDSTS_PKT_OK () {	0x8000000;}
}
unless(defined(&NGE_CMDSTS_CRC)) {
    sub NGE_CMDSTS_CRC () {	0x10000000;}
}
unless(defined(&NGE_CMDSTS_INTR)) {
    sub NGE_CMDSTS_INTR () {	0x20000000;}
}
unless(defined(&NGE_CMDSTS_MORE)) {
    sub NGE_CMDSTS_MORE () {	0x40000000;}
}
unless(defined(&NGE_CMDSTS_OWN)) {
    sub NGE_CMDSTS_OWN () {	0x80000000;}
}
unless(defined(&NGE_LASTDESC)) {
    sub NGE_LASTDESC {
	my($x) = @_;
	eval q((!(($x)-> &nge_ctl &  &NGE_CMDSTS_MORE))));
    }
}
unless(defined(&NGE_OWNDESC)) {
    sub NGE_OWNDESC {
	my($x) = @_;
	eval q((($x)-> &nge_ctl &  &NGE_CMDSTS_OWN));
    }
}
unless(defined(&NGE_INC)) {
    sub NGE_INC {
	my($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
unless(defined(&NGE_RXBYTES)) {
    sub NGE_RXBYTES {
	my($x) = @_;
	eval q((($x)-> &nge_ctl &  &NGE_CMDSTS_BUFLEN));
    }
}
unless(defined(&NGE_RXSTAT_RANGELENERR)) {
    sub NGE_RXSTAT_RANGELENERR () {	0x10000;}
}
unless(defined(&NGE_RXSTAT_LOOPBK)) {
    sub NGE_RXSTAT_LOOPBK () {	0x20000;}
}
unless(defined(&NGE_RXSTAT_ALIGNERR)) {
    sub NGE_RXSTAT_ALIGNERR () {	0x40000;}
}
unless(defined(&NGE_RXSTAT_CRCERR)) {
    sub NGE_RXSTAT_CRCERR () {	0x80000;}
}
unless(defined(&NGE_RXSTAT_SYMBOLERR)) {
    sub NGE_RXSTAT_SYMBOLERR () {	0x100000;}
}
unless(defined(&NGE_RXSTAT_RUNT)) {
    sub NGE_RXSTAT_RUNT () {	0x200000;}
}
unless(defined(&NGE_RXSTAT_GIANT)) {
    sub NGE_RXSTAT_GIANT () {	0x400000;}
}
unless(defined(&NGE_RXSTAT_DSTCLASS)) {
    sub NGE_RXSTAT_DSTCLASS () {	0x1800000;}
}
unless(defined(&NGE_RXSTAT_OVERRUN)) {
    sub NGE_RXSTAT_OVERRUN () {	0x2000000;}
}
unless(defined(&NGE_RXSTAT_RX_ABORT)) {
    sub NGE_RXSTAT_RX_ABORT () {	0x4000000;}
}
unless(defined(&NGE_DSTCLASS_REJECT)) {
    sub NGE_DSTCLASS_REJECT () {	0x;}
}
unless(defined(&NGE_DSTCLASS_UNICAST)) {
    sub NGE_DSTCLASS_UNICAST () {	0x800000;}
}
unless(defined(&NGE_DSTCLASS_MULTICAST)) {
    sub NGE_DSTCLASS_MULTICAST () {	0x1000000;}
}
unless(defined(&NGE_DSTCLASS_BROADCAST)) {
    sub NGE_DSTCLASS_BROADCAST () {	0x2000000;}
}
unless(defined(&NGE_TXSTAT_COLLCNT)) {
    sub NGE_TXSTAT_COLLCNT () {	0xf0000;}
}
unless(defined(&NGE_TXSTAT_EXCESSCOLLS)) {
    sub NGE_TXSTAT_EXCESSCOLLS () {	0x100000;}
}
unless(defined(&NGE_TXSTAT_OUTOFWINCOLL)) {
    sub NGE_TXSTAT_OUTOFWINCOLL () {	0x200000;}
}
unless(defined(&NGE_TXSTAT_EXCESS_DEFER)) {
    sub NGE_TXSTAT_EXCESS_DEFER () {	0x400000;}
}
unless(defined(&NGE_TXSTAT_DEFERED)) {
    sub NGE_TXSTAT_DEFERED () {	0x800000;}
}
unless(defined(&NGE_TXSTAT_CARR_LOST)) {
    sub NGE_TXSTAT_CARR_LOST () {	0x1000000;}
}
unless(defined(&NGE_TXSTAT_UNDERRUN)) {
    sub NGE_TXSTAT_UNDERRUN () {	0x2000000;}
}
unless(defined(&NGE_TXSTAT_TX_ABORT)) {
    sub NGE_TXSTAT_TX_ABORT () {	0x4000000;}
}
unless(defined(&NGE_TXEXTSTS_VLAN_TCI)) {
    sub NGE_TXEXTSTS_VLAN_TCI () {	0xffff;}
}
unless(defined(&NGE_TXEXTSTS_VLANPKT)) {
    sub NGE_TXEXTSTS_VLANPKT () {	0x10000;}
}
unless(defined(&NGE_TXEXTSTS_IPCSUM)) {
    sub NGE_TXEXTSTS_IPCSUM () {	0x20000;}
}
unless(defined(&NGE_TXEXTSTS_TCPCSUM)) {
    sub NGE_TXEXTSTS_TCPCSUM () {	0x80000;}
}
unless(defined(&NGE_TXEXTSTS_UDPCSUM)) {
    sub NGE_TXEXTSTS_UDPCSUM () {	0x200000;}
}
unless(defined(&NGE_RXEXTSTS_VTCI)) {
    sub NGE_RXEXTSTS_VTCI () {	0xffff;}
}
unless(defined(&NGE_RXEXTSTS_VLANPKT)) {
    sub NGE_RXEXTSTS_VLANPKT () {	0x10000;}
}
unless(defined(&NGE_RXEXTSTS_IPPKT)) {
    sub NGE_RXEXTSTS_IPPKT () {	0x20000;}
}
unless(defined(&NGE_RXEXTSTS_IPCSUMERR)) {
    sub NGE_RXEXTSTS_IPCSUMERR () {	0x40000;}
}
unless(defined(&NGE_RXEXTSTS_TCPPKT)) {
    sub NGE_RXEXTSTS_TCPPKT () {	0x80000;}
}
unless(defined(&NGE_RXEXTSTS_TCPCSUMERR)) {
    sub NGE_RXEXTSTS_TCPCSUMERR () {	0x100000;}
}
unless(defined(&NGE_RXEXTSTS_UDPPKT)) {
    sub NGE_RXEXTSTS_UDPPKT () {	0x200000;}
}
unless(defined(&NGE_RXEXTSTS_UDPCSUMERR)) {
    sub NGE_RXEXTSTS_UDPCSUMERR () {	0x400000;}
}
unless(defined(&NGE_RX_LIST_CNT)) {
    sub NGE_RX_LIST_CNT () {	128;}
}
unless(defined(&NGE_TX_LIST_CNT)) {
    sub NGE_TX_LIST_CNT () {	128;}
}
unless(defined(&NGE_VENDORID)) {
    sub NGE_VENDORID () {	0x100b;}
}
unless(defined(&NGE_DEVICEID)) {
    sub NGE_DEVICEID () {	0x22;}
}
unless(defined(&NGE_MII_STARTDELIM)) {
    sub NGE_MII_STARTDELIM () {	0x1;}
}
unless(defined(&NGE_MII_READOP)) {
    sub NGE_MII_READOP () {	0x2;}
}
unless(defined(&NGE_MII_WRITEOP)) {
    sub NGE_MII_WRITEOP () {	0x1;}
}
unless(defined(&NGE_MII_TURNAROUND)) {
    sub NGE_MII_TURNAROUND () {	0x2;}
}
unless(defined(&NGE_JUMBO_FRAMELEN)) {
    sub NGE_JUMBO_FRAMELEN () {	9018;}
}
unless(defined(&NGE_JUMBO_MTU)) {
    sub NGE_JUMBO_MTU () {	( &NGE_JUMBO_FRAMELEN -  &ETHER_HDR_LEN -  &ETHER_CRC_LEN);}
}
unless(defined(&NGE_JSLOTS)) {
    sub NGE_JSLOTS () {	384;}
}
unless(defined(&NGE_JRAWLEN)) {
    sub NGE_JRAWLEN () {	( &NGE_JUMBO_FRAMELEN +  &ETHER_ALIGN + $sizeof{ &u_int64_t});}
}
unless(defined(&NGE_JLEN)) {
    sub NGE_JLEN () {	( &NGE_JRAWLEN + ($sizeof{ &u_int64_t} - ( &NGE_JRAWLEN % $sizeof{ &u_int64_t})));}
}
unless(defined(&NGE_MCLBYTES)) {
    sub NGE_MCLBYTES () {	( &NGE_JLEN - $sizeof{ &u_int64_t});}
}
unless(defined(&NGE_JPAGESZ)) {
    sub NGE_JPAGESZ () {	 &PAGE_SIZE;}
}
unless(defined(&NGE_RESID)) {
    sub NGE_RESID () {	( &NGE_JPAGESZ - ( &NGE_JLEN *  &NGE_JSLOTS) %  &NGE_JPAGESZ);}
}
unless(defined(&NGE_JMEM)) {
    sub NGE_JMEM () {	(( &NGE_JLEN *  &NGE_JSLOTS) +  &NGE_RESID);}
}
unless(defined(&NGE_WIDTH_32BITS)) {
    sub NGE_WIDTH_32BITS () {	0;}
}
unless(defined(&NGE_WIDTH_64BITS)) {
    sub NGE_WIDTH_64BITS () {	1;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{nge_btag}),  ($sc->{nge_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{nge_btag}),  ($sc->{nge_bhandle}), $reg));
    }
}
unless(defined(&NGE_TIMEOUT)) {
    sub NGE_TIMEOUT () {	1000;}
}
unless(defined(&NGE_MIN_FRAMELEN)) {
    sub NGE_MIN_FRAMELEN () {	60;}
}
unless(defined(&NGE_PCI_VENDOR_ID)) {
    sub NGE_PCI_VENDOR_ID () {	0x;}
}
unless(defined(&NGE_PCI_DEVICE_ID)) {
    sub NGE_PCI_DEVICE_ID () {	0x2;}
}
unless(defined(&NGE_PCI_COMMAND)) {
    sub NGE_PCI_COMMAND () {	0x4;}
}
unless(defined(&NGE_PCI_STATUS)) {
    sub NGE_PCI_STATUS () {	0x6;}
}
unless(defined(&NGE_PCI_REVID)) {
    sub NGE_PCI_REVID () {	0x8;}
}
unless(defined(&NGE_PCI_CLASSCODE)) {
    sub NGE_PCI_CLASSCODE () {	0x9;}
}
unless(defined(&NGE_PCI_CACHELEN)) {
    sub NGE_PCI_CACHELEN () {	0xc;}
}
unless(defined(&NGE_PCI_LATENCY_TIMER)) {
    sub NGE_PCI_LATENCY_TIMER () {	0xd;}
}
unless(defined(&NGE_PCI_HEADER_TYPE)) {
    sub NGE_PCI_HEADER_TYPE () {	0xe;}
}
unless(defined(&NGE_PCI_LOIO)) {
    sub NGE_PCI_LOIO () {	0x10;}
}
unless(defined(&NGE_PCI_LOMEM)) {
    sub NGE_PCI_LOMEM () {	0x14;}
}
unless(defined(&NGE_PCI_BIOSROM)) {
    sub NGE_PCI_BIOSROM () {	0x30;}
}
unless(defined(&NGE_PCI_INTLINE)) {
    sub NGE_PCI_INTLINE () {	0x3c;}
}
unless(defined(&NGE_PCI_INTPIN)) {
    sub NGE_PCI_INTPIN () {	0x3d;}
}
unless(defined(&NGE_PCI_MINGNT)) {
    sub NGE_PCI_MINGNT () {	0x3e;}
}
unless(defined(&NGE_PCI_MINLAT)) {
    sub NGE_PCI_MINLAT () {	0xf;}
}
unless(defined(&NGE_PCI_RESETOPT)) {
    sub NGE_PCI_RESETOPT () {	0x48;}
}
unless(defined(&NGE_PCI_EEPROM_DATA)) {
    sub NGE_PCI_EEPROM_DATA () {	0x4c;}
}
unless(defined(&NGE_PCI_CAPID)) {
    sub NGE_PCI_CAPID () {	0x50;}
}
unless(defined(&NGE_PCI_NEXTPTR)) {
    sub NGE_PCI_NEXTPTR () {	0x51;}
}
unless(defined(&NGE_PCI_PWRMGMTCAP)) {
    sub NGE_PCI_PWRMGMTCAP () {	0x52;}
}
unless(defined(&NGE_PCI_PWRMGMTCTRL)) {
    sub NGE_PCI_PWRMGMTCTRL () {	0x54;}
}
unless(defined(&NGE_PME_EN)) {
    sub NGE_PME_EN () {	0x10;}
}
unless(defined(&NGE_PME_STATUS)) {
    sub NGE_PME_STATUS () {	0x8000;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        my($va) = @_;
	    eval q( &alpha_XXX_dmamap(( &vaddr_t)$va));
    }' unless defined(&vtophys);
}
1;
