require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DRM_P_H_)) {
    eval 'sub _DRM_P_H_ () {1;}' unless defined(&_DRM_P_H_);
    if(defined(&_KERNEL) || defined(&__KERNEL__)) {
	require 'sys/param.ph';
	require 'sys/queue.ph';
	require 'sys/malloc.ph';
	require 'sys/pool.ph';
	require 'sys/kernel.ph';
	require 'sys/systm.ph';
	require 'sys/conf.ph';
	require 'sys/stat.ph';
	require 'sys/proc.ph';
	require 'sys/resource.ph';
	require 'sys/resourcevar.ph';
	require 'sys/mutex.ph';
	require 'sys/fcntl.ph';
	require 'sys/filio.ph';
	require 'sys/signalvar.ph';
	require 'sys/poll.ph';
	require 'sys/tree.ph';
	require 'sys/endian.ph';
	require 'sys/mman.ph';
	require 'sys/stdint.ph';
	require 'sys/agpio.ph';
	require 'sys/memrange.ph';
	require 'sys/extent.ph';
	require 'sys/vnode.ph';
	require 'uvm/uvm.ph';
	require 'dev/pci/pcidevs.ph';
	require 'dev/pci/pcivar.ph';
	require 'dev/pci/agpvar.ph';
	require 'dev/pci/vga_pcivar.ph';
	require 'machine/param.ph';
	require 'machine/bus.ph';
	require './dev/pci/drm/drm.ph';
	require './dev/pci/drm/drm_atomic.ph';
	require './dev/pci/drm/agp.ph';
	eval 'sub __OS_HAS_AGP () {( &NAGP > 0);}' unless defined(&__OS_HAS_AGP);
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
	    eval 'sub __BIG_ENDIAN () {1;}' unless defined(&__BIG_ENDIAN);
	} else {
	    eval 'sub __LITTLE_ENDIAN () {1;}' unless defined(&__LITTLE_ENDIAN);
	}
	eval 'sub DRM_KERNEL_CONTEXT () {0;}' unless defined(&DRM_KERNEL_CONTEXT);
	eval 'sub DRM_RESERVED_CONTEXTS () {1;}' unless defined(&DRM_RESERVED_CONTEXTS);
	eval 'sub DRM_MAX_CTXBITMAP () {( &PAGE_SIZE * 8);}' unless defined(&DRM_MAX_CTXBITMAP);
	eval 'sub DRM_IF_VERSION {
	    my($maj, $min) = @_;
    	    eval q(($maj << 16| $min));
	}' unless defined(&DRM_IF_VERSION);
	eval 'sub DRM_CURRENTPID () { ($curproc->{p_pid});}' unless defined(&DRM_CURRENTPID);
	eval 'sub DRM_LOCK () {
	    eval q( &rw_enter_write( ($dev->{dev_lock})));
	}' unless defined(&DRM_LOCK);
	eval 'sub DRM_UNLOCK () {
	    eval q( &rw_exit_write( ($dev->{dev_lock})));
	}' unless defined(&DRM_UNLOCK);
	eval 'sub DRM_READLOCK () {
	    eval q( &rw_enter_read( ($dev->{dev_lock})));
	}' unless defined(&DRM_READLOCK);
	eval 'sub DRM_READUNLOCK () {
	    eval q( &rw_exit_read( ($dev->{dev_lock})));
	}' unless defined(&DRM_READUNLOCK);
	eval 'sub DRM_MAXUNITS () {8;}' unless defined(&DRM_MAXUNITS);
	eval 'sub drm_get_device_from_kdev {
	    my($_kdev) = @_;
    	    eval q(( ($drm_cd->{cd_ndevs}) > 0?  ($drm_cd->{cd_devs[0]}) :  &NULL));
	}' unless defined(&drm_get_device_from_kdev);
	if(0) {
	    eval 'sub drm_get_device_from_kdev {
	        my($_kdev) = @_;
    		eval q(( &minor($_kdev) <  ($drm_cd->{cd_ndevs})) ?  ($drm_cd->{cd_devs[minor($_kdev)]}) :  &NULL);
	    }' unless defined(&drm_get_device_from_kdev);
	}
	eval 'sub DRM_SUSER {
	    my($p) = @_;
    	    eval q(( &suser($p, 0) == 0));
	}' unless defined(&DRM_SUSER);
	eval 'sub DRM_MTRR_WC () { &MDF_WRITECOMBINE;}' unless defined(&DRM_MTRR_WC);
	eval 'sub PAGE_ALIGN {
	    my($addr) = @_;
    	    eval q(((($addr) +  &PAGE_MASK) & ~ &PAGE_MASK));
	}' unless defined(&PAGE_ALIGN);
	if(defined(&__i386__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__alpha__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &alpha_wmb(););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__amd64__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined(&__powerpc__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &DRM_MEMORYBARRIER());
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"sync\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
	eval 'sub DRM_COPY_TO_USER {
	    my($user, $kern, $size) = @_;
    	    eval q( &copyout($kern, $user, $size));
	}' unless defined(&DRM_COPY_TO_USER);
	eval 'sub DRM_COPY_FROM_USER {
	    my($kern, $user, $size) = @_;
    	    eval q( &copyin($user, $kern, $size));
	}' unless defined(&DRM_COPY_FROM_USER);
	eval 'sub le32_to_cpu {
	    my($x) = @_;
    	    eval q( &letoh32($x));
	}' unless defined(&le32_to_cpu);
	eval 'sub cpu_to_le32 {
	    my($x) = @_;
    	    eval q( &htole32($x));
	}' unless defined(&cpu_to_le32);
	eval 'sub DRM_UDELAY {
	    my($udelay) = @_;
    	    eval q( &DELAY($udelay));
	}' unless defined(&DRM_UDELAY);
	eval 'sub LOCK_TEST_WITH_RETURN {
	    my($dev, $file_priv) = @_;
    	    eval q( &do {  &if (! &_DRM_LOCK_IS_HELD( ($dev->{lock}->{hw_lock}->{lock})) ||  ($dev->{lock}->{file_priv}) != $file_priv) {  &DRM_ERROR(\\"%s called without lock held\\\\n\\",  &__FUNCTION__);  &return  &EINVAL; } }  &while (0));
	}' unless defined(&LOCK_TEST_WITH_RETURN);
	eval 'sub DRM_WAIT_ON {
	    my($ret, $queue, $lock,  $timeout, $msg, $condition ) = @_;
    	    eval q( &do {  &mtx_enter($lock);  &while (($ret) == 0) {  &if ($condition)  &break; $ret =  &msleep(($queue), ($lock),  &PZERO |  &PCATCH, ($msg), ($timeout)); }  &mtx_leave($lock); }  &while ( 0));
	}' unless defined(&DRM_WAIT_ON);
	eval 'sub DRM_ERROR () {( &fmt,  &arg...)  &printf("error: ["  &DRM_NAME ":pid%d:%s] *ERROR* "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg);}' unless defined(&DRM_ERROR);
	eval 'sub DRM_INFO () {( &fmt,  &arg...)  &printf("%s: "  &fmt,  ($dev_priv->{dev}->{dv_xname}),   &arg);}' unless defined(&DRM_INFO);
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_DEBUG) if defined(&DRM_DEBUG);
	    eval 'sub DRM_DEBUG () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf("["  &DRM_NAME ":pid%d:%s] "  &fmt,  ($curproc->{p_pid}),  &__func__ ,   &arg); }  &while (0);}' unless defined(&DRM_DEBUG);
	} else {
	    eval 'sub DRM_DEBUG () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_DEBUG);
	}
	eval("sub _DRM_DMA_USE_AGP () { 0x01; }") unless defined(&_DRM_DMA_USE_AGP);
	eval("sub _DRM_DMA_USE_SG () { 0x02; }") unless defined(&_DRM_DMA_USE_SG);
	eval 'sub DRM_ATI_GART_MAIN () {1;}' unless defined(&DRM_ATI_GART_MAIN);
	eval 'sub DRM_ATI_GART_FB () {2;}' unless defined(&DRM_ATI_GART_FB);
	eval 'sub DRM_ATI_GART_PCI () {1;}' unless defined(&DRM_ATI_GART_PCI);
	eval 'sub DRM_ATI_GART_PCIE () {2;}' unless defined(&DRM_ATI_GART_PCIE);
	eval 'sub DRM_ATI_GART_IGP () {3;}' unless defined(&DRM_ATI_GART_IGP);
	eval 'sub DRM_ATI_GART_R600 () {4;}' unless defined(&DRM_ATI_GART_R600);
	eval 'sub DMA_BIT_MASK {
	    my($n) = @_;
    	    eval q(((($n) == 64) ? ~0 : (1<<($n)) -1));
	}' unless defined(&DMA_BIT_MASK);
	eval 'sub upper_32_bits {
	    my($_val) = @_;
    	    eval q((( &u_int32_t)((($_val) >> 16) >> 16)));
	}' unless defined(&upper_32_bits);
	eval 'sub DRM_BUSY () {0x1;}' unless defined(&DRM_BUSY);
	eval 'sub DRM_WANTED () {0x2;}' unless defined(&DRM_WANTED);
	if(defined(&DRMLOCKDEBUG)) {
	}
	eval 'sub DRIVER_AGP () {0x1;}' unless defined(&DRIVER_AGP);
	eval 'sub DRIVER_AGP_REQUIRE () {0x2;}' unless defined(&DRIVER_AGP_REQUIRE);
	eval 'sub DRIVER_MTRR () {0x4;}' unless defined(&DRIVER_MTRR);
	eval 'sub DRIVER_DMA () {0x8;}' unless defined(&DRIVER_DMA);
	eval 'sub DRIVER_PCI_DMA () {0x10;}' unless defined(&DRIVER_PCI_DMA);
	eval 'sub DRIVER_SG () {0x20;}' unless defined(&DRIVER_SG);
	eval 'sub DRIVER_IRQ () {0x40;}' unless defined(&DRIVER_IRQ);
	eval 'sub DRIVER_GEM () {0x80;}' unless defined(&DRIVER_GEM);
	eval 'sub drm_core_ioremap_wc () { &drm_core_ioremap;}' unless defined(&drm_core_ioremap_wc);
	eval 'sub drm_gem_object_reference {
	    my($obj) = @_;
    	    eval q({  &drm_ref( ($obj->{u$obj})); });
	}' unless defined(&drm_gem_object_reference);
	eval 'sub drm_gem_object_unreference {
	    my($obj) = @_;
    	    eval q({  &drm_unref( ($obj->{u$obj})); });
	}' unless defined(&drm_gem_object_unreference);
	eval 'sub drm_lock_obj {
	    my($obj) = @_;
    	    eval q({  &simple_lock( ($obj->{u$obj})); });
	}' unless defined(&drm_lock_obj);
	eval 'sub drm_unlock_obj {
	    my($obj) = @_;
    	    eval q({  &simple_unlock( ($obj->{u$obj})); });
	}' unless defined(&drm_unlock_obj);
	if(defined(&DRMLOCKDEBUG)) {
	    eval 'sub DRM_ASSERT_HELD {
	        my($obj) = @_;
    		eval q( &KASSERT( ($obj->{do_flags}) &  &DRM_BUSY  &&  ($obj->{holding_proc}) ==  &curproc));
	    }' unless defined(&DRM_ASSERT_HELD);
	    eval 'sub DRM_OBJ_ASSERT_LOCKED {
	        my($obj) = @_;
    		eval q();
	    }' unless defined(&DRM_OBJ_ASSERT_LOCKED);
	    eval 'sub DRM_ASSERT_LOCKED {
	        my($lock) = @_;
    		eval q( &MUTEX_ASSERT_LOCKED($lock));
	    }' unless defined(&DRM_ASSERT_LOCKED);
	} else {
	    eval 'sub DRM_ASSERT_HELD {
	        my($obj) = @_;
    		eval q();
	    }' unless defined(&DRM_ASSERT_HELD);
	    eval 'sub DRM_OBJ_ASSERT_LOCKED {
	        my($obj) = @_;
    		eval q();
	    }' unless defined(&DRM_OBJ_ASSERT_LOCKED);
	    eval 'sub DRM_ASSERT_LOCKED {
	        my($lock) = @_;
    		eval q();
	    }' unless defined(&DRM_ASSERT_LOCKED);
	}
    }
}
1;
