require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&AHCI_REG_CAP)) {
    sub AHCI_REG_CAP () {	0x;}
}
unless(defined(&AHCI_REG_CAP_NP)) {
    sub AHCI_REG_CAP_NP {
	my($_r) = @_;
	eval q(((($_r) & 0x1f)+1));
    }
}
unless(defined(&AHCI_REG_CAP_SXS)) {
    sub AHCI_REG_CAP_SXS () {	(1<<5);}
}
unless(defined(&AHCI_REG_CAP_EMS)) {
    sub AHCI_REG_CAP_EMS () {	(1<<6);}
}
unless(defined(&AHCI_REG_CAP_CCCS)) {
    sub AHCI_REG_CAP_CCCS () {	(1<<7);}
}
unless(defined(&AHCI_REG_CAP_NCS)) {
    sub AHCI_REG_CAP_NCS {
	my($_r) = @_;
	eval q((((($_r) & 0x1f00)>>8)+1));
    }
}
unless(defined(&AHCI_REG_CAP_PSC)) {
    sub AHCI_REG_CAP_PSC () {	(1<<13);}
}
unless(defined(&AHCI_REG_CAP_SSC)) {
    sub AHCI_REG_CAP_SSC () {	(1<<14);}
}
unless(defined(&AHCI_REG_CAP_PMD)) {
    sub AHCI_REG_CAP_PMD () {	(1<<15);}
}
unless(defined(&AHCI_REG_CAP_FBSS)) {
    sub AHCI_REG_CAP_FBSS () {	(1<<16);}
}
unless(defined(&AHCI_REG_CAP_SPM)) {
    sub AHCI_REG_CAP_SPM () {	(1<<17);}
}
unless(defined(&AHCI_REG_CAP_SAM)) {
    sub AHCI_REG_CAP_SAM () {	(1<<18);}
}
unless(defined(&AHCI_REG_CAP_SNZO)) {
    sub AHCI_REG_CAP_SNZO () {	(1<<19);}
}
unless(defined(&AHCI_REG_CAP_ISS)) {
    sub AHCI_REG_CAP_ISS () {	(0xf<<20);}
}
unless(defined(&AHCI_REG_CAP_ISS_G1)) {
    sub AHCI_REG_CAP_ISS_G1 () {	(0x1<<20);}
}
unless(defined(&AHCI_REG_CAP_ISS_G1_2)) {
    sub AHCI_REG_CAP_ISS_G1_2 () {	(0x2<<20);}
}
unless(defined(&AHCI_REG_CAP_SCLO)) {
    sub AHCI_REG_CAP_SCLO () {	(1<<24);}
}
unless(defined(&AHCI_REG_CAP_SAL)) {
    sub AHCI_REG_CAP_SAL () {	(1<<25);}
}
unless(defined(&AHCI_REG_CAP_SALP)) {
    sub AHCI_REG_CAP_SALP () {	(1<<26);}
}
unless(defined(&AHCI_REG_CAP_SSS)) {
    sub AHCI_REG_CAP_SSS () {	(1<<27);}
}
unless(defined(&AHCI_REG_CAP_SMPS)) {
    sub AHCI_REG_CAP_SMPS () {	(1<<28);}
}
unless(defined(&AHCI_REG_CAP_SSNTF)) {
    sub AHCI_REG_CAP_SSNTF () {	(1<<29);}
}
unless(defined(&AHCI_REG_CAP_SNCQ)) {
    sub AHCI_REG_CAP_SNCQ () {	(1<<30);}
}
unless(defined(&AHCI_REG_CAP_S64A)) {
    sub AHCI_REG_CAP_S64A () {	(1<<31);}
}
unless(defined(&AHCI_FMT_CAP)) {
    sub AHCI_FMT_CAP () {	"\020" "\040S64A" "\037NCQ" "\036SSNTF" "\035SMPS" "\034SSS" "\033SALP" "\032SAL" "\031SCLO" "\024SNZO" "\023SAM" "\022SPM" "\021FBSS" "\020PMD" "\017SSC" "\016PSC" "\010CCCS" "\007EMS" "\006SXS";}
}
unless(defined(&AHCI_REG_GHC)) {
    sub AHCI_REG_GHC () {	0x4;}
}
unless(defined(&AHCI_REG_GHC_HR)) {
    sub AHCI_REG_GHC_HR () {	(1<<0);}
}
unless(defined(&AHCI_REG_GHC_IE)) {
    sub AHCI_REG_GHC_IE () {	(1<<1);}
}
unless(defined(&AHCI_REG_GHC_MRSM)) {
    sub AHCI_REG_GHC_MRSM () {	(1<<2);}
}
unless(defined(&AHCI_REG_GHC_AE)) {
    sub AHCI_REG_GHC_AE () {	(1<<31);}
}
unless(defined(&AHCI_FMT_GHC)) {
    sub AHCI_FMT_GHC () {	"\020" "\040AE" "\003MRSM" "\002IE" "\001HR";}
}
unless(defined(&AHCI_REG_IS)) {
    sub AHCI_REG_IS () {	0x8;}
}
unless(defined(&AHCI_REG_PI)) {
    sub AHCI_REG_PI () {	0xc;}
}
unless(defined(&AHCI_REG_VS)) {
    sub AHCI_REG_VS () {	0x10;}
}
unless(defined(&AHCI_REG_VS_0_95)) {
    sub AHCI_REG_VS_0_95 () {	0x905;}
}
unless(defined(&AHCI_REG_VS_1_0)) {
    sub AHCI_REG_VS_1_0 () {	0x10000;}
}
unless(defined(&AHCI_REG_VS_1_1)) {
    sub AHCI_REG_VS_1_1 () {	0x10100;}
}
unless(defined(&AHCI_REG_VS_1_2)) {
    sub AHCI_REG_VS_1_2 () {	0x10200;}
}
unless(defined(&AHCI_REG_VS_1_3)) {
    sub AHCI_REG_VS_1_3 () {	0x10300;}
}
unless(defined(&AHCI_REG_CCC_CTL)) {
    sub AHCI_REG_CCC_CTL () {	0x14;}
}
unless(defined(&AHCI_REG_CCC_CTL_INT)) {
    sub AHCI_REG_CCC_CTL_INT {
	my($_r) = @_;
	eval q(((($_r) & 0xf8) >> 3));
    }
}
unless(defined(&AHCI_REG_CCC_PORTS)) {
    sub AHCI_REG_CCC_PORTS () {	0x18;}
}
unless(defined(&AHCI_REG_EM_LOC)) {
    sub AHCI_REG_EM_LOC () {	0x1c;}
}
unless(defined(&AHCI_REG_EM_CTL)) {
    sub AHCI_REG_EM_CTL () {	0x20;}
}
unless(defined(&AHCI_PORT_REGION)) {
    sub AHCI_PORT_REGION {
	my($_p) = @_;
	eval q((0x100 + (($_p) * 0x80)));
    }
}
unless(defined(&AHCI_PORT_SIZE)) {
    sub AHCI_PORT_SIZE () {	0x80;}
}
unless(defined(&AHCI_PREG_CLB)) {
    sub AHCI_PREG_CLB () {	0x;}
}
unless(defined(&AHCI_PREG_CLBU)) {
    sub AHCI_PREG_CLBU () {	0x4;}
}
unless(defined(&AHCI_PREG_FB)) {
    sub AHCI_PREG_FB () {	0x8;}
}
unless(defined(&AHCI_PREG_FBU)) {
    sub AHCI_PREG_FBU () {	0xc;}
}
unless(defined(&AHCI_PREG_IS)) {
    sub AHCI_PREG_IS () {	0x10;}
}
unless(defined(&AHCI_PREG_IS_DHRS)) {
    sub AHCI_PREG_IS_DHRS () {	(1<<0);}
}
unless(defined(&AHCI_PREG_IS_PSS)) {
    sub AHCI_PREG_IS_PSS () {	(1<<1);}
}
unless(defined(&AHCI_PREG_IS_DSS)) {
    sub AHCI_PREG_IS_DSS () {	(1<<2);}
}
unless(defined(&AHCI_PREG_IS_SDBS)) {
    sub AHCI_PREG_IS_SDBS () {	(1<<3);}
}
unless(defined(&AHCI_PREG_IS_UFS)) {
    sub AHCI_PREG_IS_UFS () {	(1<<4);}
}
unless(defined(&AHCI_PREG_IS_DPS)) {
    sub AHCI_PREG_IS_DPS () {	(1<<5);}
}
unless(defined(&AHCI_PREG_IS_PCS)) {
    sub AHCI_PREG_IS_PCS () {	(1<<6);}
}
unless(defined(&AHCI_PREG_IS_DMPS)) {
    sub AHCI_PREG_IS_DMPS () {	(1<<7);}
}
unless(defined(&AHCI_PREG_IS_PRCS)) {
    sub AHCI_PREG_IS_PRCS () {	(1<<22);}
}
unless(defined(&AHCI_PREG_IS_IPMS)) {
    sub AHCI_PREG_IS_IPMS () {	(1<<23);}
}
unless(defined(&AHCI_PREG_IS_OFS)) {
    sub AHCI_PREG_IS_OFS () {	(1<<24);}
}
unless(defined(&AHCI_PREG_IS_INFS)) {
    sub AHCI_PREG_IS_INFS () {	(1<<26);}
}
unless(defined(&AHCI_PREG_IS_IFS)) {
    sub AHCI_PREG_IS_IFS () {	(1<<27);}
}
unless(defined(&AHCI_PREG_IS_HBDS)) {
    sub AHCI_PREG_IS_HBDS () {	(1<<28);}
}
unless(defined(&AHCI_PREG_IS_HBFS)) {
    sub AHCI_PREG_IS_HBFS () {	(1<<29);}
}
unless(defined(&AHCI_PREG_IS_TFES)) {
    sub AHCI_PREG_IS_TFES () {	(1<<30);}
}
unless(defined(&AHCI_PREG_IS_CPDS)) {
    sub AHCI_PREG_IS_CPDS () {	(1<<31);}
}
unless(defined(&AHCI_PFMT_IS)) {
    sub AHCI_PFMT_IS () {	"\20" "\040CPDS" "\037TFES" "\036HBFS" "\035HBDS" "\034IFS" "\033INFS" "\031OFS" "\030IPMS" "\027PRCS" "\010DMPS" "\006DPS" "\007PCS" "\005UFS" "\004SDBS" "\003DSS" "\002PSS" "\001DHRS";}
}
unless(defined(&AHCI_PREG_IE)) {
    sub AHCI_PREG_IE () {	0x14;}
}
unless(defined(&AHCI_PREG_IE_DHRE)) {
    sub AHCI_PREG_IE_DHRE () {	(1<<0);}
}
unless(defined(&AHCI_PREG_IE_PSE)) {
    sub AHCI_PREG_IE_PSE () {	(1<<1);}
}
unless(defined(&AHCI_PREG_IE_DSE)) {
    sub AHCI_PREG_IE_DSE () {	(1<<2);}
}
unless(defined(&AHCI_PREG_IE_SDBE)) {
    sub AHCI_PREG_IE_SDBE () {	(1<<3);}
}
unless(defined(&AHCI_PREG_IE_UFE)) {
    sub AHCI_PREG_IE_UFE () {	(1<<4);}
}
unless(defined(&AHCI_PREG_IE_DPE)) {
    sub AHCI_PREG_IE_DPE () {	(1<<5);}
}
unless(defined(&AHCI_PREG_IE_PCE)) {
    sub AHCI_PREG_IE_PCE () {	(1<<6);}
}
unless(defined(&AHCI_PREG_IE_DMPE)) {
    sub AHCI_PREG_IE_DMPE () {	(1<<7);}
}
unless(defined(&AHCI_PREG_IE_PRCE)) {
    sub AHCI_PREG_IE_PRCE () {	(1<<22);}
}
unless(defined(&AHCI_PREG_IE_IPME)) {
    sub AHCI_PREG_IE_IPME () {	(1<<23);}
}
unless(defined(&AHCI_PREG_IE_OFE)) {
    sub AHCI_PREG_IE_OFE () {	(1<<24);}
}
unless(defined(&AHCI_PREG_IE_INFE)) {
    sub AHCI_PREG_IE_INFE () {	(1<<26);}
}
unless(defined(&AHCI_PREG_IE_IFE)) {
    sub AHCI_PREG_IE_IFE () {	(1<<27);}
}
unless(defined(&AHCI_PREG_IE_HBDE)) {
    sub AHCI_PREG_IE_HBDE () {	(1<<28);}
}
unless(defined(&AHCI_PREG_IE_HBFE)) {
    sub AHCI_PREG_IE_HBFE () {	(1<<29);}
}
unless(defined(&AHCI_PREG_IE_TFEE)) {
    sub AHCI_PREG_IE_TFEE () {	(1<<30);}
}
unless(defined(&AHCI_PREG_IE_CPDE)) {
    sub AHCI_PREG_IE_CPDE () {	(1<<31);}
}
unless(defined(&AHCI_PFMT_IE)) {
    sub AHCI_PFMT_IE () {	"\20" "\040CPDE" "\037TFEE" "\036HBFE" "\035HBDE" "\034IFE" "\033INFE" "\031OFE" "\030IPME" "\027PRCE" "\010DMPE" "\007PCE" "\006DPE" "\005UFE" "\004SDBE" "\003DSE" "\002PSE" "\001DHRE";}
}
unless(defined(&AHCI_PREG_CMD)) {
    sub AHCI_PREG_CMD () {	0x18;}
}
unless(defined(&AHCI_PREG_CMD_ST)) {
    sub AHCI_PREG_CMD_ST () {	(1<<0);}
}
unless(defined(&AHCI_PREG_CMD_SUD)) {
    sub AHCI_PREG_CMD_SUD () {	(1<<1);}
}
unless(defined(&AHCI_PREG_CMD_POD)) {
    sub AHCI_PREG_CMD_POD () {	(1<<2);}
}
unless(defined(&AHCI_PREG_CMD_CLO)) {
    sub AHCI_PREG_CMD_CLO () {	(1<<3);}
}
unless(defined(&AHCI_PREG_CMD_FRE)) {
    sub AHCI_PREG_CMD_FRE () {	(1<<4);}
}
unless(defined(&AHCI_PREG_CMD_CCS)) {
    sub AHCI_PREG_CMD_CCS {
	my($_r) = @_;
	eval q(((($_r) >> 8) & 0x1f));
    }
}
unless(defined(&AHCI_PREG_CMD_MPSS)) {
    sub AHCI_PREG_CMD_MPSS () {	(1<<13);}
}
unless(defined(&AHCI_PREG_CMD_FR)) {
    sub AHCI_PREG_CMD_FR () {	(1<<14);}
}
unless(defined(&AHCI_PREG_CMD_CR)) {
    sub AHCI_PREG_CMD_CR () {	(1<<15);}
}
unless(defined(&AHCI_PREG_CMD_CPS)) {
    sub AHCI_PREG_CMD_CPS () {	(1<<16);}
}
unless(defined(&AHCI_PREG_CMD_PMA)) {
    sub AHCI_PREG_CMD_PMA () {	(1<<17);}
}
unless(defined(&AHCI_PREG_CMD_HPCP)) {
    sub AHCI_PREG_CMD_HPCP () {	(1<<18);}
}
unless(defined(&AHCI_PREG_CMD_MPSP)) {
    sub AHCI_PREG_CMD_MPSP () {	(1<<19);}
}
unless(defined(&AHCI_PREG_CMD_CPD)) {
    sub AHCI_PREG_CMD_CPD () {	(1<<20);}
}
unless(defined(&AHCI_PREG_CMD_ESP)) {
    sub AHCI_PREG_CMD_ESP () {	(1<<21);}
}
unless(defined(&AHCI_PREG_CMD_ATAPI)) {
    sub AHCI_PREG_CMD_ATAPI () {	(1<<24);}
}
unless(defined(&AHCI_PREG_CMD_DLAE)) {
    sub AHCI_PREG_CMD_DLAE () {	(1<<25);}
}
unless(defined(&AHCI_PREG_CMD_ALPE)) {
    sub AHCI_PREG_CMD_ALPE () {	(1<<26);}
}
unless(defined(&AHCI_PREG_CMD_ASP)) {
    sub AHCI_PREG_CMD_ASP () {	(1<<27);}
}
unless(defined(&AHCI_PREG_CMD_ICC)) {
    sub AHCI_PREG_CMD_ICC () {	0xf0000000;}
}
unless(defined(&AHCI_PREG_CMD_ICC_SLUMBER)) {
    sub AHCI_PREG_CMD_ICC_SLUMBER () {	0x60000000;}
}
unless(defined(&AHCI_PREG_CMD_ICC_PARTIAL)) {
    sub AHCI_PREG_CMD_ICC_PARTIAL () {	0x20000000;}
}
unless(defined(&AHCI_PREG_CMD_ICC_ACTIVE)) {
    sub AHCI_PREG_CMD_ICC_ACTIVE () {	0x10000000;}
}
unless(defined(&AHCI_PREG_CMD_ICC_IDLE)) {
    sub AHCI_PREG_CMD_ICC_IDLE () {	0x;}
}
unless(defined(&AHCI_PFMT_CMD)) {
    sub AHCI_PFMT_CMD () {	"\020" "\034ASP" "\033ALPE" "\032DLAE" "\031ATAPI" "\026ESP" "\025CPD" "\024MPSP" "\023HPCP" "\022PMA" "\021CPS" "\020CR" "\017FR" "\016MPSS" "\005FRE" "\004CLO" "\003POD" "\002SUD" "\001ST";}
}
unless(defined(&AHCI_PREG_TFD)) {
    sub AHCI_PREG_TFD () {	0x20;}
}
unless(defined(&AHCI_PREG_TFD_STS)) {
    sub AHCI_PREG_TFD_STS () {	0xff;}
}
unless(defined(&AHCI_PREG_TFD_STS_ERR)) {
    sub AHCI_PREG_TFD_STS_ERR () {	(1<<0);}
}
unless(defined(&AHCI_PREG_TFD_STS_DRQ)) {
    sub AHCI_PREG_TFD_STS_DRQ () {	(1<<3);}
}
unless(defined(&AHCI_PREG_TFD_STS_BSY)) {
    sub AHCI_PREG_TFD_STS_BSY () {	(1<<7);}
}
unless(defined(&AHCI_PREG_TFD_ERR)) {
    sub AHCI_PREG_TFD_ERR () {	0xff00;}
}
unless(defined(&AHCI_PFMT_TFD_STS)) {
    sub AHCI_PFMT_TFD_STS () {	"\20" "\010BSY" "\004DRQ" "\001ERR";}
}
unless(defined(&AHCI_PREG_SIG)) {
    sub AHCI_PREG_SIG () {	0x24;}
}
unless(defined(&AHCI_PREG_SSTS)) {
    sub AHCI_PREG_SSTS () {	0x28;}
}
unless(defined(&AHCI_PREG_SSTS_DET)) {
    sub AHCI_PREG_SSTS_DET () {	0xf;}
}
unless(defined(&AHCI_PREG_SSTS_DET_NONE)) {
    sub AHCI_PREG_SSTS_DET_NONE () {	0x;}
}
unless(defined(&AHCI_PREG_SSTS_DET_DEV_NE)) {
    sub AHCI_PREG_SSTS_DET_DEV_NE () {	0x1;}
}
unless(defined(&AHCI_PREG_SSTS_DET_DEV)) {
    sub AHCI_PREG_SSTS_DET_DEV () {	0x3;}
}
unless(defined(&AHCI_PREG_SSTS_DET_PHYOFFLINE)) {
    sub AHCI_PREG_SSTS_DET_PHYOFFLINE () {	0x4;}
}
unless(defined(&AHCI_PREG_SSTS_SPD)) {
    sub AHCI_PREG_SSTS_SPD () {	0xf0;}
}
unless(defined(&AHCI_PREG_SSTS_SPD_NONE)) {
    sub AHCI_PREG_SSTS_SPD_NONE () {	0x;}
}
unless(defined(&AHCI_PREG_SSTS_SPD_GEN1)) {
    sub AHCI_PREG_SSTS_SPD_GEN1 () {	0x10;}
}
unless(defined(&AHCI_PREG_SSTS_SPD_GEN2)) {
    sub AHCI_PREG_SSTS_SPD_GEN2 () {	0x20;}
}
unless(defined(&AHCI_PREG_SSTS_IPM)) {
    sub AHCI_PREG_SSTS_IPM () {	0xf00;}
}
unless(defined(&AHCI_PREG_SSTS_IPM_NONE)) {
    sub AHCI_PREG_SSTS_IPM_NONE () {	0x;}
}
unless(defined(&AHCI_PREG_SSTS_IPM_ACTIVE)) {
    sub AHCI_PREG_SSTS_IPM_ACTIVE () {	0x100;}
}
unless(defined(&AHCI_PREG_SSTS_IPM_PARTIAL)) {
    sub AHCI_PREG_SSTS_IPM_PARTIAL () {	0x200;}
}
unless(defined(&AHCI_PREG_SSTS_IPM_SLUMBER)) {
    sub AHCI_PREG_SSTS_IPM_SLUMBER () {	0x600;}
}
unless(defined(&AHCI_PREG_SCTL)) {
    sub AHCI_PREG_SCTL () {	0x2c;}
}
unless(defined(&AHCI_PREG_SCTL_DET)) {
    sub AHCI_PREG_SCTL_DET () {	0xf;}
}
unless(defined(&AHCI_PREG_SCTL_DET_NONE)) {
    sub AHCI_PREG_SCTL_DET_NONE () {	0x;}
}
unless(defined(&AHCI_PREG_SCTL_DET_INIT)) {
    sub AHCI_PREG_SCTL_DET_INIT () {	0x1;}
}
unless(defined(&AHCI_PREG_SCTL_DET_DISABLE)) {
    sub AHCI_PREG_SCTL_DET_DISABLE () {	0x4;}
}
unless(defined(&AHCI_PREG_SCTL_SPD)) {
    sub AHCI_PREG_SCTL_SPD () {	0xf0;}
}
unless(defined(&AHCI_PREG_SCTL_SPD_ANY)) {
    sub AHCI_PREG_SCTL_SPD_ANY () {	0x;}
}
unless(defined(&AHCI_PREG_SCTL_SPD_GEN1)) {
    sub AHCI_PREG_SCTL_SPD_GEN1 () {	0x10;}
}
unless(defined(&AHCI_PREG_SCTL_SPD_GEN2)) {
    sub AHCI_PREG_SCTL_SPD_GEN2 () {	0x20;}
}
unless(defined(&AHCI_PREG_SCTL_IPM)) {
    sub AHCI_PREG_SCTL_IPM () {	0xf00;}
}
unless(defined(&AHCI_PREG_SCTL_IPM_NONE)) {
    sub AHCI_PREG_SCTL_IPM_NONE () {	0x;}
}
unless(defined(&AHCI_PREG_SCTL_IPM_NOPARTIAL)) {
    sub AHCI_PREG_SCTL_IPM_NOPARTIAL () {	0x100;}
}
unless(defined(&AHCI_PREG_SCTL_IPM_NOSLUMBER)) {
    sub AHCI_PREG_SCTL_IPM_NOSLUMBER () {	0x200;}
}
unless(defined(&AHCI_PREG_SCTL_IPM_DISABLED)) {
    sub AHCI_PREG_SCTL_IPM_DISABLED () {	0x300;}
}
unless(defined(&AHCI_PREG_SERR)) {
    sub AHCI_PREG_SERR () {	0x30;}
}
unless(defined(&AHCI_PREG_SERR_ERR)) {
    sub AHCI_PREG_SERR_ERR {
	my($_r) = @_;
	eval q((($_r) & 0xffff));
    }
}
unless(defined(&AHCI_PREG_SERR_ERR_I)) {
    sub AHCI_PREG_SERR_ERR_I () {	(1<<0);}
}
unless(defined(&AHCI_PREG_SERR_ERR_M)) {
    sub AHCI_PREG_SERR_ERR_M () {	(1<<1);}
}
unless(defined(&AHCI_PREG_SERR_ERR_T)) {
    sub AHCI_PREG_SERR_ERR_T () {	(1<<8);}
}
unless(defined(&AHCI_PREG_SERR_ERR_C)) {
    sub AHCI_PREG_SERR_ERR_C () {	(1<<9);}
}
unless(defined(&AHCI_PREG_SERR_ERR_P)) {
    sub AHCI_PREG_SERR_ERR_P () {	(1<<10);}
}
unless(defined(&AHCI_PREG_SERR_ERR_E)) {
    sub AHCI_PREG_SERR_ERR_E () {	(1<<11);}
}
unless(defined(&AHCI_PFMT_SERR_ERR)) {
    sub AHCI_PFMT_SERR_ERR () {	"\020" "\014E" "\013P" "\012C" "\011T" "\002M" "\001I";}
}
unless(defined(&AHCI_PREG_SERR_DIAG)) {
    sub AHCI_PREG_SERR_DIAG {
	my($_r) = @_;
	eval q(((($_r) >> 16) & 0xffff));
    }
}
unless(defined(&AHCI_PREG_SERR_DIAG_N)) {
    sub AHCI_PREG_SERR_DIAG_N () {	(1<<0);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_I)) {
    sub AHCI_PREG_SERR_DIAG_I () {	(1<<1);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_W)) {
    sub AHCI_PREG_SERR_DIAG_W () {	(1<<2);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_B)) {
    sub AHCI_PREG_SERR_DIAG_B () {	(1<<3);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_D)) {
    sub AHCI_PREG_SERR_DIAG_D () {	(1<<4);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_C)) {
    sub AHCI_PREG_SERR_DIAG_C () {	(1<<5);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_H)) {
    sub AHCI_PREG_SERR_DIAG_H () {	(1<<6);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_S)) {
    sub AHCI_PREG_SERR_DIAG_S () {	(1<<7);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_T)) {
    sub AHCI_PREG_SERR_DIAG_T () {	(1<<8);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_F)) {
    sub AHCI_PREG_SERR_DIAG_F () {	(1<<9);}
}
unless(defined(&AHCI_PREG_SERR_DIAG_X)) {
    sub AHCI_PREG_SERR_DIAG_X () {	(1<<10);}
}
unless(defined(&AHCI_PFMT_SERR_DIAG)) {
    sub AHCI_PFMT_SERR_DIAG () {	"\020" "\013X" "\012F" "\011T" "\010S" "\007H" "\006C" "\005D" "\004B" "\003W" "\002I" "\001N";}
}
unless(defined(&AHCI_PREG_SACT)) {
    sub AHCI_PREG_SACT () {	0x34;}
}
unless(defined(&AHCI_PREG_CI)) {
    sub AHCI_PREG_CI () {	0x38;}
}
unless(defined(&AHCI_PREG_CI_ALL_SLOTS)) {
    sub AHCI_PREG_CI_ALL_SLOTS () {	0xffffffff;}
}
unless(defined(&AHCI_PREG_SNTF)) {
    sub AHCI_PREG_SNTF () {	0x3c;}
}
unless(defined(&AHCI_PREG_FBS)) {
    sub AHCI_PREG_FBS () {	0x40;}
}
unless(defined(&AHCI_PREG_FBS_DWE)) {
    sub AHCI_PREG_FBS_DWE () {	0xf0000;}
}
unless(defined(&AHCI_PREG_FBS_ADO)) {
    sub AHCI_PREG_FBS_ADO () {	0xf000;}
}
unless(defined(&AHCI_PREG_FBS_DEV)) {
    sub AHCI_PREG_FBS_DEV () {	0xf00;}
}
unless(defined(&AHCI_PREG_FBS_SDE)) {
    sub AHCI_PREG_FBS_SDE () {	(1<<2);}
}
unless(defined(&AHCI_PREG_FBS_DEC)) {
    sub AHCI_PREG_FBS_DEC () {	(1<<1);}
}
unless(defined(&AHCI_PREG_FBS_EN)) {
    sub AHCI_PREG_FBS_EN () {	(1<<0);}
}
1;
