/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPObjectReference;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPPacketValue;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.datamodel.OXMLSequence;

class XSLJDWPArrayReference
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    XSLJDWPObjectReference or;

    XSLJDWPArrayReference(XSLJDWPObjectReference xSLJDWPObjectReference) {
        this.or = xSLJDWPObjectReference;
    }

    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.getCommand()) {
            case 1: {
                xSLJDWPPacket2 = this.lengthCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.getValuesCmd();
                break;
            }
            case 3: {
                xSLJDWPPacket2 = this.setValuesCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    XSLJDWPPacket lengthCmd() {
        int n = this.cmdStrm.readArrayID();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(this.generateLengthData(n));
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket setValuesCmd() {
        int n = this.cmdStrm.readArrayID();
        int n2 = this.cmdStrm.readInt();
        int n3 = this.cmdStrm.readInt();
        Integer n4 = new Integer(n);
        Object v = this.or.getIds2Objs().get(n4);
        String string = XSLJDWPUtil.toString(v);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n3; ++i) {
            char c;
            cArray[i + n2] = c = this.cmdStrm.readChar();
        }
        String string2 = new String(cArray);
        XPathSequence.setStringValue((OXMLSequence)v, string2);
        this.or.getIds2Objs().put(n4, v);
        this.or.getObjs2Ids().put(v, n4);
        return this.cmd.createReply();
    }

    XSLJDWPPacket getValuesCmd() {
        int n = this.cmdStrm.readArrayID();
        int n2 = this.cmdStrm.readInt();
        int n3 = this.cmdStrm.readInt();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            XSLJDWPPacketValue[] xSLJDWPPacketValueArray = this.generateGetValuesData(n, n2, n3);
            XSLJDWPObjectReference xSLJDWPObjectReference = this.jdwpvm.xsl.getJDWPObjectReference();
            xSLJDWPObjectReference.generateArrayElementData(xSLJDWPPacketValueArray);
            if (xSLJDWPPacketValueArray.length > 0) {
                if (xSLJDWPPacketValueArray[0].getType() == 67) {
                    xSLJDWPPacketStream.writeArrayRegion((byte)67, xSLJDWPPacketValueArray);
                } else {
                    xSLJDWPPacketStream.writeArrayRegion((byte)76, xSLJDWPPacketValueArray);
                }
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    private int generateLengthData(int n) {
        byte by = (byte)(n >> 24);
        int n2 = 0;
        if (by == 6) {
            String string = null;
            string = XSLJDWPUtil.toString(this.or.getIds2Objs().get(new Integer(n)));
            if (string != null) {
                n2 = string.length();
            }
        } else {
            XMLNodeList xMLNodeList = null;
            xMLNodeList = (XMLNodeList)this.or.getIds2Objs().get(new Integer(n));
            if (xMLNodeList != null) {
                xMLNodeList.setDebugFlag();
                n2 = xMLNodeList.getLength();
            }
        }
        return n2;
    }

    private XSLJDWPPacketValue[] generateGetValuesData(int n, int n2, int n3) {
        byte by = (byte)(n >> 24);
        if (by == 6) {
            String string = null;
            string = XSLJDWPUtil.toString(this.or.getIds2Objs().get(new Integer(n)));
            if (string == null) {
                return new XSLJDWPPacketValue[0];
            }
            int n4 = string.length();
            int n5 = 0;
            if (n3 > 0) {
                n5 = n2 + n3;
            }
            if (n5 > n4) {
                n5 = n4;
            }
            XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n5 - n2];
            for (int i = n2; i < n5; ++i) {
                XSLJDWPPacketValue xSLJDWPPacketValue;
                char c = string.charAt(i);
                xSLJDWPPacketValueArray[i - n2] = xSLJDWPPacketValue = new XSLJDWPPacketValue(67, new Character(c));
            }
            return xSLJDWPPacketValueArray;
        }
        XMLNodeList xMLNodeList = null;
        xMLNodeList = (XMLNodeList)this.or.getIds2Objs().get(new Integer(n));
        if (xMLNodeList == null) {
            return new XSLJDWPPacketValue[0];
        }
        int n6 = xMLNodeList.getLength();
        int n7 = 0;
        if (n3 > 0) {
            n7 = n2 + n3;
        }
        if (n7 > n6) {
            n7 = n6;
        }
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n7 - n2];
        for (int i = n2; i < n7; ++i) {
            XSLJDWPPacketValue xSLJDWPPacketValue;
            XMLNode xMLNode = (XMLNode)xMLNodeList.item(i);
            xSLJDWPPacketValueArray[i - n2] = xSLJDWPPacketValue = new XSLJDWPPacketValue(76, xMLNode);
        }
        return xSLJDWPPacketValueArray;
    }
}

